package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * Created by PVer on 2017/4/24.
 */
@Repository("changeLogDao")
@Transactional
public class ChangeLogDaoImpl extends DaoImpl<ChangeLog> implements ChangeLogDao {


    @Override
    public ChangeLog findChangeLogByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public void saveChangeLog(ChangeLog changeLog){
        try {
            saveOrUpdate(changeLog);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public boolean checkLogUnShow(String activityNo){
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql="select count(1) as total from risk_change_log t where t.activityNo='"+activityNo+"' and t.isNew='1' and isShow='0'";
        Map<String, Object> map  = queryMap(sql, wrapper);
        if(map!=null){
            Integer num=Integer.parseInt(map.get("total").toString());
            if(num>0){
                return true;
            }
        }
        return false;
    }

    @Override
    public int updateLogShowStatus(String activityNo,String showStatus){
        String sql="update risk_change_log set isShow='"+showStatus+"',updateOn=NOW() where activityNo='"+activityNo+"' and isShow='"+DictConst.N+"'";
        return this.executeSqlUpdate(sql);
    }

    @Override
    public int changeLogStatus(String isNew,String isUpdate,String billId,String billCategory,String billType,String flagId){
        String sql="update risk_change_log set isNew='"+isNew+"', isUpdate='"+DictConst.Y+"' ";
        sql+=" where billId='"+billId+"' and billCategory='"+billCategory+"' and billType='"+billType+"'";
        sql+=" and flagId='"+flagId+"'";
        return this.executeSqlUpdate(sql);
    }

    @Override
    public Map<String,Object> checkChangeLog(Long activityId){
        String sql="select A.`name`,A.oid,max(changeDate) as changeDate from risk_activity A,risk_change_log B  " ;
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.where(" A.oid=B.billId and B.isShow='"+DictConst.Y+"'");
        wrapper.eq("A.oid",activityId);
        return this.queryMap(sql,wrapper);
    }

    @Override
    public List<ChangeLog> selectChangeLog(String billId){
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("billId",billId));
        criterionList.add(Restrictions.eq("isNew",DictConst.Y));
        criterionList.add(Restrictions.eq("isShow",DictConst.Y));
        return selectList(criterionList);
    }

    @Override
    public List<ChangeLog> selectChangeLogByMarketId(Long marketId){
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("markerRegionId",marketId));
        criterionList.add(Restrictions.eq("isUpdate",DictConst.Y));
        criterionList.add(Restrictions.eq("isShow",DictConst.Y));
        return selectList(criterionList);
    }

    @Override
    public void updateChangeLog(List<Long> ids,String isUpdate){
        String sql="update risk_change_log set isUpdate='"+isUpdate+"' where oid in ";
        String idList="";
        int count=0;
        for(Long id : ids){
            idList+=id+",";
            count++;
            // 以100为基数执行
            if(count%100==0){
                if(StringUtil.isNotEmpty(idList)){
                    idList=idList.substring(0,idList.length()-1);
                }
                this.executeSqlUpdate(sql+" ("+idList+") ");
                idList="";
                continue;
            }
            // 最后一次执行
            if(count==ids.size()){
                if(StringUtil.isNotEmpty(idList)){
                    idList=idList.substring(0,idList.length()-1);
                }
                this.executeSqlUpdate(sql+" ("+idList+") ");
                break;
            }
        }

    }
}
