package com.bcxin.risk.compose.draft;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.compose.dto.data.ComposeFrameDataDto;
import com.bcxin.risk.compose.dto.search.ComposeFrameSearchDTO;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class ComposeFrameDaoImpl extends DaoImpl<ComposeFrame> implements ComposeFrameDao{


    @Override
    public ComposeFrame findById(long id) {
        return selectById(id);
    }

    @Override
    public List<ComposeFrame> findFrameListByOrg(ComposeFrameSearchDTO searchDTO) {
        SelectWrapper wrapper = SelectWrapper.instance();
        /* wrapper.or 条件必须放在最前面，不然会出现重复记录 */
        /* 自营，允许读取公共的 */
        if (searchDTO.getIsShareTemplate()) {
            wrapper.or("(nature = 0 or (nature = 1 and org_id = "+Long.parseLong(searchDTO.getOrg_id())+"))",null);
        } else {
            wrapper.eq("nature","1");
            wrapper.eq("org_id",Long.parseLong(searchDTO.getOrg_id()));
        }
        if (StringUtil.isNotEmpty(searchDTO.getType())) {
            wrapper.eq("type",searchDTO.getType());
        }
        wrapper.eq("active", DictConst.Y);
        return selectList(wrapper);
    }


    @Override
    public List<ComposeFrameDataDto> queryComposeFrameList(ComposeFrameSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT oid," +
                            " createOn,"+
                            " type,"+
                            " name," +
                            " active," +
                            " comment, " +
                            " nature, " +
                            " fileUrl " +
                " FROM risk_ComposeFrame " +
                " where active = 1" ;

        if (StringUtil.isNotEmpty(searchDto.getKeyword())) {
            sql = sql + " and name like '%"+searchDto.getKeyword()+"%'";
        }
        if (StringUtil.isNotEmpty(searchDto.getType())) {
            sql = sql + " and type = '"+searchDto.getType()+"'";
        }
        /* 开启共享模板权限 */
        if (searchDto.getIsShareTemplate()) {
            sql = sql + " and ( nature = 0 or (nature = 1 and org_id = "+Long.parseLong(searchDto.getOrg_id())+") )";
        } else {
            sql = sql + " and ( nature = 1 and org_id = "+Long.parseLong(searchDto.getOrg_id())+" )";
        }
        sql = sql + " order by createOn desc";
        List<ComposeFrameDataDto> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            ComposeFrameDataDto dto = new ComposeFrameDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }


    /**
     * 后台管理系统模板管理列表
     *
     * @return
     */
    @Override
    public List<Map<String, Object>> ListManageComposeFrame(DwzPage page, ComposeFrameSearchDTO dto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT * FROM risk_composeframe WHERE nature = '0' AND ISNULL(org_id) ";

        if (StringUtil.isNotEmpty(dto.getType())) {
            sql = sql + " and type = '" + dto.getType() + "' ";
        }
        if (StringUtil.isNotEmpty(dto.getActive())) {
            sql = sql + " and active = '" + dto.getActive() + "' ";
        }
        sql = sql + " ORDER BY oid DESC ";
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);

    }

}
