package com.bcxin.risk.compose.draft;

import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.domain.Report;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class ComposeFileDaoImpl extends DaoImpl<ComposeFile> implements ComposeFileDao{


    @Override
    public ComposeFile findById(long id) {
        return selectById(id);
    }

    @Override
    public ComposeFile findByReportAndLevel(long reportId,String composeFileLevel) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("report_id", reportId);
        wrapper.eq("level", composeFileLevel);
        List<Object> list = selectList(wrapper);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return (ComposeFile)list.get(0);
    }

    @Override
    public ComposeFile findByReportAndTask(long reportId,Long taskId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("report_id", reportId);
        wrapper.eq("composeTask_id", taskId);
        List<Object> list = selectList(wrapper);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return (ComposeFile)list.get(0);
    }
    @Override
    public ComposeFile findByReportAndTaskId(long reportId,long taskId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("report_id", reportId);
        wrapper.eq("composeTask_id", taskId);
        List<Object> list = selectList(wrapper);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return (ComposeFile)list.get(0);
    }

    @Override
    public List<ComposeFile> findFrameListByReport(Report report) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("report_id", report.getOid());
        wrapper.orderBy("oid",false);
        return selectList(wrapper);
    }

    @Override
    public ComposeFile newestComposeFile(Report report) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("report_id", report.getOid());
        wrapper.orderBy("oid",false);
        List<Object> list = selectList(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            return (ComposeFile) list.get(0);
        }
        return null;
    }

    @Override
    public ComposeFile findByComposeTaskId(long id) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("composeTask_id", id);
        List<Object> list = selectList(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            return (ComposeFile) list.get(0);
        }
        return null;
    }

    @Override
    public ComposeFile findByFileUrl(String fileUrl) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("fileUrl", fileUrl);
        List<Object> list = selectList(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            return (ComposeFile) list.get(0);
        }
        return null;
    }
}
