package com.bcxin.risk.common.dao;

import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.common.domain.NotifyPerson;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * 消息通知配置表
 *
 * @author 张建华
 * @Date 2018年9月13日15:34:49
 */
@Repository("notifyPersonDao")
public class NotifyPersonDaoImpl extends DaoImpl<NotifyPerson> implements NotifyPersonDao {


    @Override
    public NotifyPerson selectNotifyPersonByType(String notifyPersonType) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("notifyPersonType", notifyPersonType));
        List list = selectList(criterionList);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return (NotifyPerson) list.get(0);
    }
}
