package com.bcxin.risk.common.dao;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.domain.MarketRegion;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
@Slf4j
public class MarketRegionDaoImpl extends DaoImpl<MarketRegion> implements MarketRegionDao {


    @Override
    public List<MarketRegion> findRegionByLevel(String level) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if(StringUtil.isNotEmpty(level)){
            wrapper.eq("level",level);
        }
        return selectList(wrapper);
    }

    @Override
    public List<MarketRegion> selectRegionList(){
        return selectList();
    }

    @Override
    public List<MarketRegion> findMarketRegionByOid(Long oid) {

        SelectWrapper wrapper = SelectWrapper.instance();
        if(oid != null){
            wrapper.eq("oid",oid);
        }
        return selectList(wrapper);
    }

    /**
     * 查询不包含全部的省份
     */
    @Override
    public List<MarketRegion> findRegionByLeve(String level) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if (StringUtil.isNotEmpty(level)) {
            wrapper.eq("level", DictConst.REGIONLEVEL_PROVINCE);
        }
        return selectList(wrapper);
    }

    /**
     * 获得独立已经开拓的省市
     * @return
     */
    @Override
    public Map<Long,MarketRegion> findBlazerMarket(){
        Map<Long,MarketRegion> map = Maps.newHashMap();
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("independent", DictConst.Y);
        List<Object> list = selectList(wrapper);
        list.forEach(obj->{
            MarketRegion m = (MarketRegion)obj;
            map.put(m.getOid(),m);
        });
        return map;
    }

}
