package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.data.ActivityCooperDTO;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.TableConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.Org;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


@Repository
public class QuotationRegionDaoImpl extends DaoImpl<QuotationRegion> implements QuotationRegionDao {

    @Override
    public List<QuotationRegion> findQuotationRegionList(Quotation quotation) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("quotation", quotation));
        return selectList(criterionList);
    }

    @Override
    public QuotationRegion findQuotationRegion(Quotation quotation,String areaId) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("quotation", quotation));
        criterionList.add(Restrictions.eq("region_Id", areaId));
        List list = selectList(criterionList);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return (QuotationRegion)list.get(0);
    }
    @Override
    public String getQuotationRegionIdByOrgIdAndAreaId(String orgId,String areaId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer("SELECT b.oid FROM risk_quotation a,risk_quotationregion b WHERE a.oid = b.quotation_id AND b.`level`='2' AND a.active='1'");
        // AND a.org_id='' AND b.region_Id=''
        wrapper.eq("a.org_id",orgId);
        wrapper.eq("b.region_Id",areaId);
        List<ActivityCooperDTO> dtoList = Lists.newArrayList();
        List<String> list = queryLists(sql.toString(), wrapper);
        if(list.size()>0){
            return list.get(0);
        }
        return "";
    }

    @Override
    public List<Map<String, Object>> selectQuotationRegion(Org org,String level){
        String sql = " select q.oid,q.name,r.region_Id from risk_quotation q\n" +
                     " inner join risk_quotationregion r on r.quotation_id = q.oid\n" ;
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("q.org_id",org.getOid());
        wrapper.eq("r.level",level);
        return queryMaps(sql, wrapper);
    }

    @Override
    public void deleteQuotationRegion(Quotation quotation,String level){
        String sql = "delete from risk_quotationRegion where quotation_id = " + quotation.getOid();
        if (StringUtil.isNotEmpty(level)) {
            sql = sql + " and level = "+level;
        }
        executeSqlUpdate(sql);
    }

    @Override
    public void deleteExistQuotationRegion(Org org,String oids){
        String sql = "DELETE\n" +
                "    FROM risk_quotationregion\n" +
                "    WHERE EXISTS (SELECT 1\n" +
                "            FROM risk_quotationfactor f  , risk_quotation q \n" +
                "                WHERE q.oid = f.quotation_id\n" +
                "                          AND q.oid = risk_quotationregion.quotation_id\n" +
                "                          AND q.org_id = "+org.getOid()+" ) and region_Id in ("+oids+")" ;
        executeSqlUpdate(sql);
    }

}
