package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.search.QuotationSearchDTO;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.Org;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


@Repository
public class QuotationFactorDaoImpl extends DaoImpl<QuotationFactor> implements QuotationFactorDao {

    @Override
    public List<QuotationFactor> selectList() {
        List<Criterion> criterionList = Lists.newArrayList();
        return selectList(criterionList);
    }

    @Override
    public QuotationFactor findQuotationFactorByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public QuotationFactor findQuotationFactorByDto(QuotationSearchDTO searchDto){
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getOrg() != null ) {
            criterionList.add(Restrictions.eq("org", searchDto.getOrg()));
        }
        if (StringUtil.isNotEmpty(searchDto.getActive())) {
            criterionList.add(Restrictions.eq("active", searchDto.getActive()));
        }
        if (StringUtil.isNotEmpty(searchDto.getPriceType())) {
            criterionList.add(Restrictions.eq("priceType", searchDto.getPriceType()));
        }
        return selectOne(criterionList);
    }

    @Override
    public QuotationFactor findFactorByQuotation(Quotation quotation) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("quotation", quotation));
        return selectOne(criterionList);
    }

    @Override
    public Map<String, Object> findFactorByRegion(Org org,String cityId,String areaId){
        String sql = " select f.*,q.quotationType from risk_quotationfactor f \n" +
                " inner join risk_quotation q on q.oid = f.quotation_id and q.active=1\n" +
                " inner join risk_quotationregion r on r.quotation_id = q.oid ";
        /* 选择了市，没有选区 **/
        if (StringUtil.isEmpty(areaId)) {
            SelectWrapper wrapper = SelectWrapper.instance();
            wrapper.eq("q.org_id",org.getOid());
            wrapper.eq("r.region_Id",cityId);
            List<Map<String, Object>> result = queryMaps(sql, wrapper);
            if (CollectionUtil.isNotEmpty(result)) {
                return result.get(0);
            }
            return Maps.newHashMap();
        } else {
            //目前统一找市级报价模版
            /* 选择了市，也选了区 **/
            /*SelectWrapper wrapper = SelectWrapper.instance();
            wrapper.eq("q.org_id",org.getOid());
            wrapper.eq("r.region_Id",areaId);
            List<Map<String, Object>> result = queryMaps(sql, wrapper);
            if (CollectionUtil.isNotEmpty(result)) {
                return result.get(0);
            }*/
            /* 但是没找到区的记录，则把市的报价查一下 **/
            SelectWrapper wrapper2 = SelectWrapper.instance();
            wrapper2.eq("q.org_id",org.getOid());
            wrapper2.eq("r.region_Id",cityId);
            List<Map<String, Object>> result2 = queryMaps(sql, wrapper2);
            if (CollectionUtil.isNotEmpty(result2)) {
                return result2.get(0);
            }
            return Maps.newHashMap();
        }
    }
}
