package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.data.ActivityCooperDTO;
import com.bcxin.risk.common.dto.search.CooperSearchDTO;
import com.bcxin.risk.base.domain.util.LongUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.constant.TableConst;
import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class ActivityCooperDaoImpl extends DaoImpl<ActivityCooper> implements ActivityCooperDao {
    @Autowired
    private ActivityDao activityDao;


    @Override
    public ActivityCooper findActivityCooperByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public void deleteByActivity(Activity activity){
        delete(DeleteWrapper.instance().eq("activity_id",activity.getOid()));
    }

    @Override
    public void deleteByActivityCooperBags(String activityNo){
       String sql = "delete t1 from risk_activity_cooper t1 " +
               " inner join risk_activity t2 on t1.activity_Id = t2.oid " +
               " inner join risk_org t3 on t1.org_Id = t3.saasComid " +
               " inner join risk_serviceorg t4 on t4.oid = t3.oid " +
               " where t2.activityNo = '"+activityNo+"' and t4.serviceOrgType = 5";
       executeSqlUpdate(sql);
    }

    @Override
    public List<ActivityCooperDTO> findActivityCooperDtoByActivty(Activity activity) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer("select o.oid,o.name,so.serviceOrgType,so.contactPhone," +
              "so.contactName ,rcp.amount,rcp.oid as rcpoid,so.financePhone," +
            " so.distributionorg as distributionorg ,a.oid AS orderId,o.oid AS orgId " +
            " from " + TableConst.ACTIVITYCOOPER_TABLE + " rcp " +
            " inner join "+TableConst.ACTIVITY_TABLE+" r on r.oid = rcp.activity_id " +
            " inner join "+TableConst.ORG_TABLE+" o on o.oid = rcp.org_Id " +
            " inner join "+TableConst.ORDERFORM_TABLE+" a on a.activity_id = r.oid " +
            " inner join "+TableConst.SERIVICEORG_TABLE+" so on so.oid = o.oid ");

        if ( activity == null ) {
            return Lists.newArrayList();
        } else {
            wrapper.eq("r.oid",activity.getOid());
        }
        List<ActivityCooperDTO> dtoList = Lists.newArrayList();
        List<Map<String, Object>> list = queryMaps(sql.toString(), wrapper);
        list.forEach(result->{
            Map<String,Object> map = (Map<String,Object>)result;
            ActivityCooperDTO dto = new ActivityCooperDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }


    @Override
    public List<ActivityCooperDTO> findActivityCooperDto(CooperSearchDTO searchDto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select o.oid,o.name,so.serviceOrgType,so.contactPhone,so.contactName,so.minQuote from "+ TableConst.ORG_TABLE+" o" +
                " inner join "+TableConst.SERIVICEORG_TABLE+" so on so.oid = o.oid " ;

        if ( searchDto == null ) {
            return Lists.newArrayList();
        }
        if ( LongUtil.isNotEmpty(searchDto.getActivity_id())){
            Activity activity = activityDao.findActivityByOid(searchDto.getActivity_id());
            if(activity.getCity()!=null){
                sql = sql + " inner join risk_org_region a on a.org_id = o.oid AND a.region_level = '2' AND a.region_id = " + activity.getCity().getOid()+" ";
            }else{
                sql = sql + " inner join risk_org_region a on a.org_id = o.oid AND a.region_level = '1' AND a.region_id = " + activity.getProvince().getOid()+" ";
            }
        }
        if ( StringUtil.isNotEmpty(searchDto.getType()) ){
            wrapper.eq("so.serviceOrgType",searchDto.getType());
        }
        if ( StringUtil.isNotEmpty(searchDto.getName())  ) {
            wrapper.like("o.name",searchDto.getName());
        }
        if (searchDto.getOids() != null && searchDto.getOids().length >0){
            wrapper.in("o.oid",searchDto.getOids());
        }
        if ( StringUtil.isNotEmpty(searchDto.getApprovalStatus())  ) {   //排除营业执照待审核的机构
            wrapper.eq("so.approvalStatus",searchDto.getApprovalStatus());
        }
        if (searchDto.getActivity()!=null){
            sql = sql + " inner join " + TableConst.ACTIVITYCOOPER_TABLE + " ac on ac.org_id = o.oid ";
            wrapper.eq("ac.activity_id",searchDto.getActivity().getOid());
        }
        List<ActivityCooperDTO> dtoList = Lists.newArrayList();
        List<Map<String, Object>> list = queryMaps(sql, wrapper);
        list.forEach(result->{
            ActivityCooperDTO dto = new ActivityCooperDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }


    /**
     * 查找评估机构，并进行排序
     * @param searchDto
     * @return
     */
    @Override
    public List<ActivityCooperDTO> findAssessmentCooperDTOAndOrder(CooperSearchDTO searchDto) {
        if ( searchDto == null ) {
            return Lists.newArrayList();
        }

        Activity activity = activityDao.findActivityByOid(searchDto.getActivity_id());

        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuilder sql =  new StringBuilder();
        sql.append("select distinct o.oid,o.name,so.serviceOrgType,so.contactPhone,so.contactName,so.minQuote,so.serviceMode " +
                " from risk_org o" +
                " inner join RISK_SERVICEORG so on so.oid = o.oid "+
                " inner join risk_quotation q on q.org_id = o.oid "+
                " inner join risk_quotationregion qr on qr.quotation_id = q.oid " +
                " INNER JOIN risk_se_user u ON u.org_id = o.oid ");

        // 查找服务区域相关的机构
        if ( activity.getCity() != null ) {
            sql.append(" inner join risk_org_region a on a.org_id = o.oid AND a.region_level = '2' AND a.region_id = " + activity.getCity().getOid());
        } else {
            sql.append(" inner join risk_org_region a on a.org_id = o.oid AND a.region_level = '1' AND a.region_id = " + activity.getProvince().getOid());
        }

        if ( StringUtil.isNotEmpty(searchDto.getType()) ) {
            sql.append(" AND so.serviceOrgType = '"+searchDto.getType()+"'");
        }
        if ( StringUtil.isNotEmpty(searchDto.getName())  ) {
            sql.append(" AND so.serviceOrgType like '%"+searchDto.getName()+"%'");
        }
        //排除营业执照待审核的机构
        if ( StringUtil.isNotEmpty(searchDto.getApprovalStatus())  ) {
            sql.append(" AND so.approvalStatus = '"+searchDto.getApprovalStatus()+"'");
        }
        //sql.append(" and q.quotationClass = " + DictConst.QUOTATIONCLASS_ACTIVITY);
        sql.append(" and (qr.region_Id = "+searchDto.getCity_id()+" or qr.region_Id = "+searchDto.getArea_id()+")");
        sql.append(" order by so.serviceMode");
        List<ActivityCooperDTO> dtoList = Lists.newArrayList();
        List<Map<String, Object>> list = queryMaps(sql.toString(), wrapper);
        list.forEach(result->{
            Map<String,Object> map = (Map<String,Object>)result;
            ActivityCooperDTO dto = new ActivityCooperDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }


    @Override
    public ActivityCooperDTO findAssessmentCooperByActivity(CooperSearchDTO searchDto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select o.ywzcId, o.oid,o.name,so.serviceOrgType,so.contactPhone" +
                     ",so.contactName,c.oid as cooperOid ,d.oid AS orderId ,so.umpayMerId,so.boofooMerId,d.amount," +
                     "so.stampedPicture,so.approvalStatus,so.business_license_num " +
                       " from "+TableConst.ORG_TABLE+" o" +
                       " inner join "+TableConst.SERIVICEORG_TABLE+" so on so.oid = o.oid " +
                       " inner join "+TableConst.ACTIVITYCOOPER_TABLE+" c on c.org_id = o.oid "+
                       " inner join "+TableConst.ORDERFORM_TABLE+" d on d.activity_id = c.activity_id ";

        if ( searchDto == null ) {
            return new ActivityCooperDTO();
        }
        if ( searchDto.getActivity() != null ) {
            wrapper.eq("c.activity_id",searchDto.getActivity().getOid()+"");
        }
        if ( LongUtil.isNotEmpty(searchDto.getActivity_id()) ) {
            wrapper.eq("c.activity_id",searchDto.getActivity_id()+"");
        }
        if ( LongUtil.isNotEmpty(searchDto.getOrder_id()) ) {
            wrapper.eq("d.oid",searchDto.getOrder_id()+"");
        }
        wrapper.eq("so.serviceOrgType", DictConst.SERVICEORGTYPE_FXPGJG);
        Map<String,Object> map = queryMap(sql, wrapper);
        if ( map == null) {
            return new ActivityCooperDTO();
        }
        return new ActivityCooperDTO(map);
    }

    @Override
    public ActivityCooperDTO findSimpleAssessmentByActivity(Activity activity) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select o.oid,o.name,so.serviceMode" +
                " from " + TableConst.ORG_TABLE+" o" +
                " inner join "+TableConst.SERIVICEORG_TABLE+" so on so.oid = o.oid " +
                " inner join "+TableConst.ACTIVITYCOOPER_TABLE+" c on c.org_id = o.oid ";
        wrapper.eq("c.activity_id",activity.getOid());
        wrapper.eq("so.serviceOrgType", DictConst.SERVICEORGTYPE_FXPGJG);
        Map<String,Object> map = queryMap(sql, wrapper);
        if ( map == null) {
            return new ActivityCooperDTO();
        }
        return new ActivityCooperDTO(map);
    }

}
