package com.bcxin.risk.user.dao;


import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.user.dto.data.*;
import com.bcxin.risk.user.dto.search.PoliceUserSearchDto;
import com.bcxin.risk.user.dto.search.UserRoleSearchDto;

import java.util.List;


public interface UserDao extends IDao<User> {

    User selectUserByComId(String comId);

    User findUserByName(String name);

    User findUserByOid(long oid);

    List userList(DwzPage page, UserDto userDto);

    User findAdminUser();

    List<UserRoleDataDto> queryUserList(UserRoleSearchDto dto);

    List<MenuDataDto> queryMenuByUser(Long userId);

    UserDataDto findUserByOrgId(Long orgId);

    List<UserRoleDataDto> queryUserListByOrgId(User user, String name, Page page);

    User findPoliceUserByArea(Long area_id);

    List<UserRoleDataDto> queryUserOrRoleList(UserRoleSearchDto dto);

    List<UserPlainDataDTO> findUserListByRole(long orgId, String roleCode);

    int updateUser(User user);

    List findFrontUserList(UserDto userDto, DwzPage page);

    List<UserRoleDataDto> findCashierByuserType(String usertypeGljgyhCw);

    List<User> findUserListByDto(UserDto dto);

    List<PoliceUserDataDto> findPoliceUser(PoliceUserSearchDto dto, Page page);

    List<UserRoleDataDto> queryUserList(Long orgId, String name, Page page);

    List<UserRoleDataDto> findAssessmentManageUser(long orgId);

    List<UserPlainDataDTO> findUserListByOrgAndUserType(Long orgId, String userType);

    List<User> findUserByOrgIdAndUserType(Long orgId, String userType);

    List<User> findByListOid(List<Long> list);

    int countUserByType(String userType);

    User selectUserByUserName(String userName);

    User selectUserByComId(String userType, String comId);

    User selectUserByPerId(String perId);

    User selectUserByComIdAndUserName(String phone, String comId);

    User selectUserByComIdAndPhone(String phone, String comId);

    List<User> selectServiceOrgPerson(String userType, Long oid);

    List<User> selectServiceOrgPersonByList(List<String> userTypeList, Long oid);

    User selectServiceOrgRegister(Org org);

    List<User> selectUserListByList(List<Long> expertIdList);

    boolean existsUserName(String userName);

    /**
     * 关账用户表与电子签章用户Id
     * @param user
     * @return
     */
    int correlate(User user);
}