package com.bcxin.risk.survey;

import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.report.enums.SurveyStep;
import com.bcxin.risk.survey.domain.SurveyTask;
import com.bcxin.risk.survey.domain.Survey_FeedBack;
import com.bcxin.risk.survey.domain.dto.serach.Survey_FeedBackSerachDto;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import java.util.ArrayList;
import java.util.List;

/**
 * @param oid
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */
public interface Survey_FeedBackDao extends IDao<Survey_FeedBack> {

    Survey_FeedBack findSurvey_FeedBackByOid(Long oid);

    List<Survey_FeedBack> findSurvey_FeedBackList(Survey_FeedBackSerachDto serachDto, Page page);

    /**
     * 根据踏勘任务+任务阶段获取踏勘反馈信息
     * @param task
     * @param surveyStep
     * @return
     */
    Survey_FeedBack findSurveyFeedBackByTaskAndStep(SurveyTask task, SurveyStep surveyStep);

    /**
     * 根据任务id获取踏勘反馈列表
     * @param taskId
     * @return
     */
    List<Survey_FeedBack> findSurveyFeedBackListBySurveyTaskId(Long taskId);

}
