package com.bcxin.risk.compose.draft;

import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.report.domain.Report;

import java.util.List;

public interface ComposeFileDao extends IDao<ComposeFile> {

	ComposeFile findById(long id);

	ComposeFile findByReportAndLevel(long reportId,String composeFileLevel);

	ComposeFile findByReportAndTask(long reportId,Long taskId);

	ComposeFile findByReportAndTaskId(long reportId,long taskId);

	List<ComposeFile>   findFrameListByReport(Report report);

	ComposeFile newestComposeFile(Report report);

	ComposeFile findByComposeTaskId(long id);

	/**
	 * 根据fileUrl查找
	 */
	ComposeFile findByFileUrl(String fileUrl);

}
