/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.surveytk;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.dao.QueryHelper;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.SurveyTask;
import com.bcxin.risk.surveytk.SurveyTkTaskDao;
import com.bcxin.risk.surveytk.domain.dto.SurveyTaskDataDto;
import com.bcxin.risk.surveytk.domain.dto.SurveyTaskDto;
import com.bcxin.risk.surveytk.enums.SurveyStatusEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="surveyTkTaskDao")
public class SurveyTkTaskDaoImpl
extends DaoImpl<SurveyTask>
implements SurveyTkTaskDao {
    public SurveyTask findSurveyTaskByOid(Long oid) {
        return (SurveyTask)this.selectById(oid);
    }

    public List<SurveyTaskDataDto> findSurveyTaskList(SurveyTaskDto searchDto, Page page) {
        List list = Lists.newArrayList();
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer();
        sql.append("select DISTINCT A.oid,A.activity_id as activityId,");
        sql.append("ACT.`name` AS activityName,");
        sql.append("B.orderStatus, G.reportUrgent,");
        sql.append("F.`name` as activityVenue,");
        sql.append("case A.taskStatus when '103' then (select N.realName from risk_surveytask M,risk_se_user N where M.userId=N.oid and M.surveyTaskStatus='REFUSE' and M.taskId=A.oid order by A.oid desc limit 1) else E.realName end as realName, ");
        sql.append("(select IFNULL(N.realName,'--') from risk_se_user N where N.oid=A.consultation_id limit 1) as consultationName, ");
        sql.append("E.userName AS tkUserName,");
        sql.append("E.oid AS tkUserId,");
        sql.append("A.acceptStatus,");
        sql.append("A.taskStatus,");
        sql.append("IF(INSTR(A.zj_config,'ZJ03'),'1','0') AS zjConfig,");
        sql.append("IF(A.tk_config='TK01' OR A.tk_config='TK02' OR A.tk_config ='TK03',\"1\",\"0\") AS tkConfig,");
        sql.append("DATE_FORMAT(A.acceptDate,'%Y-%m-%d %H:%i:00') AS 'acceptDate',");
        sql.append("DATE_FORMAT(A.finishDate,'%Y-%m-%d %H:%i:00') AS 'finishDate',");
        sql.append("DATE_FORMAT(A.createOn,'%Y-%m-%d %H:%i:00') AS 'createOn' ");
        sql.append("FROM risk_task A ");
        sql.append("INNER JOIN RISK_ACTIVITY ACT ON ACT.oid=A.activity_id ");
        sql.append("INNER JOIN RISK_OrderForm B ON A.activity_id = B.activity_id ");
        sql.append("INNER JOIN risk_activity_cooper C ON A.activity_id = C.activity_id ");
        sql.append("INNER JOIN risk_se_user D ON D.org_id = C.org_id ");
        sql.append("inner join risk_report G on G.activity_id=A.activity_id ");
        sql.append("LEFT JOIN risk_se_user E ON E.oid = A.assgin_id ");
        sql.append("LEFT JOIN (select V.activity_id,group_concat(SV.`name`) as `name` from risk_activity_venue V,sys_venue SV where V.venue_id=SV.oid group by V.activity_id) F on F.activity_id=A.activity_id ");
        sql.append("WHERE A.taskType = '2' and B.orderStatus != 9 ");
        sql.append(" and B.orderStatus in (1,4) ");
        if (searchDto.getUserId() != null) {
            sql.append(" and D.oid = " + searchDto.getUserId()).append("\r\n");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getReportUrgent())) {
            sql.append(" and G.reportUrgent = " + searchDto.getReportUrgent()).append("\r\n");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getAcceptStatus())) {
            sql.append(" and  A.acceptStatus= " + searchDto.getAcceptStatus()).append("\r\n");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getTaskStatus())) {
            sql.append(" and  A.taskStatus= " + searchDto.getTaskStatus()).append("\r\n");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvince())) {
            sql.append(" and  ACT.province_id= " + searchDto.getProvince()).append("\r\n");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCity())) {
            sql.append(" and  ACT.city_id= " + searchDto.getCity()).append("\r\n");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyName())) {
            sql.append(" and  A.`name` like '%" + searchDto.getKeyName() + "%'").append("\r\n");
        }
        wrapper.orderBy("A.createOn", false);
        if (page == null) {
            list = this.queryMaps(sql.toString(), (Wrapper)wrapper);
        } else {
            Page pageList = this.queryMapsPage(sql.toString(), (Wrapper)wrapper, page);
            list = pageList.getRecords();
        }
        ArrayList<SurveyTaskDataDto> dtoList = new ArrayList<SurveyTaskDataDto>();
        list.forEach(result -> {
            SurveyTaskDataDto dto = new SurveyTaskDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public SurveyTask findSurveyTaskByTaskId(Long taskId, SurveyStatusEnum surveyStatusEnum) {
        Order[] orders;
        List list;
        ArrayList<Object> criterionList = new ArrayList<Object>();
        criterionList.add(Restrictions.eq((String)"task.oid", (Object)taskId));
        if (surveyStatusEnum != null) {
            ArrayList<String> surveyTaskStatus = new ArrayList<String>();
            surveyTaskStatus.add(surveyStatusEnum.getKey());
            criterionList.add(Restrictions.in((String)"surveyTaskStatus", surveyTaskStatus));
        }
        if ((list = this.selectList(criterionList, orders = new Order[]{Order.desc((String)"oid")})) == null || list.size() == 0) {
            return null;
        }
        return (SurveyTask)list.get(0);
    }

    public List<Map<String, Object>> findSurveyPlan(Long surveyTaskId, String step, Long venueId) {
        ArrayList<Map<String, Object>> list = new ArrayList();
        String sql = "select \nA.oid as feedBackId,-- \u8e0f\u52d8\u53cd\u9988id \nB.oid as planId,-- \u8e0f\u52d8\u8ba1\u5212id\nC.oid as surveyTaskId,-- \u8e0f\u52d8\u4efb\u52a1id\nE.oid as venueId, -- \u573a\u9986id\nD.oid as questionnaireId,-- \u8e0f\u52d8\u95ee\u5377id\nB.surveyStep, -- \u8e0f\u52d8\u9636\u6bb5\nB.taskStatus as planStatus,-- \u8ba1\u5212\u72b6\u6001\nD.reportPath as surveyReport, -- \u8e0f\u52d8\u62a5\u544a\nF.tkExpert,-- \u8e0f\u52d8\u4e13\u5bb6 \ncase when B.allDay=1 then DATE_FORMAT(B.beginTime,'%Y-%m-%d')\nelse DATE_FORMAT(B.beginTime,'%Y-%m-%d %H:%i') end as beginTime,-- \u8e0f\u52d8\u5f00\u59cb\u65f6\u95f4\ncase when B.allDay=1 then DATE_FORMAT(B.endTime,'%Y-%m-%d')\nelse DATE_FORMAT(B.endTime,'%Y-%m-%d %H:%i') end as endTime, -- \u8e0f\u52d8\u7ed3\u675f\u65f6\u95f4\nE.`name` as venueName -- \u8e0f\u52d8\u573a\u9986\nfrom risk_survey_feedback A\ninner join risk_surveyplan B on A.oid=B.feedBackId\ninner join risk_surveytask C on A.taskId=C.oid\ninner join risk_Survey_Questionnaire D on A.oid=D.feedBackId and D.venueId=B.venueId\ninner join sys_venue E on E.oid=B.venueId\nleft join (select M.surveyStep,M.surveyTaskId,CONCAT(N.realName,' ',N.phone) as tkExpert \nfrom risk_survey_expert M,risk_se_user N where M.expertUserId=N.oid\n) F on (F.surveyStep=B.surveyStep and C.oid=F.surveyTaskId)\nwhere C.oid=" + surveyTaskId + " and B.surveyStep='" + step + "'";
        if (venueId != null) {
            sql = sql + " and E.oid=" + venueId;
        }
        sql = sql + " order by B.oid asc";
        list = this.queryMaps(sql.toString());
        return list;
    }

    public List<Map<String, Object>> findSurveySuggest(List<Long> questionIds) {
        String sqlGroup = "SET SESSION group_concat_max_len=5120";
        QueryHelper.executeSql(sqlGroup, null);
        String sql = "select DISTINCT C.taskId surveyTaskId,A.questionnaireId,C.surveyStep,A.answer as tkResult,B.result as reformResult,A.reformId,D.photos as tkPhotos,E.photos as reformPhoto from risk_survey_info A inner join risk_surveyreform B on A.reformId=B.oid inner join risk_surveyplan C on C.questionnaireId=A.questionnaireId inner join risk_surveyproject F on F.oid=A.oid left join (select surveyInfoId as surveyInfoId,GROUP_CONCAT(path) as photos from risk_survey_photo group by surveyInfoId) D on D.surveyInfoId=A.oid left join(select correctionId as correctionId,GROUP_CONCAT(path) as photos from risk_survey_photo group by correctionId) E on A.reformId=E.correctionId where A.nextSurvey=1 ";
        String ids = "";
        for (Long id : questionIds) {
            ids = ids + id + ",";
        }
        if (StringUtil.isNotEmpty((String)ids)) {
            ids = ids.substring(0, ids.length() - 1);
        }
        sql = sql + "and A.questionnaireId in (" + ids + ")";
        sql = sql + " order by F.sort asc";
        List list = this.queryMaps(sql.toString());
        return list;
    }

    public Long getVenue(Long surveyTaskId, String step) {
        String sql = "select distinct C.venueId from risk_surveytask A,risk_survey_feedback B,risk_surveyplan C WHERE A.oid=B.taskId and C.feedBackId=B.oid and  A.oid=" + surveyTaskId + " and B.surveyStep='" + step + "'";
        List list = this.queryMaps(sql.toString());
        if (list != null && list.size() > 0) {
            return Long.parseLong(((Map)list.get(0)).get("venueId").toString());
        }
        return null;
    }

    public boolean checkSurveyExpertAndDoing(Activity activity, String step) {
        String sql = "select A.oid, case A.surveyStep when 'FIRST' then 1  when 'SECOND' then 2 when 'THIRD' then 3 else '' end surveyStep,  A.taskStatus, E.tkExpert, act.oid as activityId from RISK_SurveyPlan A inner join risk_surveytask B on A.taskId=B.oid inner join risk_activity act on act.oid=B.activityId left join( select M.surveyStep,M.taskId,N.oid as tkExpert from risk_survey_expert M,risk_se_user N where M.expertUserId=N.oid ) E on (E.taskId=B.taskId and A.surveyStep=E.surveyStep) where act.oid=" + activity.getOid() + " and A.taskStatus IN ('CONTINUE','COMPLETE') and A.surveyStep='" + step + "' order by B.oid,A.time asc";
        List list = this.queryMaps(sql.toString());
        return list == null || list.size() <= 0;
    }
}

