/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.report.material;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.dao.QueryHelper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.material.dao.MaterialFormAttrDao;
import com.bcxin.risk.report.material.domain.MaterialFormAttr;
import com.bcxin.risk.report.material.domain.MaterialFormMenu;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class MaterialFormAttrDaoImpl
extends DaoImpl<MaterialFormAttr>
implements MaterialFormAttrDao {
    public List<MaterialFormAttr> findByMenu(MaterialFormMenu materialFormMenu) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"materialFormMenu", (Object)materialFormMenu));
        Order order = Order.asc((String)"seq");
        List list = this.selectList(criterionList, order);
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    public List<MaterialFormAttr> findMultiByMenu(MaterialFormMenu materialFormMenu) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"materialFormMenu", (Object)materialFormMenu));
        criterionList.add(Restrictions.ne((String)"mainEle", (Object)"1"));
        Order order = Order.asc((String)"seq");
        List list = this.selectList(criterionList, order);
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    public MaterialFormAttr findByMenuAttrCode(MaterialFormMenu materialFormMenu, String attrCode) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"materialFormMenu", (Object)materialFormMenu));
        criterionList.add(Restrictions.eq((String)"attrCode", (Object)attrCode));
        List list = this.selectList(criterionList);
        if (list.size() > 0) {
            return (MaterialFormAttr)list.get(0);
        }
        return null;
    }

    public List<MaterialFormAttr> findByAttrCodes(String[] attrCodes, Activity activity) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.in("attrCode", (Object[])attrCodes);
        wrapper.in("activity_id", activity.getOid() + "");
        return this.selectList((Wrapper)wrapper);
    }

    public List<MaterialFormAttr> findByActivity(Activity activity) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.in("activity_id", activity.getOid() + "");
        return this.selectList((Wrapper)wrapper);
    }

    public MaterialFormAttr findByAttrCode(String attrCode, Activity activity) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"activity", (Object)activity));
        criterionList.add(Restrictions.eq((String)"attrCode", (Object)attrCode));
        return (MaterialFormAttr)this.selectOne(criterionList);
    }

    public void updateScript(String value, String attrCode) {
        HashMap params = Maps.newHashMap();
        params.put("script", value);
        params.put("attrCode", attrCode);
        QueryHelper.executeSql("update risk_materialformattr set script = :script , updateOn = SYSDATE() where attrCode = :attrCode ", params);
        QueryHelper.executeSql("update risk_materialformattrtemplate set script = :script , updateOn = SYSDATE() where attrCode = :attrCode ", params);
    }

    public List<Map<String, Object>> selectScriptEle() {
        String sql = "select attrCode,script from risk_materialformattrtemplate where script !='' and events != ''";
        List result = this.queryMaps(sql);
        return result;
    }

    public void deleteByActivityId(Long activityId) {
        String sql = "delete from risk_materialformattr where activity_id = " + activityId;
        this.executeSqlUpdate(sql);
    }
}

