/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.order;

import cn.hutool.core.date.DateUtil;
import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.DomainDateUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.order.OrderForm;
import com.bcxin.risk.order.OrderFormDao;
import com.bcxin.risk.order.dto.data.OrderFormDataDTO;
import com.bcxin.risk.order.dto.search.OrderFormSearchDTO;
import com.bcxin.risk.order.enums.OrderTypeEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.stereotype.Repository;

@Repository(value="orderFormDao")
public class OrderFormDaoImpl
extends DaoImpl<OrderForm>
implements OrderFormDao {
    public OrderForm findOrderFormByOid(Long oid) {
        return (OrderForm)this.selectById(oid);
    }

    public OrderForm findOrderFormByNo(String orderNo) {
        return (OrderForm)this.selectOne(SelectWrapper.instance().eq("orderNo", (Object)orderNo));
    }

    public Map<String, String> countOrderNum(Long userId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuilder sb = new StringBuilder();
        sb.append("select").append("\r\n");
        sb.append("sum(case A.orderStatus when '0' then 1 else 0 end) as unPayCount,").append("\r\n");
        sb.append("sum(case A.orderStatus when '1' then 1 else 0 end) as payCount").append("\r\n");
        sb.append("from risk_orderform A,risk_activity B").append("\r\n");
        sb.append("where A.orderNo=B.activityNo and B.activityStatus!='50' and B.user_id=" + userId);
        HashMap countMap = Maps.newHashMap();
        Map result = this.queryMap(sb.toString().toString(), (Wrapper)wrapper);
        countMap.put("unPayCount", result.get("unPayCount") == null ? "0" : result.get("unPayCount").toString());
        countMap.put("payCount", result.get("payCount") == null ? "0" : result.get("payCount").toString());
        return countMap;
    }

    public List<OrderFormDataDTO> findFinanceTicketList(OrderFormSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select e.approvalStatus, e.invoiceType, e.`comment` as comment, o.delayPhoto,rep.reportStatus,p.province,  IFNULL((SELECT city FROM sys_region WHERE oid = a.city_id),'0') as city ,  IFNULL((SELECT area FROM sys_region WHERE oid = a.area_id),'0') as area ,  o.oid as orderId, a.oid as activityId,a.name as activityName,  a.activitySource,  a.gov, o.orderNo,DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate,a.activityType,   o.orderStatus,a.activityStatus, o.amount,IFNULL(o.refundAmount,0) as refundAmount,IFNULL(o.sourceAmount,0) as sourceAmount, off.payOrg,oo.name as orgName, org.name as pgOrgName,a.isVirtualContractor,a.sponsor,t.paymentMode,t.paymentType,  DATE_FORMAT(t.endTime,'%Y-%m-%d %H:%i:%s') AS payDate  from RISK_ACTIVITY a  inner join sys_region p on p.oid = a.province_id inner join RISK_ORDERFORM o on o.activity_id = a.oid  inner join RISK_SE_USER u on o.user_id = u.oid  inner join risk_org oo on oo.oid = u.org_id  INNER JOIN risk_activityexpress e  ON o.oid = e.orderForm_id left join risk_transaction t on t.orderForm_id  = o.oid  left join risk_transactionoffline off on off.oid = t.oid  left join risk_report rep on rep.activity_id=a.oid  left join ( select A.activity_id,A.org_id,C.name from RISK_Activity_Cooper A,risk_serviceorg B,risk_org C  where B.serviceOrgType=1 and A.org_id=B.oid and A.org_id=C.oid ) org on a.oid=org.activity_id  WHERE EXISTS (SELECT 1 FROM risk_activity_cooper d ,risk_serviceOrg e  WHERE d.org_id = e.oid AND e.serviceOrgType = '1' AND d.activity_id = a.oid )  and o.orderStatus != 9 and a.isBackup = 0 ";
        if (searchDto.getUser() != null && searchDto.getUser().getOrg() != null && !"chuna".equals(searchDto.getUser().getUserName()) && !"chunali".equals(searchDto.getUser().getUserName())) {
            sql = sql + " AND org.org_id  = " + searchDto.getUser().getOrg().getOid();
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyname())) {
            sql = sql + " AND (a.name like '%" + searchDto.getKeyname() + "%'  or org.name like '%" + searchDto.getKeyname() + "%'  or a.sponsor like '%" + searchDto.getKeyname() + "%'  or o.amount like '%" + searchDto.getKeyname() + "%' ) ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = " + searchDto.getOrderStatus() + " ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate()) && StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + " AND a.orderDate between DATE_FORMAT('" + searchDto.getStartDate() + "','%Y-%m-%d %H:%i:%S')  and DATE_FORMAT('" + DateUtil.format((Date)DomainDateUtil.addDay((Date)DomainDateUtil.parseDate((String)searchDto.getEndDate()), (int)1), (String)"yyyy-MM-dd") + "','%Y-%m-%d %H:%i:%S')";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvince())) {
            sql = sql + " AND p.oid = " + searchDto.getProvince() + " ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayMethod())) {
            sql = sql + " and t.paymentMode='" + searchDto.getPayMethod() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getApprovalStatus())) {
            sql = sql + " and e.approvalStatus='" + searchDto.getApprovalStatus() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayBeginDate())) {
            sql = sql + " and t.endTime >= '" + searchDto.getPayBeginDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayEndDate())) {
            sql = sql + " and t.endTime <= '" + searchDto.getPayEndDate() + "' ";
        }
        sql = "testchuna".equals(searchDto.getUser().getUserName()) ? sql + " and (u.userName = 'chengban' or u.userName = 'chanpinbu')" : sql + " and (u.userName != 'chengban' and userName != 'chanpinbu')";
        wrapper.orderBy("a.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<OrderFormDataDTO> findFinanceOrderFormDtoList(OrderFormSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select  o.delayPhoto,rep.reportStatus,p.province,  IFNULL((SELECT city FROM sys_region WHERE oid = a.city_id),'0') as city ,  IFNULL((SELECT area FROM sys_region WHERE oid = a.area_id),'0') as area ,  o.oid as orderId, a.oid as activityId,a.name as activityName,  a.activitySource,  a.gov, o.orderNo,DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate,a.activityType,   o.orderStatus,a.activityStatus, o.amount,IFNULL(o.refundAmount,0) as refundAmount,IFNULL(o.sourceAmount,0) as sourceAmount, off.payOrg,oo.name as orgName, org.name as pgOrgName,a.isVirtualContractor,a.sponsor,t.paymentMode,t.paymentType,  DATE_FORMAT(t.endTime,'%Y-%m-%d %H:%i:%s') AS payDate  from RISK_ACTIVITY a  inner join sys_region p on p.oid = a.province_id inner join RISK_ORDERFORM o on o.activity_id = a.oid  inner join RISK_SE_USER u on o.user_id = u.oid  inner join risk_org oo on oo.oid = u.org_id  left join risk_transaction t on t.orderForm_id  = o.oid  left join risk_transactionoffline off on off.oid = t.oid  left join risk_report rep on rep.activity_id=a.oid  left join ( select A.activity_id,A.org_id,C.name from RISK_Activity_Cooper A,risk_serviceorg B,risk_org C  where B.serviceOrgType=1 and A.org_id=B.oid and A.org_id=C.oid ) org on a.oid=org.activity_id  WHERE EXISTS (SELECT 1 FROM risk_activity_cooper d ,risk_serviceOrg e  WHERE d.org_id = e.oid AND e.serviceOrgType = '1' AND d.activity_id = a.oid )  and o.orderStatus != 9 and a.isBackup = 0 ";
        if (searchDto.getUser() != null && searchDto.getUser().getOrg() != null && !"chuna".equals(searchDto.getUser().getUserName()) && !"chunali".equals(searchDto.getUser().getUserName())) {
            sql = sql + " AND org.org_id  = " + searchDto.getUser().getOrg().getOid();
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyname())) {
            sql = sql + " AND (a.name like '%" + searchDto.getKeyname() + "%'  or org.name like '%" + searchDto.getKeyname() + "%'  or a.sponsor like '%" + searchDto.getKeyname() + "%'  or o.amount like '%" + searchDto.getKeyname() + "%' ) ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = " + searchDto.getOrderStatus() + " ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate()) && StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + " AND a.orderDate between DATE_FORMAT('" + searchDto.getStartDate() + "','%Y-%m-%d %H:%i:%S')  and DATE_FORMAT('" + DateUtil.format((Date)DomainDateUtil.addDay((Date)DomainDateUtil.parseDate((String)searchDto.getEndDate()), (int)1), (String)"yyyy-MM-dd") + "','%Y-%m-%d %H:%i:%S')";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvince())) {
            sql = sql + " AND p.oid = " + searchDto.getProvince() + " ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayMethod())) {
            sql = sql + " and t.paymentMode='" + searchDto.getPayMethod() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayBeginDate())) {
            sql = sql + " and t.endTime >= '" + searchDto.getPayBeginDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayEndDate())) {
            sql = sql + " and t.endTime <= '" + searchDto.getPayEndDate() + "' ";
        }
        sql = "testchuna".equals(searchDto.getUser().getUserName()) ? sql + " and (u.userName = 'chengban' or u.userName = 'chanpinbu')" : sql + " and (u.userName != 'chengban' and userName != 'chanpinbu')";
        wrapper.orderBy("a.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<Map<String, Object>> findFinanceProvince(OrderFormSearchDTO searchDto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select DISTINCT p.oid,p.province \n from RISK_ACTIVITY a  \n inner join sys_region p on p.oid = a.province_id \n inner join RISK_ORDERFORM o on o.activity_id = a.oid  \n inner join RISK_SE_USER u on o.user_id = u.oid  \n inner join risk_org oo on oo.oid = u.org_id  \n left join risk_transaction t on t.orderForm_id  = o.oid  \n left join risk_transactionoffline off on off.oid = t.oid  \n WHERE EXISTS (SELECT 1 FROM risk_activity_cooper d ,risk_serviceOrg e  \n WHERE d.org_id = e.oid AND e.serviceOrgType = '1' AND d.activity_id = a.oid )  \n and o.orderStatus != 9 and a.isBackup = 0 ";
        sql = "testchuna".equals(searchDto.getUser().getUserName()) ? sql + " and (u.userName = 'chengban' or u.userName = 'chanpinbu')" : sql + " and (u.userName != 'chengban' and userName != 'chanpinbu')";
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public Map<String, Object> findFinanceOrderFormSummary(OrderFormSearchDTO searchDto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select  count(a.oid) 'elements',  sum(case when o.orderStatus = '0' then o.amount else 0 end) 'wzf',  sum(case when o.orderStatus = '1' then o.amount else 0 end) 'yzf',  sum(case when o.orderStatus = '4' then o.amount else 0 end) 'yhzf', sum(o.amount) 'total' from RISK_ACTIVITY a  inner join sys_region p on p.oid = a.province_id inner join RISK_ORDERFORM o on o.activity_id = a.oid  inner join RISK_SE_USER u on o.user_id = u.oid  inner join risk_org oo on oo.oid = u.org_id  left join risk_transaction t on t.orderForm_id  = o.oid  left join risk_transactionoffline off on off.oid = t.oid  left join (  select A.activity_id, A.org_id, C.name  from RISK_Activity_Cooper A,risk_serviceorg B,risk_org C   where B.serviceOrgType=1 and A.org_id=B.oid and A.org_id=C.oid ) org on a.oid=org.activity_id  WHERE EXISTS (SELECT 1 FROM risk_activity_cooper d ,risk_serviceOrg e  WHERE d.org_id = e.oid AND e.serviceOrgType = '1' AND d.activity_id = a.oid )  and o.orderStatus != 9 and a.isBackup = 0  ";
        if (searchDto.getUser() != null && searchDto.getUser().getOrg() != null && !"chuna".equals(searchDto.getUser().getUserName()) && !"chunali".equals(searchDto.getUser().getUserName())) {
            sql = sql + " AND org.org_id  = " + searchDto.getUser().getOrg().getOid();
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyname())) {
            sql = sql + " AND (a.name like '%" + searchDto.getKeyname() + "%'  or org.name like '%" + searchDto.getKeyname() + "%'  or a.sponsor like '%" + searchDto.getKeyname() + "%'  or o.amount like '%" + searchDto.getKeyname() + "%' ) ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = " + searchDto.getOrderStatus() + " ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate()) && StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + " AND a.orderDate between DATE_FORMAT('" + searchDto.getStartDate() + "','%Y-%m-%d %H:%i:%S')  and DATE_FORMAT('" + DateUtil.format((Date)DomainDateUtil.addDay((Date)DomainDateUtil.parseDate((String)searchDto.getEndDate()), (int)1), (String)"yyyy-MM-dd") + "','%Y-%m-%d %H:%i:%S')";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvince())) {
            sql = sql + " AND p.oid = " + searchDto.getProvince() + " ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayMethod())) {
            sql = sql + " and t.paymentMode='" + searchDto.getPayMethod() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayBeginDate())) {
            sql = sql + " and t.endTime >= '" + searchDto.getPayBeginDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayEndDate())) {
            sql = sql + " and t.endTime <= '" + searchDto.getPayEndDate() + "' ";
        }
        sql = "testchuna".equals(searchDto.getUser().getUserName()) ? sql + " and (u.userName = 'chengban' or u.userName = 'chanpinbu')" : sql + " and (u.userName != 'chengban' and userName != 'chanpinbu')";
        return this.queryMap(sql, (Wrapper)wrapper);
    }

    public List<Map<String, Object>> findFinanceOrderFormExportList(OrderFormSearchDTO searchDto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select o.orderNo '01',\n CONCAT(p.province,c.city) '02',\n a.name '03',\n case when a.activitySource = 1 then '\u5728\u7ebf\u7533\u62a5'\n when a.activitySource = 2 then '\u7cfb\u7edf\u5f55\u5165' else '' end '0301',\n a.sponsor '04',\n a.orderDate '05',\n o.amount '06',\n case when o.orderStatus = 0 then '\u672a\u652f\u4ed8'\n when o.orderStatus = 1 then '\u5df2\u652f\u4ed8'\n when o.orderStatus = 4 then '\u5ef6\u540e\u652f\u4ed8' else '' end '07',\n case when t.paymentType = 4 then '\u8054\u52a8\u4f18\u52bf'\n when t.paymentType = 5 then '\u94f6\u884c\u8f6c\u8d26'\n when t.paymentType = 6 then '\u73b0\u91d1' else '' end '08',\n t.createOn '09',\n off.payAccount '10',\n off.payOrg '11',\n case when ae.invoiceExpressMode = 1 then '\u666e\u901a\u53d1\u7968'\n when ae.invoiceExpressMode = 2 then '\u589e\u503c\u7a0e\u53d1\u7968' else '' end '12',\n case when ae.invoiceExpressMode = 1 then ae.invoiceTitle when ae.invoiceExpressMode = 2 then ae.companyNameInvoice else '' end as '13',\n ae.taxpayerNumberInvoice '14',\n ae.registerAddressInvoice '15',\n ae.bankInvoice '16',\n ae.bankAccountInvoice '17',\n ae.ticketAddress '18'  from RISK_ACTIVITY a  inner join sys_region p on p.oid = a.province_id inner join RISK_ORDERFORM o on o.activity_id = a.oid  inner join RISK_SE_USER u on o.user_id = u.oid  inner join risk_org oo on oo.oid = u.org_id  left join risk_transaction t on t.orderForm_id  = o.oid  left join risk_transactionoffline off on off.oid = t.oid  left join sys_region c on c.oid = a.city_id left join risk_activityexpress ae on ae.orderForm_id = o.oid inner join(  SELECT  distinct d.activity_id,o.oid,o.name  FROM  risk_activity_cooper d, risk_serviceOrg e, risk_org o  WHERE  d.org_id = e.oid  AND e.oid = o.oid  AND e.serviceOrgType = '1' ) K on K.activity_id=a.oid  where 1=1  and o.orderStatus != 9 and a.isBackup = 0 ";
        if (searchDto.getUser() != null && searchDto.getUser().getOrg() != null && !"chuna".equals(searchDto.getUser().getUserName()) && !"chunali".equals(searchDto.getUser().getUserName())) {
            sql = sql + " and k.oid = " + searchDto.getUser().getOrg().getOid();
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyname())) {
            sql = sql + " AND ( a.name like '%" + searchDto.getKeyname() + "%' or a.sponsor like '%" + searchDto.getKeyname() + "%' or K.name like '%" + searchDto.getKeyname() + "%' )";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = " + searchDto.getOrderStatus() + " ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getAmount())) {
            sql = sql + " and o.amount like '%" + searchDto.getAmount() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate()) && StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + " AND a.orderDate between DATE_FORMAT('" + searchDto.getStartDate() + "','%Y-%m-%d %H:%i:%S')  and DATE_FORMAT('" + DateUtil.format((Date)DomainDateUtil.addDay((Date)DomainDateUtil.parseDate((String)searchDto.getEndDate()), (int)1), (String)"yyyy-MM-dd") + "','%Y-%m-%d %H:%i:%S')";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvince())) {
            sql = sql + " AND p.oid = " + searchDto.getProvince() + " ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayMethod())) {
            sql = sql + " and t.paymentMode='" + searchDto.getPayMethod() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayBeginDate())) {
            sql = sql + " and t.endTime >='" + searchDto.getPayBeginDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayEndDate())) {
            sql = sql + " and t.endTime <='" + searchDto.getPayEndDate() + "' ";
        }
        sql = "testchuna".equals(searchDto.getUser().getUserName()) ? sql + " and (u.userName = 'chengban' or u.userName = 'chanpinbu')" : sql + " and (u.userName != 'chengban' and userName != 'chanpinbu')";
        wrapper.orderBy("a.oid", false);
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List<OrderFormDataDTO> findOrderFormDtoList(OrderFormSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select  IFNULL(o.refundAmount,0) as refundAmount,  t.paymentMode, o.oid as orderId, a.isBackUp, a.oid as activityId, a.name as activityName, a.activitySource, o.orderNo, DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate, a.activityType,  i.alias,  o.orderStatus, a.activityStatus, '' as approvalStatus, r.reportStatus, '' as sbApprovalStatus, a.primaryStatus, o.amount, a.gov, a.province_id as province, (SELECT COUNT(1)   FROM risk_activity_cooper b,risk_serviceOrg c   WHERE b.org_id = c.oid  AND c.serviceOrgType = '1'  AND b.activity_id = a.oid ) AS pgjgCount, (select oid as taskId from risk_task where taskType=2 and activity_id=A.oid and assgin_id is not null limit 1) as taskId  from RISK_ACTIVITY a  inner join RISK_ORDERFORM o on o.activity_id = a.oid  inner join RISK_report r on r.activity_id = a.oid  inner join RISK_SE_USER u on o.user_id = u.oid  inner join sys_region i on i.oid = a.area_id  left join risk_transaction t on t.orderForm_id  = o.oid ";
        wrapper.where(" (a.isBackup=0 or a.needReport=1) ", new Object[0]);
        wrapper.notIn("o.orderStatus", "9");
        if (StringUtil.isNotEmpty((String)searchDto.getIsShenBao())) {
            wrapper.eq("a.isShenBao", (Object)searchDto.getIsShenBao());
        }
        if (searchDto.getUser() != null) {
            wrapper.eq("u.oid", (Object)searchDto.getUser().getOid());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyname())) {
            wrapper.like("a.name", searchDto.getKeyname());
        }
        if (searchDto.getProcess().equalsIgnoreCase("1")) {
            wrapper.notIn("a.activityStatus", "50");
        }
        if (searchDto.getProcess().equalsIgnoreCase("0")) {
            wrapper.eq("a.activityStatus", (Object)"50");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderStatus())) {
            if ("50".equals(searchDto.getOrderStatus())) {
                wrapper.eq("a.activityStatus", (Object)"50");
            } else {
                wrapper.notIn("a.activityStatus", "50");
                wrapper.eq("o.orderStatus", (Object)searchDto.getOrderStatus());
            }
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivitySource())) {
            wrapper.eq("a.activitySource", (Object)searchDto.getActivitySource());
        }
        if ("1".equals(searchDto.getSortValue())) {
            wrapper.orderBy(" a.startDate", true);
        } else if ("2".equals(searchDto.getSortValue())) {
            wrapper.orderBy(" a.startDate", false);
        } else if ("3".equals(searchDto.getSortValue())) {
            wrapper.orderBy(" a.createOn", true);
        } else if ("4".equals(searchDto.getSortValue())) {
            wrapper.orderBy(" a.createOn", false);
        } else {
            wrapper.orderBy(" a.createOn", false);
        }
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<OrderFormDataDTO> findServiceOrderList(OrderFormSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select  o.oid as orderId, a.oid as activityId, a.name as activityName, a.activitySource, so.serviceOrgType , o.orderNo,DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate,a.activityType,o.orderStatus ,a.activityStatus,o.reportAmount as reportAmount,o.discountAmount as discountAmount,o.amount as total,ac.amount ,a.gov,IFNULL(a.chooseAssess,'1') AS chooseAssess  from RISK_ACTIVITY a  inner join RISK_ORDERFORM o on o.activity_id = a.oid  inner join RISK_ACTIVITY_COOPER ac on ac.activity_id = a.oid  inner join RISK_SERVICEORG so on so.oid = ac.org_id ";
        wrapper.eq("a.isBackup", (Object)"0");
        wrapper.notIn("o.orderStatus", "9");
        if (searchDto.getOrg() != null) {
            wrapper.eq("ac.org_id", (Object)searchDto.getOrg().getOid());
        }
        if (searchDto.getProcess().equalsIgnoreCase("1")) {
            wrapper.notIn("a.activityStatus", "50");
        }
        if (searchDto.getProcess().equalsIgnoreCase("0")) {
            wrapper.eq("a.activityStatus", (Object)"50");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyname())) {
            wrapper.like("a.name", searchDto.getKeyname());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityStatus())) {
            if (searchDto.getActivityStatus().equalsIgnoreCase("0") || searchDto.getActivityStatus().equalsIgnoreCase("1")) {
                wrapper.eq("o.orderStatus", (Object)searchDto.getActivityStatus());
            } else if ("4".equals(searchDto.getActivityStatus())) {
                wrapper.eq("o.orderStatus", (Object)searchDto.getActivityStatus());
            } else {
                Object[] o = new Object[]{new String("0"), new String("2")};
                wrapper.eq("a.activityStatus", (Object)searchDto.getActivityStatus());
                wrapper.notIn("o.orderStatus", o);
            }
        }
        wrapper.orderBy("a.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public OrderForm findOrderFormByAcivity(Activity activity) {
        ArrayList criterionList = Lists.newArrayList();
        if (activity != null) {
            criterionList.add(Restrictions.eq((String)"activity", (Object)activity));
        }
        return (OrderForm)this.selectOne(criterionList);
    }

    public List<OrderFormDataDTO> queryOrderDetail(OrderForm orderForm) {
        String sql = "SELECT m.amount,            m.fyxm,            m.name,            m.contactName,            m.contactPhone     FROM        (SELECT a.discountAmount AS amount,              '\u98ce\u9669\u8bc4\u4f30\u62a5\u544a\u8d39\u7528' AS fyxm,              (SELECT d.name                 FROM risk_activity_cooper b , risk_serviceorg c ,risk_org d                 WHERE b.org_id = c.oid                   AND c.oid = d.oid                  AND c.serviceOrgType = '1'                  AND b.activity_id = a.activity_id) AS name,              (SELECT c.contactName                 FROM risk_activity_cooper b , risk_serviceorg c                WHERE b.org_id = c.oid                   AND c.serviceOrgType = '1'                  AND b.activity_id = a.activity_id) AS contactName ,              (SELECT c.contactPhone                 FROM risk_activity_cooper b , risk_serviceorg c                 WHERE b.org_id = c.oid                   AND c.serviceOrgType = '1'                  AND b.activity_id = a.activity_id) AS contactPhone           FROM risk_orderform a         WHERE IFNULL(a.discountAmount,0)>0           AND a.oid = " + orderForm.getOid() + "      UNION        SELECT a.contractAmount AS amount,              '\u5408\u540c\u8ba4\u8bc1\u8d39\u7528' AS fyxm,               NULL AS name,               NULL AS contactName ,               NULL AS contactPhone          FROM risk_orderform a        WHERE IFNULL(a.contractAmount,0)>0          AND a.oid = " + orderForm.getOid() + "      UNION        SELECT a.monitorAmount AS amount,              '\u89c6\u9891\u76d1\u63a7\u8d39\u7528' AS fyxm,               NULL AS name,               NULL AS contactName ,               NULL AS contactPhone         FROM risk_orderform a        WHERE IFNULL(a.monitorAmount,0)>0          AND a.oid = " + orderForm.getOid() + "      UNION        SELECT a.supplyAmount AS amount,              '\u8865\u5145\u8d39\u7528' AS fyxm,               NULL AS name,               NULL AS contactName ,               NULL AS contactPhone         FROM risk_orderform a        WHERE IFNULL(a.supplyAmount,0)>0          AND a.oid = " + orderForm.getOid() + " ) m ";
        ArrayList dtoList = Lists.newArrayList();
        List pageList = this.queryMaps(sql);
        pageList.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<OrderForm> queryNeedSyncOrder() {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.or((Criterion)Restrictions.eq((String)"isSync", (Object)"0"), (Criterion)Restrictions.isNull((String)"isSync")));
        criterionList.add(Restrictions.eq((String)"orderStatus", (Object)"1"));
        Order order = Order.desc((String)"oid");
        return this.selectList(criterionList, order);
    }

    public List manageActivityList(OrderFormSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select p.province,sr1.city,sr2.area, o.oid as orderId,  a.oid as activityId,a.name as activityName,  a.activitySource,  a.approveOrg as approvalUnit,  o.orderNo,DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn, DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate,  a.address ,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn , a.activityType ,o.orderStatus,a.activityStatus,a.approvalStatus, a.sbApprovalStatus, sd.label as activityStatusName,o.amount,  DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate, DATE_FORMAT(a.endDate,'%Y-%m-%d %H:%i:%s') AS endDate,  a.sponsor, if(timeStampDiff(DAY, NOW(), startDate)>0, timeStampDiff(DAY, NOW(), startDate),'') AS dateFrom ,b.paymentMode  from RISK_ACTIVITY a  inner join RISK_ORDERFORM o on o.activity_id = a.oid  inner join sys_region p on p.oid = a.province_id inner join RISK_SE_USER u on o.user_id = u.oid  inner JOIN sys_region sr1 ON sr1.oid = a.city_id  LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id  INNER JOIN sys_dict sd on sd.`value`= a.activityStatus and sd.type='activityStatus' LEFT JOIN risk_transaction b on b.orderNo = o.orderNo and b.payStatus='1' where 1=1  and o.orderStatus != '9' ";
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') >= '" + searchDto.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') <= '" + searchDto.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate1())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') >= '" + searchDto.getEndDate1() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate2())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') <= '" + searchDto.getEndDate2() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') >= '" + searchDto.getOrderDateStart() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') <= '" + searchDto.getOrderDateEnd() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCreateDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') >= '" + searchDto.getCreateDateStart() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCreateDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') <= '" + searchDto.getCreateDateEnd() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivitySource())) {
            sql = sql + " AND a.activitySource = '" + searchDto.getActivitySource() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityType())) {
            sql = sql + " AND a.activityType = '" + searchDto.getActivityType() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityStatus())) {
            sql = sql + " AND a.activityStatus = '" + searchDto.getActivityStatus() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getSbApprovalStatus())) {
            sql = sql + " AND a.sbApprovalStatus = '" + searchDto.getSbApprovalStatus() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = '" + searchDto.getOrderStatus() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayMethod())) {
            sql = sql + "  AND b.paymentMode  = '" + searchDto.getPayMethod() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyWord())) {
            sql = sql + " AND ( a.sponsor like '%" + searchDto.getKeyWord() + "%' OR  a.`name` LIKE '%" + searchDto.getKeyWord() + "%' OR a.address LIKE '%" + searchDto.getKeyWord() + "%')";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvinceId())) {
            sql = sql + " AND a.province_id = '" + searchDto.getProvinceId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCityId())) {
            sql = sql + " AND a.city_id = '" + searchDto.getCityId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getAreaId())) {
            sql = sql + " AND a.area_id = '" + searchDto.getAreaId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getApprovalUnit())) {
            sql = sql + " AND sr3.area like '%" + searchDto.getApprovalUnit() + "%' ";
        }
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + this.getOrderTypeSql(searchDto.getSortValue());
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List manageOrderList(OrderFormSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select p.province,sr1.city,sr2.area, o.oid as orderId,  a.oid as activityId,a.name as activityName,  a.activitySource,  a.approveOrg as approvalUnit,  o.orderNo,DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn, DATE_FORMAT(a.activityDate,'%Y-%m-%d %H:%i:%s') AS activityDate,  DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate,  a.address ,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn , a.activityType ,o.orderStatus,a.activityStatus,a.approvalStatus, a.sbApprovalStatus, sd.label as activityStatusName,o.amount,  DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate, DATE_FORMAT(a.endDate,'%Y-%m-%d %H:%i:%s') AS endDate,  a.sponsor, if(timeStampDiff(DAY, NOW(), startDate)>0, timeStampDiff(DAY, NOW(), startDate),'') AS dateFrom ,b.paymentMode  from RISK_ACTIVITY a  inner join RISK_ORDERFORM o on o.activity_id = a.oid  inner join sys_region p on p.oid = a.province_id inner join RISK_SE_USER u on o.user_id = u.oid  inner JOIN sys_region sr1 ON sr1.oid = a.city_id  LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id  INNER JOIN sys_dict sd on sd.`value`= a.activityStatus and sd.type='activityStatus' LEFT JOIN risk_transaction b on b.orderNo = o.orderNo and b.payStatus='1' where 1=1  and o.orderStatus != '9'  and a.activitySource != 2 and a.gov != 1  and a.isBackUp != 1 ";
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') >= '" + searchDto.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') <= '" + searchDto.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate1())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') >= '" + searchDto.getEndDate1() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate2())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') <= '" + searchDto.getEndDate2() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') >= '" + searchDto.getOrderDateStart() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') <= '" + searchDto.getOrderDateEnd() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCreateDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') >= '" + searchDto.getCreateDateStart() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCreateDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') <= '" + searchDto.getCreateDateEnd() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityType())) {
            sql = sql + " AND a.activityType = '" + searchDto.getActivityType() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityStatus())) {
            sql = sql + " AND a.activityStatus = '" + searchDto.getActivityStatus() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getSbApprovalStatus())) {
            sql = sql + " AND a.sbApprovalStatus = '" + searchDto.getSbApprovalStatus() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = '" + searchDto.getOrderStatus() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayMethod())) {
            sql = sql + "  AND b.paymentMode  = '" + searchDto.getPayMethod() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyWord())) {
            sql = sql + " AND ( a.sponsor like '%" + searchDto.getKeyWord() + "%' OR  a.`name` LIKE '%" + searchDto.getKeyWord() + "%' OR a.address LIKE '%" + searchDto.getKeyWord() + "%')";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvinceId())) {
            sql = sql + " AND a.province_id = '" + searchDto.getProvinceId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCityId())) {
            sql = sql + " AND a.city_id = '" + searchDto.getCityId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getAreaId())) {
            sql = sql + " AND a.area_id = '" + searchDto.getAreaId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getApprovalUnit())) {
            sql = sql + " AND sr3.area like '%" + searchDto.getApprovalUnit() + "%' ";
        }
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + this.getOrderTypeSql(searchDto.getSortValue());
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List manageBusinessList(OrderFormSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT p.province,sr1.city,sr2.area,a.oid AS activityId, a.NAME AS activityName, a.activitySource, a.approveOrg as approvalUnit, DATE_FORMAT(a.activityDate,'%Y-%m-%d %H:%i:%s') AS activityDate, DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate, a.address,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn,a.activityType, a.activityStatus,sd.label as activityStatusName,a.sbApprovalStatus,DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate, DATE_FORMAT(a.endDate,'%Y-%m-%d %H:%i:%s') AS endDate,a.sponsor, if(timeStampDiff(DAY, NOW(), startDate)>0,timeStampDiff(DAY, NOW(), startDate),'') AS dateFrom  FROM RISK_ACTIVITY a  INNER JOIN risk_orderForm o ON a.oid = o.activity_id  INNER JOIN sys_region p ON p.oid = a.province_id  LEFT JOIN sys_region sr1 ON sr1.oid = a.city_id  LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id  INNER JOIN sys_dict sd on sd.`value`= a.activityStatus and sd.type='activityStatus' and a.gov != 1  and a.isBackUp != 1  AND o.orderStatus != '9'";
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') >= '" + searchDto.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') <= '" + searchDto.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate1())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') >= '" + searchDto.getEndDate1() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate2())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') <= '" + searchDto.getEndDate2() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') >= '" + searchDto.getOrderDateStart() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') <= '" + searchDto.getOrderDateEnd() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCreateDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') >= '" + searchDto.getCreateDateStart() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCreateDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') <= '" + searchDto.getCreateDateEnd() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityType())) {
            sql = sql + " AND a.activityType = '" + searchDto.getActivityType() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityStatus())) {
            sql = sql + " AND a.activityStatus = '" + searchDto.getActivityStatus() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getSbApprovalStatus())) {
            sql = sql + " AND a.sbApprovalStatus = '" + searchDto.getSbApprovalStatus() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyWord())) {
            sql = sql + " AND ( a.sponsor like '%" + searchDto.getKeyWord() + "%' OR  a.`name` LIKE '%" + searchDto.getKeyWord() + "%' OR a.address LIKE '%" + searchDto.getKeyWord() + "%')";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvinceId())) {
            sql = sql + " AND a.province_id = '" + searchDto.getProvinceId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCityId())) {
            sql = sql + " AND a.city_id = '" + searchDto.getCityId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getAreaId())) {
            sql = sql + " AND a.area_id = '" + searchDto.getAreaId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getApprovalUnit())) {
            sql = sql + " AND sr3.area like '%" + searchDto.getApprovalUnit() + "%' ";
        }
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + this.getOrderTypeSql(searchDto.getSortValue());
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List manageGovActivityList(OrderFormSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT p.province,sr1.city,sr2.area,a.oid AS activityId, a.approveOrg as approvalUnit,  a. NAME AS activityName,DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS activityDate, a.address,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn,a.activityType, a.activityStatus,sd.label as activityStatusName,DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate, DATE_FORMAT(a.endDate,'%Y-%m-%d %H:%i:%s') AS endDate,a.sponsor, DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate, if(timeStampDiff(DAY, NOW(), startDate)>0,timeStampDiff(DAY, NOW(), startDate),'') AS dateFrom,  a.isBackup  FROM RISK_ACTIVITY a  INNER JOIN risk_orderForm o ON a.oid = o.activity_id  INNER JOIN sys_region p ON p.oid = a.province_id  LEFT JOIN sys_region sr1 ON sr1.oid = a.city_id  LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id  INNER JOIN sys_dict sd on sd.`value`= a.activityStatus and sd.type='activityStatus' where a.gov = '1' and a.isBackup = 1  AND o.orderStatus != '9' ";
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') >= '" + searchDto.getStartDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') <= '" + searchDto.getEndDate() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate1())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') >= '" + searchDto.getEndDate1() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate2())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') <= '" + searchDto.getEndDate2() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') >= '" + searchDto.getOrderDateStart() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') <= '" + searchDto.getOrderDateEnd() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCreateDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') >= '" + searchDto.getCreateDateStart() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCreateDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') <= '" + searchDto.getCreateDateEnd() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityType())) {
            sql = sql + " AND a.activityType = '" + searchDto.getActivityType() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityStatus())) {
            sql = sql + " AND a.activityStatus = '" + searchDto.getActivityStatus() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getIsAssessment())) {
            sql = sql + " AND a.needReport = '" + searchDto.getIsAssessment() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyWord())) {
            sql = sql + " AND ( a.sponsor like '%" + searchDto.getKeyWord() + "%' OR  a.`name` LIKE '%" + searchDto.getKeyWord() + "%' OR a.address LIKE '%" + searchDto.getKeyWord() + "%')";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvinceId())) {
            sql = sql + " AND a.province_id = '" + searchDto.getProvinceId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCityId())) {
            sql = sql + " AND a.city_id = '" + searchDto.getCityId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getAreaId())) {
            sql = sql + " AND a.area_id = '" + searchDto.getAreaId() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getApprovalUnit())) {
            sql = sql + " AND a.approveOrg like '%" + searchDto.getApprovalUnit() + "%' ";
        }
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + this.getOrderTypeSql(searchDto.getSortValue());
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    private String getOrderTypeSql(String order) {
        if (OrderTypeEnum.ORDER_DESC.getKey().equals(order)) {
            return " ORDER BY a.orderDate DESC ";
        }
        if (OrderTypeEnum.ORDER_ASC.getKey().equals(order)) {
            return " ORDER BY a.orderDate ASC ";
        }
        if (OrderTypeEnum.DATE_FROM_ASC.getKey().equals(order)) {
            return " ORDER BY  timeStampDiff(DAY, NOW(), a.startDate) <=0,timeStampDiff(DAY, NOW(), a.startDate) asc ";
        }
        if (OrderTypeEnum.DATE_FROM_DESC.getKey().equals(order)) {
            return " ORDER BY timeStampDiff(DAY, NOW(), a.startDate) desc ";
        }
        if (OrderTypeEnum.ACTIVITY_START_DATE_ASC.getKey().equals(order)) {
            return " ORDER BY a.startDate ASC ";
        }
        if (OrderTypeEnum.ACTIVITY_START_DATE_DESC.getKey().equals(order)) {
            return " ORDER BY a.startDate DESC ";
        }
        if (OrderTypeEnum.ACTIVITY_END_DATE_ASC.getKey().equals(order)) {
            return " ORDER BY a.endDate ASC ";
        }
        if (OrderTypeEnum.ACTIVITY_END_DATE_DESC.getKey().equals(order)) {
            return " ORDER BY a.endDate DESC ";
        }
        if (OrderTypeEnum.ORDER_AMOUNT_DESC.getKey().equals(order)) {
            return " ORDER BY o.amount DESC ";
        }
        if (OrderTypeEnum.ORDER_AMOUNT_ASC.getKey().equals(order)) {
            return " ORDER BY o.amount ASC ";
        }
        if (OrderTypeEnum.CREATE_DESC.getKey().equals(order)) {
            return " ORDER BY a.createOn DESC ";
        }
        if (OrderTypeEnum.CREATE_ASC.getKey().equals(order)) {
            return " ORDER BY a.createOn ASC ";
        }
        return " ORDER BY a.oid DESC ";
    }

    public List<OrderFormDataDTO> findServiceOrderListByOrderStatus(OrderFormSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select t.paymentMode,o.refundAmount,o.oid as orderId, a.oid as activityId, a.name as activityName, a.activitySource, so.serviceOrgType, o.orderNo,DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate,a.activityType,o.orderStatus, a.activityStatus,o.reportAmount as reportAmount,o.discountAmount as discountAmount,o.amount as total,ac.amount ,a.gov,IFNULL(a.chooseAssess,'1') AS chooseAssess  from RISK_ACTIVITY a  inner join RISK_ORDERFORM o on o.activity_id = a.oid  inner join RISK_ACTIVITY_COOPER ac on ac.activity_id = a.oid  inner join RISK_SERVICEORG so on so.oid = ac.org_id  left join risk_transaction t on t.orderForm_id  = o.oid ";
        wrapper.notIn("o.orderStatus", (Collection)Lists.newArrayList((Object[])new String[]{"9"}));
        wrapper.notIn("a.activitySource", (Collection)Lists.newArrayList((Object[])new String[]{"2"}));
        if (searchDto.getOrg() != null) {
            wrapper.eq("ac.org_id", (Object)searchDto.getOrg().getOid());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyname())) {
            wrapper.like("a.name", searchDto.getKeyname());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProcess())) {
            wrapper.eq("o.orderStatus", (Object)searchDto.getProcess());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderStatus())) {
            wrapper.eq("o.orderStatus", (Object)searchDto.getOrderStatus());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivitySource())) {
            wrapper.eq("a.activitySource", (Object)searchDto.getActivitySource());
        }
        wrapper.orderBy("a.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List findExportActivityList(OrderFormSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer("select DISTINCT ");
        sql.append("ra.createOn,");
        sql.append("ra.orderDate,");
        sql.append("rof.orderNo,");
        sql.append("ra.`name` as 'activityName',");
        sql.append("dict7.label as 'activitySource',");
        sql.append("dict6.label as 'activityType',");
        sql.append("sd5.label as 'activityStatus',");
        sql.append("CONCAT(sr1.province,IFNULL(sr2.city,''),IFNULL(sr3.area,'')) as 'place',");
        sql.append("ra.address,");
        sql.append("ra.sbApprovalStatus,");
        sql.append("if(ra.isBackup=1,'\u5426','\u662f') as isBackup,");
        sql.append("ra.sponsor,");
        sql.append("ra.startDate,");
        sql.append("ra.endDate,");
        sql.append("if(timeStampDiff(DAY, NOW(), ra.startDate)>0,timeStampDiff(DAY, NOW(), ra.startDate),'') AS dateFrom,");
        sql.append("rsu.realName,");
        sql.append("rsu.phone,");
        sql.append("rt.endTime,");
        sql.append("rof.amount,");
        sql.append("rof.reportAmount,");
        sql.append("rof.discountAmount,");
        sql.append("if( rt.paymentMode='2','\u7ebf\u4e0b\u652f\u4ed8',sd4.label) as 'paymentMode',");
        sql.append("sd1.label as 'orderStatus',");
        sql.append("rof.contractAmount,");
        sql.append("rof.monitorAmount,");
        sql.append("sd2.label as 'reportExpressMode',");
        sql.append("sd3.label as 'invoiceExpressMode',");
        sql.append("org.`name` as 'riskCompany',");
        sql.append("IF(ri.oid is null,'\u672a\u5728\u5e73\u53f0\u8d2d\u4e70\u4fdd\u969c','\u5df2\u6295\u4fdd') as 'insurancePolicy'");
        sql.append("from risk_activity ra");
        sql.append(" INNER JOIN SYS_DICT dict6 on dict6.type='ACTIVITYTYPE' and dict6.`value`=ra.activityType");
        sql.append(" INNER JOIN SYS_DICT dict7 on dict7.type='ACTIVITYSOURCE' and dict7.`value`=ra.activitySource");
        sql.append(" INNER JOIN RISK_OrderForm rof on ra.oid=rof.activity_id");
        sql.append(" LEFT JOIN RISK_Transaction rt on rt.orderForm_id = rof.oid and rt.payStatus='1'");
        sql.append(" INNER JOIN risk_report rr on rr.activity_id=ra.oid");
        sql.append(" LEFT JOIN RISK_ActivityExpress rae on rae.orderForm_id= rof.oid");
        sql.append(" LEFT JOIN (select ro.oid,ro.`name`,rac.activity_id from RISK_Activity_Cooper rac");
        sql.append(" INNER JOIN risk_serviceorg rs on rac.org_id=rs.oid and rs.serviceOrgType='1'");
        sql.append(" INNER JOIN risk_org ro on ro.oid=rs.oid  ");
        sql.append(" ) org on org.activity_id = ra.oid");
        sql.append(" LEFT JOIN (select ro.oid,ro.`name`,rac.activity_id from RISK_Activity_Cooper rac");
        sql.append(" INNER JOIN risk_serviceorg rs on rac.org_id=rs.oid and rs.serviceOrgType='5'");
        sql.append(" INNER JOIN risk_org ro on ro.oid=rs.oid  ");
        sql.append(" ) org1 on org1.activity_id = ra.oid");
        sql.append(" LEFT JOIN RISK_InsurancePolicy ri on ri.activity_id=ra.oid");
        sql.append(" INNER JOIN risk_se_user rsu on rsu.oid= ra.user_id");
        sql.append(" INNER JOIN sys_region sr1 on sr1.oid=ra.province_id");
        sql.append(" LEFT JOIN sys_region sr2 on sr2.oid=ra.city_id");
        sql.append(" LEFT JOIN sys_region sr3 on sr3.oid=ra.area_id");
        sql.append(" LEFT JOIN sys_dict sd1 on sd1.type='ORDERSTATUS' and sd1.`value`=rof.orderStatus");
        sql.append(" LEFT JOIN sys_dict sd2 on sd2.type='REPORTEXPRESS' and sd2.`value`=rae.reportExpressMode");
        sql.append(" LEFT JOIN sys_dict sd3 on sd3.type='INVOICEEXPRESS' and sd3.`value`=rae.invoiceExpressMode");
        sql.append(" LEFT JOIN sys_dict sd4 on sd4.type='PAYMENTTYPE' and sd4.`value`=rt.paymentType");
        sql.append(" INNER JOIN sys_dict sd5 on sd5.type='ACTIVITYSTATUS' and sd5.`value`=ra.activityStatus");
        sql.append(" where rof.orderStatus != '9' ");
        if (StringUtil.isEmpty((String)searchDto.getExportType())) {
            return null;
        }
        if (!"1".equals(searchDto.getExportType())) {
            if ("2".equals(searchDto.getExportType())) {
                sql.append(" AND ra.activitySource != '2'");
            } else if ("3".equals(searchDto.getExportType())) {
                sql.append(" and ra.isBackup = '0' and ra.activitySource != '2'");
            } else if ("4".equals(searchDto.getExportType())) {
                sql.append(" and ra.gov = '1' AND ra.isBackup = '1' and ra.activitySource != '2'");
            }
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStartDate())) {
            sql.append(" AND DATE_FORMAT(ra.startDate,'%Y-%m-%d') >= '" + searchDto.getStartDate() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
            sql.append(" AND DATE_FORMAT(ra.startDate,'%Y-%m-%d') <= '" + searchDto.getEndDate() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate1())) {
            sql.append(" AND DATE_FORMAT(ra.endDate,'%Y-%m-%d') >= '" + searchDto.getEndDate1() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndDate2())) {
            sql.append(" AND DATE_FORMAT(ra.endDate,'%Y-%m-%d') <= '" + searchDto.getEndDate2() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderDateStart())) {
            sql.append("  AND DATE_FORMAT(ra.orderDate,'%Y-%m-%d') >= '" + searchDto.getOrderDateStart() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderDateEnd())) {
            sql.append("  AND DATE_FORMAT(ra.orderDate,'%Y-%m-%d') <= '" + searchDto.getOrderDateEnd() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCreateDateStart())) {
            sql.append(" AND DATE_FORMAT(ra.createOn,'%Y-%m-%d') >= '" + searchDto.getCreateDateStart() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCreateDateEnd())) {
            sql.append("  AND DATE_FORMAT(ra.createOn,'%Y-%m-%d') <= '" + searchDto.getCreateDateEnd() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivitySource())) {
            sql.append("  AND ra.activitySource = '" + searchDto.getActivitySource() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityType())) {
            sql.append("  AND ra.activityType = '" + searchDto.getActivityType() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityStatus())) {
            sql.append("  AND ra.activityStatus = '" + searchDto.getActivityStatus() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getSbApprovalStatus())) {
            sql.append("  AND ra.sbApprovalStatus = '" + searchDto.getSbApprovalStatus() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOrderStatus())) {
            sql.append("  AND  rof.orderStatus = '" + searchDto.getOrderStatus() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getPayMethod())) {
            sql.append("  AND rt.paymentMode  = '" + searchDto.getPayMethod() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyWord())) {
            sql.append(" AND ( ra.sponsor like '%" + searchDto.getKeyWord() + "%' OR  ra.`name` LIKE '%" + searchDto.getKeyWord() + "%' OR ra.address LIKE '%" + searchDto.getKeyWord() + "%')");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvinceId())) {
            sql.append("  AND ra.province_id = '" + searchDto.getProvinceId() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCityId())) {
            sql.append(" AND ra.city_id = '" + searchDto.getCityId() + "' ");
        }
        if (StringUtil.isNotEmpty((String)searchDto.getAreaId())) {
            sql.append(" AND ra.area_id = '" + searchDto.getAreaId() + "' ");
        }
        sql.append(this.getExportOrderTypeSql(searchDto.getSortValue()));
        System.out.println(sql.toString());
        return this.queryMaps(sql.toString(), (Wrapper)wrapper);
    }

    private String getExportOrderTypeSql(String order) {
        if (Objects.equals(order, OrderTypeEnum.ORDER_DESC.getKey())) {
            return " ORDER BY ra.orderDate DESC ";
        }
        if (Objects.equals(order, OrderTypeEnum.ORDER_ASC.getKey())) {
            return " ORDER BY ra.orderDate ASC ";
        }
        if (Objects.equals(order, OrderTypeEnum.ORDER_AMOUNT_DESC.getKey())) {
            return " ORDER BY rof.amount DESC ";
        }
        if (Objects.equals(order, OrderTypeEnum.ORDER_AMOUNT_ASC.getKey())) {
            return " ORDER BY rof.amount ASC ";
        }
        if (Objects.equals(order, OrderTypeEnum.DATE_FROM_DESC.getKey())) {
            return "  ORDER BY  timeStampDiff(DAY, NOW(), ra.startDate) <=0,timeStampDiff(DAY, NOW(), ra.startDate) DESC ";
        }
        if (Objects.equals(order, OrderTypeEnum.DATE_FROM_ASC.getKey())) {
            return "  ORDER BY  timeStampDiff(DAY, NOW(), ra.startDate) <=0,timeStampDiff(DAY, NOW(), ra.startDate) ASC ";
        }
        if (Objects.equals(order, OrderTypeEnum.ACTIVITY_START_DATE_DESC.getKey())) {
            return " ORDER BY ra.startDate DESC ";
        }
        if (Objects.equals(order, OrderTypeEnum.ACTIVITY_START_DATE_ASC.getKey())) {
            return " ORDER BY ra.startDate ASC ";
        }
        if (Objects.equals(order, OrderTypeEnum.ACTIVITY_END_DATE_DESC.getKey())) {
            return " ORDER BY ra.endDate DESC ";
        }
        if (Objects.equals(order, OrderTypeEnum.ACTIVITY_END_DATE_ASC.getKey())) {
            return " ORDER BY ra.endDate ASC ";
        }
        if (Objects.equals(order, OrderTypeEnum.CREATE_DESC.getKey())) {
            return " ORDER BY ra.createOn DESC ";
        }
        if (Objects.equals(order, OrderTypeEnum.CREATE_ASC.getKey())) {
            return " ORDER BY ra.createOn ASC ";
        }
        return " ORDER BY ra.oid DESC";
    }

    public OrderForm findOrderFormByActivity(Activity activity) {
        ArrayList<SimpleExpression> criterionList = new ArrayList<SimpleExpression>();
        criterionList.add(Restrictions.eq((String)"activity", (Object)activity));
        List orders = this.selectList(criterionList);
        if (orders != null && orders.size() > 0) {
            return (OrderForm)orders.get(0);
        }
        return null;
    }

    public int countOrder() {
        String sql = "select a.oid                  from RISK_ACTIVITY a                    inner join RISK_ORDERFORM o on o.activity_id = a.oid                   inner join sys_region p on p.oid = a.province_id                  inner join RISK_SE_USER u on o.user_id = u.oid                   inner JOIN sys_region sr1 ON sr1.oid = a.city_id                   LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id                   INNER JOIN sys_dict sd on sd.`value`= a.activityStatus and sd.type='activityStatus'                  LEFT JOIN risk_transaction b on b.orderNo = o.orderNo and b.payStatus='1'                  where 1=1 and o.orderStatus != '9'                   and ((a.gov =1 and a.isBackup ='0') or (a.gov ='' or ISNULL(a.gov) or a.gov ='0')) ;";
        SelectWrapper wrapper = SelectWrapper.instance();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return list.size();
        }
        return 0;
    }

    public int countActivity() {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer("SELECT\n       a.oid\n    FROM\n        RISK_ACTIVITY a  \n    INNER JOIN\n        risk_orderForm o \n            ON a.oid = o.activity_id  \n    INNER JOIN\n        sys_region p \n            ON p.oid = a.province_id  \n    LEFT JOIN\n        sys_region sr1 \n            ON sr1.oid = a.city_id  \n    LEFT JOIN\n        sys_region sr2 \n            ON sr2.oid = a.area_id  \n    INNER JOIN\n        sys_dict sd \n            on sd.`value`= a.activityStatus \n            and sd.type='activityStatus' \n            AND (\n                a.gov ='' \n                or ISNULL(a.gov) \n                or a.gov ='0'\n            )  \n            AND o.orderStatus NOT IN (\n                '9'\n            ) \n    ORDER BY\n        a.oid DESC  ");
        List list = this.queryMaps(sql.toString(), (Wrapper)wrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return list.size();
        }
        return 0;
    }

    public int countGovActivity() {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer("SELECT\n       a.oid\n    FROM\n        RISK_ACTIVITY a  \n    INNER JOIN\n        sys_region p \n            ON p.oid = a.province_id  \n    LEFT JOIN\n        sys_region sr1 \n            ON sr1.oid = a.city_id  \n    LEFT JOIN\n        sys_region sr2 \n            ON sr2.oid = a.area_id  \n    INNER JOIN\n        sys_dict sd \n            on sd.`value`= a.activityStatus \n            and sd.type='activityStatus' \n    where\n        a.gov = '1'  \n        AND a.activityStatus NOT IN (\n            '9'\n        )  \n    ORDER BY\n        a.oid DESC  ");
        List list = this.queryMaps(sql.toString(), (Wrapper)wrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return list.size();
        }
        return 0;
    }

    public List newOrderFormList() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT   p.province,   sr1.city,   sr2.area,   a. NAME AS activityName,   DATE_FORMAT(  a.createOn,  '%Y-%m-%d %H:%i:%s'   ) AS createOn,   a.sponsor FROM   RISK_ACTIVITY a INNER JOIN sys_region p ON p.oid = a.province_id INNER JOIN RISK_ORDERFORM o ON o.activity_id = a.oid INNER JOIN RISK_SE_USER u ON o.user_id = u.oid LEFT JOIN sys_region sr1 ON sr1.oid = a.city_id LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id INNER JOIN sys_dict sd ON sd.`value` = a.activityStatus AND sd.type = 'activityStatus' LEFT JOIN risk_transaction b ON b.orderNo = o.orderNo AND b.payStatus = '1' WHERE   1 = 1 AND o.orderStatus NOT IN ('9') AND (   (a.gov = 1 AND a.isBackup = '0')   OR (  a.gov = ''  OR ISNULL(a.gov)  OR a.gov = '0'   ) ) ORDER BY   a.createOn DESC LIMIT 5 ";
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List newGovActivity() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT   p.province,   sr1.city,   sr2.area,   a. NAME AS activityName,   DATE_FORMAT(  a.createOn,  '%Y-%m-%d %H:%i:%s'   ) AS createOn,   a.sponsor FROM   RISK_ACTIVITY a INNER JOIN sys_region p ON p.oid = a.province_id INNER JOIN RISK_ORDERFORM o ON o.activity_id = a.oid INNER JOIN RISK_SE_USER u ON o.user_id = u.oid LEFT JOIN sys_region sr1 ON sr1.oid = a.city_id LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id INNER JOIN sys_dict sd ON sd.`value` = a.activityStatus AND sd.type = 'activityStatus' LEFT JOIN risk_transaction b ON b.orderNo = o.orderNo AND b.payStatus = '1' WHERE   1 = 1 AND o.orderStatus NOT IN ('9') AND a.gov= '1'ORDER BY   a.createOn DESC LIMIT 5 ";
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public List newActivity() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT   p.province,   sr1.city,   sr2.area,   a. NAME AS activityName,   DATE_FORMAT(  a.createOn,  '%Y-%m-%d %H:%i:%s'   ) AS createOn,   a.sponsor FROM   RISK_ACTIVITY a INNER JOIN sys_region p ON p.oid = a.province_id INNER JOIN RISK_ORDERFORM o ON o.activity_id = a.oid INNER JOIN RISK_SE_USER u ON o.user_id = u.oid LEFT JOIN sys_region sr1 ON sr1.oid = a.city_id LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id INNER JOIN sys_dict sd ON sd.`value` = a.activityStatus AND sd.type = 'activityStatus' LEFT JOIN risk_transaction b ON b.orderNo = o.orderNo AND b.payStatus = '1' WHERE   1 = 1 AND o.orderStatus NOT IN ('9')  AND (a.gov ='' or ISNULL(a.gov) or a.gov ='0') ORDER BY   a.createOn DESC LIMIT 5 ";
        return this.queryMaps(sql, (Wrapper)wrapper);
    }
}

