/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.enums.OperateLogTypeEnum;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.log.OperateLog;
import com.bcxin.risk.log.OperateLogDao;
import com.bcxin.risk.log.dto.search.OperateLogDto;
import com.bcxin.risk.log.dto.search.OperateLogSearchDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="operateLogDao")
public class OperateLogDaoImpl
extends DaoImpl<OperateLog>
implements OperateLogDao {
    public OperateLog findOperateLogByOid(Long oid) {
        return (OperateLog)this.selectById(oid);
    }

    public List<OperateLogDto> findOperateLogList(OperateLogSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select A.oid,A.userId,A.operateType,DATE_FORMAT(A.operateTime,'%Y-%m-%d %H:%i:%s') as operateTime,A.bizId,A.sourceId,A.success,A.content,A.ip,A.expand1,A.expand2,A.activityId,A.activityName, B.userName,B.realName from risk_operate_log A,risk_se_user B where 1=1 and A.userId=B.oid ";
        if (!searchDto.getIsSelfFinance().booleanValue()) {
            String filerType = OperateLogTypeEnum.LOGIN_IN.getKey() + "," + OperateLogTypeEnum.PAY_DELAY.getKey() + "," + OperateLogTypeEnum.CHECK_RECEIPT.getKey();
            sql = sql + " and A.operateType in (" + filerType + ") ";
        }
        if (searchDto.getUserIdList() != null && searchDto.getUserIdList().size() > 0) {
            String ids = "";
            for (Long id : searchDto.getUserIdList()) {
                ids = ids + id + ",";
            }
            if (StringUtil.isNotEmpty((String)ids)) {
                ids = ids.substring(0, ids.length() - 1);
            }
            sql = sql + " and A.userId in ( " + ids + " )";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getOperateType())) {
            sql = sql + " and A.operateType = '" + searchDto.getOperateType() + "'";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getSuccess())) {
            sql = sql + " and A.success = '" + searchDto.getSuccess() + "'";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getKeyword())) {
            sql = sql + " and (A.activityName like '%" + searchDto.getKeyword() + "%' or A.ip like '%" + searchDto.getKeyword() + "%' or B.realName like '%" + searchDto.getKeyword() + "%' or A.activityName like '%" + searchDto.getKeyword() + "%')";
        }
        sql = sql + " order by A.operateTime desc";
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            OperateLogDto dto = new OperateLogDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }
}

