/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.dynamic;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.dynamic.DynamicPanel;
import com.bcxin.risk.dynamic.DynamicPanelDao;
import com.bcxin.risk.dynamic.dto.DynamicPanelDto;
import com.bcxin.risk.dynamic.dto.DynamicSearchDto;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository(value="dynamicPanelDao")
public class DynamicPanelDaoImpl
extends DaoImpl<DynamicPanel>
implements DynamicPanelDao {
    public List<DynamicPanelDto> searchDynamicPanelList(DynamicSearchDto searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select  A.oid, A.templateId, A.dynamicType, A.activityId, A.activityName, B.template, A.templateData, A.orgId, A.contractOrgId, DATE_FORMAT(A.createOn,'%Y-%m-%d %H:%i:%s') as createOn  from risk_dynamic_panel A  INNER JOIN risk_dynamic_panel_template B on A.templateId=B.oid  where 1=1 and A.isShow='1'";
        if (searchDto.getOrgId() != null) {
            sql = sql + " and A.orgId=" + searchDto.getOrgId();
        }
        if (searchDto.getContractOrgId() != null) {
            sql = sql + " and A.contractOrgId=" + searchDto.getContractOrgId();
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityId())) {
            sql = sql + " and A.activityId=" + searchDto.getActivityId();
        }
        if (StringUtil.isNotEmpty((String)searchDto.getDynamicType())) {
            sql = sql + " and A.dynamicType=" + searchDto.getDynamicType();
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityName())) {
            sql = sql + " and A.activityName = '" + searchDto.getActivityName() + "'";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getStartTime())) {
            sql = sql + " and A.createOn >= '" + searchDto.getStartTime() + "'";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getEndTime())) {
            sql = sql + " and A.createOn <= '" + searchDto.getEndTime() + "'";
        }
        sql = StringUtil.isNotEmpty((String)searchDto.getOrder()) ? sql + " order by A.createOn " + searchDto.getOrder() : sql + " order by A.createOn desc ";
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            DynamicPanelDto dto = new DynamicPanelDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public boolean checkDynamic(Long templateId, Long userId, Long activityId) {
        Integer num;
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select count(1) as total from risk_dynamic_panel t where t.activityId=" + activityId + " and t.templateId=" + templateId + " and t.operateId=" + userId;
        Map map = this.queryMap(sql, (Wrapper)wrapper);
        return map != null && (num = Integer.valueOf(Integer.parseInt(map.get("total").toString()))) > 0;
    }

    public String checkPGDynamic(Long templateId, Long orgId, Long activityId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select oid from risk_dynamic_panel t where t.activityId=" + activityId + " and t.templateId=" + templateId + " and t.orgId=" + orgId;
        Map map = this.queryMap(sql, (Wrapper)wrapper);
        if (map != null) {
            String oid = map.get("oid").toString();
            return oid;
        }
        return null;
    }

    public int updateDynamicShowStatus(Long activityId, String showStatus) {
        String sql = "update risk_dynamic_panel set isShow='" + showStatus + "',updateOn=NOW() where activityId='" + activityId + "' and isShow='" + "0" + "'";
        return this.executeSqlUpdate(sql);
    }
}

