/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.compose.dto.search.ComposeWeatherSearchDto;
import com.bcxin.risk.compose.source.ComposeWeather;
import com.bcxin.risk.compose.source.ComposeWeatherDao;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class ComposeWeatherDaoImpl
extends DaoImpl<ComposeWeather>
implements ComposeWeatherDao {
    public List<ComposeWeather> findListByBox(Page page, ComposeWeatherSearchDto searchDto) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getProvinceId() != null) {
            criterionList.add(Restrictions.eq((String)"provinceId", (Object)searchDto.getProvinceId()));
        }
        if (searchDto.getCityId() != null) {
            criterionList.add(Restrictions.eq((String)"cityId", (Object)searchDto.getCityId()));
        }
        if (searchDto.getAreaId() != null) {
            criterionList.add(Restrictions.eq((String)"areaId", (Object)searchDto.getAreaId()));
        }
        if (searchDto.getScenicId() != null) {
            criterionList.add(Restrictions.eq((String)"scenicId", (Object)searchDto.getScenicId()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getName())) {
            criterionList.add(Restrictions.like((String)"name", (Object)("%" + searchDto.getName() + "%")));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public ComposeWeather findOneByComposeWeather(ComposeWeather composeWeather) {
        List<ComposeWeather> list = this.findByComposeWeather(composeWeather);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<ComposeWeather> findByComposeWeather(ComposeWeather composeWeather) {
        ArrayList criterionList = Lists.newArrayList();
        if (composeWeather.getProvinceId() != null) {
            criterionList.add(Restrictions.eq((String)"provinceId", (Object)composeWeather.getProvinceId()));
        } else {
            criterionList.add(Restrictions.isNull((String)"provinceId"));
        }
        if (composeWeather.getCityId() != null) {
            criterionList.add(Restrictions.eq((String)"cityId", (Object)composeWeather.getCityId()));
        } else {
            criterionList.add(Restrictions.isNull((String)"cityId"));
        }
        if (composeWeather.getAreaId() != null) {
            criterionList.add(Restrictions.eq((String)"areaId", (Object)composeWeather.getAreaId()));
        } else {
            criterionList.add(Restrictions.isNull((String)"areaId"));
        }
        if (composeWeather.getScenicId() != null) {
            criterionList.add(Restrictions.eq((String)"scenicId", (Object)composeWeather.getScenicId()));
        } else {
            criterionList.add(Restrictions.isNull((String)"scenicId"));
        }
        return this.selectList(criterionList);
    }
}

