/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.dao;

import com.bcxin.risk.common.dao.RegionDao;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.common.dto.data.RegionDataDto;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class RegionDaoImpl
extends DaoImpl<Region>
implements RegionDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegionDaoImpl.class);

    public List<Region> selectRegionList() {
        Order[] orders = new Order[]{Order.asc((String)"seq"), Order.asc((String)"oid")};
        return this.selectList(orders);
    }

    public List<Region> selectProvinceRegionList() {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", (Object)"1");
        wrapper.orderBy("seq", true);
        return this.selectList((Wrapper)wrapper);
    }

    public List<Region> selectCityRegionList() {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", (Object)"2");
        wrapper.orderBy("seq", true);
        return this.selectList((Wrapper)wrapper);
    }

    public List<Region> selectAreaRegionList() {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", (Object)"3");
        wrapper.orderBy("seq", true);
        return this.selectList((Wrapper)wrapper);
    }

    public List<Region> selectUnitRegionList() {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", (Object)"4");
        wrapper.orderBy("seq", true);
        return this.selectList((Wrapper)wrapper);
    }

    public List<RegionDataDto> queryRegion(Long oid) {
        String sql = "SELECT a.oid,(CASE WHEN a.level = '1' THEN a.province WHEN a.level = '2' THEN a.city ELSE a.area END ) AS area,a.parent_id,a.level,(CASE WHEN (SELECT COUNT(1) FROM risk_org_region WHERE region_id = a.oid AND org_id = " + oid + ")>0 THEN 1 ELSE 0 END) AS xzbz  FROM sys_region a WHERE a.level != '3' ";
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.orderBy("a.oid", true);
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map map = result;
            RegionDataDto dto = new RegionDataDto(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public Region findRegionByname(String name) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.or("city = '" + name + "' or province = '" + name + "'", new Object[0]);
        return (Region)this.selectOne((Wrapper)wrapper);
    }

    public Region findRegionByOid(Long oid) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("oid", (Object)oid);
        return (Region)this.selectById(oid);
    }

    public List<Region> findRegionByParentId(String parentId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("parent_id", (Object)parentId);
        wrapper.orderBy("seq,oid", true);
        return this.selectList((Wrapper)wrapper);
    }

    public List<RegionDataDto> getAllRegion() {
        String sql = "SELECT        a.oid,        (CASE             WHEN a.level = '1' THEN a.province             WHEN a.level = '2' THEN a.city             ELSE a.area         END ) AS area,        a.parent_id,        a.level    FROM        sys_region a     WHERE        a.level != '3' ";
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.orderBy("a.oid", true);
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map map = result;
            RegionDataDto dto = new RegionDataDto(map);
            dtoList.add(dto);
        });
        return dtoList;
    }
}

