/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ResourceBundle;

public class DBConnection {
    private static Connection instance_1;
    private static Connection instance_2;
    private static Connection instance_3;

    public static synchronized Connection getConnection() {
        if (instance_1 == null) {
            instance_1 = DBConnection._getConnection();
        }
        return instance_1;
    }

    public static synchronized Connection getDraftConnection() {
        if (instance_2 == null) {
            instance_2 = DBConnection._getDraftConnection();
        }
        return instance_2;
    }

    public static synchronized Connection getDataTransferConnection() {
        if (instance_3 == null) {
            instance_3 = DBConnection._getDataTransferConnection();
        }
        return instance_3;
    }

    private static Connection _getConnection() {
        ResourceBundle config = ResourceBundle.getBundle("properties/jdbc");
        String driverClassName = config.getString("jdbc.driverClass");
        String url = config.getString("jdbc.url");
        String username = config.getString("jdbc.username");
        String password = config.getString("jdbc.password");
        Connection conn = null;
        try {
            Class.forName(driverClassName);
            conn = DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

    private static Connection _getDraftConnection() {
        ResourceBundle config = ResourceBundle.getBundle("properties/jdbc");
        String driverClassName = config.getString("risk.draft.jdbc.driverClassName");
        String url = config.getString("risk.draft.jdbc.url");
        String username = config.getString("risk.draft.jdbc.username");
        String password = config.getString("risk.draft.jdbc.password");
        Connection conn = null;
        try {
            Class.forName(driverClassName);
            conn = DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

    private static Connection _getDataTransferConnection() {
        ResourceBundle config = ResourceBundle.getBundle("properties/jdbc");
        String driverClassName = config.getString("risk.dataTransfer.jdbc.driverClassName");
        String url = config.getString("risk.dataTransfer.jdbc.url");
        String username = config.getString("risk.dataTransfer.jdbc.username");
        String password = config.getString("risk.dataTransfer.jdbc.password");
        Connection conn = null;
        try {
            Class.forName(driverClassName);
            conn = DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }
}

