/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.activity;

import com.bcxin.risk.activity.Quotation;
import com.bcxin.risk.activity.QuotationRegion;
import com.bcxin.risk.activity.QuotationRegionDao;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.Org;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class QuotationRegionDaoImpl
extends DaoImpl<QuotationRegion>
implements QuotationRegionDao {
    public List<QuotationRegion> findQuotationRegionList(Quotation quotation) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"quotation", (Object)quotation));
        return this.selectList(criterionList);
    }

    public QuotationRegion findQuotationRegion(Quotation quotation, String areaId) {
        ArrayList criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq((String)"quotation", (Object)quotation));
        criterionList.add(Restrictions.eq((String)"region_Id", (Object)areaId));
        List list = this.selectList(criterionList);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (QuotationRegion)list.get(0);
    }

    public String getQuotationRegionIdByOrgIdAndAreaId(String orgId, String areaId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer("SELECT b.oid FROM risk_quotation a,risk_quotationregion b WHERE a.oid = b.quotation_id AND b.`level`='2' AND a.active='1'");
        wrapper.eq("a.org_id", (Object)orgId);
        wrapper.eq("b.region_Id", (Object)areaId);
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryLists(sql.toString(), (Wrapper)wrapper);
        if (list.size() > 0) {
            return (String)list.get(0);
        }
        return "";
    }

    public List<Map<String, Object>> selectQuotationRegion(Org org, String level) {
        String sql = " select q.oid,q.name,r.region_Id from risk_quotation q\n inner join risk_quotationregion r on r.quotation_id = q.oid\n";
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("q.org_id", (Object)org.getOid());
        wrapper.eq("r.level", (Object)level);
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public void deleteQuotationRegion(Quotation quotation, String level) {
        String sql = "delete from risk_quotationRegion where quotation_id = " + quotation.getOid();
        if (StringUtil.isNotEmpty((String)level)) {
            sql = sql + " and level = " + level;
        }
        this.executeSqlUpdate(sql);
    }

    public void deleteExistQuotationRegion(Org org, String oids) {
        String sql = "DELETE\n    FROM risk_quotationregion\n    WHERE EXISTS (SELECT 1\n            FROM risk_quotationfactor f  , risk_quotation q \n                WHERE q.oid = f.quotation_id\n                          AND q.oid = risk_quotationregion.quotation_id\n                          AND q.org_id = " + org.getOid() + " ) and region_Id in (" + oids + ")";
        this.executeSqlUpdate(sql);
    }
}

