/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.activity;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.ActivityMaterial;
import com.bcxin.risk.activity.ActivityMaterialDao;
import com.bcxin.risk.activity.dto.search.ActivityMaterialSearchDTO;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityMaterialDaoImpl
extends DaoImpl<ActivityMaterial>
implements ActivityMaterialDao {
    public ActivityMaterial findActivityMaterialByOid(Long oid) {
        return (ActivityMaterial)this.selectById(oid);
    }

    public List<ActivityMaterial> findActivityMaterialList(ActivityMaterialSearchDTO searchDto) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getUser() != null) {
            criterionList.add(Restrictions.eq((String)"user", (Object)searchDto.getUser()));
        }
        if (searchDto.getActivity() != null) {
            criterionList.add(Restrictions.eq((String)"activity", (Object)searchDto.getActivity()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getActivityMaterialType())) {
            criterionList.add(Restrictions.eq((String)"activityMaterialType", (Object)searchDto.getActivityMaterialType()));
        }
        return this.selectList(criterionList);
    }

    public List<ActivityMaterial> findActivityMaterialByActivity(Activity activity) {
        ArrayList criterionList = Lists.newArrayList();
        if (activity != null) {
            criterionList.add(Restrictions.eq((String)"activity", (Object)activity));
        }
        return this.selectList(criterionList);
    }

    public List<ActivityMaterial> findAcMaterialByActivityAndUser(Activity activity, User user) {
        ArrayList criterionList = Lists.newArrayList();
        if (activity != null) {
            criterionList.add(Restrictions.eq((String)"activity", (Object)activity));
        }
        if (user != null) {
            criterionList.add(Restrictions.eq((String)"user", (Object)user));
        }
        return this.selectList(criterionList);
    }

    public ActivityMaterial findActivityMaterialByActivity(Activity activity, String materialType) {
        List list;
        ArrayList criterionList = Lists.newArrayList();
        if (activity != null) {
            criterionList.add(Restrictions.eq((String)"activity", (Object)activity));
        }
        if (StringUtil.isNotEmpty((String)materialType)) {
            criterionList.add(Restrictions.eq((String)"activityMaterialType", (Object)materialType));
        }
        if (CollectionUtil.isNotEmpty((Collection)(list = this.selectList(criterionList)))) {
            return (ActivityMaterial)list.get(0);
        }
        return null;
    }

    public void mergeActivityMaterial(ActivityMaterial activityMaterial) {
        this.mergeObj(activityMaterial);
    }

    public ActivityMaterial findActivityMaterial(ActivityMaterialSearchDTO searchDto) {
        List materialList;
        ArrayList criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)searchDto.getActivityMaterialType())) {
            criterionList.add(Restrictions.eq((String)"activityMaterialType", (Object)searchDto.getActivityMaterialType()));
        }
        if (searchDto.getActivity() != null) {
            criterionList.add(Restrictions.eq((String)"activity", (Object)searchDto.getActivity()));
        }
        if (searchDto.getUser() != null) {
            criterionList.add(Restrictions.eq((String)"user", (Object)searchDto.getUser()));
        }
        if (CollectionUtil.isNotEmpty((Collection)(materialList = this.selectList(criterionList)))) {
            return (ActivityMaterial)materialList.get(0);
        }
        return null;
    }

    public Map<String, Object> querySubReport(Activity activity) {
        long activity_id = activity.getOid();
        String sql = "SELECT (CASE WHEN (SELECT COUNT(1)  FROM risk_activitymaterial  WHERE activitymaterialType = '3'  AND activity_id =" + activity_id + ") = m.supOrgCount  THEN '1'  ELSE '0'  END ) AS jcb, (CASE WHEN (SELECT COUNT(1)  FROM risk_activitymaterial  WHERE activitymaterialType = '" + "10" + "'  AND activity_id =" + activity_id + ") = m.supOrgCount  THEN '1'  ELSE '0'  END ) AS jlbg   FROM (SELECT count(1) AS supOrgCount  FROM risk_activity_cooper a,risk_serviceorg b  WHERE a.org_id = b.oid  AND b.serviceOrgType = '" + "9" + "'  AND a.activity_id =" + activity_id + ")m ";
        SelectWrapper wrapper = SelectWrapper.instance();
        return this.queryMap(sql, (Wrapper)wrapper);
    }

    public ActivityMaterial findActivityMaterialByActivityAndType(Activity activity, String approvalMaterial) {
        return null;
    }

    public void updateActivityMaterialByDto(ActivityMaterialSearchDTO dto) {
        long activity_id = dto.getActivity().getOid();
        String sql = "UPDATE risk_activitymaterial  SET commitStatus = '" + dto.getCommitStatus() + "'  WHERE activity_id =" + activity_id + " AND activitymaterialType = '" + dto.getActivityMaterialType() + "'";
        this.executeSqlUpdate(sql);
    }
}

