/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.activity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.ActivityDao;
import com.bcxin.risk.activity.dto.data.ActivityDataDTO;
import com.bcxin.risk.activity.dto.data.BLBCommunicationDto;
import com.bcxin.risk.activity.dto.search.ActivitySearchDTO;
import com.bcxin.risk.base.dao.QueryHelper;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.DomainDateUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository(value="activityDao")
public class ActivityDaoImpl
extends DaoImpl<Activity>
implements ActivityDao {
    public List<Activity> activityList() {
        return this.selectList();
    }

    public Activity findActivityByOid(Long oid) {
        return (Activity)this.selectById(oid);
    }

    public Activity findActivityByName(String name) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("name", (Object)name);
        List list = this.selectList((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (Activity)list.get(0);
    }

    public List<ActivityDataDTO> findActivityByActivityName(String activityName, String filterId) {
        String sql = "SELECT a.oid from risk_activity a  inner join risk_orderForm o on o.activity_id = a.oid where a.name = '" + activityName + "' and o.orderStatus != " + "200" + " and o.orderStatus != " + "9";
        if (StringUtil.isNotEmpty((String)filterId)) {
            sql = sql + " and a.oid !='" + filterId + "'";
        }
        SelectWrapper wrapper = SelectWrapper.instance();
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public Activity findActivityByActivityNo(String activityNo) {
        return (Activity)this.selectOne(SelectWrapper.instance().eq("activityNo", (Object)activityNo));
    }

    public List<ActivityDataDTO> findActivityDtoList(ActivitySearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if (searchDto != null) {
            if (searchDto.getActivityStatus() != null) {
                wrapper.eq("activityStatus", (Object)searchDto.getActivityStatus());
            }
            if (searchDto.getSponsor() != null) {
                wrapper.like("sponsor", searchDto.getSponsor());
            }
            if (searchDto.getOrderNo() != null) {
                wrapper.eq("orderNo", (Object)searchDto.getOrderNo());
            }
            if (searchDto.getStarttime() != null) {
                wrapper.ge("createOn", (Object)DomainDateUtil.parseDate((String)searchDto.getStarttime()));
            }
            if (searchDto.getEndtime() != null) {
                wrapper.le("endDate", (Object)DomainDateUtil.parseDate((String)searchDto.getEndtime()));
            }
            if (searchDto.getUser() != null) {
                wrapper.eq("user_id", (Object)searchDto.getUser().getOid());
            }
            if (searchDto.getActivityType() != null) {
                wrapper.eq("activityType", (Object)searchDto.getActivityType());
            }
            if (StringUtil.isNotEmpty((String)searchDto.getName())) {
                wrapper.like("name", searchDto.getName());
            }
        }
        wrapper.orderBy("updateOn", false);
        wrapper.orderBy("oid", false);
        List list = Lists.newArrayList();
        if (page == null) {
            list = this.queryMaps("select * from risk_activity ", (Wrapper)wrapper);
        } else {
            Page rpage = this.queryMapsPage("select * from risk_activity ", (Wrapper)wrapper, page);
            list = rpage.getRecords();
        }
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            ActivityDataDTO dto = (ActivityDataDTO)BeanUtil.mapToBean((Map)result, ActivityDataDTO.class, (boolean)true);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ActivityDataDTO> findActivityList(ActivitySearchDTO searchDto, Page page) {
        String sql = "SELECT oid, name, address, activityStatus, gov, (SELECT label   FROM sys_dict WHERE type = 'activityStatus' AND value = risk_activity.activityStatus) AS activityStatusLabel , (SELECT label    FROM sys_dict  WHERE value = risk_activity.activityType) AS activityType  FROM risk_activity ";
        if (searchDto != null) {
            if (StringUtil.isNotEmpty((String)searchDto.getActivityStatus())) {
                sql = sql + " AND activityStatus ='" + searchDto.getActivityStatus() + "' ";
            }
            if (StringUtil.isNotEmpty((String)searchDto.getSponsor())) {
                sql = sql + " AND sponsor like'%" + searchDto.getSponsor() + "%' ";
            }
            if (StringUtil.isNotEmpty((String)searchDto.getStartDate())) {
                sql = sql + " AND startDate <='" + searchDto.getStartDate() + "' ";
            }
            if (StringUtil.isNotEmpty((String)searchDto.getEndDate())) {
                sql = sql + " AND endDate >='" + searchDto.getEndDate() + "' ";
            }
            if (searchDto.getUser() != null) {
                sql = sql + " AND user_id =" + searchDto.getUser().getOid() + " ";
            }
            if (searchDto.getActivityType() != null) {
                sql = sql + " AND activityType ='" + searchDto.getActivityType() + "' ";
            }
            if (StringUtil.isNotEmpty((String)searchDto.getName())) {
                sql = sql + " AND name like'%" + searchDto.getName() + "%' ";
            }
        }
        sql = sql + "ORDER BY createOn DESC";
        SelectWrapper wrapper = SelectWrapper.instance();
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List findActivityHistoryList(ActivitySearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT  a.oid, a.createOn, a.activityNo, a.name, a.sponsor, o.name as assessment, p.province, c.city, area.area FROM risk_activity a inner join risk_activity_cooper ac on ac.activity_id = a.oid inner join risk_serviceorg so on so.oid = ac.org_id  inner join risk_org o on o.oid = so.oid inner join sys_region p on p.oid = a.province_id inner join sys_region c on c.oid = a.city_id left join sys_region area on area.oid = a.area_id where 1=1 and so.serviceOrgType = '1' and a.activitysource = '2' ";
        if (StringUtil.isNotEmpty((String)searchDto.getActivityNo())) {
            sql = sql + " AND a.activityNo = '" + searchDto.getActivityNo() + "' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getName())) {
            sql = sql + " AND a.name like '%" + searchDto.getName() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getSponsor())) {
            sql = sql + " AND sponsor like'%" + searchDto.getSponsor() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getAssessment())) {
            sql = sql + " AND o.name like '%" + searchDto.getAssessment() + "%' ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getProvince())) {
            sql = sql + " AND a.province_id = " + searchDto.getProvince() + " ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getCity())) {
            sql = sql + " AND a.city_id = " + searchDto.getCity() + " ";
        }
        if (StringUtil.isNotEmpty((String)searchDto.getArea())) {
            sql = sql + " AND a.area_id = " + searchDto.getArea() + " ";
        }
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + " ORDER BY a.oid DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return this.queryMaps(sql, (Wrapper)wrapper);
    }

    public Map<String, String> countActivity(ActivitySearchDTO dto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuilder sql = new StringBuilder("select count(1) as allTotal, sum(case r.activityStatus when '50' then 1 else 0 end) as complete, sum(case r.activityStatus when '50' then 0 else 1 end) as uncomplete from RISK_ACTIVITY r ");
        if (dto.getUser() == null) {
            return Maps.newHashMap();
        }
        wrapper.eq("user_id", (Object)dto.getUser().getOid());
        HashMap countMap = Maps.newHashMap();
        Map result = this.queryMap(sql.toString(), (Wrapper)wrapper);
        countMap.put("allTotal", result.get("allTotal") == null ? "0" : result.get("allTotal").toString());
        countMap.put("complete", result.get("complete") == null ? "0" : result.get("complete").toString());
        countMap.put("uncomplete", result.get("uncomplete") == null ? "0" : result.get("uncomplete").toString());
        return countMap;
    }

    public List<ActivityDataDTO> findActivityByApprovalStatus(ActivitySearchDTO activitySearchDTO, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select  DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn, a.oid,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn, p.province AS province , c.city AS city , area.area AS area , a.`name` AS name , a.activitySource , a.address AS address, a.sponsor AS sponsor , a.activityStatus , a.oid AS activityId , a.startDate AS startDate , a.endDate AS endDate  from risk_activity a  inner join sys_region p on p.oid = a.province_id  inner join sys_region c on c.oid = a.city_id  left join sys_region area on area.oid = a.area_id";
        sql = sql + " where a.province_id = '" + activitySearchDTO.getProvince() + "' ";
        if (StringUtil.isNotEmpty((String)activitySearchDTO.getCity())) {
            sql = sql + " and a.city_id = '" + activitySearchDTO.getCity() + "' ";
        }
        if (StringUtil.isNotEmpty((String)activitySearchDTO.getArea())) {
            sql = sql + " and a.area_id  = '" + activitySearchDTO.getArea() + "' ";
        }
        wrapper.orderBy("a.createOn", false);
        wrapper.orderBy("a.oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            ActivityDataDTO dto = new ActivityDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public Map<String, String> getActivitySuccessCount(User user, Long orgId) {
        StringBuilder sql = new StringBuilder(" select count(od.oid) as complete from RISK_ORDERFORM od  inner join RISK_SE_USER se on se.oid = od.user_Id inner join risk_activity a on a.oid = od.activity_id inner join risk_activity_cooper cp on cp.activity_id = a.oid ");
        if (user == null) {
            return Maps.newHashMap();
        }
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("od.orderStatus", (Object)"1");
        wrapper.eq("se.oid", (Object)user.getOid());
        wrapper.eq("cp.org_id", (Object)orgId);
        HashMap countMap = Maps.newHashMap();
        List list = this.queryMaps(sql.toString(), (Wrapper)wrapper);
        for (Object object : list) {
            Map result = (Map)object;
            countMap.put("complete", result.get("complete") == null ? "0" : result.get("complete").toString());
        }
        return countMap;
    }

    public List<BLBCommunicationDto> findBLBCommunicationDtoList(Long userId, String activityType) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT a.oid as activity_id ,a.name    FROM risk_activity a ,risk_orderform c  WHERE a.oid = c.activity_id     AND (c.orderStatus = 1 or c.orderStatus = 4)    AND a.user_id = '" + userId + "'     AND NOT exists  (SELECT 1                       FROM risk_insurancePolicy b                     WHERE a.oid = b.activity_id) ";
        if ("TY".equals(activityType)) {
            sql = sql + "    AND (a.activityType = '100001' or a.activityType = '100006')";
        } else if ("WY".equals(activityType)) {
            sql = sql + "    AND (a.activityType = '100002' or a.activityType = '100006')";
        } else if ("ZL".equals(activityType)) {
            sql = sql + "    AND (a.activityType = '100003' or a.activityType = '100005' or a.activityType = '100006' )";
        } else if ("QT".equals(activityType)) {
            sql = sql + "    AND (a.activityType = '100004' or a.activityType = '100006' or a.activityType = '100007')";
        }
        wrapper.orderBy("a.createOn", false);
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        list.forEach(result -> {
            BLBCommunicationDto dto = new BLBCommunicationDto(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ActivityDataDTO> findTicketList(ActivitySearchDTO searchDto, Page page) {
        StringBuffer stringBuffer = new StringBuffer("SELECT ra.oid,ra.`name`,ra.startDate,ra.endDate,ra.number,ra.days,dict.label as activityType");
        stringBuffer.append(" FROM risk_activity ra");
        stringBuffer.append(" INNER JOIN sys_dict dict ON ra.activityType = dict.value and dict.type = 'ActivityType' ");
        SelectWrapper wrapper = SelectWrapper.instance();
        if (StringUtil.isNotEmpty((String)searchDto.getName())) {
            wrapper.like("ra.name", searchDto.getName());
        }
        wrapper.orderBy("ra.createOn", false);
        wrapper.orderBy("ra.oid", false);
        List list = Lists.newArrayList();
        if (page == null) {
            list = this.queryMaps(stringBuffer.toString(), (Wrapper)wrapper);
        } else {
            Page rpage = this.queryMapsPage(stringBuffer.toString(), (Wrapper)wrapper, page);
            list = rpage.getRecords();
        }
        ArrayList dtoList = Lists.newArrayList();
        list.forEach(result -> {
            ActivityDataDTO dto = (ActivityDataDTO)BeanUtil.mapToBean((Map)result, ActivityDataDTO.class, (boolean)true);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ActivityDataDTO> findUnInsureReportList(User user, String productType) {
        HashMap paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("select  a.oid,a.name from risk_orderform o inner join risk_activity a on a.oid = o.activity_id  inner join risk_se_user se on se.oid = o.user_id  inner join risk_insuranceproduct i on i.activityType = t.oid where   1=1   and i.productType =:productone    and se.oid =:seoidone    and o.orderStatus = 1    and  a.oid not in  ( select   aa.oid   from risk_orderform oo  inner join risk_activity aa on aa.oid = oo.activity_id    inner join risk_se_user see on see.oid = oo.user_id    inner join risk_insurancepolicy pol on pol.activity_id = aa.oid    inner join risk_insuranceproduct ii on ii.activityType = tt.oid  where  1=1   and ii.productType =:producttwo   and see.oid =:seoidtwo    and oo.orderStatus = 1)");
        if (user == null || productType == null) {
            return Lists.newArrayList();
        }
        paramMap.put("productone", productType);
        paramMap.put("producttwo", productType);
        paramMap.put("seoidone", user.getOid());
        paramMap.put("seoidtwo", user.getOid());
        ArrayList dtoList = Lists.newArrayList();
        List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
        list.forEach(result -> {
            Map map = (Map)result;
            ActivityDataDTO dto = new ActivityDataDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ActivityDataDTO> findActivityByOrgId(Long orgId) {
        String sql = "SELECT A.oid,A.name from risk_activity A,risk_activity_cooper B  where A.oid=B.activity_id and B.org_id=" + orgId + " order by A.createOn desc";
        ArrayList dtoList = Lists.newArrayList();
        List<Object> list = QueryHelper.findBySql(sql, null);
        list.forEach(result -> {
            Map map = (Map)result;
            ActivityDataDTO dto = new ActivityDataDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<ActivityDataDTO> findActivityByContractId(Long contractId) {
        String sql = "select t.oid ,t.`name` from risk_activity t where t.org_id=" + contractId + " order by t.createOn desc";
        ArrayList dtoList = Lists.newArrayList();
        List<Object> list = QueryHelper.findBySql(sql.toString(), null);
        list.forEach(result -> {
            Map map = (Map)result;
            ActivityDataDTO dto = new ActivityDataDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public Map<String, String> activityCount(Long oid) {
        StringBuilder sql = new StringBuilder(" SELECT SUM(b.amount) AS amount,COUNT(1) AS count FROM risk_activity a                 INNER JOIN risk_orderForm b on a.oid =b.activity_id                INNER JOIN risk_org c ON a.org_id = c.oid                 INNER JOIN risk_activity_cooper e ON a.org_id = e.org_id  WHERE e.org_id = " + oid + "  and a.activitySource != '" + "2" + "' ");
        SelectWrapper wrapper = SelectWrapper.instance();
        HashMap countMap = Maps.newHashMap();
        List list = this.queryMaps(sql.toString(), (Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            for (Object object : list) {
                Map result = (Map)object;
                countMap.put("amount", result.get("amount") == null ? "0" : result.get("amount").toString());
                countMap.put("count", result.get("count") == null ? "0" : result.get("count").toString());
            }
        } else {
            countMap.put("amount", "0");
            countMap.put("count", "0");
        }
        return countMap;
    }

    public List<Map<String, Object>> countAmountByActivity(Long oid) {
        StringBuilder sql = new StringBuilder(" SELECT a.activityType, sum(b.amount) AS amount  FROM risk_activity a  INNER JOIN risk_orderForm b on a.oid = b.activity_id  INNER JOIN risk_org c ON a.org_id = c.oid  INNER JOIN risk_activity_cooper e ON a.oid = e.activity_id  WHERE e.org_id = " + oid + " and a.activitySource != '" + "2" + "' GROUP BY a.activityType");
        SelectWrapper wrapper = SelectWrapper.instance();
        List list = this.queryMaps(sql.toString(), (Wrapper)wrapper);
        return list;
    }

    public List<Activity> activityPushList(String isPushToSB) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("isPushToSB", (Object)isPushToSB);
        wrapper.eq("pushResult", (Object)"0");
        return this.selectList((Wrapper)wrapper);
    }

    public List<Activity> activityStarList() {
        SelectWrapper wrapper = SelectWrapper.instance();
        DateTime now = DateUtil.date();
        wrapper.gt("startDate", (Object)now);
        return this.selectList((Wrapper)wrapper);
    }
}

