webpackJsonp([19],{

/***/ "/qCn":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__("GiK3");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_rc_notification__ = __webpack_require__("Hx0i");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__icon__ = __webpack_require__("FC3+");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }




var defaultDuration = 3;
var defaultTop;
var messageInstance;
var key = 1;
var prefixCls = 'ant-message';
var transitionName = 'move-up';
var getContainer;
var maxCount;

function getMessageInstance(callback) {
  if (messageInstance) {
    callback(messageInstance);
    return;
  }

  __WEBPACK_IMPORTED_MODULE_1_rc_notification__["a" /* default */].newInstance({
    prefixCls: prefixCls,
    transitionName: transitionName,
    style: {
      top: defaultTop
    },
    getContainer: getContainer,
    maxCount: maxCount
  }, function (instance) {
    if (messageInstance) {
      callback(messageInstance);
      return;
    }

    messageInstance = instance;
    callback(instance);
  });
}

function notice(args) {
  var duration = args.duration !== undefined ? args.duration : defaultDuration;
  var iconType = {
    info: 'info-circle',
    success: 'check-circle',
    error: 'close-circle',
    warning: 'exclamation-circle',
    loading: 'loading'
  }[args.type];
  var target = args.key || key++;
  var closePromise = new Promise(function (resolve) {
    var callback = function callback() {
      if (typeof args.onClose === 'function') {
        args.onClose();
      }

      return resolve(true);
    };

    getMessageInstance(function (instance) {
      var iconNode = /*#__PURE__*/__WEBPACK_IMPORTED_MODULE_0_react__["createElement"](__WEBPACK_IMPORTED_MODULE_2__icon__["default"], {
        type: iconType,
        theme: iconType === 'loading' ? 'outlined' : 'filled'
      });
      var switchIconNode = iconType ? iconNode : '';
      instance.notice({
        key: target,
        duration: duration,
        style: {},
        content: /*#__PURE__*/__WEBPACK_IMPORTED_MODULE_0_react__["createElement"]("div", {
          className: "".concat(prefixCls, "-custom-content").concat(args.type ? " ".concat(prefixCls, "-").concat(args.type) : '')
        }, args.icon ? args.icon : switchIconNode, /*#__PURE__*/__WEBPACK_IMPORTED_MODULE_0_react__["createElement"]("span", null, args.content)),
        onClose: callback
      });
    });
  });

  var result = function result() {
    if (messageInstance) {
      messageInstance.removeNotice(target);
    }
  };

  result.then = function (filled, rejected) {
    return closePromise.then(filled, rejected);
  };

  result.promise = closePromise;
  return result;
}

function isArgsProps(content) {
  return Object.prototype.toString.call(content) === '[object Object]' && !!content.content;
}

var api = {
  open: notice,
  config: function config(options) {
    if (options.top !== undefined) {
      defaultTop = options.top;
      messageInstance = null; // delete messageInstance for new defaultTop
    }

    if (options.duration !== undefined) {
      defaultDuration = options.duration;
    }

    if (options.prefixCls !== undefined) {
      prefixCls = options.prefixCls;
    }

    if (options.getContainer !== undefined) {
      getContainer = options.getContainer;
    }

    if (options.transitionName !== undefined) {
      transitionName = options.transitionName;
      messageInstance = null; // delete messageInstance for new transitionName
    }

    if (options.maxCount !== undefined) {
      maxCount = options.maxCount;
      messageInstance = null;
    }
  },
  destroy: function destroy() {
    if (messageInstance) {
      messageInstance.destroy();
      messageInstance = null;
    }
  }
};
['success', 'info', 'warning', 'error', 'loading'].forEach(function (type) {
  api[type] = function (content, duration, onClose) {
    if (isArgsProps(content)) {
      return api.open(_extends(_extends({}, content), {
        type: type
      }));
    }

    if (typeof duration === 'function') {
      onClose = duration;
      duration = undefined;
    }

    return api.open({
      content: content,
      duration: duration,
      type: type,
      onClose: onClose
    });
  };
});
api.warn = api.warning;
/* harmony default export */ __webpack_exports__["default"] = (api);

/***/ }),

/***/ "06MX":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__("Q9dM"));
var _createClass2 = _interopRequireDefault(__webpack_require__("wm7F"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("F6AD"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("fghW"));
var _inherits2 = _interopRequireDefault(__webpack_require__("QwVp"));
var _react = _interopRequireWildcard(__webpack_require__("GiK3"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Mouse = exports.default = /*#__PURE__*/function (_Component) {
  function Mouse(props) {
    var _this;
    (0, _classCallCheck2.default)(this, Mouse);
    _this = _callSuper(this, Mouse, [props]);
    _this.handleMouseDown = function (e) {
      // console.log(e)
      if (_this.state.isDown == false) {
        return;
      }
      _this.setState({
        clientX: e.clientX,
        //获取x坐标和y坐标
        clientY: e.clientY,
        // isDown: true, //开关打开
        cursor: 'move' //设置样式
      });
    };
    _this.handleMouseMove = function (e) {
      if (_this.state.isDown == false) {
        return;
      }
      //获取x坐标和y坐标
      var nx = e.clientX;
      var ny = e.clientY;
      // //计算移动后的左偏移量和顶部的偏移量
      var nl = nx - (_this.state.clientX - _this.state.offsetLeft);
      var nt = ny - (_this.state.clientY - _this.state.offsetTop);
      _this.setState({
        x: nl,
        y: nt
      });
    };
    _this.handleMouseUp = function (e) {
      // console.log(e)
      _this.setState({
        isDown: false,
        //开关关闭
        cursor: 'default'
      });
    };
    _this.state = {
      clientX: 0,
      clientY: 0,
      x: 0,
      y: 0,
      isDown: props.isDown || false,
      cursor: 'default',
      offsetLeft: props.offsetLeft || 0,
      offsetTop: props.offsetTop || 0
    };
    return _this;
  }
  (0, _inherits2.default)(Mouse, _Component);
  return (0, _createClass2.default)(Mouse, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      window.addEventListener('mousedown', this.handleMouseDown);
      window.addEventListener('mousemove', this.handleMouseMove);
      window.addEventListener('mouseup', this.handleMouseUp);
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      // console.log(nextProps)
      this.setState({
        isDown: nextProps.isDown,
        offsetLeft: nextProps.offsetLeft,
        offsetTop: nextProps.offsetTop
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      // window.removeEventListener('mousemove', this.handleMouseMove)
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state = this.state,
        x = _this$state.x,
        y = _this$state.y,
        cursor = _this$state.cursor; // console.log('Mouse', this.props.children);
      return /*#__PURE__*/_react.default.createElement("div", null, this.props && this.props.children && this.props.children({
        x: x,
        y: y,
        cursor: cursor
      }));
    }
  }]);
}(_react.Component);

/***/ }),

/***/ "0vbU":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "0wj8":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

/**!
 * @fileOverview Kickass library to create and place poppers near their reference elements.
 * @version 1.12.6
 * @license
 * Copyright (c) 2016 Federico Zivolo and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
(function (global, factory) {
   true ? module.exports = factory() : typeof define === 'function' && define.amd ? define(factory) : global.Popper = factory();
})(void 0, function () {
  'use strict';

  var isBrowser = typeof window !== 'undefined' && typeof window.document !== 'undefined';
  var longerTimeoutBrowsers = ['Edge', 'Trident', 'Firefox'];
  var timeoutDuration = 0;
  for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
    if (isBrowser && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0) {
      timeoutDuration = 1;
      break;
    }
  }
  function microtaskDebounce(fn) {
    var called = false;
    return function () {
      if (called) {
        return;
      }
      called = true;
      Promise.resolve().then(function () {
        called = false;
        fn();
      });
    };
  }
  function taskDebounce(fn) {
    var scheduled = false;
    return function () {
      if (!scheduled) {
        scheduled = true;
        setTimeout(function () {
          scheduled = false;
          fn();
        }, timeoutDuration);
      }
    };
  }
  var supportsMicroTasks = isBrowser && window.Promise;

  /**
  * Create a debounced version of a method, that's asynchronously deferred
  * but called in the minimum time possible.
  *
  * @method
  * @memberof Popper.Utils
  * @argument {Function} fn
  * @returns {Function}
  */
  var debounce = supportsMicroTasks ? microtaskDebounce : taskDebounce;

  /**
   * Check if the given variable is a function
   * @method
   * @memberof Popper.Utils
   * @argument {Any} functionToCheck - variable to check
   * @returns {Boolean} answer to: is a function?
   */
  function isFunction(functionToCheck) {
    var getType = {};
    return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
  }

  /**
   * Get CSS computed property of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Eement} element
   * @argument {String} property
   */
  function getStyleComputedProperty(element, property) {
    if (element.nodeType !== 1) {
      return [];
    }
    // NOTE: 1 DOM access here
    var css = window.getComputedStyle(element, null);
    return property ? css[property] : css;
  }

  /**
   * Returns the parentNode or the host of the element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} parent
   */
  function getParentNode(element) {
    if (element.nodeName === 'HTML') {
      return element;
    }
    return element.parentNode || element.host;
  }

  /**
   * Returns the scrolling parent of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} scroll parent
   */
  function getScrollParent(element) {
    // Return body, `getScroll` will take care to get the correct `scrollTop` from it
    if (!element) {
      return window.document.body;
    }
    switch (element.nodeName) {
      case 'HTML':
      case 'BODY':
        return element.ownerDocument.body;
      case '#document':
        return element.body;
    }

    // Firefox want us to check `-x` and `-y` variations as well

    var _getStyleComputedProp = getStyleComputedProperty(element),
      overflow = _getStyleComputedProp.overflow,
      overflowX = _getStyleComputedProp.overflowX,
      overflowY = _getStyleComputedProp.overflowY;
    if (/(auto|scroll)/.test(overflow + overflowY + overflowX)) {
      return element;
    }
    return getScrollParent(getParentNode(element));
  }

  /**
   * Returns the offset parent of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} offset parent
   */
  function getOffsetParent(element) {
    // NOTE: 1 DOM access here
    var offsetParent = element && element.offsetParent;
    var nodeName = offsetParent && offsetParent.nodeName;
    if (!nodeName || nodeName === 'BODY' || nodeName === 'HTML') {
      if (element) {
        return element.ownerDocument.documentElement;
      }
      return window.document.documentElement;
    }

    // .offsetParent will return the closest TD or TABLE in case
    // no offsetParent is present, I hate this job...
    if (['TD', 'TABLE'].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, 'position') === 'static') {
      return getOffsetParent(offsetParent);
    }
    return offsetParent;
  }
  function isOffsetContainer(element) {
    var nodeName = element.nodeName;
    if (nodeName === 'BODY') {
      return false;
    }
    return nodeName === 'HTML' || getOffsetParent(element.firstElementChild) === element;
  }

  /**
   * Finds the root node (document, shadowDOM root) of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} node
   * @returns {Element} root node
   */
  function getRoot(node) {
    if (node.parentNode !== null) {
      return getRoot(node.parentNode);
    }
    return node;
  }

  /**
   * Finds the offset parent common to the two provided nodes
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element1
   * @argument {Element} element2
   * @returns {Element} common offset parent
   */
  function findCommonOffsetParent(element1, element2) {
    // This check is needed to avoid errors in case one of the elements isn't defined for any reason
    if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
      return window.document.documentElement;
    }

    // Here we make sure to give as "start" the element that comes first in the DOM
    var order = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING;
    var start = order ? element1 : element2;
    var end = order ? element2 : element1;

    // Get common ancestor container
    var range = document.createRange();
    range.setStart(start, 0);
    range.setEnd(end, 0);
    var commonAncestorContainer = range.commonAncestorContainer;

    // Both nodes are inside #document

    if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start.contains(end)) {
      if (isOffsetContainer(commonAncestorContainer)) {
        return commonAncestorContainer;
      }
      return getOffsetParent(commonAncestorContainer);
    }

    // one of the nodes is inside shadowDOM, find which one
    var element1root = getRoot(element1);
    if (element1root.host) {
      return findCommonOffsetParent(element1root.host, element2);
    } else {
      return findCommonOffsetParent(element1, getRoot(element2).host);
    }
  }

  /**
   * Gets the scroll value of the given element in the given side (top and left)
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @argument {String} side `top` or `left`
   * @returns {number} amount of scrolled pixels
   */
  function getScroll(element) {
    var side = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'top';
    var upperSide = side === 'top' ? 'scrollTop' : 'scrollLeft';
    var nodeName = element.nodeName;
    if (nodeName === 'BODY' || nodeName === 'HTML') {
      var html = element.ownerDocument.documentElement;
      var scrollingElement = element.ownerDocument.scrollingElement || html;
      return scrollingElement[upperSide];
    }
    return element[upperSide];
  }

  /*
   * Sum or subtract the element scroll values (left and top) from a given rect object
   * @method
   * @memberof Popper.Utils
   * @param {Object} rect - Rect object you want to change
   * @param {HTMLElement} element - The element from the function reads the scroll values
   * @param {Boolean} subtract - set to true if you want to subtract the scroll values
   * @return {Object} rect - The modifier rect object
   */
  function includeScroll(rect, element) {
    var subtract = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    var scrollTop = getScroll(element, 'top');
    var scrollLeft = getScroll(element, 'left');
    var modifier = subtract ? -1 : 1;
    rect.top += scrollTop * modifier;
    rect.bottom += scrollTop * modifier;
    rect.left += scrollLeft * modifier;
    rect.right += scrollLeft * modifier;
    return rect;
  }

  /*
   * Helper to detect borders of a given element
   * @method
   * @memberof Popper.Utils
   * @param {CSSStyleDeclaration} styles
   * Result of `getStyleComputedProperty` on the given element
   * @param {String} axis - `x` or `y`
   * @return {number} borders - The borders size of the given axis
   */

  function getBordersSize(styles, axis) {
    var sideA = axis === 'x' ? 'Left' : 'Top';
    var sideB = sideA === 'Left' ? 'Right' : 'Bottom';
    return +styles['border' + sideA + 'Width'].split('px')[0] + +styles['border' + sideB + 'Width'].split('px')[0];
  }

  /**
   * Tells if you are running Internet Explorer 10
   * @method
   * @memberof Popper.Utils
   * @returns {Boolean} isIE10
   */
  var isIE10 = undefined;
  var isIE10$1 = function isIE10$1() {
    if (isIE10 === undefined) {
      isIE10 = navigator.appVersion.indexOf('MSIE 10') !== -1;
    }
    return isIE10;
  };
  function getSize(axis, body, html, computedStyle) {
    return Math.max(body['offset' + axis], body['scroll' + axis], html['client' + axis], html['offset' + axis], html['scroll' + axis], isIE10$1() ? html['offset' + axis] + computedStyle['margin' + (axis === 'Height' ? 'Top' : 'Left')] + computedStyle['margin' + (axis === 'Height' ? 'Bottom' : 'Right')] : 0);
  }
  function getWindowSizes() {
    var body = window.document.body;
    var html = window.document.documentElement;
    var computedStyle = isIE10$1() && window.getComputedStyle(html);
    return {
      height: getSize('Height', body, html, computedStyle),
      width: getSize('Width', body, html, computedStyle)
    };
  }
  var classCallCheck = function classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };
  var createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();
  var defineProperty = function defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  };
  var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };

  /**
   * Given element offsets, generate an output similar to getBoundingClientRect
   * @method
   * @memberof Popper.Utils
   * @argument {Object} offsets
   * @returns {Object} ClientRect like output
   */
  function getClientRect(offsets) {
    return _extends({}, offsets, {
      right: offsets.left + offsets.width,
      bottom: offsets.top + offsets.height
    });
  }

  /**
   * Get bounding client rect of given element
   * @method
   * @memberof Popper.Utils
   * @param {HTMLElement} element
   * @return {Object} client rect
   */
  function getBoundingClientRect(element) {
    var rect = {};

    // IE10 10 FIX: Please, don't ask, the element isn't
    // considered in DOM in some circumstances...
    // This isn't reproducible in IE10 compatibility mode of IE11
    if (isIE10$1()) {
      try {
        rect = element.getBoundingClientRect();
        var scrollTop = getScroll(element, 'top');
        var scrollLeft = getScroll(element, 'left');
        rect.top += scrollTop;
        rect.left += scrollLeft;
        rect.bottom += scrollTop;
        rect.right += scrollLeft;
      } catch (err) {}
    } else {
      rect = element.getBoundingClientRect();
    }
    var result = {
      left: rect.left,
      top: rect.top,
      width: rect.right - rect.left,
      height: rect.bottom - rect.top
    };

    // subtract scrollbar size from sizes
    var sizes = element.nodeName === 'HTML' ? getWindowSizes() : {};
    var width = sizes.width || element.clientWidth || result.right - result.left;
    var height = sizes.height || element.clientHeight || result.bottom - result.top;
    var horizScrollbar = element.offsetWidth - width;
    var vertScrollbar = element.offsetHeight - height;

    // if an hypothetical scrollbar is detected, we must be sure it's not a `border`
    // we make this check conditional for performance reasons
    if (horizScrollbar || vertScrollbar) {
      var styles = getStyleComputedProperty(element);
      horizScrollbar -= getBordersSize(styles, 'x');
      vertScrollbar -= getBordersSize(styles, 'y');
      result.width -= horizScrollbar;
      result.height -= vertScrollbar;
    }
    return getClientRect(result);
  }
  function getOffsetRectRelativeToArbitraryNode(children, parent) {
    var isIE10 = isIE10$1();
    var isHTML = parent.nodeName === 'HTML';
    var childrenRect = getBoundingClientRect(children);
    var parentRect = getBoundingClientRect(parent);
    var scrollParent = getScrollParent(children);
    var styles = getStyleComputedProperty(parent);
    var borderTopWidth = +styles.borderTopWidth.split('px')[0];
    var borderLeftWidth = +styles.borderLeftWidth.split('px')[0];
    var offsets = getClientRect({
      top: childrenRect.top - parentRect.top - borderTopWidth,
      left: childrenRect.left - parentRect.left - borderLeftWidth,
      width: childrenRect.width,
      height: childrenRect.height
    });
    offsets.marginTop = 0;
    offsets.marginLeft = 0;

    // Subtract margins of documentElement in case it's being used as parent
    // we do this only on HTML because it's the only element that behaves
    // differently when margins are applied to it. The margins are included in
    // the box of the documentElement, in the other cases not.
    if (!isIE10 && isHTML) {
      var marginTop = +styles.marginTop.split('px')[0];
      var marginLeft = +styles.marginLeft.split('px')[0];
      offsets.top -= borderTopWidth - marginTop;
      offsets.bottom -= borderTopWidth - marginTop;
      offsets.left -= borderLeftWidth - marginLeft;
      offsets.right -= borderLeftWidth - marginLeft;

      // Attach marginTop and marginLeft because in some circumstances we may need them
      offsets.marginTop = marginTop;
      offsets.marginLeft = marginLeft;
    }
    if (isIE10 ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== 'BODY') {
      offsets = includeScroll(offsets, parent);
    }
    return offsets;
  }
  function getViewportOffsetRectRelativeToArtbitraryNode(element) {
    var html = element.ownerDocument.documentElement;
    var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
    var width = Math.max(html.clientWidth, window.innerWidth || 0);
    var height = Math.max(html.clientHeight, window.innerHeight || 0);
    var scrollTop = getScroll(html);
    var scrollLeft = getScroll(html, 'left');
    var offset = {
      top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
      left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
      width: width,
      height: height
    };
    return getClientRect(offset);
  }

  /**
   * Check if the given element is fixed or is inside a fixed parent
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @argument {Element} customContainer
   * @returns {Boolean} answer to "isFixed?"
   */
  function isFixed(element) {
    var nodeName = element.nodeName;
    if (nodeName === 'BODY' || nodeName === 'HTML') {
      return false;
    }
    if (getStyleComputedProperty(element, 'position') === 'fixed') {
      return true;
    }
    return isFixed(getParentNode(element));
  }

  /**
   * Computed the boundaries limits and return them
   * @method
   * @memberof Popper.Utils
   * @param {HTMLElement} popper
   * @param {HTMLElement} reference
   * @param {number} padding
   * @param {HTMLElement} boundariesElement - Element used to define the boundaries
   * @returns {Object} Coordinates of the boundaries
   */
  function getBoundaries(popper, reference, padding, boundariesElement) {
    // NOTE: 1 DOM access here
    var boundaries = {
      top: 0,
      left: 0
    };
    var offsetParent = findCommonOffsetParent(popper, reference);

    // Handle viewport case
    if (boundariesElement === 'viewport') {
      boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent);
    } else {
      // Handle other cases based on DOM element used as boundaries
      var boundariesNode = void 0;
      if (boundariesElement === 'scrollParent') {
        boundariesNode = getScrollParent(getParentNode(popper));
        if (boundariesNode.nodeName === 'BODY') {
          boundariesNode = popper.ownerDocument.documentElement;
        }
      } else if (boundariesElement === 'window') {
        boundariesNode = popper.ownerDocument.documentElement;
      } else {
        boundariesNode = boundariesElement;
      }
      var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent);

      // In case of HTML, we need a different computation
      if (boundariesNode.nodeName === 'HTML' && !isFixed(offsetParent)) {
        var _getWindowSizes = getWindowSizes(),
          height = _getWindowSizes.height,
          width = _getWindowSizes.width;
        boundaries.top += offsets.top - offsets.marginTop;
        boundaries.bottom = height + offsets.top;
        boundaries.left += offsets.left - offsets.marginLeft;
        boundaries.right = width + offsets.left;
      } else {
        // for all the other DOM elements, this one is good
        boundaries = offsets;
      }
    }

    // Add paddings
    boundaries.left += padding;
    boundaries.top += padding;
    boundaries.right -= padding;
    boundaries.bottom -= padding;
    return boundaries;
  }
  function getArea(_ref) {
    var width = _ref.width,
      height = _ref.height;
    return width * height;
  }

  /**
   * Utility used to transform the `auto` placement to the placement with more
   * available space.
   * @method
   * @memberof Popper.Utils
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function computeAutoPlacement(placement, refRect, popper, reference, boundariesElement) {
    var padding = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
    if (placement.indexOf('auto') === -1) {
      return placement;
    }
    var boundaries = getBoundaries(popper, reference, padding, boundariesElement);
    var rects = {
      top: {
        width: boundaries.width,
        height: refRect.top - boundaries.top
      },
      right: {
        width: boundaries.right - refRect.right,
        height: boundaries.height
      },
      bottom: {
        width: boundaries.width,
        height: boundaries.bottom - refRect.bottom
      },
      left: {
        width: refRect.left - boundaries.left,
        height: boundaries.height
      }
    };
    var sortedAreas = Object.keys(rects).map(function (key) {
      return _extends({
        key: key
      }, rects[key], {
        area: getArea(rects[key])
      });
    }).sort(function (a, b) {
      return b.area - a.area;
    });
    var filteredAreas = sortedAreas.filter(function (_ref2) {
      var width = _ref2.width,
        height = _ref2.height;
      return width >= popper.clientWidth && height >= popper.clientHeight;
    });
    var computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;
    var variation = placement.split('-')[1];
    return computedPlacement + (variation ? '-' + variation : '');
  }

  /**
   * Get offsets to the reference element
   * @method
   * @memberof Popper.Utils
   * @param {Object} state
   * @param {Element} popper - the popper element
   * @param {Element} reference - the reference element (the popper will be relative to this)
   * @returns {Object} An object containing the offsets which will be applied to the popper
   */
  function getReferenceOffsets(state, popper, reference) {
    var commonOffsetParent = findCommonOffsetParent(popper, reference);
    return getOffsetRectRelativeToArbitraryNode(reference, commonOffsetParent);
  }

  /**
   * Get the outer sizes of the given element (offset size + margins)
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Object} object containing width and height properties
   */
  function getOuterSizes(element) {
    var styles = window.getComputedStyle(element);
    var x = parseFloat(styles.marginTop) + parseFloat(styles.marginBottom);
    var y = parseFloat(styles.marginLeft) + parseFloat(styles.marginRight);
    var result = {
      width: element.offsetWidth + y,
      height: element.offsetHeight + x
    };
    return result;
  }

  /**
   * Get the opposite placement of the given one
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement
   * @returns {String} flipped placement
   */
  function getOppositePlacement(placement) {
    var hash = {
      left: 'right',
      right: 'left',
      bottom: 'top',
      top: 'bottom'
    };
    return placement.replace(/left|right|bottom|top/g, function (matched) {
      return hash[matched];
    });
  }

  /**
   * Get offsets to the popper
   * @method
   * @memberof Popper.Utils
   * @param {Object} position - CSS position the Popper will get applied
   * @param {HTMLElement} popper - the popper element
   * @param {Object} referenceOffsets - the reference offsets (the popper will be relative to this)
   * @param {String} placement - one of the valid placement options
   * @returns {Object} popperOffsets - An object containing the offsets which will be applied to the popper
   */
  function getPopperOffsets(popper, referenceOffsets, placement) {
    placement = placement.split('-')[0];

    // Get popper node sizes
    var popperRect = getOuterSizes(popper);

    // Add position, width and height to our offsets object
    var popperOffsets = {
      width: popperRect.width,
      height: popperRect.height
    };

    // depending by the popper placement we have to compute its offsets slightly differently
    var isHoriz = ['right', 'left'].indexOf(placement) !== -1;
    var mainSide = isHoriz ? 'top' : 'left';
    var secondarySide = isHoriz ? 'left' : 'top';
    var measurement = isHoriz ? 'height' : 'width';
    var secondaryMeasurement = !isHoriz ? 'height' : 'width';
    popperOffsets[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2;
    if (placement === secondarySide) {
      popperOffsets[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
    } else {
      popperOffsets[secondarySide] = referenceOffsets[getOppositePlacement(secondarySide)];
    }
    return popperOffsets;
  }

  /**
   * Mimics the `find` method of Array
   * @method
   * @memberof Popper.Utils
   * @argument {Array} arr
   * @argument prop
   * @argument value
   * @returns index or -1
   */
  function find(arr, check) {
    // use native find if supported
    if (Array.prototype.find) {
      return arr.find(check);
    }

    // use `filter` to obtain the same behavior of `find`
    return arr.filter(check)[0];
  }

  /**
   * Return the index of the matching object
   * @method
   * @memberof Popper.Utils
   * @argument {Array} arr
   * @argument prop
   * @argument value
   * @returns index or -1
   */
  function findIndex(arr, prop, value) {
    // use native findIndex if supported
    if (Array.prototype.findIndex) {
      return arr.findIndex(function (cur) {
        return cur[prop] === value;
      });
    }

    // use `find` + `indexOf` if `findIndex` isn't supported
    var match = find(arr, function (obj) {
      return obj[prop] === value;
    });
    return arr.indexOf(match);
  }

  /**
   * Loop trough the list of modifiers and run them in order,
   * each of them will then edit the data object.
   * @method
   * @memberof Popper.Utils
   * @param {dataObject} data
   * @param {Array} modifiers
   * @param {String} ends - Optional modifier name used as stopper
   * @returns {dataObject}
   */
  function runModifiers(modifiers, data, ends) {
    var modifiersToRun = ends === undefined ? modifiers : modifiers.slice(0, findIndex(modifiers, 'name', ends));
    modifiersToRun.forEach(function (modifier) {
      if (modifier['function']) {
        // eslint-disable-line dot-notation
        console.warn('`modifier.function` is deprecated, use `modifier.fn`!');
      }
      var fn = modifier['function'] || modifier.fn; // eslint-disable-line dot-notation
      if (modifier.enabled && isFunction(fn)) {
        // Add properties to offsets to make them a complete clientRect object
        // we do this before each modifier to make sure the previous one doesn't
        // mess with these values
        data.offsets.popper = getClientRect(data.offsets.popper);
        data.offsets.reference = getClientRect(data.offsets.reference);
        data = fn(data, modifier);
      }
    });
    return data;
  }

  /**
   * Updates the position of the popper, computing the new offsets and applying
   * the new style.<br />
   * Prefer `scheduleUpdate` over `update` because of performance reasons.
   * @method
   * @memberof Popper
   */
  function update() {
    // if popper is destroyed, don't perform any further update
    if (this.state.isDestroyed) {
      return;
    }
    var data = {
      instance: this,
      styles: {},
      arrowStyles: {},
      attributes: {},
      flipped: false,
      offsets: {}
    };

    // compute reference element offsets
    data.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference);

    // compute auto placement, store placement inside the data object,
    // modifiers will be able to edit `placement` if needed
    // and refer to originalPlacement to know the original value
    data.placement = computeAutoPlacement(this.options.placement, data.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding);

    // store the computed placement inside `originalPlacement`
    data.originalPlacement = data.placement;

    // compute the popper offsets
    data.offsets.popper = getPopperOffsets(this.popper, data.offsets.reference, data.placement);
    data.offsets.popper.position = 'absolute';

    // run the modifiers
    data = runModifiers(this.modifiers, data);

    // the first `update` will call `onCreate` callback
    // the other ones will call `onUpdate` callback
    if (!this.state.isCreated) {
      this.state.isCreated = true;
      this.options.onCreate(data);
    } else {
      this.options.onUpdate(data);
    }
  }

  /**
   * Helper used to know if the given modifier is enabled.
   * @method
   * @memberof Popper.Utils
   * @returns {Boolean}
   */
  function isModifierEnabled(modifiers, modifierName) {
    return modifiers.some(function (_ref) {
      var name = _ref.name,
        enabled = _ref.enabled;
      return enabled && name === modifierName;
    });
  }

  /**
   * Get the prefixed supported property name
   * @method
   * @memberof Popper.Utils
   * @argument {String} property (camelCase)
   * @returns {String} prefixed property (camelCase or PascalCase, depending on the vendor prefix)
   */
  function getSupportedPropertyName(property) {
    var prefixes = [false, 'ms', 'Webkit', 'Moz', 'O'];
    var upperProp = property.charAt(0).toUpperCase() + property.slice(1);
    for (var i = 0; i < prefixes.length - 1; i++) {
      var prefix = prefixes[i];
      var toCheck = prefix ? '' + prefix + upperProp : property;
      if (typeof window.document.body.style[toCheck] !== 'undefined') {
        return toCheck;
      }
    }
    return null;
  }

  /**
   * Destroy the popper
   * @method
   * @memberof Popper
   */
  function destroy() {
    this.state.isDestroyed = true;

    // touch DOM only if `applyStyle` modifier is enabled
    if (isModifierEnabled(this.modifiers, 'applyStyle')) {
      this.popper.removeAttribute('x-placement');
      this.popper.style.left = '';
      this.popper.style.position = '';
      this.popper.style.top = '';
      this.popper.style[getSupportedPropertyName('transform')] = '';
    }
    this.disableEventListeners();

    // remove the popper if user explicity asked for the deletion on destroy
    // do not use `remove` because IE11 doesn't support it
    if (this.options.removeOnDestroy) {
      this.popper.parentNode.removeChild(this.popper);
    }
    return this;
  }

  /**
   * Get the window associated with the element
   * @argument {Element} element
   * @returns {Window}
   */
  function getWindow(element) {
    var ownerDocument = element.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView : window;
  }
  function attachToScrollParents(scrollParent, event, callback, scrollParents) {
    var isBody = scrollParent.nodeName === 'BODY';
    var target = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
    target.addEventListener(event, callback, {
      passive: true
    });
    if (!isBody) {
      attachToScrollParents(getScrollParent(target.parentNode), event, callback, scrollParents);
    }
    scrollParents.push(target);
  }

  /**
   * Setup needed event listeners used to update the popper position
   * @method
   * @memberof Popper.Utils
   * @private
   */
  function setupEventListeners(reference, options, state, updateBound) {
    // Resize event listener on window
    state.updateBound = updateBound;
    getWindow(reference).addEventListener('resize', state.updateBound, {
      passive: true
    });

    // Scroll event listener on scroll parents
    var scrollElement = getScrollParent(reference);
    attachToScrollParents(scrollElement, 'scroll', state.updateBound, state.scrollParents);
    state.scrollElement = scrollElement;
    state.eventsEnabled = true;
    return state;
  }

  /**
   * It will add resize/scroll events and start recalculating
   * position of the popper element when they are triggered.
   * @method
   * @memberof Popper
   */
  function enableEventListeners() {
    if (!this.state.eventsEnabled) {
      this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate);
    }
  }

  /**
   * Remove event listeners used to update the popper position
   * @method
   * @memberof Popper.Utils
   * @private
   */
  function removeEventListeners(reference, state) {
    // Remove resize event listener on window
    getWindow(reference).removeEventListener('resize', state.updateBound);

    // Remove scroll event listener on scroll parents
    state.scrollParents.forEach(function (target) {
      target.removeEventListener('scroll', state.updateBound);
    });

    // Reset state
    state.updateBound = null;
    state.scrollParents = [];
    state.scrollElement = null;
    state.eventsEnabled = false;
    return state;
  }

  /**
   * It will remove resize/scroll events and won't recalculate popper position
   * when they are triggered. It also won't trigger onUpdate callback anymore,
   * unless you call `update` method manually.
   * @method
   * @memberof Popper
   */
  function disableEventListeners() {
    if (this.state.eventsEnabled) {
      window.cancelAnimationFrame(this.scheduleUpdate);
      this.state = removeEventListeners(this.reference, this.state);
    }
  }

  /**
   * Tells if a given input is a number
   * @method
   * @memberof Popper.Utils
   * @param {*} input to check
   * @return {Boolean}
   */
  function isNumeric(n) {
    return n !== '' && !isNaN(parseFloat(n)) && isFinite(n);
  }

  /**
   * Set the style to the given popper
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element - Element to apply the style to
   * @argument {Object} styles
   * Object with a list of properties and values which will be applied to the element
   */
  function setStyles(element, styles) {
    Object.keys(styles).forEach(function (prop) {
      var unit = '';
      // add unit if the value is numeric and is one of the following
      if (['width', 'height', 'top', 'right', 'bottom', 'left'].indexOf(prop) !== -1 && isNumeric(styles[prop])) {
        unit = 'px';
      }
      element.style[prop] = styles[prop] + unit;
    });
  }

  /**
   * Set the attributes to the given popper
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element - Element to apply the attributes to
   * @argument {Object} styles
   * Object with a list of properties and values which will be applied to the element
   */
  function setAttributes(element, attributes) {
    Object.keys(attributes).forEach(function (prop) {
      var value = attributes[prop];
      if (value !== false) {
        element.setAttribute(prop, attributes[prop]);
      } else {
        element.removeAttribute(prop);
      }
    });
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} data.styles - List of style properties - values to apply to popper element
   * @argument {Object} data.attributes - List of attribute properties - values to apply to popper element
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The same data object
   */
  function applyStyle(data) {
    // any property present in `data.styles` will be applied to the popper,
    // in this way we can make the 3rd party modifiers add custom styles to it
    // Be aware, modifiers could override the properties defined in the previous
    // lines of this modifier!
    setStyles(data.instance.popper, data.styles);

    // any property present in `data.attributes` will be applied to the popper,
    // they will be set as HTML attributes of the element
    setAttributes(data.instance.popper, data.attributes);

    // if arrowElement is defined and arrowStyles has some properties
    if (data.arrowElement && Object.keys(data.arrowStyles).length) {
      setStyles(data.arrowElement, data.arrowStyles);
    }
    return data;
  }

  /**
   * Set the x-placement attribute before everything else because it could be used
   * to add margins to the popper margins needs to be calculated to get the
   * correct popper offsets.
   * @method
   * @memberof Popper.modifiers
   * @param {HTMLElement} reference - The reference element used to position the popper
   * @param {HTMLElement} popper - The HTML element used as popper.
   * @param {Object} options - Popper.js options
   */
  function applyStyleOnLoad(reference, popper, options, modifierOptions, state) {
    // compute reference element offsets
    var referenceOffsets = getReferenceOffsets(state, popper, reference);

    // compute auto placement, store placement inside the data object,
    // modifiers will be able to edit `placement` if needed
    // and refer to originalPlacement to know the original value
    var placement = computeAutoPlacement(options.placement, referenceOffsets, popper, reference, options.modifiers.flip.boundariesElement, options.modifiers.flip.padding);
    popper.setAttribute('x-placement', placement);

    // Apply `position` to popper before anything else because
    // without the position applied we can't guarantee correct computations
    setStyles(popper, {
      position: 'absolute'
    });
    return options;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function computeStyle(data, options) {
    var x = options.x,
      y = options.y;
    var popper = data.offsets.popper;

    // Remove this legacy support in Popper.js v2

    var legacyGpuAccelerationOption = find(data.instance.modifiers, function (modifier) {
      return modifier.name === 'applyStyle';
    }).gpuAcceleration;
    if (legacyGpuAccelerationOption !== undefined) {
      console.warn('WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!');
    }
    var gpuAcceleration = legacyGpuAccelerationOption !== undefined ? legacyGpuAccelerationOption : options.gpuAcceleration;
    var offsetParent = getOffsetParent(data.instance.popper);
    var offsetParentRect = getBoundingClientRect(offsetParent);

    // Styles
    var styles = {
      position: popper.position
    };

    // floor sides to avoid blurry text
    var offsets = {
      left: Math.floor(popper.left),
      top: Math.floor(popper.top),
      bottom: Math.floor(popper.bottom),
      right: Math.floor(popper.right)
    };
    var sideA = x === 'bottom' ? 'top' : 'bottom';
    var sideB = y === 'right' ? 'left' : 'right';

    // if gpuAcceleration is set to `true` and transform is supported,
    //  we use `translate3d` to apply the position to the popper we
    // automatically use the supported prefixed version if needed
    var prefixedProperty = getSupportedPropertyName('transform');

    // now, let's make a step back and look at this code closely (wtf?)
    // If the content of the popper grows once it's been positioned, it
    // may happen that the popper gets misplaced because of the new content
    // overflowing its reference element
    // To avoid this problem, we provide two options (x and y), which allow
    // the consumer to define the offset origin.
    // If we position a popper on top of a reference element, we can set
    // `x` to `top` to make the popper grow towards its top instead of
    // its bottom.
    var left = void 0,
      top = void 0;
    if (sideA === 'bottom') {
      top = -offsetParentRect.height + offsets.bottom;
    } else {
      top = offsets.top;
    }
    if (sideB === 'right') {
      left = -offsetParentRect.width + offsets.right;
    } else {
      left = offsets.left;
    }
    if (gpuAcceleration && prefixedProperty) {
      styles[prefixedProperty] = 'translate3d(' + left + 'px, ' + top + 'px, 0)';
      styles[sideA] = 0;
      styles[sideB] = 0;
      styles.willChange = 'transform';
    } else {
      // othwerise, we use the standard `top`, `left`, `bottom` and `right` properties
      var invertTop = sideA === 'bottom' ? -1 : 1;
      var invertLeft = sideB === 'right' ? -1 : 1;
      styles[sideA] = top * invertTop;
      styles[sideB] = left * invertLeft;
      styles.willChange = sideA + ', ' + sideB;
    }

    // Attributes
    var attributes = {
      'x-placement': data.placement
    };

    // Update `data` attributes, styles and arrowStyles
    data.attributes = _extends({}, attributes, data.attributes);
    data.styles = _extends({}, styles, data.styles);
    data.arrowStyles = _extends({}, data.offsets.arrow, data.arrowStyles);
    return data;
  }

  /**
   * Helper used to know if the given modifier depends from another one.<br />
   * It checks if the needed modifier is listed and enabled.
   * @method
   * @memberof Popper.Utils
   * @param {Array} modifiers - list of modifiers
   * @param {String} requestingName - name of requesting modifier
   * @param {String} requestedName - name of requested modifier
   * @returns {Boolean}
   */
  function isModifierRequired(modifiers, requestingName, requestedName) {
    var requesting = find(modifiers, function (_ref) {
      var name = _ref.name;
      return name === requestingName;
    });
    var isRequired = !!requesting && modifiers.some(function (modifier) {
      return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
    });
    if (!isRequired) {
      var _requesting = '`' + requestingName + '`';
      var requested = '`' + requestedName + '`';
      console.warn(requested + ' modifier is required by ' + _requesting + ' modifier in order to work, be sure to include it before ' + _requesting + '!');
    }
    return isRequired;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function arrow(data, options) {
    // arrow depends on keepTogether in order to work
    if (!isModifierRequired(data.instance.modifiers, 'arrow', 'keepTogether')) {
      return data;
    }
    var arrowElement = options.element;

    // if arrowElement is a string, suppose it's a CSS selector
    if (typeof arrowElement === 'string') {
      arrowElement = data.instance.popper.querySelector(arrowElement);

      // if arrowElement is not found, don't run the modifier
      if (!arrowElement) {
        return data;
      }
    } else {
      // if the arrowElement isn't a query selector we must check that the
      // provided DOM node is child of its popper node
      if (!data.instance.popper.contains(arrowElement)) {
        console.warn('WARNING: `arrow.element` must be child of its popper element!');
        return data;
      }
    }
    var placement = data.placement.split('-')[0];
    var _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;
    var isVertical = ['left', 'right'].indexOf(placement) !== -1;
    var len = isVertical ? 'height' : 'width';
    var sideCapitalized = isVertical ? 'Top' : 'Left';
    var side = sideCapitalized.toLowerCase();
    var altSide = isVertical ? 'left' : 'top';
    var opSide = isVertical ? 'bottom' : 'right';
    var arrowElementSize = getOuterSizes(arrowElement)[len];

    //
    // extends keepTogether behavior making sure the popper and its
    // reference have enough pixels in conjuction
    //

    // top/left side
    if (reference[opSide] - arrowElementSize < popper[side]) {
      data.offsets.popper[side] -= popper[side] - (reference[opSide] - arrowElementSize);
    }
    // bottom/right side
    if (reference[side] + arrowElementSize > popper[opSide]) {
      data.offsets.popper[side] += reference[side] + arrowElementSize - popper[opSide];
    }

    // compute center of the popper
    var center = reference[side] + reference[len] / 2 - arrowElementSize / 2;

    // Compute the sideValue using the updated popper offsets
    // take popper margin in account because we don't have this info available
    var popperMarginSide = getStyleComputedProperty(data.instance.popper, 'margin' + sideCapitalized).replace('px', '');
    var sideValue = center - getClientRect(data.offsets.popper)[side] - popperMarginSide;

    // prevent arrowElement from being placed not contiguously to its popper
    sideValue = Math.max(Math.min(popper[len] - arrowElementSize, sideValue), 0);
    data.arrowElement = arrowElement;
    data.offsets.arrow = {};
    data.offsets.arrow[side] = Math.round(sideValue);
    data.offsets.arrow[altSide] = ''; // make sure to unset any eventual altSide value from the DOM node

    return data;
  }

  /**
   * Get the opposite placement variation of the given one
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement variation
   * @returns {String} flipped placement variation
   */
  function getOppositeVariation(variation) {
    if (variation === 'end') {
      return 'start';
    } else if (variation === 'start') {
      return 'end';
    }
    return variation;
  }

  /**
   * List of accepted placements to use as values of the `placement` option.<br />
   * Valid placements are:
   * - `auto`
   * - `top`
   * - `right`
   * - `bottom`
   * - `left`
   *
   * Each placement can have a variation from this list:
   * - `-start`
   * - `-end`
   *
   * Variations are interpreted easily if you think of them as the left to right
   * written languages. Horizontally (`top` and `bottom`), `start` is left and `end`
   * is right.<br />
   * Vertically (`left` and `right`), `start` is top and `end` is bottom.
   *
   * Some valid examples are:
   * - `top-end` (on top of reference, right aligned)
   * - `right-start` (on right of reference, top aligned)
   * - `bottom` (on bottom, centered)
   * - `auto-right` (on the side with more space available, alignment depends by placement)
   *
   * @static
   * @type {Array}
   * @enum {String}
   * @readonly
   * @method placements
   * @memberof Popper
   */
  var placements = ['auto-start', 'auto', 'auto-end', 'top-start', 'top', 'top-end', 'right-start', 'right', 'right-end', 'bottom-end', 'bottom', 'bottom-start', 'left-end', 'left', 'left-start'];

  // Get rid of `auto` `auto-start` and `auto-end`
  var validPlacements = placements.slice(3);

  /**
   * Given an initial placement, returns all the subsequent placements
   * clockwise (or counter-clockwise).
   *
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement - A valid placement (it accepts variations)
   * @argument {Boolean} counter - Set to true to walk the placements counterclockwise
   * @returns {Array} placements including their variations
   */
  function clockwise(placement) {
    var counter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var index = validPlacements.indexOf(placement);
    var arr = validPlacements.slice(index + 1).concat(validPlacements.slice(0, index));
    return counter ? arr.reverse() : arr;
  }
  var BEHAVIORS = {
    FLIP: 'flip',
    CLOCKWISE: 'clockwise',
    COUNTERCLOCKWISE: 'counterclockwise'
  };

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function flip(data, options) {
    // if `inner` modifier is enabled, we can't use the `flip` modifier
    if (isModifierEnabled(data.instance.modifiers, 'inner')) {
      return data;
    }
    if (data.flipped && data.placement === data.originalPlacement) {
      // seems like flip is trying to loop, probably there's not enough space on any of the flippable sides
      return data;
    }
    var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, options.boundariesElement);
    var placement = data.placement.split('-')[0];
    var placementOpposite = getOppositePlacement(placement);
    var variation = data.placement.split('-')[1] || '';
    var flipOrder = [];
    switch (options.behavior) {
      case BEHAVIORS.FLIP:
        flipOrder = [placement, placementOpposite];
        break;
      case BEHAVIORS.CLOCKWISE:
        flipOrder = clockwise(placement);
        break;
      case BEHAVIORS.COUNTERCLOCKWISE:
        flipOrder = clockwise(placement, true);
        break;
      default:
        flipOrder = options.behavior;
    }
    flipOrder.forEach(function (step, index) {
      if (placement !== step || flipOrder.length === index + 1) {
        return data;
      }
      placement = data.placement.split('-')[0];
      placementOpposite = getOppositePlacement(placement);
      var popperOffsets = data.offsets.popper;
      var refOffsets = data.offsets.reference;

      // using floor because the reference offsets may contain decimals we are not going to consider here
      var floor = Math.floor;
      var overlapsRef = placement === 'left' && floor(popperOffsets.right) > floor(refOffsets.left) || placement === 'right' && floor(popperOffsets.left) < floor(refOffsets.right) || placement === 'top' && floor(popperOffsets.bottom) > floor(refOffsets.top) || placement === 'bottom' && floor(popperOffsets.top) < floor(refOffsets.bottom);
      var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
      var overflowsRight = floor(popperOffsets.right) > floor(boundaries.right);
      var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
      var overflowsBottom = floor(popperOffsets.bottom) > floor(boundaries.bottom);
      var overflowsBoundaries = placement === 'left' && overflowsLeft || placement === 'right' && overflowsRight || placement === 'top' && overflowsTop || placement === 'bottom' && overflowsBottom;

      // flip the variation if required
      var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;
      var flippedVariation = !!options.flipVariations && (isVertical && variation === 'start' && overflowsLeft || isVertical && variation === 'end' && overflowsRight || !isVertical && variation === 'start' && overflowsTop || !isVertical && variation === 'end' && overflowsBottom);
      if (overlapsRef || overflowsBoundaries || flippedVariation) {
        // this boolean to detect any flip loop
        data.flipped = true;
        if (overlapsRef || overflowsBoundaries) {
          placement = flipOrder[index + 1];
        }
        if (flippedVariation) {
          variation = getOppositeVariation(variation);
        }
        data.placement = placement + (variation ? '-' + variation : '');

        // this object contains `position`, we want to preserve it along with
        // any additional property we may add in the future
        data.offsets.popper = _extends({}, data.offsets.popper, getPopperOffsets(data.instance.popper, data.offsets.reference, data.placement));
        data = runModifiers(data.instance.modifiers, data, 'flip');
      }
    });
    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function keepTogether(data) {
    var _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;
    var placement = data.placement.split('-')[0];
    var floor = Math.floor;
    var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;
    var side = isVertical ? 'right' : 'bottom';
    var opSide = isVertical ? 'left' : 'top';
    var measurement = isVertical ? 'width' : 'height';
    if (popper[side] < floor(reference[opSide])) {
      data.offsets.popper[opSide] = floor(reference[opSide]) - popper[measurement];
    }
    if (popper[opSide] > floor(reference[side])) {
      data.offsets.popper[opSide] = floor(reference[side]);
    }
    return data;
  }

  /**
   * Converts a string containing value + unit into a px value number
   * @function
   * @memberof {modifiers~offset}
   * @private
   * @argument {String} str - Value + unit string
   * @argument {String} measurement - `height` or `width`
   * @argument {Object} popperOffsets
   * @argument {Object} referenceOffsets
   * @returns {Number|String}
   * Value in pixels, or original string if no values were extracted
   */
  function toValue(str, measurement, popperOffsets, referenceOffsets) {
    // separate value from unit
    var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
    var value = +split[1];
    var unit = split[2];

    // If it's not a number it's an operator, I guess
    if (!value) {
      return str;
    }
    if (unit.indexOf('%') === 0) {
      var element = void 0;
      switch (unit) {
        case '%p':
          element = popperOffsets;
          break;
        case '%':
        case '%r':
        default:
          element = referenceOffsets;
      }
      var rect = getClientRect(element);
      return rect[measurement] / 100 * value;
    } else if (unit === 'vh' || unit === 'vw') {
      // if is a vh or vw, we calculate the size based on the viewport
      var size = void 0;
      if (unit === 'vh') {
        size = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
      } else {
        size = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
      }
      return size / 100 * value;
    } else {
      // if is an explicit pixel unit, we get rid of the unit and keep the value
      // if is an implicit unit, it's px, and we return just the value
      return value;
    }
  }

  /**
   * Parse an `offset` string to extrapolate `x` and `y` numeric offsets.
   * @function
   * @memberof {modifiers~offset}
   * @private
   * @argument {String} offset
   * @argument {Object} popperOffsets
   * @argument {Object} referenceOffsets
   * @argument {String} basePlacement
   * @returns {Array} a two cells array with x and y offsets in numbers
   */
  function parseOffset(offset, popperOffsets, referenceOffsets, basePlacement) {
    var offsets = [0, 0];

    // Use height if placement is left or right and index is 0 otherwise use width
    // in this way the first offset will use an axis and the second one
    // will use the other one
    var useHeight = ['right', 'left'].indexOf(basePlacement) !== -1;

    // Split the offset string to obtain a list of values and operands
    // The regex addresses values with the plus or minus sign in front (+10, -20, etc)
    var fragments = offset.split(/(\+|\-)/).map(function (frag) {
      return frag.trim();
    });

    // Detect if the offset string contains a pair of values or a single one
    // they could be separated by comma or space
    var divider = fragments.indexOf(find(fragments, function (frag) {
      return frag.search(/,|\s/) !== -1;
    }));
    if (fragments[divider] && fragments[divider].indexOf(',') === -1) {
      console.warn('Offsets separated by white space(s) are deprecated, use a comma (,) instead.');
    }

    // If divider is found, we divide the list of values and operands to divide
    // them by ofset X and Y.
    var splitRegex = /\s*,\s*|\s+/;
    var ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments];

    // Convert the values with units to absolute pixels to allow our computations
    ops = ops.map(function (op, index) {
      // Most of the units rely on the orientation of the popper
      var measurement = (index === 1 ? !useHeight : useHeight) ? 'height' : 'width';
      var mergeWithPrevious = false;
      return op
      // This aggregates any `+` or `-` sign that aren't considered operators
      // e.g.: 10 + +5 => [10, +, +5]
      .reduce(function (a, b) {
        if (a[a.length - 1] === '' && ['+', '-'].indexOf(b) !== -1) {
          a[a.length - 1] = b;
          mergeWithPrevious = true;
          return a;
        } else if (mergeWithPrevious) {
          a[a.length - 1] += b;
          mergeWithPrevious = false;
          return a;
        } else {
          return a.concat(b);
        }
      }, [])
      // Here we convert the string values into number values (in px)
      .map(function (str) {
        return toValue(str, measurement, popperOffsets, referenceOffsets);
      });
    });

    // Loop trough the offsets arrays and execute the operations
    ops.forEach(function (op, index) {
      op.forEach(function (frag, index2) {
        if (isNumeric(frag)) {
          offsets[index] += frag * (op[index2 - 1] === '-' ? -1 : 1);
        }
      });
    });
    return offsets;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @argument {Number|String} options.offset=0
   * The offset value as described in the modifier description
   * @returns {Object} The data object, properly modified
   */
  function offset(data, _ref) {
    var offset = _ref.offset;
    var placement = data.placement,
      _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;
    var basePlacement = placement.split('-')[0];
    var offsets = void 0;
    if (isNumeric(+offset)) {
      offsets = [+offset, 0];
    } else {
      offsets = parseOffset(offset, popper, reference, basePlacement);
    }
    if (basePlacement === 'left') {
      popper.top += offsets[0];
      popper.left -= offsets[1];
    } else if (basePlacement === 'right') {
      popper.top += offsets[0];
      popper.left += offsets[1];
    } else if (basePlacement === 'top') {
      popper.left += offsets[0];
      popper.top -= offsets[1];
    } else if (basePlacement === 'bottom') {
      popper.left += offsets[0];
      popper.top += offsets[1];
    }
    data.popper = popper;
    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function preventOverflow(data, options) {
    var boundariesElement = options.boundariesElement || getOffsetParent(data.instance.popper);

    // If offsetParent is the reference element, we really want to
    // go one step up and use the next offsetParent as reference to
    // avoid to make this modifier completely useless and look like broken
    if (data.instance.reference === boundariesElement) {
      boundariesElement = getOffsetParent(boundariesElement);
    }
    var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, boundariesElement);
    options.boundaries = boundaries;
    var order = options.priority;
    var popper = data.offsets.popper;
    var check = {
      primary: function primary(placement) {
        var value = popper[placement];
        if (popper[placement] < boundaries[placement] && !options.escapeWithReference) {
          value = Math.max(popper[placement], boundaries[placement]);
        }
        return defineProperty({}, placement, value);
      },
      secondary: function secondary(placement) {
        var mainSide = placement === 'right' ? 'left' : 'top';
        var value = popper[mainSide];
        if (popper[placement] > boundaries[placement] && !options.escapeWithReference) {
          value = Math.min(popper[mainSide], boundaries[placement] - (placement === 'right' ? popper.width : popper.height));
        }
        return defineProperty({}, mainSide, value);
      }
    };
    order.forEach(function (placement) {
      var side = ['left', 'top'].indexOf(placement) !== -1 ? 'primary' : 'secondary';
      popper = _extends({}, popper, check[side](placement));
    });
    data.offsets.popper = popper;
    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function shift(data) {
    var placement = data.placement;
    var basePlacement = placement.split('-')[0];
    var shiftvariation = placement.split('-')[1];

    // if shift shiftvariation is specified, run the modifier
    if (shiftvariation) {
      var _data$offsets = data.offsets,
        reference = _data$offsets.reference,
        popper = _data$offsets.popper;
      var isVertical = ['bottom', 'top'].indexOf(basePlacement) !== -1;
      var side = isVertical ? 'left' : 'top';
      var measurement = isVertical ? 'width' : 'height';
      var shiftOffsets = {
        start: defineProperty({}, side, reference[side]),
        end: defineProperty({}, side, reference[side] + reference[measurement] - popper[measurement])
      };
      data.offsets.popper = _extends({}, popper, shiftOffsets[shiftvariation]);
    }
    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function hide(data) {
    if (!isModifierRequired(data.instance.modifiers, 'hide', 'preventOverflow')) {
      return data;
    }
    var refRect = data.offsets.reference;
    var bound = find(data.instance.modifiers, function (modifier) {
      return modifier.name === 'preventOverflow';
    }).boundaries;
    if (refRect.bottom < bound.top || refRect.left > bound.right || refRect.top > bound.bottom || refRect.right < bound.left) {
      // Avoid unnecessary DOM access if visibility hasn't changed
      if (data.hide === true) {
        return data;
      }
      data.hide = true;
      data.attributes['x-out-of-boundaries'] = '';
    } else {
      // Avoid unnecessary DOM access if visibility hasn't changed
      if (data.hide === false) {
        return data;
      }
      data.hide = false;
      data.attributes['x-out-of-boundaries'] = false;
    }
    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function inner(data) {
    var placement = data.placement;
    var basePlacement = placement.split('-')[0];
    var _data$offsets = data.offsets,
      popper = _data$offsets.popper,
      reference = _data$offsets.reference;
    var isHoriz = ['left', 'right'].indexOf(basePlacement) !== -1;
    var subtractLength = ['top', 'left'].indexOf(basePlacement) === -1;
    popper[isHoriz ? 'left' : 'top'] = reference[basePlacement] - (subtractLength ? popper[isHoriz ? 'width' : 'height'] : 0);
    data.placement = getOppositePlacement(placement);
    data.offsets.popper = getClientRect(popper);
    return data;
  }

  /**
   * Modifier function, each modifier can have a function of this type assigned
   * to its `fn` property.<br />
   * These functions will be called on each update, this means that you must
   * make sure they are performant enough to avoid performance bottlenecks.
   *
   * @function ModifierFn
   * @argument {dataObject} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {dataObject} The data object, properly modified
   */

  /**
   * Modifiers are plugins used to alter the behavior of your poppers.<br />
   * Popper.js uses a set of 9 modifiers to provide all the basic functionalities
   * needed by the library.
   *
   * Usually you don't want to override the `order`, `fn` and `onLoad` props.
   * All the other properties are configurations that could be tweaked.
   * @namespace modifiers
   */
  var modifiers = {
    /**
     * Modifier used to shift the popper on the start or end of its reference
     * element.<br />
     * It will read the variation of the `placement` property.<br />
     * It can be one either `-end` or `-start`.
     * @memberof modifiers
     * @inner
     */
    shift: {
      /** @prop {number} order=100 - Index used to define the order of execution */
      order: 100,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: shift
    },
    /**
     * The `offset` modifier can shift your popper on both its axis.
     *
     * It accepts the following units:
     * - `px` or unitless, interpreted as pixels
     * - `%` or `%r`, percentage relative to the length of the reference element
     * - `%p`, percentage relative to the length of the popper element
     * - `vw`, CSS viewport width unit
     * - `vh`, CSS viewport height unit
     *
     * For length is intended the main axis relative to the placement of the popper.<br />
     * This means that if the placement is `top` or `bottom`, the length will be the
     * `width`. In case of `left` or `right`, it will be the height.
     *
     * You can provide a single value (as `Number` or `String`), or a pair of values
     * as `String` divided by a comma or one (or more) white spaces.<br />
     * The latter is a deprecated method because it leads to confusion and will be
     * removed in v2.<br />
     * Additionally, it accepts additions and subtractions between different units.
     * Note that multiplications and divisions aren't supported.
     *
     * Valid examples are:
     * ```
     * 10
     * '10%'
     * '10, 10'
     * '10%, 10'
     * '10 + 10%'
     * '10 - 5vh + 3%'
     * '-10px + 5vh, 5px - 6%'
     * ```
     * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
     * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
     * > More on this [reading this issue](https://github.com/FezVrasta/popper.js/issues/373)
     *
     * @memberof modifiers
     * @inner
     */
    offset: {
      /** @prop {number} order=200 - Index used to define the order of execution */
      order: 200,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: offset,
      /** @prop {Number|String} offset=0
       * The offset value as described in the modifier description
       */
      offset: 0
    },
    /**
     * Modifier used to prevent the popper from being positioned outside the boundary.
     *
     * An scenario exists where the reference itself is not within the boundaries.<br />
     * We can say it has "escaped the boundaries" — or just "escaped".<br />
     * In this case we need to decide whether the popper should either:
     *
     * - detach from the reference and remain "trapped" in the boundaries, or
     * - if it should ignore the boundary and "escape with its reference"
     *
     * When `escapeWithReference` is set to`true` and reference is completely
     * outside its boundaries, the popper will overflow (or completely leave)
     * the boundaries in order to remain attached to the edge of the reference.
     *
     * @memberof modifiers
     * @inner
     */
    preventOverflow: {
      /** @prop {number} order=300 - Index used to define the order of execution */
      order: 300,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: preventOverflow,
      /**
       * @prop {Array} [priority=['left','right','top','bottom']]
       * Popper will try to prevent overflow following these priorities by default,
       * then, it could overflow on the left and on top of the `boundariesElement`
       */
      priority: ['left', 'right', 'top', 'bottom'],
      /**
       * @prop {number} padding=5
       * Amount of pixel used to define a minimum distance between the boundaries
       * and the popper this makes sure the popper has always a little padding
       * between the edges of its container
       */
      padding: 5,
      /**
       * @prop {String|HTMLElement} boundariesElement='scrollParent'
       * Boundaries used by the modifier, can be `scrollParent`, `window`,
       * `viewport` or any DOM element.
       */
      boundariesElement: 'scrollParent'
    },
    /**
     * Modifier used to make sure the reference and its popper stay near eachothers
     * without leaving any gap between the two. Expecially useful when the arrow is
     * enabled and you want to assure it to point to its reference element.
     * It cares only about the first axis, you can still have poppers with margin
     * between the popper and its reference element.
     * @memberof modifiers
     * @inner
     */
    keepTogether: {
      /** @prop {number} order=400 - Index used to define the order of execution */
      order: 400,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: keepTogether
    },
    /**
     * This modifier is used to move the `arrowElement` of the popper to make
     * sure it is positioned between the reference element and its popper element.
     * It will read the outer size of the `arrowElement` node to detect how many
     * pixels of conjuction are needed.
     *
     * It has no effect if no `arrowElement` is provided.
     * @memberof modifiers
     * @inner
     */
    arrow: {
      /** @prop {number} order=500 - Index used to define the order of execution */
      order: 500,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: arrow,
      /** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
      element: '[x-arrow]'
    },
    /**
     * Modifier used to flip the popper's placement when it starts to overlap its
     * reference element.
     *
     * Requires the `preventOverflow` modifier before it in order to work.
     *
     * **NOTE:** this modifier will interrupt the current update cycle and will
     * restart it if it detects the need to flip the placement.
     * @memberof modifiers
     * @inner
     */
    flip: {
      /** @prop {number} order=600 - Index used to define the order of execution */
      order: 600,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: flip,
      /**
       * @prop {String|Array} behavior='flip'
       * The behavior used to change the popper's placement. It can be one of
       * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
       * placements (with optional variations).
       */
      behavior: 'flip',
      /**
       * @prop {number} padding=5
       * The popper will flip if it hits the edges of the `boundariesElement`
       */
      padding: 5,
      /**
       * @prop {String|HTMLElement} boundariesElement='viewport'
       * The element which will define the boundaries of the popper position,
       * the popper will never be placed outside of the defined boundaries
       * (except if keepTogether is enabled)
       */
      boundariesElement: 'viewport'
    },
    /**
     * Modifier used to make the popper flow toward the inner of the reference element.
     * By default, when this modifier is disabled, the popper will be placed outside
     * the reference element.
     * @memberof modifiers
     * @inner
     */
    inner: {
      /** @prop {number} order=700 - Index used to define the order of execution */
      order: 700,
      /** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
      enabled: false,
      /** @prop {ModifierFn} */
      fn: inner
    },
    /**
     * Modifier used to hide the popper when its reference element is outside of the
     * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
     * be used to hide with a CSS selector the popper when its reference is
     * out of boundaries.
     *
     * Requires the `preventOverflow` modifier before it in order to work.
     * @memberof modifiers
     * @inner
     */
    hide: {
      /** @prop {number} order=800 - Index used to define the order of execution */
      order: 800,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: hide
    },
    /**
     * Computes the style that will be applied to the popper element to gets
     * properly positioned.
     *
     * Note that this modifier will not touch the DOM, it just prepares the styles
     * so that `applyStyle` modifier can apply it. This separation is useful
     * in case you need to replace `applyStyle` with a custom implementation.
     *
     * This modifier has `850` as `order` value to maintain backward compatibility
     * with previous versions of Popper.js. Expect the modifiers ordering method
     * to change in future major versions of the library.
     *
     * @memberof modifiers
     * @inner
     */
    computeStyle: {
      /** @prop {number} order=850 - Index used to define the order of execution */
      order: 850,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: computeStyle,
      /**
       * @prop {Boolean} gpuAcceleration=true
       * If true, it uses the CSS 3d transformation to position the popper.
       * Otherwise, it will use the `top` and `left` properties.
       */
      gpuAcceleration: true,
      /**
       * @prop {string} [x='bottom']
       * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
       * Change this if your popper should grow in a direction different from `bottom`
       */
      x: 'bottom',
      /**
       * @prop {string} [x='left']
       * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
       * Change this if your popper should grow in a direction different from `right`
       */
      y: 'right'
    },
    /**
     * Applies the computed styles to the popper element.
     *
     * All the DOM manipulations are limited to this modifier. This is useful in case
     * you want to integrate Popper.js inside a framework or view library and you
     * want to delegate all the DOM manipulations to it.
     *
     * Note that if you disable this modifier, you must make sure the popper element
     * has its position set to `absolute` before Popper.js can do its work!
     *
     * Just disable this modifier and define you own to achieve the desired effect.
     *
     * @memberof modifiers
     * @inner
     */
    applyStyle: {
      /** @prop {number} order=900 - Index used to define the order of execution */
      order: 900,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: applyStyle,
      /** @prop {Function} */
      onLoad: applyStyleOnLoad,
      /**
       * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
       * @prop {Boolean} gpuAcceleration=true
       * If true, it uses the CSS 3d transformation to position the popper.
       * Otherwise, it will use the `top` and `left` properties.
       */
      gpuAcceleration: undefined
    }
  };

  /**
   * The `dataObject` is an object containing all the informations used by Popper.js
   * this object get passed to modifiers and to the `onCreate` and `onUpdate` callbacks.
   * @name dataObject
   * @property {Object} data.instance The Popper.js instance
   * @property {String} data.placement Placement applied to popper
   * @property {String} data.originalPlacement Placement originally defined on init
   * @property {Boolean} data.flipped True if popper has been flipped by flip modifier
   * @property {Boolean} data.hide True if the reference element is out of boundaries, useful to know when to hide the popper.
   * @property {HTMLElement} data.arrowElement Node used as arrow by arrow modifier
   * @property {Object} data.styles Any CSS property defined here will be applied to the popper, it expects the JavaScript nomenclature (eg. `marginBottom`)
   * @property {Object} data.arrowStyles Any CSS property defined here will be applied to the popper arrow, it expects the JavaScript nomenclature (eg. `marginBottom`)
   * @property {Object} data.boundaries Offsets of the popper boundaries
   * @property {Object} data.offsets The measurements of popper, reference and arrow elements.
   * @property {Object} data.offsets.popper `top`, `left`, `width`, `height` values
   * @property {Object} data.offsets.reference `top`, `left`, `width`, `height` values
   * @property {Object} data.offsets.arrow] `top` and `left` offsets, only one of them will be different from 0
   */

  /**
   * Default options provided to Popper.js constructor.<br />
   * These can be overriden using the `options` argument of Popper.js.<br />
   * To override an option, simply pass as 3rd argument an object with the same
   * structure of this object, example:
   * ```
   * new Popper(ref, pop, {
   *   modifiers: {
   *     preventOverflow: { enabled: false }
   *   }
   * })
   * ```
   * @type {Object}
   * @static
   * @memberof Popper
   */
  var Defaults = {
    /**
     * Popper's placement
     * @prop {Popper.placements} placement='bottom'
     */
    placement: 'bottom',
    /**
     * Whether events (resize, scroll) are initially enabled
     * @prop {Boolean} eventsEnabled=true
     */
    eventsEnabled: true,
    /**
     * Set to true if you want to automatically remove the popper when
     * you call the `destroy` method.
     * @prop {Boolean} removeOnDestroy=false
     */
    removeOnDestroy: false,
    /**
     * Callback called when the popper is created.<br />
     * By default, is set to no-op.<br />
     * Access Popper.js instance with `data.instance`.
     * @prop {onCreate}
     */
    onCreate: function onCreate() {},
    /**
     * Callback called when the popper is updated, this callback is not called
     * on the initialization/creation of the popper, but only on subsequent
     * updates.<br />
     * By default, is set to no-op.<br />
     * Access Popper.js instance with `data.instance`.
     * @prop {onUpdate}
     */
    onUpdate: function onUpdate() {},
    /**
     * List of modifiers used to modify the offsets before they are applied to the popper.
     * They provide most of the functionalities of Popper.js
     * @prop {modifiers}
     */
    modifiers: modifiers
  };

  /**
   * @callback onCreate
   * @param {dataObject} data
   */

  /**
   * @callback onUpdate
   * @param {dataObject} data
   */

  // Utils
  // Methods
  var Popper = function () {
    /**
     * Create a new Popper.js instance
     * @class Popper
     * @param {HTMLElement|referenceObject} reference - The reference element used to position the popper
     * @param {HTMLElement} popper - The HTML element used as popper.
     * @param {Object} options - Your custom options to override the ones defined in [Defaults](#defaults)
     * @return {Object} instance - The generated Popper.js instance
     */
    function Popper(reference, popper) {
      var _this = this;
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      classCallCheck(this, Popper);
      this.scheduleUpdate = function () {
        return requestAnimationFrame(_this.update);
      };

      // make update() debounced, so that it only runs at most once-per-tick
      this.update = debounce(this.update.bind(this));

      // with {} we create a new object with the options inside it
      this.options = _extends({}, Popper.Defaults, options);

      // init state
      this.state = {
        isDestroyed: false,
        isCreated: false,
        scrollParents: []
      };

      // get reference and popper elements (allow jQuery wrappers)
      this.reference = reference && reference.jquery ? reference[0] : reference;
      this.popper = popper && popper.jquery ? popper[0] : popper;

      // Deep merge modifiers options
      this.options.modifiers = {};
      Object.keys(_extends({}, Popper.Defaults.modifiers, options.modifiers)).forEach(function (name) {
        _this.options.modifiers[name] = _extends({}, Popper.Defaults.modifiers[name] || {}, options.modifiers ? options.modifiers[name] : {});
      });

      // Refactoring modifiers' list (Object => Array)
      this.modifiers = Object.keys(this.options.modifiers).map(function (name) {
        return _extends({
          name: name
        }, _this.options.modifiers[name]);
      })
      // sort the modifiers by order
      .sort(function (a, b) {
        return a.order - b.order;
      });

      // modifiers have the ability to execute arbitrary code when Popper.js get inited
      // such code is executed in the same order of its modifier
      // they could add new properties to their options configuration
      // BE AWARE: don't add options to `options.modifiers.name` but to `modifierOptions`!
      this.modifiers.forEach(function (modifierOptions) {
        if (modifierOptions.enabled && isFunction(modifierOptions.onLoad)) {
          modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
        }
      });

      // fire the first update to position the popper in the right place
      this.update();
      var eventsEnabled = this.options.eventsEnabled;
      if (eventsEnabled) {
        // setup event listeners, they will take care of update the position in specific situations
        this.enableEventListeners();
      }
      this.state.eventsEnabled = eventsEnabled;
    }

    // We can't use class properties because they don't get listed in the
    // class prototype and break stuff like Sinon stubs

    createClass(Popper, [{
      key: 'update',
      value: function update$$1() {
        return update.call(this);
      }
    }, {
      key: 'destroy',
      value: function destroy$$1() {
        return destroy.call(this);
      }
    }, {
      key: 'enableEventListeners',
      value: function enableEventListeners$$1() {
        return enableEventListeners.call(this);
      }
    }, {
      key: 'disableEventListeners',
      value: function disableEventListeners$$1() {
        return disableEventListeners.call(this);
      }

      /**
       * Schedule an update, it will run on the next UI update available
       * @method scheduleUpdate
       * @memberof Popper
       */

      /**
       * Collection of utilities useful when writing custom modifiers.
       * Starting from version 1.7, this method is available only if you
       * include `popper-utils.js` before `popper.js`.
       *
       * **DEPRECATION**: This way to access PopperUtils is deprecated
       * and will be removed in v2! Use the PopperUtils module directly instead.
       * Due to the high instability of the methods contained in Utils, we can't
       * guarantee them to follow semver. Use them at your own risk!
       * @static
       * @private
       * @type {Object}
       * @deprecated since version 1.8
       * @member Utils
       * @memberof Popper
       */
    }]);
    return Popper;
  }();

  /**
   * The `referenceObject` is an object that provides an interface compatible with Popper.js
   * and lets you use it as replacement of a real DOM node.<br />
   * You can use this method to position a popper relatively to a set of coordinates
   * in case you don't have a DOM node to use as reference.
   *
   * ```
   * new Popper(referenceObject, popperNode);
   * ```
   *
   * NB: This feature isn't supported in Internet Explorer 10
   * @name referenceObject
   * @property {Function} data.getBoundingClientRect
   * A function that returns a set of coordinates compatible with the native `getBoundingClientRect` method.
   * @property {number} data.clientWidth
   * An ES6 getter that will return the width of the virtual reference element.
   * @property {number} data.clientHeight
   * An ES6 getter that will return the height of the virtual reference element.
   */

  Popper.Utils = (typeof window !== 'undefined' ? window : global).PopperUtils;
  Popper.placements = placements;
  Popper.Defaults = Defaults;
  return Popper;
});
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("DuR2")))

/***/ }),

/***/ "1+y7":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAAAeCAYAAAFIwk4JAAAAAXNSR0IArs4c6QAAA5ZJREFUSA2lVk1IVFEUPvelBpWEEEYRLQqkhVAg5KKsXGVQQgSRUGBQuBAi8y+KFkLRPCeiEKI2LdoUUVEUSUKFEfS3EIl+LCISRHERQVZCOafvvJn77nkzb8a/C2/ud77zd8+95903RHb43GMhUYLZCp4FmkxzPq8MldAOpQXri9kEjCW0kNYIE9FCPm4yOlFopWBmz3n6/IyYaoKwGS9DPg+A3BCQeX+6+RBCj2t9zFKh9mg7dZg+twce7QhXmKJHEsEpmb7qkIKLQoLpI3JacZMAV4quM9wAayuzNgg8swht68IKe4GX0ySNaYMQe3QU5V20snPM3kUTlDqMnT1sjYM53HbL6mVlF6J1HlUg82eXMcFPEWObjYNdPYVs3/BcCzkBORmF7OadlKL7AnOGoXfUaSot7zJaRmafJ5BpcUh10gIyJhXK04IkV+ezyc14icvoJ11Fxq3ogS942rAZ/dkBoo4+P4dD0DcRQ0NTqM/1GZSuI31+GOskERg1JnhKB3OOjD53I4Ulng2W6jiPkrzfiumlJrgJxGVL2rMKZJ97kbEuo5uArlSwzbg+o5DptsICdcstsbq0o0ePLYHl1YdYAFOHkicsdruq+9HQOBwaEeQA5gZrDHkPdveOyM7R5+sw2hcaZQMDbaexpYU1EkgXOdtJ5HJapOkwQkBWU7FWKtxAB82kklVGYWvNP7hGr0RDD3AEN7ST4GhGYVrNICpvFogxjBJ2peFMfxPcVcjUZF9thYxDnaFGdxwhq8AVLqYfaACmdrBLlSYOvsKr0ELt5kWc0nLxCRMswV/iWWcNZzUbLLLTJON8chP6XI+K7sUZz5L7RGVUSU3mr/aLnn43ry2QbBSONcEbLjeyPGtoITrlvA6ocAWO466SAxitMMFnwJ7INkLQIWxR/u3t5jrc/r05fkJ4tAJX65jVRSsk3MJxgym8LeLUSJZfX4RWUiOasIRuKZ2GVfgEvaFzvEyTAU7ybsz9OXya6KNjZkTrolsqGp9rcY5PtNEc8SDOuIr2msg3IzehRE9yObbpLRKXzzFZD5rqSJxvfEJrmWDpwBYrTjsb+oUT20ht5n0+28IJxSv9H+s10Op8QQLeUBKdrD9LsebTJ7Ru8seH8V7Jtzw6BqiUtlCzyd+pyn7mCa2Tz6eR9CTeze+gNqOqD1Y1k9nQTS6hEVo1E+N52vyhFjMqn5kurLZunsGmd2f6jVun9T+WFAYXIRdFDAAAAABJRU5ErkJggg=="

/***/ }),

/***/ "1Bek":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAAAgCAYAAAB3j6rJAAADtklEQVRYR82XWahWVRTHf/9GsbDIEFILRYoGxAejwadMg8CH0BIxirBySKIJJIVC0Eqh8kWQ1IQQBSGHIIuCoqAEI7E5J5CiHJAyUys1dcn/ss/1fMdzvu/cc1/ugu/lO2uv/dtrr2mLPiLqIxzUAomIy4HxwAPASGAE4P/+A/YBXwOfAe9JOtnkcBeARMQYYK+kgxHRD3gamAdcU2ODP4HlwKuS/q2h363SAhIRzwKvAx9ImhgRjwHv9MRg0v0VeFLSJ3XXdoNExEzgrdzCh4F1wKfA2LoGc3qngemSah2kCyQi7gU+Bi7JGfoDuA24EvgB6N8AxksekbS201qlONgDDC1RXi9pckQ8DyzpZKzi+3Hgdkm72q03yAvAm22UJgMbgS3AXQ1hvgFGS4qq9QZZA0wFLqpQOpSuaBBgg5c1hJkg6cNKkBQjwxzlwDRgcInyOklTI+IlYGFDkM8lVQZ9MX0drBOAGcD9BS9NdFqn4jWqBzC7gXf9k/RdJ4/cnFJ3BbDB1TEirgeeSD8H8sF0RfbeV4UMK9p3YGabf5+8PkDS0U4gLwKLk5Kr42pgpaQdEXFx8o69dFjStIhYBMwtGN0BrE8nd7q7LNwCPAg8BJyUdGcnEGeFXV+ULwB7yWl8IiIcP64vDuxvgTO5k/+UNve1eWMDGCST/4Grq0p/VtB+LiwqAh3Oecm6Pm3/zGhE3JE29uZuiNsBZ+MxwB51zzrr/yT9VeaVDOS3ioJWtubL5KVfgEkJwPFkcTf2NV8HPGUPFAz8CMyX5BtokQzkd2BIDzKhTNUQjwMvA7d2sOUOPVuSvdQlGYizwO7tjTznJpcyK29nE+CszMeLvy+W5PGiBcRZ8mgvKFwf3gdc8IoyMAWvvZAXe2OUJF9Xt0eazh2Z4TkpNq4tAbkKcL96u+Tbckmz8iCmdpw4upuIa4zTvEzagXgSdJadn1kjYlUKtiYgPlV+qMrbaAdySpJn3xYQl/GdwBUNSGYDyxp45Kgkg7ZO8RHhQXlpAxBny8qKdZ6D76mo3Fsl3X0BiP9oeEX2hvvI6BKYrcANFePFHElvVIG4JNuwA7Cu/A140nOcFcU1xFlTnGMOADdK+qcUJLOSnhav9WBo3pAeW88USI6kATw/mJ8Cxklyu+iSti+9iBgOLACmAJfWcM8rgJ8RLmz5jfNL99teHqIjSM47bv8eE/zs9BPDfclgntD3AtuAzcBHkk5HxE3uJcB9gBviiZSRbnYrykaBWm/fGp7otUqfATkH0sAoMAH+9p4AAAAASUVORK5CYII="

/***/ }),

/***/ "2mw7":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = login;
var _config = __webpack_require__("bzuE");
var _api = __webpack_require__("H/Zg");
// preset before starting RTC
//  class Presetting {
//   // init() {
//   //   // populate userId/roomId
//   //   $('#userId').val('user_' + parseInt(Math.random() * 100000000));
//   //   $('#roomId').val(parseInt(Math.random() * 100000));
//   //   // const roomId = this.query('roomId');
//   //   const roomId = '83999';
//   //   const userId = this.query('userId');
//   //   if (roomId) {
//   //     $('#roomId').val(roomId);
//   //   }
//   //   if (userId) {
//   //     $('#userId').val(userId);
//   //   }

//   //   $('#main-video-btns').hide();
//   //   $('.mask').hide();
//   //   setBtnClickFuc();
//   // }

//   // query(name) {
//   //   const match = window.location.search.match(new RegExp('(\\?|&)' + name + '=([^&]*)(&|$)'));
//   //   return !match ? '' : decodeURIComponent(match[2]);
//   // }

//   login(share, callback) {
//     let userId = $('#userId').val();
//     if (share) {
//       userId = 'share_' + userId;
//     }
//     const config = genTestUserSig(userId);
//     const sdkAppId = config.sdkAppId;
//     const userSig = config.userSig;
//     const roomId = $('#roomId').val();

//     callback({
//       // sdkAppId,
//       // userId,
//       // userSig,
//       // roomId
//       sdkAppId: 1400246643,
//       userId: "user_43707228",
//       userSig:
//         "eJwtzMEKgzAQBNB-ydUia4y6Cr0Ueih4UqG9lWoSWaJVkrQUSv*9oh7nzTBf1pR1*FaWFYyHwA5rJqmenjSt-HLK3kWcQcY57gMnzWOeSbIiEgBcpKmIt8bTqBZNEFFEOeCm6jOTXTwFgQD7B-XLe95IDzc7TH2gz21QXU5j1155OdLQmUrWueZZMiBOxh3Z7w8UZDLR",
//       roomId: "83999",
//     });
//   }
// }

function login(share, roomId, mobilePhone, cid, name, callback) {
  console.log(roomId);
  console.log(cid + name);
  // let userId = 'user_43707228';
  // if (share) {
  //   userId = "share_" + userId;
  // }

  // callback({
  //   // sdkAppId,
  //   // userId,
  //   // userSig,
  //   // roomId
  //   sdkAppId: 1400246643,
  //   userId,
  //   userSig:
  //   "eJwtzV0LgjAYBeD-slvD3tycU-Ai6ULQkqiuZeDM4UdjM-ui-56pl*c5B84HndOTPQiNAuTYgFZTloXoelnKiU3FtcjvRujcdx2CMXOXmSlqrpQsULAhAA6hlOC56WUrRnUZ831MMMwqnkrq0SkQBosZef1-WF2yi2Ku1tkhebf6xbw0avcGLnHdlVVzs*jRawb*yLYh*v4Asdg1aw__"    roomId: "83999",
  // });
  if (share) {
    (0, _api.getTencentYspSig)({
      cid: mobilePhone,
      name: name,
      isShare: "1"
    }).then(function (res) {
      callback({
        sdkAppId: _config.imKey.SDKAppID,
        userId: "share_" + mobilePhone,
        userSig: res.data,
        roomId: roomId
      });
    });
  } else {
    (0, _api.getTencentYspSig)({
      cid: mobilePhone,
      name: name
    }).then(function (res) {
      callback({
        sdkAppId: _config.imKey.SDKAppID,
        userId: mobilePhone,
        userSig: res.data,
        roomId: roomId
      });
    });
    // callback({
    //   sdkAppId: imKey.sdkAppId,
    //   userId: "user_95243385",
    //   userSig:
    //     "eJwtzEsLgkAUBeD-MuuI68wdGYV2vcAsSkNqE8KMdgnFV1MR-fdEXZ7vHM6Xxbtobk3DfMbnwGZDJm3KjjIa*Nma5uZJjkIoOQ1a-UirijTzHQTg6LooxqajwvQqlfI8gQJGNe*Kmt5dQAWTtZT37-szrWUY4yXRdgW5PZxksbkGd-sKeJR*nFLVWZ2E23h5XLDfHxB2Msg_",
    //   roomId,
    // });
  }
}

/***/ }),

/***/ "2pqD":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
__webpack_require__("rpBe");
var _checkbox = _interopRequireDefault(__webpack_require__("hK1P"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__("Q9dM"));
var _createClass2 = _interopRequireDefault(__webpack_require__("wm7F"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("F6AD"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("fghW"));
var _inherits2 = _interopRequireDefault(__webpack_require__("QwVp"));
__webpack_require__("sRCI");
var _modal = _interopRequireDefault(__webpack_require__("vnWH"));
var _react = _interopRequireWildcard(__webpack_require__("GiK3"));
var _dva = __webpack_require__("S6G3");
__webpack_require__("bPsJ");
var _RecordVideo = _interopRequireDefault(__webpack_require__("F1Lc"));
var _recordRTC = __webpack_require__("NH7q");
var _recording = _interopRequireDefault(__webpack_require__("RMDC"));
var _dec, _class;
/**
 * 视频通话页面
 */
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var confirm = _modal.default.confirm,
  warning = _modal.default.warning,
  success = _modal.default.success,
  error = _modal.default.error;
var _TOOLS = [{
  type: 'mute',
  icon: __webpack_require__("NCSo"),
  checkIcon: __webpack_require__("CE2x"),
  name: '静音'
}, {
  type: 'video',
  icon: __webpack_require__("Z1a+"),
  checkIcon: __webpack_require__("5uwJ"),
  name: '视频'
}, {
  type: 'add',
  icon: __webpack_require__("zVWh"),
  checkIcon: __webpack_require__("WO9G"),
  name: '添加'
}, {
  type: 'record',
  icon: __webpack_require__("7Mgp"),
  checkIcon: _recording.default,
  name: '录制'
}, {
  type: 'close',
  icon: __webpack_require__("MRHW"),
  checkIcon: __webpack_require__("SECW"),
  name: '结束'
}];
var _GENRE_TOOLS = [{
  type: 'mute',
  icon: __webpack_require__("NCSo"),
  checkIcon: __webpack_require__("CE2x"),
  name: '静音'
}, {
  type: 'record',
  icon: __webpack_require__("7Mgp"),
  checkIcon: _recording.default,
  name: '录制'
}, {
  type: 'close',
  icon: __webpack_require__("MRHW"),
  checkIcon: __webpack_require__("SECW"),
  name: '结束'
}];
var BoxTool = exports.default = (_dec = (0, _dva.connect)(function (state) {
  return {
    ownCid: state.im.v5Data.ownCid,
    videoType: state.command.videoType,
    //0: 九宫格 1: 右侧列表   2: 顶部列表   3: 十六宫格  4: 二十五宫格
    recordStatus: state.command.recordStatus,
    // 0：未录制 1：录制中
    videoGenre: state.command.videoGenre // 功能类型 0: 视频调度(一对多) 1: 视频上拉(一对一)
  };
}), _dec(_class = /*#__PURE__*/function (_Component) {
  function BoxTool(props) {
    var _this;
    (0, _classCallCheck2.default)(this, BoxTool);
    _this = _callSuper(this, BoxTool, [props]);
    _this.onClickTool = function (type) {
      var _this$props = _this.props,
        canMic = _this$props.canMic,
        common = _this$props.common,
        switchVideoTool = _this$props.switchVideoTool,
        canCamera = _this$props.canCamera,
        addMember = _this$props.addMember,
        dissolutionRoomModal = _this$props.dissolutionRoomModal;
      switch (type) {
        case "mute":
          {
            if (canMic) {
              switchVideoTool(type);
              if (common.isMicOn) {
                common.isMicOn = false;
                common.muteAudio();
              } else {
                common.isMicOn = true;
                common.unmuteAudio();
              }
            }
            break;
          }
        case "video":
          {
            if (canCamera) {
              switchVideoTool(type);
              if (common.isCamOn) {
                common.isCamOn = false;
                common.muteVideo();
              } else {
                common.isCamOn = true;
                common.unmuteVideo();
              }
            }
            break;
          }
        case "share":
          {
            common.screenShareClick();
            break;
          }
        case "add":
          {
            addMember();
            break;
          }
        case "record":
          {
            _this.onRecordVideo('start');
            break;
          }
        case "close":
          {
            dissolutionRoomModal();
          }
      }
    };
    _this.onRecordVideo = function (status) {
      // 0：未录制 1：录制中
      var that = _this;
      if (status == 'start') {
        warning({
          title: '录制功能为浏览器录制，录制过程中，请勿关闭当前录制的浏览器页面及注意当前网络！',
          okText: '我知道了',
          onOk: function onOk() {
            _modal.default.destroyAll();
            (0, _recordRTC.startRecord)(function (success) {
              that.props.dispatch({
                type: 'command/fetchRecordStatus',
                payload: 1
              });
            }, function (err) {
              error({
                title: '浏览器无法获取录制权限，启动失败',
                okText: '好的'
              });
            });
          }
        });
      } else if (status == 'end') {
        confirm({
          title: '是否确认结束视频调度录屏？',
          okText: '确定',
          cancelText: '取消',
          onOk: function onOk() {
            _modal.default.destroyAll();
            (0, _recordRTC.stopRecord)();
            that.props.dispatch({
              type: 'command/fetchRecordStatus',
              payload: 0
            });
            var hasE = (0, _recordRTC.hasError)();
            if (hasE) {
              error({
                title: '录制文件生成失败',
                okText: '好的'
              });
            } else {
              success({
                content: '录制结束，录制文件已下载完成！',
                okText: '我知道了',
                onOk: function onOk() {
                  _modal.default.destroyAll();
                  (0, _recordRTC.downloadRecord)();
                }
              });
            }
          },
          onCancel: function onCancel() {
            console.log('Cancel');
          }
        });
      }
      _this.props.onRecordVideo && _this.props.onRecordVideo();
    };
    _this.state = {
      isShowChange: false // 切换布局弹框是否显示
    };
    return _this;
  }
  (0, _inherits2.default)(BoxTool, _Component);
  return (0, _createClass2.default)(BoxTool, [{
    key: "componentDidMount",
    value: function componentDidMount() {}
  }, {
    key: "onChangeVideoType",
    value: function onChangeVideoType(type) {
      console.log('onChangeVideoType', type);
      this.props.dispatch({
        type: 'command/fetchVideoType',
        payload: type
      });
    }
  }, {
    key: "onShowChange",
    value: function onShowChange() {
      this.setState({
        isShowChange: this.state.isShowChange ? false : true
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$state = this.state,
        currentTime = _this$state.currentTime,
        isShowChange = _this$state.isShowChange;
      var _this$props2 = this.props,
        toolStatus = _this$props2.toolStatus,
        recordStatus = _this$props2.recordStatus,
        addMember = _this$props2.addMember,
        boxToolStyle = _this$props2.boxToolStyle,
        dissolutionRoomModal = _this$props2.dissolutionRoomModal,
        videoType = _this$props2.videoType,
        videoGenre = _this$props2.videoGenre;
      var hasVideoScheduling = videoGenre == 0 ? true : false;
      var tools = hasVideoScheduling ? _TOOLS : _GENRE_TOOLS;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: boxToolStyle
      }, tools.map(function (tool, index) {
        if (recordStatus != 0 && tool.type == 'record') {
          return /*#__PURE__*/_react.default.createElement("div", {
            className: "tool-item",
            onClick: _this2.onRecordVideo.bind(_this2, 'end')
          }, /*#__PURE__*/_react.default.createElement("img", {
            src: _recording.default,
            alt: ""
          }), /*#__PURE__*/_react.default.createElement("div", {
            className: "name"
          }, "\u7ED3\u675F\u5F55\u5236"));
        }
        return /*#__PURE__*/_react.default.createElement("div", {
          className: "tool-item",
          onClick: _this2.onClickTool.bind(_this2, tool.type)
        }, /*#__PURE__*/_react.default.createElement("img", {
          src: toolStatus[tool.type] ? tool.checkIcon : tool.icon,
          alt: ""
        }), /*#__PURE__*/_react.default.createElement("div", {
          className: "name"
        }, tool.name));
      }), hasVideoScheduling ? /*#__PURE__*/_react.default.createElement("div", {
        className: "tool-item change-abs",
        onClick: this.onShowChange.bind(this)
      }, /*#__PURE__*/_react.default.createElement("img", {
        src: toolStatus.close ? __webpack_require__("dToI") : __webpack_require__("dToI"),
        alt: ""
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "name"
      }, "\u5207\u6362\u5E03\u5C40"), isShowChange ? /*#__PURE__*/_react.default.createElement("div", {
        className: "change-content"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "change-item",
        onChange: this.onChangeVideoType.bind(this, '0')
      }, /*#__PURE__*/_react.default.createElement("img", {
        className: "change-img",
        src: __webpack_require__("AS0P")
      }), /*#__PURE__*/_react.default.createElement(_checkbox.default, {
        checked: videoType == "0" ? true : false,
        key: "0"
      }, "\u4E5D\u5BAB\u683C")), /*#__PURE__*/_react.default.createElement("div", {
        className: "change-item",
        onChange: this.onChangeVideoType.bind(this, '3')
      }, /*#__PURE__*/_react.default.createElement("img", {
        className: "change-img",
        src: __webpack_require__("AS0P")
      }), /*#__PURE__*/_react.default.createElement(_checkbox.default, {
        checked: videoType == "3" ? true : false,
        key: "3"
      }, "\u5341\u516D\u5BAB\u683C")), /*#__PURE__*/_react.default.createElement("div", {
        className: "change-item",
        onChange: this.onChangeVideoType.bind(this, '4')
      }, /*#__PURE__*/_react.default.createElement("img", {
        className: "change-img",
        src: __webpack_require__("AS0P")
      }), /*#__PURE__*/_react.default.createElement(_checkbox.default, {
        checked: videoType == "4" ? true : false,
        key: "4"
      }, "\u4E8C\u5341\u4E94\u5BAB\u683C")), /*#__PURE__*/_react.default.createElement("div", {
        className: "change-item",
        onChange: this.onChangeVideoType.bind(this, '1')
      }, /*#__PURE__*/_react.default.createElement("img", {
        className: "change-img",
        src: __webpack_require__("6Jhx")
      }), /*#__PURE__*/_react.default.createElement(_checkbox.default, {
        checked: videoType == "1" ? true : false,
        key: "1"
      }, "\u53F3\u4FA7\u5217\u8868")), /*#__PURE__*/_react.default.createElement("div", {
        className: "change-item",
        onChange: this.onChangeVideoType.bind(this, '2')
      }, /*#__PURE__*/_react.default.createElement("img", {
        className: "change-img",
        src: __webpack_require__("K7vd")
      }), /*#__PURE__*/_react.default.createElement(_checkbox.default, {
        checked: videoType == "2" ? true : false,
        key: "2"
      }, "\u9876\u90E8\u5217\u8868"))) : null) : null, /*#__PURE__*/_react.default.createElement(_RecordVideo.default, null));
    }
  }]);
}(_react.Component)) || _class);

/***/ }),

/***/ "5uwJ":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAA4lJREFUWEftl01oHGUYx3//2dUQojub1CoePJQaKfFkTQ5+0YJ46UFFBQ8q9ZNEatLsxtaj40lBs7uKXaFpIVVQ8OChCCJ4CIJVGtsiogc/DkrVQm2ys1htTHYemTG7zq4N3W22mwjOcXif//t7n/d5nvmPWGeP1hkP/x0gzzPnq4HmgG/8GvM8Be3Idl2G3Kzdj/E0sNWM3lY2kJgHjsuhWJrUe63ExtdGQBs9u2LB53WMnRcr1BA33ZVm9LSn31rVi4DccTto8HhdsAgwrClBIQyn7qTioJ/Xk03FxxbJnbCbLeDosqAhXutKsm9XD983Wxdhve07y+bFCqNBwGikLwIZQ35Bx1uBUkN2pssFPdaKQOPaVMamq1evC2Rpu2fJMH7G01JVR6lxOwLcEh0qwaA/qWOrAXIzNmjG7LLGp+WCbm3US3uWDnwKwIMYCeCdlBg5mdcfcjM2V+2opIs794LKqwHqe95SSz5+dEAx7+fVF9fbMGFbFiscBvobau4jP6+7wgzVCrdcUFsG5UqavVnbERhvm+HGYML9o327LuOGjgG5Gdtj8FK1GyXOInaasRvjjhDIEdsvOVBfmu45nymMh2uFK36QuKeU0xduxmbM2NYxIMGswVANBj7u7uaBUy/qdDQDOw3UULj7r9/CM8eGtVh9vzZAIpwzu8t5FRs7uONAEl8qwVjpFc2cb5x0HAjxDQ5j5Ul9uD6A/qaoOA57Sznl1vzK6gDEoas3MfzdmBbWrqjFJxi31cDEZ5cb9/1a0C9r0vbXpek66VM044nYYPwJuNfP6/OOF3X1+5jO2lhgTGJElgNxDiM0cCPA7dGkTrDtkn864h9sN2t3YrxrRp0DiF1nf9vtR+9z5lYWKK1kP9w9ttmWOIwx0NBxH5QL2qFUxsKii0yUxFB4r6vxQ6kJG6LC0eVrOVLO65+CXha+aq9dufgnLwMPmUgK3tq4idGw+8IMHagVnDhUzuvRVQFl7E2MR6IDOhzwc3pqJT0zk6S6H4nQU281MRvzKcUEFK91+XZggEozcCdOkTzzI/1BhV1mUZFGJt8Rg6WcTjSjUevAaBZkbcqCqOLb9kjs9/MablUwso7XPGs95yq8Gp8VrQrF10tM9biM/+zp91Z16jx0Omt3BwEjiJswNoSjoUnBAHEm/JVOiDfmc3q/ybh/LWuLqb/Yzc8X9z/QhbK57jL0F0MRw3k9o7x7AAAAAElFTkSuQmCC"

/***/ }),

/***/ "6Jhx":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJgAAABoCAYAAAANUDk4AAAAAXNSR0IArs4c6QAAAmxJREFUeF7t3LFNBFEQBFE2WYIi2cNFCJOR6lpvAxh1d5XxrX1er9fnhy+zwPM8Xz/DvDuf590LZMz4pyAE+6chnfl7AYIx43QBgp3O6zjBOHC6AMFO53WcYBw4XYBgp/M6TjAOnC5AsNN5HScYB04XINjpvI4TjAOnCxDsdF7HCcaB0wUIdjqv4wTjwOkCBDud13GCceB0AYKdzus4wThwugDBTud1nGAcOF2AYKfzOk4wDpwuQLDTeR0nGAdOFyDY6byOE4wDpwsQ7HRexwnGgdMFCHY6r+O/BXv3RfwfLEaQYDEga3EItkY01odgMSBrcTzy14jG+hAsBmQtDsHWiMb6ECwGZC0OwdaIxvoQLAZkLQ7B1ojG+hAsBmQtDsHWiMb6ECwGZC0OwdaIxvoQLAZkLQ7B1ojG+hAsBmQtDsHWiMb6ECwGZC0OwdaIxvoQLAZkLQ7B1ojG+hAsBmQtDsHWiMb6ECwGZC0OwdaIxvoQLAZkLQ7B1ojG+hAsBmQtDsHWiMb6ECwGZC0OwdaIxvoQLAZkLQ7B1ojG+hAsBmQtzm/B3r2ff7TGCBIsBmQtDsHWiMb6ECwGZC2OR/4a0VgfgsWArMUh2BrRWB+CxYCsxSHYGtFYH4LFgKzFIdga0VgfgsWArMUh2BrRWB+CxYCsxSHYGtFYH4LFgKzFIdga0VgfgsWArMUh2BrRWB+CxYCsxSHYGtFYH4LFgKzFIdga0VgfgsWArMUh2BrRWB+CxYCsxSHYGtFYH4LFgKzFIdga0VgfgsWArMUh2BrRWB+CxYCsxSHYGtFYH4LFgKzFIdga0VifNcG+AeKO5ad/GBYzAAAAAElFTkSuQmCC"

/***/ }),

/***/ "6Mj6":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "6VvU":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = isMobile
module.exports.isMobile = isMobile
module.exports.default = isMobile

var mobileRE = /(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series[46]0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i

var tabletRE = /(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series[46]0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino|android|ipad|playbook|silk/i

function isMobile (opts) {
  if (!opts) opts = {}
  var ua = opts.ua
  if (!ua && typeof navigator !== 'undefined') ua = navigator.userAgent
  if (ua && ua.headers && typeof ua.headers['user-agent'] === 'string') {
    ua = ua.headers['user-agent']
  }
  if (typeof ua !== 'string') return false

  var result = opts.tablet ? tabletRE.test(ua) : mobileRE.test(ua)

  if (
    !result &&
    opts.tablet &&
    opts.featureDetect &&
    navigator &&
    navigator.maxTouchPoints > 1 &&
    ua.indexOf('Macintosh') !== -1 &&
    ua.indexOf('Safari') !== -1
  ) {
    result = true
  }

  return result
}


/***/ }),

/***/ "6upA":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACwAAABCCAYAAAAsejQrAAAAAXNSR0IArs4c6QAACvBJREFUaEPNWntwVNUZ/33n3Lub94uNo0VR21pH66vTmdp2LEMC8hq18ggImkSopuhIRRzxWUmR1krxUbEqKGhJxAKjtIJWKEod7Uyddqb1RRXsaJWAkmxCkkU22b3n69y7uZvde+/u3ZvgjPef3bnnnO/7ne/8vsc55xJG8XBLa0lXsvtCQF3EwIVgHguglokiBI4D6GRQJzH2keA3SNIbkXWPvD8KlaCRDD78kxvHkzKuVaxmE6iIwQHE0EdEtJ4IT9VueORggIFW10CAD199/VRm/g2Ac6zBRGBm69d8mM13qd9U+/A7JzAiSjKrZ0jIO4IALwjwkZbF30gMGg8z8/RMxSYuU0Au+9ptthKvCYEpBkH31p5Wu4paW5N+FvcF3Nl8w2WAsZEZlebSEwg2Bez/5m96vexZWCZ3zsj5YnhKRHi9mGhO2dOPfpYPdF7AnU3XrwCruzgXIpfJMkB6UiSbQi4OAYeEJmdEnvrdm7lA5wTc2bjoPgYvC7bofgua28L2SAL1AXJibdsj//SS5gn4cON1d4HVPX7qnU7lNPiIx4OiGjChpu3xd13O6nzR1bRoBit+3kuZk8NOjjqjhlOGHVHMX68wkumkRPQxVennj1mzpi9TTpaFO69qOYlA7yjmMbmWI9OnnHHLCcgVJRw+6NcOoo0ntK9tzg34ypaXAEzLGUhda+5QWUgcs2UUEkWIQEyzIpvWplc8beHO+S11AL+aFWd9EkGQROFJsaGkY1PEm1K0P3L5pLNozhwjK9N1zr/mNTDG53UUl5cFXeOAqWZoxUiK5kj72o1pwD3zfzo+ycZrXh6ZlQccFndnBh9WOibsy+H0/Ghf7R+eODMNOHrFNWsZaHFFAccMnJkts78cexKK6sdDP/dsyNox1lyMrigSb+/FwJ7XYXQccic+x5t88kmK70WeeeIfxFu2yK7ndx0E8wl+cdWzXZMouWoOiibXgYTwZBQrhfiuPTjatgUwLCp6RbV0IZXm9FAZkEq0YlVk8xO3kkkHw0hadHCFpTzVlqVRaqi4fQn0c87yyxFWe+Kdvej79W8Bw65xskmRXz99GNm8/gyKzl24lBn3e2r0IVnpwitRNKW+ILB2p/jOVxHb0J6ycJYFMxw4Xd5lO7Usqaim6JyFGxhYYEkIkFvlyV9D5eoVOWmQaxYmPXpvWQ7jwEGPAjq7eBquY1IzEKCLKNqw8O8MvtD2wLzVYQaKkqvnoXj6xYGsa3c+9uIufPH0s/krfA8DkhAt1NWwYD+Yv+mlOZ/XVj6wEtop5hYu+JP8tAO9S+9yDXTvYFK7GdsJBYnbKTq7+X8AjfN2Okf9mqGieuNjoOKi4GjNVT8WR0/TdR4MzJ9YpBDLKTqr2dwInjQUaLJIlC8u17Q9PirA3Y2L0tsr322PbRYSK6lrVvM+Yj6jEMCZFKl86JeQI6SEYVJiyR1uDvsUJ0R8G0VnNu8CeMh7fJNlmgIlC+aj6JIpI6JEfMdOfLFhkzMI+Mc1yCuoe0bTOgauTWkuvDgxrVvx4MoRhbW+pXfC+KSjAIDZ9tCE9n3qmdm0mBkPezmdi2SO+ZRc24Si6ZMCWTn+0m4ce9IqvHw31ZlRg4BkVUnlGOprWHhmIjFoHR+5wphPvcpSoPzuZdDPO7sg0Im330P/PatByVQ94U7FjoOZjGMFIvytZlv7RZaD9lx+1cfMONV3T+tV/WgaihfMQ3jqJJDMUfwYCgMv77Z4S4aR++Al/0nR8uptbStSgH/c+ACDb/I1k8OLMycoThmLoskToF1wLmRtxFpw43AXkm+9i/iuv0J92uE62vLTl7kCJMW5Ndva3rUAH2loPJ0H+UNm9jaRn+QvuZ2IXqn+U7vlLOmY3XPZlc8zMCOdflIkyzrd80udgXH7FeBpgXRpzfZndmQDvnz+BTBgnrZI+9jALxX5RW2/dtcEPZ2I3qze3v4DIrIOM7KyYs8l81YzcHM6EzqOU51xyG9LFdTirl0zc1IX+nfLXtj4dhpTplBubCw90mO8x8yneivLNoFbgc8u2iHU75iAgFVVO569NXOYq+7ouazpOzCSrwNcGnhX7JqlYwvkd1ybsYQE2lM5tnwKrVuXyAvYbOy7ZN6livFHBou0DA8ndBUDgUnrmKF9DiHofTD9sOrFTT1OG+Ss7I5Mv2IRgx/LBOyXCV13BH5RxmFxS5dAB4nQj6q2t33kRcu8pWjvtLk3MLAmyJVLfkfLn0uJ0EGaPqHyhfYPc8nxrZ17p81drJit4si1PK5LmewtjV+UyC5u6CCkmFC5Y9P+fON8AZuDe6fPvZEVP+S+ssifWJyKcxU7gugQCZpQ8dLmfb6T9Otgt/dMm7uEFD9ox17rvcPJRnQ+TDgkgbqKl7d+UAiWgixsC+qb2rBUmYcuNqmdUcFl0vxxmQifka7VVWx/tuDb0UCArZA3ZfbNirG6EGt4sD5dthPoc6FTXfmLm/8TRFZgwBboqQ23sOJVfpnKfZCU8gICPhchGRiszcIgE0z37bt49jLFfF/WYL/EQRbtDwtN1JX/eevekSgekYXTnJ7UcBtD3VuoYiLqJMF15Tufe6/QMa5QOtKBadCTZ9+uDPUrj6CRVdyZYIXQ6st3bXbdvQXBMCoL24r6J826UzGvzKWYgC5Bsr5s99Z3goDz6ntcAJuC+yfO/LliXuFaQkJUQNSXvfJcuqYdDejjBjgFesbdivEL+56PBEWFwsSyPdveGg3IzLHHFbApuLd+ZitYLQdRt5TaxLK/bP338QI7qrCWD0Rf/YzbpBA7S3c/96/jCfZLAczMhDlbBb7dwNRK6isBeAhUUawsVqbxQCklQ+Ewi1CCWIcysmmmkeKEGmQpBhRzvFjXYjjttBi11vl+LjPqKMGLHw6jV48MGqKG2AjltJ6SGoRigIcv5Rydlab6wyiP4vdN3fYWvpDVKMjpuGGLRHXPWCQQSWRakHRdsaog5mIoDgOalOY+0HxMMpj/WCVBIplMclxCHGUYMWsyunlxB3BIDoaKjQP02PWu/duILMwNraHBksgZBCN9oUEiGSaEa5GgMkgATjuyIpBw76xSfVVSV90imYhCyHSfpE6flzz5swN+Vva1cLzp/m8J4nJbEEkUKyXGSR76WG24QScDVQAXD9kWyvo2zYgJUr2uCRCOKWPwk0zQxzTxUeX6pd35QOcFzC1r9cRA/3mZAphwqmSYoIYfQcTM44RzEkM9DOaYIHQ5gbDgQ6yo136va6KX1i/NuQH1DWvc2qolDoTPzwIsxCmSVWmWclbEoJMF2Fx012OQ6hPQXJZjRgcD/fYAJeSRonXL/jtiC5sD+Zp7Tk+AazIoEVKGGCfJ0LJBk1RCVRBUMUzgRGwokRCkjgqWMSeIJES/YDYvOtKPXqz205rWrI+SnON8OWx+noBXPvj6FwZXDDk2yIDGksawblRJ08GGSKsMQGQ6of1fDgcNQ8lBQ4loGNxrnkGZMnUhORamT8vX3NE5aqezrMxMR5fceUJIyRMTSQxbVikSQpQqxaUQCGnM0mBoiqBBQHGCDUgyWCIZYjqmBB3VDJif6SKRAHTdnAjHwqWVB2j1LUf9wPpy2OUkDVtk/7i91aE4agwVL0/Zxz6rs/+bvxakIftlneVZLbqmJw2ljhSxHqVHW110GRWHcw02k0n3iXtLiwYGS4VQ4QSpMImwFiKIBJkpYxA6SWOQWekGDyrIAUOqeJlWG8MDN8WDZLdMDP8Ha96wbRjI3DAAAAAASUVORK5CYII="

/***/ }),

/***/ "7Mgp":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAAudJREFUWEfNmE2ITlEYx39/LCwQm6lRLEmWFsQoM7EQC1+RMrPxsfOVicISZRDDzsfCUCKDBVmQmTImFpaSWVKUDZlZWODRk+fquN73vXfGW+6pu7n3PP/nd59zznPOecQ4m5nNAtYAq4C5wOx4XOl9PG+BR8ADSZ/G40JlO5vZemA3sByYUtLuG/AUuCDpbhmbQiAzWwb0AEvLCDboMwwclPSskU5dIDObDJwB9uYEfgAufg94mQyTd8uGbxGwLn5iUs6+Fzgg6XstsJpAZjYTuBXzJLP7Cpx3SEkfy0TLzFrcObAHmJrY+PzaLOlzXucvoIDxCCxIOvcD+yW9KwOS72Nmc4CzwMbk22uPYB7qD6AYpodJZAw4KunEREBqgB0GjgGZX4/U6nT48kDnkjnjMFsl3WwGTKZhZluAGwlUr6R92fffQLGahhLnR5oVmTqROp68b8tWXwrkyzFb2v2SNjUzMjWgbidzaliSp5dfYxlJ704Y+WqaN9EJXPYnYqKPJKtvgyfPDOgJ0B5iPZIOlRX+l35mdtKTZWgMSOpQ7E2eV3w78KTXWibPmJn/zA5gO7AwRF8BV4DLknxRNGyRpz4Anjx9m2lxoE6gLyyHJPleVSTUClwHOup09Ihvk+TOirR8r2uLTl0O5DAO5a1bkm8XdVtE5nEDmMzWoVYWRcrMPJOfDqNrDjQArIgX7ZIGC4B2AheL/jy+75J0qUDPfTuDt0EHeuOrKl7Ml+Qzv1GEngOLSwK9kLSkQM99O4O3EQcaBabFi+mSxgoE0v5FXGOSphfouW/X9DbmQF+AzGiGpOxjTZ3cDzQDyH07g7fRSg5Z5Sb1VaArQvY/ln03cCr891UtMXZWb+vwUJlZdTbXAPI7V3WOHwFVnQNaAPmJrTpH2ICqziE/gPy2Wp1rUED5rbUaF8Vsp6zUVTqBqk6xIT1TVKYckz/oVKZgVQPMS3proyDhVY1aJT2vkngh4f54S3o/AdIWsUP2RbRSAAAAAElFTkSuQmCC"

/***/ }),

/***/ "8VXG":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CheckRTC;
__webpack_require__("UQ5M");
var _message2 = _interopRequireDefault(__webpack_require__("/qCn"));
/**
 * 检查设备是否支持
 */
// import Common from './common';

// const presetting = new Presetting();
// presetting.init();
function CheckRTC() {
  // 检查浏览器是否支持TRTC视频功能（check if browser is compatible with TRTC）
  TRTC.checkSystemRequirements().then(function (result) {
    console.log("检测浏览器");
    if (!result) {
      alert('您的浏览器不兼容视频应用！建议下载最新版Chrome浏览器');
      window.location.href = 'https://www.google.cn/chrome/';
    }
  });

  // setup logging stuffs
  TRTC.Logger.setLogLevel(TRTC.Logger.LogLevel.DEBUG);
  TRTC.Logger.enableUploadLog();
  TRTC.getDevices().then(function (devices) {
    devices.forEach(function (item) {
      console.log('device: ' + item.kind + ' ' + item.label + ' ' + item.deviceId);
    });
  }).catch(function (error) {
    _message2.default.error("获取设备失败");
    console.error('getDevices error observed ' + error);
  });

  // populate camera options
  // TRTC.getCameras().then(devices => {
  //   devices.forEach(device => {
  //     console.log(device)
  //     if (!Common.cameraId) {
  //       Common.cameraId = device.deviceId;
  //     }
  //     // let div = $('<div></div>');
  //     // div.attr('id', device.deviceId);
  //     // div.html(device.label);
  //     // div.appendTo('#camera-option');
  //   });
  // });

  // populate microphone options
  // TRTC.getMicrophones().then(devices => {
  //   devices.forEach(device => {
  //     if (!Common.micId) {
  //       Common.micId = device.deviceId;
  //     }
  //     // let div = $('<div></div>');
  //     // div.attr('id', device.deviceId);
  //     // div.html(device.label);
  //     // div.appendTo('#mic-option');
  //   });
  // });
}

/***/ }),

/***/ "8ZKn":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAbCAYAAABm409WAAAAAXNSR0IArs4c6QAAAsBJREFUSA21VjFvUzEQPgdKWWBgIyoSUiemLvyArhAJ2oGhUhaWjnliSNQNsVXNUIWxDF2QupWAKKz9AV06MUVCKgobA5UQARrzfXe2H8l7KUrVWPLzvfPdd2f7fGcn57WWX5Bf8li81NAXIVoN4n1x0kM/kGvyVrbcl0kwrnSi5avyU15g7in6lVKZnHkGcleuy3MY6udso4oGMv8IU6/h8Q2Mv+FlF2MXZo7kphjAd6zkTO6DvwK5FYxzkDvFWJeOe4cxtVEDmW9gZhtKFSi8wfKb0na9JF1GNP0itrENnVXoDCHyDEZeRtHcAD338NThK7IBoXYUSmPmD5TuuFriRSLzTZCb4Xc1rqSiDO45t0UAPwlcBfVDB4rNHNrQ1RPLMINcw7+ShveS+f2i5pQcYhCLmGgOlhYQMZ9BD2Ve7v13z6l1XuOZDOQTRCqIrLtXNc4Zik72J4LTiYFsQWk5YB/CmVZp/DMoMt/FVj0hdgVEPDCGY7EZ+DHk1tBvh74Gg8e6+qIGOYYFbBrgDeUajnQc/9BzL7ewwo9Y8h3tpMmzVY1r5FjAZhTZ9Y+XqCi+rKx5WdctYVogbc3mwk8acqyqhWmauSTih4a7gtFAfv3L8Q+VPZAd3XM7k50ganPhJw1/cFbW+kwJlgostySZRDBanHzDnj9AOJ9oJ00e58paxAI2Ddj1Z+Iqa7bnS5DbQ/8a+h7Al0rD1DAMC9gzv2iV4MUuDM9pVixbxTQ8ZlZisUZg9RZFLBbM50y5lhWngcxlqWtp+1QLEGbMgFWiOowwn29eyEhM14ZRh/canXk9oB8zLTg0wDbTkmkmRIvFzIp+NMKRt5bPliHqrISkmM/3cILbF3u25CBGZb6P6OD1rwGUx/heL1zHxXfSuEb6Hz3kxAbBAu/l4b+sibSTDyjysa6MiF1WNi1/CMDUXwnmB40/Mi5yAAAAAElFTkSuQmCC"

/***/ }),

/***/ "9oFX":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var __importStar = this && this.__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) {
    if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
  }
  result["default"] = mod;
  return result;
};

var __importDefault = this && this.__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};

Object.defineProperty(exports, "__esModule", {
  value: true
});

var React = __importStar(__webpack_require__("GiK3"));

var findDOMNode_1 = __importDefault(__webpack_require__("x85o"));

var toArray_1 = __importDefault(__webpack_require__("Hjgs"));

var warning_1 = __importDefault(__webpack_require__("GNCS"));

var ref_1 = __webpack_require__("MtKN");

var resize_observer_polyfill_1 = __importDefault(__webpack_require__("z+gd"));

var util_1 = __webpack_require__("kXYA");

var INTERNAL_PREFIX_KEY = 'rc-observer-key'; // Still need to be compatible with React 15, we use class component here

var ReactResizeObserver =
/*#__PURE__*/
function (_React$Component) {
  _inherits(ReactResizeObserver, _React$Component);

  function ReactResizeObserver() {
    var _this;

    _classCallCheck(this, ReactResizeObserver);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ReactResizeObserver).apply(this, arguments));
    _this.resizeObserver = null;
    _this.childNode = null;
    _this.currentElement = null;
    _this.state = {
      width: 0,
      height: 0
    };

    _this.onResize = function (entries) {
      var onResize = _this.props.onResize;
      var target = entries[0].target;

      var _target$getBoundingCl = target.getBoundingClientRect(),
          width = _target$getBoundingCl.width,
          height = _target$getBoundingCl.height;
      /**
       * Resize observer trigger when content size changed.
       * In most case we just care about element size,
       * let's use `boundary` instead of `contentRect` here to avoid shaking.
       */


      var fixedWidth = Math.floor(width);
      var fixedHeight = Math.floor(height);

      if (_this.state.width !== fixedWidth || _this.state.height !== fixedHeight) {
        var size = {
          width: fixedWidth,
          height: fixedHeight
        };

        _this.setState(size);

        if (onResize) {
          onResize(size);
        }
      }
    };

    _this.setChildNode = function (node) {
      _this.childNode = node;
    };

    return _this;
  }

  _createClass(ReactResizeObserver, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.onComponentUpdated();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.onComponentUpdated();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.destroyObserver();
    }
  }, {
    key: "onComponentUpdated",
    value: function onComponentUpdated() {
      var disabled = this.props.disabled; // Unregister if disabled

      if (disabled) {
        this.destroyObserver();
        return;
      } // Unregister if element changed


      var element = findDOMNode_1.default(this.childNode || this);
      var elementChanged = element !== this.currentElement;

      if (elementChanged) {
        this.destroyObserver();
        this.currentElement = element;
      }

      if (!this.resizeObserver && element) {
        this.resizeObserver = new resize_observer_polyfill_1.default(this.onResize);
        this.resizeObserver.observe(element);
      }
    }
  }, {
    key: "destroyObserver",
    value: function destroyObserver() {
      if (this.resizeObserver) {
        this.resizeObserver.disconnect();
        this.resizeObserver = null;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var children = this.props.children;
      var childNodes = toArray_1.default(children);

      if (childNodes.length > 1) {
        warning_1.default(false, 'Find more than one child node with `children` in ResizeObserver. Will only observe first one.');
      } else if (childNodes.length === 0) {
        warning_1.default(false, '`children` of ResizeObserver is empty. Nothing is in observe.');
        return null;
      }

      var childNode = childNodes[0];

      if (React.isValidElement(childNode) && util_1.supportRef(childNode)) {
        var ref = childNode.ref;
        childNodes[0] = React.cloneElement(childNode, {
          ref: ref_1.composeRef(ref, this.setChildNode)
        });
      }

      return childNodes.length === 1 ? childNodes[0] : childNodes.map(function (node, index) {
        if (!React.isValidElement(node) || 'key' in node && node.key !== null) {
          return node;
        }

        return React.cloneElement(node, {
          key: "".concat(INTERNAL_PREFIX_KEY, "-").concat(index)
        });
      });
    }
  }]);

  return ReactResizeObserver;
}(React.Component);

ReactResizeObserver.displayName = 'ResizeObserver';
exports.default = ReactResizeObserver;

/***/ }),

/***/ "9rO7":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAAXNSR0IArs4c6QAAA9JJREFUaEPdmstvG1UUxr/PiSE0pQ8okUD5A9ixY8HCdlERSkIRSLSilQC1FRQEjfBMhVAWxSxQJFSPUSgSiZAqJCiPdkEpJIICtUdiw45l94FKgZZXDaV25kPX2JNJyWNm7MhjvBv5HN/vd8+Ze86910SPf9jj+rEMIDelYdXwuogchDsTBUdcolBmGi+Vxznf0uYDGPFeHd9DuC1Rwm8UQ1xJ9eOeFoQPkC3qlIB9iRbfFEfgg4rN/ebRB8g4+jGQNmOuzdkkwewsaWzRw2cNTcQl1+JdywGKUkuwazORL3dmBY1LEfi/AmQdnZMwFky3MKlFoC7iHdfic2Hsw9jEikC2pJo89IcZYCWbwTQG5sb5d1z/oF88AEdVCZuiCkhOBBz9LOH2ZQDEd4P9eGBunL9HBWvHPm4ElgAIQc2ll/h2YAce/PJJVtsRFcW3bQACtojjLQgS5S2DGDt3mH9GERLXtm2A9M3YUa9hvzxM+b0I8RW3Y3f5AK/FFRbWryMAX7/AyxlHNoTjAYi5oWE8cnovr4cVE8euYwBm8KyjCQmv+UKIs3cPYs/MYdbiiAvj01EAM2CuqIIHvBKIxJmhYTx+ei8XwwiKatNxACMg42gSwssBiFM783iiQHpRBa5nvyEAjXQqqijACqTTu5U8DpD0G8T1xIX5fsMAGpEo6gSA5wNCOt6SbyiAJOZKmJbwtIHoS+GhC3l+HmZmw9rEAghudLZtw5ZPD/GP1QY0EPe/gdFFD6pYmEtECuVKOup5OAbi/U62xmFnPWgXKwJxBmrXJ+toBsA+AQXXYrH1e10DMKmVdTDSlwK/eRGza6XWrmltvX4VvxrRJH6oWBzuOkBwQ05ippzHs6tBjEzpjmoNCw3RxE+uxaGuA2SKGgWwtCIRJ1yLR1ZKtUQCNFKohJMQnvIrNuBUbNo3QiQSwIgsSKkLDt4LHp4xhclKnhNBiMQCGJF7Plbfwjw+lPBYS3QKeLVss9B6TjSAEfnMtNIXr+KMgIcD6TRRsTlpnhMP0IzETQvz+ETCiA+Rgl3J0+kJACM6d1ID+gXm0GyXn07EkVv68VHiltHVKvPuaW36rYpZCNnmui8SR+Xh3+qblDqwVmuRe0ubvWv4AsB9LYjA0U0yCpkRZmrBaiCjb+LWah3nIdy7zCYJEWg2Zgcl9EVu8oiqa3Fz11oJ86J6V/BXZOFLDnXXZrprAGbgTElvQzgIRD/hJnG2kuejXQVoY/b/49q1/UCnINYGCFzybcSGvF2IdS/5ev6atecvuhv9SS//1aDdHO2WfyIvtKNMxj/M1ulPpko7RQAAAABJRU5ErkJggg=="

/***/ }),

/***/ "A+AJ":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__("GiK3");
var react_default = /*#__PURE__*/__webpack_require__.n(react);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__("KSGD");
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);

// EXTERNAL MODULE: ./node_modules/react-lifecycles-compat/react-lifecycles-compat.es.js
var react_lifecycles_compat_es = __webpack_require__("R8mX");

// EXTERNAL MODULE: ./node_modules/antd/node_modules/classnames/index.js
var classnames = __webpack_require__("kTQ8");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: ./node_modules/omit.js/es/index.js
var es = __webpack_require__("JkBm");

// EXTERNAL MODULE: ./node_modules/antd/es/_util/type.js
var type = __webpack_require__("D+5j");

// EXTERNAL MODULE: ./node_modules/antd/es/icon/index.js + 5 modules
var es_icon = __webpack_require__("FC3+");

// CONCATENATED MODULE: ./node_modules/antd/es/input/ClearableLabeledInput.js
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }







var ClearableInputType = Object(type["a" /* tuple */])('text', 'input');
function hasPrefixSuffix(props) {
  return !!(props.prefix || props.suffix || props.allowClear);
}

var ClearableLabeledInput_ClearableLabeledInput = /*#__PURE__*/function (_React$Component) {
  _inherits(ClearableLabeledInput, _React$Component);

  var _super = _createSuper(ClearableLabeledInput);

  function ClearableLabeledInput() {
    _classCallCheck(this, ClearableLabeledInput);

    return _super.apply(this, arguments);
  }

  _createClass(ClearableLabeledInput, [{
    key: "renderClearIcon",
    value: function renderClearIcon(prefixCls) {
      var _this$props = this.props,
          allowClear = _this$props.allowClear,
          value = _this$props.value,
          disabled = _this$props.disabled,
          readOnly = _this$props.readOnly,
          inputType = _this$props.inputType,
          handleReset = _this$props.handleReset;

      if (!allowClear || disabled || readOnly || value === undefined || value === null || value === '') {
        return null;
      }

      var className = inputType === ClearableInputType[0] ? "".concat(prefixCls, "-textarea-clear-icon") : "".concat(prefixCls, "-clear-icon");
      return /*#__PURE__*/react["createElement"](es_icon["default"], {
        type: "close-circle",
        theme: "filled",
        onClick: handleReset,
        className: className,
        role: "button"
      });
    }
  }, {
    key: "renderSuffix",
    value: function renderSuffix(prefixCls) {
      var _this$props2 = this.props,
          suffix = _this$props2.suffix,
          allowClear = _this$props2.allowClear;

      if (suffix || allowClear) {
        return /*#__PURE__*/react["createElement"]("span", {
          className: "".concat(prefixCls, "-suffix")
        }, this.renderClearIcon(prefixCls), suffix);
      }

      return null;
    }
  }, {
    key: "renderLabeledIcon",
    value: function renderLabeledIcon(prefixCls, element) {
      var _classNames;

      var props = this.props;
      var suffix = this.renderSuffix(prefixCls);

      if (!hasPrefixSuffix(props)) {
        return /*#__PURE__*/react["cloneElement"](element, {
          value: props.value
        });
      }

      var prefix = props.prefix ? /*#__PURE__*/react["createElement"]("span", {
        className: "".concat(prefixCls, "-prefix")
      }, props.prefix) : null;
      var affixWrapperCls = classnames_default()(props.className, "".concat(prefixCls, "-affix-wrapper"), (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-affix-wrapper-sm"), props.size === 'small'), _defineProperty(_classNames, "".concat(prefixCls, "-affix-wrapper-lg"), props.size === 'large'), _defineProperty(_classNames, "".concat(prefixCls, "-affix-wrapper-input-with-clear-btn"), props.suffix && props.allowClear && this.props.value), _classNames));
      return /*#__PURE__*/react["createElement"]("span", {
        className: affixWrapperCls,
        style: props.style
      }, prefix, /*#__PURE__*/react["cloneElement"](element, {
        style: null,
        value: props.value,
        className: getInputClassName(prefixCls, props.size, props.disabled)
      }), suffix);
    }
  }, {
    key: "renderInputWithLabel",
    value: function renderInputWithLabel(prefixCls, labeledElement) {
      var _classNames3;

      var _this$props3 = this.props,
          addonBefore = _this$props3.addonBefore,
          addonAfter = _this$props3.addonAfter,
          style = _this$props3.style,
          size = _this$props3.size,
          className = _this$props3.className; // Not wrap when there is not addons

      if (!addonBefore && !addonAfter) {
        return labeledElement;
      }

      var wrapperClassName = "".concat(prefixCls, "-group");
      var addonClassName = "".concat(wrapperClassName, "-addon");
      var addonBeforeNode = addonBefore ? /*#__PURE__*/react["createElement"]("span", {
        className: addonClassName
      }, addonBefore) : null;
      var addonAfterNode = addonAfter ? /*#__PURE__*/react["createElement"]("span", {
        className: addonClassName
      }, addonAfter) : null;
      var mergedWrapperClassName = classnames_default()("".concat(prefixCls, "-wrapper"), _defineProperty({}, wrapperClassName, addonBefore || addonAfter));
      var mergedGroupClassName = classnames_default()(className, "".concat(prefixCls, "-group-wrapper"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefixCls, "-group-wrapper-sm"), size === 'small'), _defineProperty(_classNames3, "".concat(prefixCls, "-group-wrapper-lg"), size === 'large'), _classNames3)); // Need another wrapper for changing display:table to display:inline-block
      // and put style prop in wrapper

      return /*#__PURE__*/react["createElement"]("span", {
        className: mergedGroupClassName,
        style: style
      }, /*#__PURE__*/react["createElement"]("span", {
        className: mergedWrapperClassName
      }, addonBeforeNode, /*#__PURE__*/react["cloneElement"](labeledElement, {
        style: null
      }), addonAfterNode));
    }
  }, {
    key: "renderTextAreaWithClearIcon",
    value: function renderTextAreaWithClearIcon(prefixCls, element) {
      var _this$props4 = this.props,
          value = _this$props4.value,
          allowClear = _this$props4.allowClear,
          className = _this$props4.className,
          style = _this$props4.style;

      if (!allowClear) {
        return /*#__PURE__*/react["cloneElement"](element, {
          value: value
        });
      }

      var affixWrapperCls = classnames_default()(className, "".concat(prefixCls, "-affix-wrapper"), "".concat(prefixCls, "-affix-wrapper-textarea-with-clear-btn"));
      return /*#__PURE__*/react["createElement"]("span", {
        className: affixWrapperCls,
        style: style
      }, /*#__PURE__*/react["cloneElement"](element, {
        style: null,
        value: value
      }), this.renderClearIcon(prefixCls));
    }
  }, {
    key: "renderClearableLabeledInput",
    value: function renderClearableLabeledInput() {
      var _this$props5 = this.props,
          prefixCls = _this$props5.prefixCls,
          inputType = _this$props5.inputType,
          element = _this$props5.element;

      if (inputType === ClearableInputType[0]) {
        return this.renderTextAreaWithClearIcon(prefixCls, element);
      }

      return this.renderInputWithLabel(prefixCls, this.renderLabeledIcon(prefixCls, element));
    }
  }, {
    key: "render",
    value: function render() {
      return this.renderClearableLabeledInput();
    }
  }]);

  return ClearableLabeledInput;
}(react["Component"]);

Object(react_lifecycles_compat_es["polyfill"])(ClearableLabeledInput_ClearableLabeledInput);
/* harmony default export */ var input_ClearableLabeledInput = (ClearableLabeledInput_ClearableLabeledInput);
// EXTERNAL MODULE: ./node_modules/antd/es/config-provider/index.js + 1 modules
var config_provider = __webpack_require__("PmSq");

// EXTERNAL MODULE: ./node_modules/antd/es/_util/warning.js
var warning = __webpack_require__("qGip");

// CONCATENATED MODULE: ./node_modules/antd/es/input/Input.js
function Input__typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Input__typeof = function _typeof(obj) { return typeof obj; }; } else { Input__typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Input__typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function Input__classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Input__defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Input__createClass(Constructor, protoProps, staticProps) { if (protoProps) Input__defineProperties(Constructor.prototype, protoProps); if (staticProps) Input__defineProperties(Constructor, staticProps); return Constructor; }

function Input__inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) Input__setPrototypeOf(subClass, superClass); }

function Input__setPrototypeOf(o, p) { Input__setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return Input__setPrototypeOf(o, p); }

function Input__createSuper(Derived) { var hasNativeReflectConstruct = Input__isNativeReflectConstruct(); return function _createSuperInternal() { var Super = Input__getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = Input__getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return Input__possibleConstructorReturn(this, result); }; }

function Input__possibleConstructorReturn(self, call) { if (call && (Input__typeof(call) === "object" || typeof call === "function")) { return call; } return Input__assertThisInitialized(self); }

function Input__assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function Input__isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function Input__getPrototypeOf(o) { Input__getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return Input__getPrototypeOf(o); }

function Input__defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










var InputSizes = Object(type["a" /* tuple */])('small', 'default', 'large');
function fixControlledValue(value) {
  if (typeof value === 'undefined' || value === null) {
    return '';
  }

  return value;
}
function resolveOnChange(target, e, onChange) {
  if (onChange) {
    var event = e;

    if (e.type === 'click') {
      // click clear icon
      event = Object.create(e);
      event.target = target;
      event.currentTarget = target;
      var originalInputValue = target.value; // change target ref value cause e.target.value should be '' when clear input

      target.value = '';
      onChange(event); // reset target ref value

      target.value = originalInputValue;
      return;
    }

    onChange(event);
  }
}
function getInputClassName(prefixCls, size, disabled) {
  var _classNames;

  return classnames_default()(prefixCls, (_classNames = {}, Input__defineProperty(_classNames, "".concat(prefixCls, "-sm"), size === 'small'), Input__defineProperty(_classNames, "".concat(prefixCls, "-lg"), size === 'large'), Input__defineProperty(_classNames, "".concat(prefixCls, "-disabled"), disabled), _classNames));
}

var Input_Input = /*#__PURE__*/function (_React$Component) {
  Input__inherits(Input, _React$Component);

  var _super = Input__createSuper(Input);

  function Input(props) {
    var _this;

    Input__classCallCheck(this, Input);

    _this = _super.call(this, props);

    _this.saveClearableInput = function (input) {
      _this.clearableInput = input;
    };

    _this.saveInput = function (input) {
      _this.input = input;
    };

    _this.handleReset = function (e) {
      _this.setValue('', function () {
        _this.focus();
      });

      resolveOnChange(_this.input, e, _this.props.onChange);
    };

    _this.renderInput = function (prefixCls) {
      var _this$props = _this.props,
          className = _this$props.className,
          addonBefore = _this$props.addonBefore,
          addonAfter = _this$props.addonAfter,
          size = _this$props.size,
          disabled = _this$props.disabled; // Fix https://fb.me/react-unknown-prop

      var otherProps = Object(es["a" /* default */])(_this.props, ['prefixCls', 'onPressEnter', 'addonBefore', 'addonAfter', 'prefix', 'suffix', 'allowClear', // Input elements must be either controlled or uncontrolled,
      // specify either the value prop, or the defaultValue prop, but not both.
      'defaultValue', 'size', 'inputType']);
      return /*#__PURE__*/react["createElement"]("input", _extends({}, otherProps, {
        onChange: _this.handleChange,
        onKeyDown: _this.handleKeyDown,
        className: classnames_default()(getInputClassName(prefixCls, size, disabled), Input__defineProperty({}, className, className && !addonBefore && !addonAfter)),
        ref: _this.saveInput
      }));
    };

    _this.clearPasswordValueAttribute = function () {
      // https://github.com/ant-design/ant-design/issues/20541
      _this.removePasswordTimeout = setTimeout(function () {
        if (_this.input && _this.input.getAttribute('type') === 'password' && _this.input.hasAttribute('value')) {
          _this.input.removeAttribute('value');
        }
      });
    };

    _this.handleChange = function (e) {
      _this.setValue(e.target.value, _this.clearPasswordValueAttribute);

      resolveOnChange(_this.input, e, _this.props.onChange);
    };

    _this.handleKeyDown = function (e) {
      var _this$props2 = _this.props,
          onPressEnter = _this$props2.onPressEnter,
          onKeyDown = _this$props2.onKeyDown;

      if (e.keyCode === 13 && onPressEnter) {
        onPressEnter(e);
      }

      if (onKeyDown) {
        onKeyDown(e);
      }
    };

    _this.renderComponent = function (_ref) {
      var getPrefixCls = _ref.getPrefixCls;
      var value = _this.state.value;
      var customizePrefixCls = _this.props.prefixCls;
      var prefixCls = getPrefixCls('input', customizePrefixCls);
      return /*#__PURE__*/react["createElement"](input_ClearableLabeledInput, _extends({}, _this.props, {
        prefixCls: prefixCls,
        inputType: "input",
        value: fixControlledValue(value),
        element: _this.renderInput(prefixCls),
        handleReset: _this.handleReset,
        ref: _this.saveClearableInput
      }));
    };

    var value = typeof props.value === 'undefined' ? props.defaultValue : props.value;
    _this.state = {
      value: value
    };
    return _this;
  }

  Input__createClass(Input, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.clearPasswordValueAttribute();
    } // Since polyfill `getSnapshotBeforeUpdate` need work with `componentDidUpdate`.
    // We keep an empty function here.

  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {}
  }, {
    key: "getSnapshotBeforeUpdate",
    value: function getSnapshotBeforeUpdate(prevProps) {
      if (hasPrefixSuffix(prevProps) !== hasPrefixSuffix(this.props)) {
        Object(warning["a" /* default */])(this.input !== document.activeElement, 'Input', "When Input is focused, dynamic add or remove prefix / suffix will make it lose focus caused by dom structure change. Read more: https://ant.design/components/input/#FAQ");
      }

      return null;
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.removePasswordTimeout) {
        clearTimeout(this.removePasswordTimeout);
      }
    }
  }, {
    key: "focus",
    value: function focus() {
      this.input.focus();
    }
  }, {
    key: "blur",
    value: function blur() {
      this.input.blur();
    }
  }, {
    key: "select",
    value: function select() {
      this.input.select();
    }
  }, {
    key: "setValue",
    value: function setValue(value, callback) {
      if (!('value' in this.props)) {
        this.setState({
          value: value
        }, callback);
      }
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/react["createElement"](config_provider["ConfigConsumer"], null, this.renderComponent);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps) {
      if ('value' in nextProps) {
        return {
          value: nextProps.value
        };
      }

      return null;
    }
  }]);

  return Input;
}(react["Component"]);

Input_Input.defaultProps = {
  type: 'text'
};
Input_Input.propTypes = {
  type: prop_types["string"],
  id: prop_types["string"],
  size: prop_types["oneOf"](InputSizes),
  maxLength: prop_types["number"],
  disabled: prop_types["bool"],
  value: prop_types["any"],
  defaultValue: prop_types["any"],
  className: prop_types["string"],
  addonBefore: prop_types["node"],
  addonAfter: prop_types["node"],
  prefixCls: prop_types["string"],
  onPressEnter: prop_types["func"],
  onKeyDown: prop_types["func"],
  onKeyUp: prop_types["func"],
  onFocus: prop_types["func"],
  onBlur: prop_types["func"],
  prefix: prop_types["node"],
  suffix: prop_types["node"],
  allowClear: prop_types["bool"]
};
Object(react_lifecycles_compat_es["polyfill"])(Input_Input);
/* harmony default export */ var input_Input = (Input_Input);
// CONCATENATED MODULE: ./node_modules/antd/es/input/Group.js
function Group__defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





var Group_Group = function Group(props) {
  return /*#__PURE__*/react["createElement"](config_provider["ConfigConsumer"], null, function (_ref) {
    var _classNames;

    var getPrefixCls = _ref.getPrefixCls;
    var customizePrefixCls = props.prefixCls,
        _props$className = props.className,
        className = _props$className === void 0 ? '' : _props$className;
    var prefixCls = getPrefixCls('input-group', customizePrefixCls);
    var cls = classnames_default()(prefixCls, (_classNames = {}, Group__defineProperty(_classNames, "".concat(prefixCls, "-lg"), props.size === 'large'), Group__defineProperty(_classNames, "".concat(prefixCls, "-sm"), props.size === 'small'), Group__defineProperty(_classNames, "".concat(prefixCls, "-compact"), props.compact), _classNames), className);
    return /*#__PURE__*/react["createElement"]("span", {
      className: cls,
      style: props.style,
      onMouseEnter: props.onMouseEnter,
      onMouseLeave: props.onMouseLeave,
      onFocus: props.onFocus,
      onBlur: props.onBlur
    }, props.children);
  });
};

/* harmony default export */ var input_Group = (Group_Group);
// EXTERNAL MODULE: ./node_modules/is-mobile/index.js
var is_mobile = __webpack_require__("6VvU");
var is_mobile_default = /*#__PURE__*/__webpack_require__.n(is_mobile);

// EXTERNAL MODULE: ./node_modules/antd/es/button/index.js + 2 modules
var es_button = __webpack_require__("zwGx");

// CONCATENATED MODULE: ./node_modules/antd/es/input/Search.js
function Search__typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Search__typeof = function _typeof(obj) { return typeof obj; }; } else { Search__typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Search__typeof(obj); }

function Search__defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function Search__extends() { Search__extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return Search__extends.apply(this, arguments); }

function Search__classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Search__defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Search__createClass(Constructor, protoProps, staticProps) { if (protoProps) Search__defineProperties(Constructor.prototype, protoProps); if (staticProps) Search__defineProperties(Constructor, staticProps); return Constructor; }

function Search__inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) Search__setPrototypeOf(subClass, superClass); }

function Search__setPrototypeOf(o, p) { Search__setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return Search__setPrototypeOf(o, p); }

function Search__createSuper(Derived) { var hasNativeReflectConstruct = Search__isNativeReflectConstruct(); return function _createSuperInternal() { var Super = Search__getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = Search__getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return Search__possibleConstructorReturn(this, result); }; }

function Search__possibleConstructorReturn(self, call) { if (call && (Search__typeof(call) === "object" || typeof call === "function")) { return call; } return Search__assertThisInitialized(self); }

function Search__assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function Search__isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function Search__getPrototypeOf(o) { Search__getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return Search__getPrototypeOf(o); }

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};









var Search_Search = /*#__PURE__*/function (_React$Component) {
  Search__inherits(Search, _React$Component);

  var _super = Search__createSuper(Search);

  function Search() {
    var _this;

    Search__classCallCheck(this, Search);

    _this = _super.apply(this, arguments);

    _this.saveInput = function (node) {
      _this.input = node;
    };

    _this.onChange = function (e) {
      var _this$props = _this.props,
          onChange = _this$props.onChange,
          onSearch = _this$props.onSearch;

      if (e && e.target && e.type === 'click' && onSearch) {
        onSearch(e.target.value, e);
      }

      if (onChange) {
        onChange(e);
      }
    };

    _this.onSearch = function (e) {
      var _this$props2 = _this.props,
          onSearch = _this$props2.onSearch,
          loading = _this$props2.loading,
          disabled = _this$props2.disabled;

      if (loading || disabled) {
        return;
      }

      if (onSearch) {
        onSearch(_this.input.input.value, e);
      }

      if (!Object(is_mobile["isMobile"])({
        tablet: true
      })) {
        _this.input.focus();
      }
    };

    _this.renderLoading = function (prefixCls) {
      var _this$props3 = _this.props,
          enterButton = _this$props3.enterButton,
          size = _this$props3.size;

      if (enterButton) {
        return /*#__PURE__*/react["createElement"](es_button["default"], {
          className: "".concat(prefixCls, "-button"),
          type: "primary",
          size: size,
          key: "enterButton"
        }, /*#__PURE__*/react["createElement"](es_icon["default"], {
          type: "loading"
        }));
      }

      return /*#__PURE__*/react["createElement"](es_icon["default"], {
        className: "".concat(prefixCls, "-icon"),
        type: "loading",
        key: "loadingIcon"
      });
    };

    _this.renderSuffix = function (prefixCls) {
      var _this$props4 = _this.props,
          suffix = _this$props4.suffix,
          enterButton = _this$props4.enterButton,
          loading = _this$props4.loading;

      if (loading && !enterButton) {
        return [suffix, _this.renderLoading(prefixCls)];
      }

      if (enterButton) return suffix;
      var icon = /*#__PURE__*/react["createElement"](es_icon["default"], {
        className: "".concat(prefixCls, "-icon"),
        type: "search",
        key: "searchIcon",
        onClick: _this.onSearch
      });

      if (suffix) {
        return [/*#__PURE__*/react["isValidElement"](suffix) ? /*#__PURE__*/react["cloneElement"](suffix, {
          key: 'suffix'
        }) : null, icon];
      }

      return icon;
    };

    _this.renderAddonAfter = function (prefixCls) {
      var _this$props5 = _this.props,
          enterButton = _this$props5.enterButton,
          size = _this$props5.size,
          disabled = _this$props5.disabled,
          addonAfter = _this$props5.addonAfter,
          loading = _this$props5.loading;
      var btnClassName = "".concat(prefixCls, "-button");

      if (loading && enterButton) {
        return [_this.renderLoading(prefixCls), addonAfter];
      }

      if (!enterButton) return addonAfter;
      var button;
      var enterButtonAsElement = enterButton;
      var isAntdButton = enterButtonAsElement.type && enterButtonAsElement.type.__ANT_BUTTON === true;

      if (isAntdButton || enterButtonAsElement.type === 'button') {
        button = /*#__PURE__*/react["cloneElement"](enterButtonAsElement, Search__extends({
          onClick: _this.onSearch,
          key: 'enterButton'
        }, isAntdButton ? {
          className: btnClassName,
          size: size
        } : {}));
      } else {
        button = /*#__PURE__*/react["createElement"](es_button["default"], {
          className: btnClassName,
          type: "primary",
          size: size,
          disabled: disabled,
          key: "enterButton",
          onClick: _this.onSearch
        }, enterButton === true ? /*#__PURE__*/react["createElement"](es_icon["default"], {
          type: "search"
        }) : enterButton);
      }

      if (addonAfter) {
        return [button, /*#__PURE__*/react["isValidElement"](addonAfter) ? /*#__PURE__*/react["cloneElement"](addonAfter, {
          key: 'addonAfter'
        }) : null];
      }

      return button;
    };

    _this.renderSearch = function (_ref) {
      var getPrefixCls = _ref.getPrefixCls;

      var _a = _this.props,
          customizePrefixCls = _a.prefixCls,
          customizeInputPrefixCls = _a.inputPrefixCls,
          size = _a.size,
          enterButton = _a.enterButton,
          className = _a.className,
          restProps = __rest(_a, ["prefixCls", "inputPrefixCls", "size", "enterButton", "className"]);

      delete restProps.onSearch;
      delete restProps.loading;
      var prefixCls = getPrefixCls('input-search', customizePrefixCls);
      var inputPrefixCls = getPrefixCls('input', customizeInputPrefixCls);
      var inputClassName;

      if (enterButton) {
        var _classNames;

        inputClassName = classnames_default()(prefixCls, className, (_classNames = {}, Search__defineProperty(_classNames, "".concat(prefixCls, "-enter-button"), !!enterButton), Search__defineProperty(_classNames, "".concat(prefixCls, "-").concat(size), !!size), _classNames));
      } else {
        inputClassName = classnames_default()(prefixCls, className);
      }

      return /*#__PURE__*/react["createElement"](input_Input, Search__extends({
        onPressEnter: _this.onSearch
      }, restProps, {
        size: size,
        prefixCls: inputPrefixCls,
        addonAfter: _this.renderAddonAfter(prefixCls),
        suffix: _this.renderSuffix(prefixCls),
        onChange: _this.onChange,
        ref: _this.saveInput,
        className: inputClassName
      }));
    };

    return _this;
  }

  Search__createClass(Search, [{
    key: "focus",
    value: function focus() {
      this.input.focus();
    }
  }, {
    key: "blur",
    value: function blur() {
      this.input.blur();
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/react["createElement"](config_provider["ConfigConsumer"], null, this.renderSearch);
    }
  }]);

  return Search;
}(react["Component"]);


Search_Search.defaultProps = {
  enterButton: false
};
// EXTERNAL MODULE: ./node_modules/rc-resize-observer/es/index.js
var rc_resize_observer_es = __webpack_require__("9oFX");
var es_default = /*#__PURE__*/__webpack_require__.n(rc_resize_observer_es);

// CONCATENATED MODULE: ./node_modules/antd/es/input/calculateNodeHeight.js
// Thanks to https://github.com/andreypopp/react-textarea-autosize/

/**
 * calculateNodeHeight(uiTextNode, useCache = false)
 */
var HIDDEN_TEXTAREA_STYLE = "\n  min-height:0 !important;\n  max-height:none !important;\n  height:0 !important;\n  visibility:hidden !important;\n  overflow:hidden !important;\n  position:absolute !important;\n  z-index:-1000 !important;\n  top:0 !important;\n  right:0 !important\n";
var SIZING_STYLE = ['letter-spacing', 'line-height', 'padding-top', 'padding-bottom', 'font-family', 'font-weight', 'font-size', 'font-variant', 'text-rendering', 'text-transform', 'width', 'text-indent', 'padding-left', 'padding-right', 'border-width', 'box-sizing'];
var computedStyleCache = {};
var hiddenTextarea;
function calculateNodeStyling(node) {
  var useCache = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var nodeRef = node.getAttribute('id') || node.getAttribute('data-reactid') || node.getAttribute('name');

  if (useCache && computedStyleCache[nodeRef]) {
    return computedStyleCache[nodeRef];
  }

  var style = window.getComputedStyle(node);
  var boxSizing = style.getPropertyValue('box-sizing') || style.getPropertyValue('-moz-box-sizing') || style.getPropertyValue('-webkit-box-sizing');
  var paddingSize = parseFloat(style.getPropertyValue('padding-bottom')) + parseFloat(style.getPropertyValue('padding-top'));
  var borderSize = parseFloat(style.getPropertyValue('border-bottom-width')) + parseFloat(style.getPropertyValue('border-top-width'));
  var sizingStyle = SIZING_STYLE.map(function (name) {
    return "".concat(name, ":").concat(style.getPropertyValue(name));
  }).join(';');
  var nodeInfo = {
    sizingStyle: sizingStyle,
    paddingSize: paddingSize,
    borderSize: borderSize,
    boxSizing: boxSizing
  };

  if (useCache && nodeRef) {
    computedStyleCache[nodeRef] = nodeInfo;
  }

  return nodeInfo;
}
function calculateNodeHeight(uiTextNode) {
  var useCache = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var minRows = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  var maxRows = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

  if (!hiddenTextarea) {
    hiddenTextarea = document.createElement('textarea');
    document.body.appendChild(hiddenTextarea);
  } // Fix wrap="off" issue
  // https://github.com/ant-design/ant-design/issues/6577


  if (uiTextNode.getAttribute('wrap')) {
    hiddenTextarea.setAttribute('wrap', uiTextNode.getAttribute('wrap'));
  } else {
    hiddenTextarea.removeAttribute('wrap');
  } // Copy all CSS properties that have an impact on the height of the content in
  // the textbox


  var _calculateNodeStyling = calculateNodeStyling(uiTextNode, useCache),
      paddingSize = _calculateNodeStyling.paddingSize,
      borderSize = _calculateNodeStyling.borderSize,
      boxSizing = _calculateNodeStyling.boxSizing,
      sizingStyle = _calculateNodeStyling.sizingStyle; // Need to have the overflow attribute to hide the scrollbar otherwise
  // text-lines will not calculated properly as the shadow will technically be
  // narrower for content


  hiddenTextarea.setAttribute('style', "".concat(sizingStyle, ";").concat(HIDDEN_TEXTAREA_STYLE));
  hiddenTextarea.value = uiTextNode.value || uiTextNode.placeholder || '';
  var minHeight = Number.MIN_SAFE_INTEGER;
  var maxHeight = Number.MAX_SAFE_INTEGER;
  var height = hiddenTextarea.scrollHeight;
  var overflowY;

  if (boxSizing === 'border-box') {
    // border-box: add border, since height = content + padding + border
    height += borderSize;
  } else if (boxSizing === 'content-box') {
    // remove padding, since height = content
    height -= paddingSize;
  }

  if (minRows !== null || maxRows !== null) {
    // measure height of a textarea with a single row
    hiddenTextarea.value = ' ';
    var singleRowHeight = hiddenTextarea.scrollHeight - paddingSize;

    if (minRows !== null) {
      minHeight = singleRowHeight * minRows;

      if (boxSizing === 'border-box') {
        minHeight = minHeight + paddingSize + borderSize;
      }

      height = Math.max(minHeight, height);
    }

    if (maxRows !== null) {
      maxHeight = singleRowHeight * maxRows;

      if (boxSizing === 'border-box') {
        maxHeight = maxHeight + paddingSize + borderSize;
      }

      overflowY = height > maxHeight ? '' : 'hidden';
      height = Math.min(maxHeight, height);
    }
  }

  return {
    height: height,
    minHeight: minHeight,
    maxHeight: maxHeight,
    overflowY: overflowY
  };
}
// EXTERNAL MODULE: ./node_modules/antd/es/_util/raf.js
var raf = __webpack_require__("1wHS");

// CONCATENATED MODULE: ./node_modules/antd/es/input/ResizableTextArea.js
function ResizableTextArea__typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ResizableTextArea__typeof = function _typeof(obj) { return typeof obj; }; } else { ResizableTextArea__typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ResizableTextArea__typeof(obj); }

function ResizableTextArea__extends() { ResizableTextArea__extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return ResizableTextArea__extends.apply(this, arguments); }

function ResizableTextArea__defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function ResizableTextArea__classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ResizableTextArea__defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ResizableTextArea__createClass(Constructor, protoProps, staticProps) { if (protoProps) ResizableTextArea__defineProperties(Constructor.prototype, protoProps); if (staticProps) ResizableTextArea__defineProperties(Constructor, staticProps); return Constructor; }

function ResizableTextArea__inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) ResizableTextArea__setPrototypeOf(subClass, superClass); }

function ResizableTextArea__setPrototypeOf(o, p) { ResizableTextArea__setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return ResizableTextArea__setPrototypeOf(o, p); }

function ResizableTextArea__createSuper(Derived) { var hasNativeReflectConstruct = ResizableTextArea__isNativeReflectConstruct(); return function _createSuperInternal() { var Super = ResizableTextArea__getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = ResizableTextArea__getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return ResizableTextArea__possibleConstructorReturn(this, result); }; }

function ResizableTextArea__possibleConstructorReturn(self, call) { if (call && (ResizableTextArea__typeof(call) === "object" || typeof call === "function")) { return call; } return ResizableTextArea__assertThisInitialized(self); }

function ResizableTextArea__assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function ResizableTextArea__isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function ResizableTextArea__getPrototypeOf(o) { ResizableTextArea__getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return ResizableTextArea__getPrototypeOf(o); }










var ResizableTextArea_ResizableTextArea = /*#__PURE__*/function (_React$Component) {
  ResizableTextArea__inherits(ResizableTextArea, _React$Component);

  var _super = ResizableTextArea__createSuper(ResizableTextArea);

  function ResizableTextArea(props) {
    var _this;

    ResizableTextArea__classCallCheck(this, ResizableTextArea);

    _this = _super.call(this, props);

    _this.saveTextArea = function (textArea) {
      _this.textArea = textArea;
    };

    _this.resizeOnNextFrame = function () {
      raf["a" /* default */].cancel(_this.nextFrameActionId);
      _this.nextFrameActionId = Object(raf["a" /* default */])(_this.resizeTextarea);
    };

    _this.resizeTextarea = function () {
      var autoSize = _this.props.autoSize || _this.props.autosize;

      if (!autoSize || !_this.textArea) {
        return;
      }

      var minRows = autoSize.minRows,
          maxRows = autoSize.maxRows;
      var textareaStyles = calculateNodeHeight(_this.textArea, false, minRows, maxRows);

      _this.setState({
        textareaStyles: textareaStyles,
        resizing: true
      }, function () {
        raf["a" /* default */].cancel(_this.resizeFrameId);
        _this.resizeFrameId = Object(raf["a" /* default */])(function () {
          _this.setState({
            resizing: false
          });

          _this.fixFirefoxAutoScroll();
        });
      });
    };

    _this.renderTextArea = function () {
      var _this$props = _this.props,
          prefixCls = _this$props.prefixCls,
          autoSize = _this$props.autoSize,
          autosize = _this$props.autosize,
          className = _this$props.className,
          disabled = _this$props.disabled;
      var _this$state = _this.state,
          textareaStyles = _this$state.textareaStyles,
          resizing = _this$state.resizing;
      Object(warning["a" /* default */])(autosize === undefined, 'Input.TextArea', 'autosize is deprecated, please use autoSize instead.');
      var otherProps = Object(es["a" /* default */])(_this.props, ['prefixCls', 'onPressEnter', 'autoSize', 'autosize', 'defaultValue', 'allowClear']);
      var cls = classnames_default()(prefixCls, className, ResizableTextArea__defineProperty({}, "".concat(prefixCls, "-disabled"), disabled)); // Fix https://github.com/ant-design/ant-design/issues/6776
      // Make sure it could be reset when using form.getFieldDecorator

      if ('value' in otherProps) {
        otherProps.value = otherProps.value || '';
      }

      var style = ResizableTextArea__extends(ResizableTextArea__extends(ResizableTextArea__extends({}, _this.props.style), textareaStyles), resizing ? {
        overflowX: 'hidden',
        overflowY: 'hidden'
      } : null);

      return /*#__PURE__*/react["createElement"](es_default.a, {
        onResize: _this.resizeOnNextFrame,
        disabled: !(autoSize || autosize)
      }, /*#__PURE__*/react["createElement"]("textarea", ResizableTextArea__extends({}, otherProps, {
        className: cls,
        style: style,
        ref: _this.saveTextArea
      })));
    };

    _this.state = {
      textareaStyles: {},
      resizing: false
    };
    return _this;
  }

  ResizableTextArea__createClass(ResizableTextArea, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.resizeTextarea();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      // Re-render with the new content then recalculate the height as required.
      if (prevProps.value !== this.props.value) {
        this.resizeTextarea();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      raf["a" /* default */].cancel(this.nextFrameActionId);
      raf["a" /* default */].cancel(this.resizeFrameId);
    } // https://github.com/ant-design/ant-design/issues/21870

  }, {
    key: "fixFirefoxAutoScroll",
    value: function fixFirefoxAutoScroll() {
      try {
        if (document.activeElement === this.textArea) {
          var currentStart = this.textArea.selectionStart;
          var currentEnd = this.textArea.selectionEnd;
          this.textArea.setSelectionRange(currentStart, currentEnd);
        }
      } catch (e) {// Fix error in Chrome:
        // Failed to read the 'selectionStart' property from 'HTMLInputElement'
        // http://stackoverflow.com/q/21177489/3040605
      }
    }
  }, {
    key: "render",
    value: function render() {
      return this.renderTextArea();
    }
  }]);

  return ResizableTextArea;
}(react["Component"]);

Object(react_lifecycles_compat_es["polyfill"])(ResizableTextArea_ResizableTextArea);
/* harmony default export */ var input_ResizableTextArea = (ResizableTextArea_ResizableTextArea);
// CONCATENATED MODULE: ./node_modules/antd/es/input/TextArea.js
function TextArea__typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { TextArea__typeof = function _typeof(obj) { return typeof obj; }; } else { TextArea__typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return TextArea__typeof(obj); }

function TextArea__extends() { TextArea__extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return TextArea__extends.apply(this, arguments); }

function TextArea__classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function TextArea__defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function TextArea__createClass(Constructor, protoProps, staticProps) { if (protoProps) TextArea__defineProperties(Constructor.prototype, protoProps); if (staticProps) TextArea__defineProperties(Constructor, staticProps); return Constructor; }

function TextArea__inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) TextArea__setPrototypeOf(subClass, superClass); }

function TextArea__setPrototypeOf(o, p) { TextArea__setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return TextArea__setPrototypeOf(o, p); }

function TextArea__createSuper(Derived) { var hasNativeReflectConstruct = TextArea__isNativeReflectConstruct(); return function _createSuperInternal() { var Super = TextArea__getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = TextArea__getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return TextArea__possibleConstructorReturn(this, result); }; }

function TextArea__possibleConstructorReturn(self, call) { if (call && (TextArea__typeof(call) === "object" || typeof call === "function")) { return call; } return TextArea__assertThisInitialized(self); }

function TextArea__assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function TextArea__isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function TextArea__getPrototypeOf(o) { TextArea__getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return TextArea__getPrototypeOf(o); }








var TextArea_TextArea = /*#__PURE__*/function (_React$Component) {
  TextArea__inherits(TextArea, _React$Component);

  var _super = TextArea__createSuper(TextArea);

  function TextArea(props) {
    var _this;

    TextArea__classCallCheck(this, TextArea);

    _this = _super.call(this, props);

    _this.saveTextArea = function (resizableTextArea) {
      _this.resizableTextArea = resizableTextArea;
    };

    _this.saveClearableInput = function (clearableInput) {
      _this.clearableInput = clearableInput;
    };

    _this.handleChange = function (e) {
      _this.setValue(e.target.value, function () {
        _this.resizableTextArea.resizeTextarea();
      });

      resolveOnChange(_this.resizableTextArea.textArea, e, _this.props.onChange);
    };

    _this.handleKeyDown = function (e) {
      var _this$props = _this.props,
          onPressEnter = _this$props.onPressEnter,
          onKeyDown = _this$props.onKeyDown;

      if (e.keyCode === 13 && onPressEnter) {
        onPressEnter(e);
      }

      if (onKeyDown) {
        onKeyDown(e);
      }
    };

    _this.handleReset = function (e) {
      _this.setValue('', function () {
        _this.resizableTextArea.renderTextArea();

        _this.focus();
      });

      resolveOnChange(_this.resizableTextArea.textArea, e, _this.props.onChange);
    };

    _this.renderTextArea = function (prefixCls) {
      return /*#__PURE__*/react["createElement"](input_ResizableTextArea, TextArea__extends({}, _this.props, {
        prefixCls: prefixCls,
        onKeyDown: _this.handleKeyDown,
        onChange: _this.handleChange,
        ref: _this.saveTextArea
      }));
    };

    _this.renderComponent = function (_ref) {
      var getPrefixCls = _ref.getPrefixCls;
      var value = _this.state.value;
      var customizePrefixCls = _this.props.prefixCls;
      var prefixCls = getPrefixCls('input', customizePrefixCls);
      return /*#__PURE__*/react["createElement"](input_ClearableLabeledInput, TextArea__extends({}, _this.props, {
        prefixCls: prefixCls,
        inputType: "text",
        value: fixControlledValue(value),
        element: _this.renderTextArea(prefixCls),
        handleReset: _this.handleReset,
        ref: _this.saveClearableInput
      }));
    };

    var value = typeof props.value === 'undefined' ? props.defaultValue : props.value;
    _this.state = {
      value: value
    };
    return _this;
  }

  TextArea__createClass(TextArea, [{
    key: "setValue",
    value: function setValue(value, callback) {
      if (!('value' in this.props)) {
        this.setState({
          value: value
        }, callback);
      }
    }
  }, {
    key: "focus",
    value: function focus() {
      this.resizableTextArea.textArea.focus();
    }
  }, {
    key: "blur",
    value: function blur() {
      this.resizableTextArea.textArea.blur();
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/react["createElement"](config_provider["ConfigConsumer"], null, this.renderComponent);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps) {
      if ('value' in nextProps) {
        return {
          value: nextProps.value
        };
      }

      return null;
    }
  }]);

  return TextArea;
}(react["Component"]);

Object(react_lifecycles_compat_es["polyfill"])(TextArea_TextArea);
/* harmony default export */ var input_TextArea = (TextArea_TextArea);
// CONCATENATED MODULE: ./node_modules/antd/es/input/Password.js
function Password__typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Password__typeof = function _typeof(obj) { return typeof obj; }; } else { Password__typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Password__typeof(obj); }

function Password__extends() { Password__extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return Password__extends.apply(this, arguments); }

function Password__defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function Password__classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Password__defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Password__createClass(Constructor, protoProps, staticProps) { if (protoProps) Password__defineProperties(Constructor.prototype, protoProps); if (staticProps) Password__defineProperties(Constructor, staticProps); return Constructor; }

function Password__inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) Password__setPrototypeOf(subClass, superClass); }

function Password__setPrototypeOf(o, p) { Password__setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return Password__setPrototypeOf(o, p); }

function Password__createSuper(Derived) { var hasNativeReflectConstruct = Password__isNativeReflectConstruct(); return function _createSuperInternal() { var Super = Password__getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = Password__getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return Password__possibleConstructorReturn(this, result); }; }

function Password__possibleConstructorReturn(self, call) { if (call && (Password__typeof(call) === "object" || typeof call === "function")) { return call; } return Password__assertThisInitialized(self); }

function Password__assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function Password__isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function Password__getPrototypeOf(o) { Password__getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return Password__getPrototypeOf(o); }

var Password___rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};






var ActionMap = {
  click: 'onClick',
  hover: 'onMouseOver'
};

var Password_Password = /*#__PURE__*/function (_React$Component) {
  Password__inherits(Password, _React$Component);

  var _super = Password__createSuper(Password);

  function Password() {
    var _this;

    Password__classCallCheck(this, Password);

    _this = _super.apply(this, arguments);
    _this.state = {
      visible: false
    };

    _this.onVisibleChange = function () {
      var disabled = _this.props.disabled;

      if (disabled) {
        return;
      }

      _this.setState(function (_ref) {
        var visible = _ref.visible;
        return {
          visible: !visible
        };
      });
    };

    _this.saveInput = function (instance) {
      if (instance && instance.input) {
        _this.input = instance.input;
      }
    };

    return _this;
  }

  Password__createClass(Password, [{
    key: "getIcon",
    value: function getIcon() {
      var _iconProps;

      var _this$props = this.props,
          prefixCls = _this$props.prefixCls,
          action = _this$props.action;
      var iconTrigger = ActionMap[action] || '';
      var iconProps = (_iconProps = {}, Password__defineProperty(_iconProps, iconTrigger, this.onVisibleChange), Password__defineProperty(_iconProps, "className", "".concat(prefixCls, "-icon")), Password__defineProperty(_iconProps, "type", this.state.visible ? 'eye' : 'eye-invisible'), Password__defineProperty(_iconProps, "key", 'passwordIcon'), Password__defineProperty(_iconProps, "onMouseDown", function onMouseDown(e) {
        // Prevent focused state lost
        // https://github.com/ant-design/ant-design/issues/15173
        e.preventDefault();
      }), _iconProps);
      return /*#__PURE__*/react["createElement"](es_icon["default"], iconProps);
    }
  }, {
    key: "focus",
    value: function focus() {
      this.input.focus();
    }
  }, {
    key: "blur",
    value: function blur() {
      this.input.blur();
    }
  }, {
    key: "select",
    value: function select() {
      this.input.select();
    }
  }, {
    key: "render",
    value: function render() {
      var _a = this.props,
          className = _a.className,
          prefixCls = _a.prefixCls,
          inputPrefixCls = _a.inputPrefixCls,
          size = _a.size,
          visibilityToggle = _a.visibilityToggle,
          restProps = Password___rest(_a, ["className", "prefixCls", "inputPrefixCls", "size", "visibilityToggle"]);

      var suffixIcon = visibilityToggle && this.getIcon();
      var inputClassName = classnames_default()(prefixCls, className, Password__defineProperty({}, "".concat(prefixCls, "-").concat(size), !!size));
      return /*#__PURE__*/react["createElement"](input_Input, Password__extends({}, Object(es["a" /* default */])(restProps, ['suffix']), {
        type: this.state.visible ? 'text' : 'password',
        size: size,
        className: inputClassName,
        prefixCls: inputPrefixCls,
        suffix: suffixIcon,
        ref: this.saveInput
      }));
    }
  }]);

  return Password;
}(react["Component"]);


Password_Password.defaultProps = {
  inputPrefixCls: 'ant-input',
  prefixCls: 'ant-input-password',
  action: 'click',
  visibilityToggle: true
};
// CONCATENATED MODULE: ./node_modules/antd/es/input/index.js





input_Input.Group = input_Group;
input_Input.Search = Search_Search;
input_Input.TextArea = input_TextArea;
input_Input.Password = Password_Password;
/* harmony default export */ var input = __webpack_exports__["default"] = (input_Input);

/***/ }),

/***/ "AS0P":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJgAAABoCAYAAAANUDk4AAAAAXNSR0IArs4c6QAAA2xJREFUeF7tnEFOHEAQA9nP5lH5LLlGymnaLolYxb1L4K5ezBz4fH9///r6j78+n8/vv799f56ftcyPC/lhC1k7GAVTMDIBP8HIdA/suV/5foIdLABHFAwM94KeW4gd7KIBN6NgXLYNsh2skWKRMXcwdrCiHQWUghVCbCLmFmIHa+qRsxQsz5Ak2MHIdA/suYOxgx0sAEcUDAz3gp5biB3sogE3o2Bctg2yHayRYpExdzB2sKIdBZSCFUJsIuYWYgdr6pGzFCzPkCTYwch0D+y5g7GDHSwARxQMDPeCnluIHeyiATejYFy2DbIdrJFikTF3MHawoh0FlIIVQmwi5hZiB2vqkbMULM+QJNjByHQP7LmDsYMdLABHFAwM94KeW4gd7KIBN6NgXLYNsh2skWKRMXcwxWxEmcA/CXzMxATIBBSMTFf2l4IpAZqAJR+N9x0+V/J9aH2XgJxQMDLdA3tuIT60HiwARxQMDLeAtoMVQmwi5g7GDtbUI2cpWJ5hlTC3EDtY1Y8YpmBxhCjADobG+w6fOxg72LsE5ISCkeke2HMLsYMdLABHFAwMt4C2gxVCbCLmDsYO1tQjZylYnmGVMLcQO1jVjximYHGEKMAOhsb7Dp87GDvYuwTkhIKR6R7Ycwuxgx0sAEcUDAy3gLaDFUJsIuYOxg7W1CNnKVieYZUwtxA7WNWPGKZgcYQowA6GxvsOnzsYO9i7BOSEgpHpHthzC7GDHSwARxQMDLeAtoMVQmwi5g7GDtbUI2cpWJ5hlTC3EDtY1Y8YpmBxhCjAf0CHxitcwXQATUDB0HiFK5gOoAn4DobG+w6f+6PFd7B3CcgJBSPTPbDnFuI72MECcETBwHALaDtYIcQmYu5g7GBNPXKWguUZVglzC7GDVf2IYQoWR4gC7GBovO/wuYOxg71LQE4oGJnugT23EDvYwQJwRMHAcAtoO1ghxCZi7mDsYE09cpaC5RlWCXMLsYNV/YhhChZHiALsYGi87/C5g7GDvUtATigYme6BPbcQO9jBAnBEwcBwC2g7WCHEJmLuYOxgTT1yloLlGVYJcwuxg1X9iGEKFkeIAuxgaLzv8LmDsYO9S0BOKBiZ7oE9txA72MECcETBwHALaDtYIcQmYu5g7GBNPXKWguUZVglzC7GDVf2IYQoWR4gC/gD5ukXFPyHZKgAAAABJRU5ErkJggg=="

/***/ }),

/***/ "BJ3c":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAAAgCAYAAAEAiJpfAAAAAXNSR0IArs4c6QAAA5pJREFUWAm1l09sTUEUxvtPVKIlqUqbIqQhQSQkrESsbLC2sO3GhoWtRJsmmgiJWBESsfGnCwt2XZDYlJCSEISFBV0gqLQNmlaf33d7z3TuvTP3Pk2c5Lw55/u+c2bevHl33mtoSK1Wqz23uIGkUwljzYEGgL3IEEqwnXrJqDMJ5Em814GSywQ0OTQfmIJxQpzlipMqgPUeMZMKPjKeEO5MBLZCwEK4uNxGU4mw2MZGzGI3oiuAtp7dqapbI8IdrsoPIL7hjw0j3tjIi7pokdNGaLQ1NBHMe+QRE1H41OLC24NMTIIWpyIQ6ueK459FXqmcBr14clzSfF2+K/mAuFJDNIkne5YXgo/g2/K4Zh/CZQMiGbWamH2wBgh+SGS5G8GmROSsP5cr3eyKCDJnQaxHzvCZteYwR9sHK6Bs55erQSr+5KoDQebzDfBfYyvxtU2Inkgo84k0XhPAEmihInnNbElBj+Q+3logygAKzvh8Mk+ttscw8pX4TsuDI4J5/ICRxBP4Li+fIz9seXBE0IWPhkjwNnw2xOmEZg6ORGA9+ENcppN5KlQM3pPgUmE/TUT8KkHCL8lbgzqe0tetTjP3KWF8mZJlw1rIVfgy18ACwI5A5fkANmc1hRHx3XyBRHlMeb7YnTa4Scg2T7Aljd95mIXtfKemLHEjTXRGzN47ggDwgRHp2OXzLob0m1jNRYJ2S7wx06TsUaAJ7uDf3UyRoKqJ9qU5Uutgf2N187jcKcJBNxvrHlS61wofWbguiI7TLLnlg2wVyNz6fpnZ9VxVFuWj+8oM59JZ7kWq/e3zYyen/lLa46YDlxLQ5FraSA+HqnshMwV6PZ1lIxliqQmNtuKxd6zbLflhFuoPtz2EBzHEz3DZML4hJALXA/os/guvslkEl3H3G8fvCa6n4lX8D+5OfKIB2IuP4bJbVki8Cf8icIk2TZ1/Zdm5ewt+0OYpHRH241Wmdz9YJYK/UjpZjKSwr47m42h0s9+uQyvJ6dh8UZwibV2ZJd8EBM347zKhxxWvlugKUoLi0K1hPQetHqAF7/R8H7EOYcwyN4z10Rj7Wsae92+okZuN8XgeUsLMRxluGBEZM3dDRLMI07RsR/x3e0xVALpj67HojizO7kV0rHcheiY8qmcFqSa6kH96bHtrVfg69Y4cvqRUh201lfvxyh8NuRmKf9xygkB6iPmSf/xw+ukwyhn7nOggLuBlJx36v9mwLfYvO3ss6OBO/74AAAAASUVORK5CYII="

/***/ }),

/***/ "BUm/":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAqZJREFUWEfdl0uIjWEYx3//b2Y0bnPOcSm3oqwkoWHBUrKQMikpKbKxsDFnimaaGBulmXOOhcLCAiW5bGywsiIlosbCgiQplHPOuA1jvr9majDO5ftmHEO+7fu8z/N7n8v/e1/xlz/95fiUAKTa3GHTaTM5BtxnRE8xq84YtmVNSgCSaX8cDi7ymHwVxwlgJjC4IMGUR136Mh6IEoBEqz0UPNXEvGdd6q/ktPmUG5485pnNvEkJpr/p0vvaAcDTYk6Loxwm035gs/z/AxA8L+S0MDIDre41LK11BkJAEscFLytB2Mw27Buybaxj2qsefYgCLrdebgpu2ayN60yit5DVsrj2v9qVAMw45Cb3sckBSxzSibiLOVUuQBDQPzXk2ouc3tYMYMTRrP1eNTDAXeBiMadt4w0Qta+iFFcDmNXhuV/76cbMjwoAhIhb+QyHJDmyBHEykEj7JGZPjODfTYKAjfmMrtUEINnqK4YtQUA79ZyvBBKKej5zAtiggF2FjM6MHUBcWtnE9p83Pujjkk2LxIpCVg+rZSLZ6oOGw+MHqOJ9QgAk3tmjBUkw3zBtQgDKjeFIDwhygbhYUS3raAi/chRY8zslKNGBZNo5e1iGY38S6wpZ3Rx7E5YRotQBJxigw8TSAWtYB3Qy1r8gjg7YVipNy1AvRKZAOBR3ihndqxlAKu320ByJDP7DYDCoY0W+R701KcFIEyJuCK5XbELTILHXZqHEzkJWZ2sLUE9zsVv3qwpRmw875OC4p0DiJWZU/SxWY+ZMlA5UPOAfBVjU5ca+T5S9GQ9+4RiwXmJzIaurVUuQ9mmb3WMuQYTTczY7hh4lgtcVmxDqgdnD6wFbixldjt2E1QASbW7GXAAWRI2iTGi43VhHS7mL67/3OI06Ua3XvwHYL4cw6diBEwAAAABJRU5ErkJggg=="

/***/ }),

/***/ "CE2x":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAABLhJREFUWEfFl2+IVFUUwH/nzaa7IPNm1sUITEQC0XChRJH60ofMRMoI+kusZYb0wXpv1zTCaO2/sTtvjBA1U0qM/lCBFJlQH6IWCltIKoMCDawwdJ03+Wed3Xkn3t034+w2s/NmV/F+ujP33HN+97xz7jlXuMJDVaW1i+UhxkAvn8tkebq71cr8y1KKLBHhgsJXeU++j6M3hEl18qYqj4byCYsVkwKyu3QhATtUWVgJIMIe12ZNd7cEtcDGwkwaKNWpDwcB24Gp1YyKRY+fkaeqrVWDEeGtXIbHGvbQPR9o4os+egCnZEwgj7BNlfnAneZ/oTBFmX0yK39XQo0LI6INAdlPa5pB3ldYWgFzWJpZmXtVjoXG7E76UJZEUOvynrxRkq0HM3KOmGP6Bp03PMR+Va4rwwgfNSdYdaJHzpb+S7n6ZKBkjXJhp+/J2nAeByY2UNrRFQG8q5CMDCuw2fd4XkTCeXmEskX4NAI66HuyLC7M/4CSrj4oSocK7QLTLrrazI03RTgrFh25Xvm4mnPT67W9OMyP0doR3+P6ytSOdIwE8JjDjAKyHQ098MB4X1DgmNXEytM9criWXOtzmhz28SPD5wk9G90z9WDKQElH1wGv14QRwvvks2kWq//qlZP1ws529ZwqLWPlyqldxTMVSQK2o0cVZkeEO66CzUzhTEmoeYjh456Ep401bFdPqdJaKRwHxtgPs2eowC8RTD5hc+3AZsnHslxFyASwy1nloofiwhiGMVlxwPfEFLqJjKrZBLtzHmuqBXA1GxKVgD1mUdib96TjksEIH+Yy3BcXxiCkOtUJArwIaGvek3JJiAvWyD1TT6fYjm5Q2GLoLF7zM7Kx3qbK9UsJYxiSrm5CeSH8YQkv5jx5Ni7QpYaZFNDlgDFAE/lklwtmJKgrqjNC3aCOAxO2tVvPMH/6LH77/Qm5EDcESlnWEQS8bWLIYl8uIw/VUhAHJtybdDTU1yHCId+TRQ0BJbt0GUUOGDrhS9+TW6spiAtjgFw9gTIjukqm5z0ZiAsl6Y06q3iBPyKggZk21/zcLYXJpLbtak4VO9SRmErq9BYx1T/OMD1O0tFfgbnRhncsi2wTlLvAQmCuhXtLCuvVpqSjg6Xmf8YcmhuJIwOUcvWRQNkd6wSl10GNFuKWbm3qzzEU6Srms9IUR2/5sKWJ7eh2BdP/1hzCXj/DqvFq09Xrdcb5YU5EOk7ls9I2IaBwU7pLlxeL3C/CAlXmwEgcRMF5yM+wuF6hTHXqDUFAv4lJ+MnPyoIJA4Ubo35ml8LqCjeOaiGSrt4ugj0zySdjEyDt6h1FZb8BEhpuZ0Y9g+LAtHbqTcMB30Ze62tu4e5/XpbSJwrjsStQ85AMgbb7njw+IQ/FgTEZ6epilO8qvHecBHf5vfJD+Ko92Ee/QnsEtNb3ZGfDQHFhSoqjHir0QiLyVEFgn8K80qtV4Ny0Fmb9+YqcahjIdnXXqKdKjLbTdvU24D1V0tUMisUmPyMvNQJjvJp29OYifFMrgMdTaLs6B2WbwrIKuSGBHj8rzzQKY4DaNujcQoEjJgbrXHq1DNiO3ojFIlEGNcHXfo8cnQhMdFVACFUs0HY6KyPZcwXHf/5Hk9e7LmkkAAAAAElFTkSuQmCC"

/***/ }),

/***/ "CF3O":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABMAAAAUCAYAAABvVQZ0AAAB/0lEQVQ4T6WTPWhUURCFv3M3CP7kJQhBRQVFYmVkRcFSxEYLG1NY2K5FhLhvFTshGqwssptt/E2nhYVaCGqhop2FYiI2akBBCLppNrskFrp35D0NZl/ei5hMOXPPd2funCuWiM6inZM4DwRA0+BSs6LLWRJlFbrO2l5r8SpZl2ffTFWv03TZsNAKBjcWwURhpqyxTFhw2nrNUQCmzfPYObYajAk2JUVmTEkUvOeLHIeBHnluNqr6qLWnbGNuFW+j5FLv949arWXsVmfJrss4uQJQLDW4piC02gq7+t2HqCko2ROMQ2mdmfHViWHvmXCiz4uhtHf8A3uqdYPW43I8APYvBBp8x9jTHNX7+XznGduJZ1ywuu1y8dIcR2NrRNvE8aENZtxvjupYsuOgaI9QvMW/IXobZU3GsO7Qtnn4lOjsXrOi/kWw0B4CRxbmHWyvV/Q5HlMd3JFxsE1ozGHkI//M5+MJxDhiTeLiZ+Q4HlnjuYwDqQuAKcRFeSZM9AEXBJtTz4oXkTVmof2mZXpuLoLdAk4sE7BQdlvrB23LzxzvgK4VAGc6Wuya32a+BQOCb67FXXLs8HA142dMyzGgH0z6HP0GGzxcma0o8l96BCUrYlQWVR3FxoiqaapMWHdoeQ9vkiLnyNdHNPFfsPhnhDYEhJGvgTpGuTGq4axpfgHDYbDqQpHzVgAAAABJRU5ErkJggg=="

/***/ }),

/***/ "EYLL":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAhCAYAAADdy1suAAAAAXNSR0IArs4c6QAABQ9JREFUSEuNll1sVEUUx/9n7t37saUfK3QXW6AgClQBJRH5UIKlQSIRRUwwEQzE+KAPvmgwwSeNQCJGEz+CD0KCEh8kJIY0EQttt3xE0ojGgCZGKYKlDd2WlW7d7t3u3Dnm3v2gu9uFnrd7zsxv/vfMmTNDqGB8tjaUlsZLimk9GMsAhAnIABgAoYcVt9l1Q8fpUd9XZlTq4QsNQWcksxugNxkIVlo45+8nYLfdGjtSOq4I7ETr72dF3zGw+C7A0vAxW9JO2jCYzAcKYKczPF8BZwA0FIJVzdAatkG7Zy3IbATAYKcPbrwbbv8RcKr39gLM3Tfj5sbZW6+nPKcP5igsR4UvMPCQP5IMBBbshdawHURiUvHMErLvIGTv+wDL7DTiQ/a6oVcL4FRX/V5mesePChPGI0eh1a2cUjbc4S6MX9oOsJudLmi91TLYQdzROD1FmasApnmBwKKPoTdsmxI0PyjzzwHIy+/lP88HW2OryYmGX1MKX/jypy2Bufxk0e+z0w/n/AqAc1VFGqzVv4DMmYXFWUmke9aAU1d8nxRuM4111rcB9IyvdsF+6LN2FKl1Y20Y/81Pm2964w4EFu4v+6PMtc8ge/dk00F4i1Jd4avMaPIc5qoeCHtu0aRM717Ia59mN8dsgLniDEivLgOr0YtI/7Te9zPjKxrrDI8BsD2H9WQfSBhFk9K/vggV787JrQYFpsNo/gSiZHN5/Caccw9mBYC+98Be3VmVwM7ZZnAmXliM7CaYK86ChFkkoBiMEx74MoD5fipW9kAEi1Mh+w9DjfwM98ZRH2QsOQyt/unyVCQuIn0hmwoCH6SxjvAxEF7Ibt4H0GftLJskB75G5o9d0EJrYCw7Vhb3HBM3D+A3KNUVeYWZD/krTVsMc/mpstOWubIP8trnMB/rgqhaVAYuKTcWwAPE7ZGqVED1gSnkq174EfTG7UWTx39/HRQIIbBgXwW1ByB7sweEgJN2a2yD3yvGusK7wMgWp3ekH/4WWmhVAaLip0E1y0B6TRnYHe7E+KWX/SNNgMtEjwfXDfbkm5CeUmGvs2VpfhPak2tC2qQqvd+X17/MNaFcnyB8aK2LvZ1Tnp032h4J6zr/yLkK8YNVi6Ddm2ubViPA6nbbHPimpG3iuN0a20IEVQT2PlKnQnOYAt0gzJtUZgWndyCs9OAW2oh0fkjZ1ZTqrGsCGVHmqcEJOGGlY89PhJYpzq/mwRmGd46LT0uJYiL8YDmxzaXQimA/LdGZc1kpD+43qFIjQrtFsc3UAmfS+J1ymTodmceSPficieOIcNKi2HOVoHdUnAc5HZH7mDjKOTgTOuLDxrP5S7OSsLLNm2ygf4MTR8H0p20bm2h19ia+k00JnM+59Z+I0aYBr3/f1SYF87sQeGpWnZMZrZWuFhSaZkCx5j0rmMhlqdI6VNKytX/pieHRKW0en5tRnXTceQRhMnFIEKrBwiAB/4HBXj8AO8KlESWQcImT1UM3r9BWjBdt8MQPT2lybf1SYtaUy026Tv6VxawiBLKEAEtGQoBueX6X1TBBDGsaJay1Q39VBjMoGa1bStB1KJ4tNKrKlo6aQSDbBVgQEsyU8P2uirlCxCXRSG3LkHcTFawsxzfaI1VVgcxcIYUtdK5VCtUk2FAQupdjASW9VCjoI4I4KSUlagJDf1MLsu+snFWsivipUK1lUI1wRVAq14Sm+zkOQEoWetpNczKYNm5VqpL/Ad/tG1fSEdnsAAAAAElFTkSuQmCC"

/***/ }),

/***/ "F1Lc":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__("Q9dM"));
var _createClass2 = _interopRequireDefault(__webpack_require__("wm7F"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("F6AD"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("fghW"));
var _inherits2 = _interopRequireDefault(__webpack_require__("QwVp"));
var _react = _interopRequireDefault(__webpack_require__("GiK3"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
// 屏幕录制
var RecordVideo = /*#__PURE__*/function (_React$Component) {
  function RecordVideo(props) {
    (0, _classCallCheck2.default)(this, RecordVideo);
    return _callSuper(this, RecordVideo, [props]);
  }
  (0, _inherits2.default)(RecordVideo, _React$Component);
  return (0, _createClass2.default)(RecordVideo, [{
    key: "render",
    value: function render() {
      console.log('this.props', this.props);
      return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("video", {
        style: {
          display: 'none'
        },
        volume: "1",
        id: "record_rtc_video",
        controls: true,
        src: this.props.src,
        srcObject: this.props.srcObject
      }), /*#__PURE__*/_react.default.createElement("audio", {
        id: "record_rtc_audio",
        controls: true,
        style: {
          display: 'none'
        }
      }));
    }
  }]);
}(_react.default.Component);
var _default = exports.default = RecordVideo;

/***/ }),

/***/ "GNCS":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.warning = warning;
exports.note = note;
exports.resetWarned = resetWarned;
exports.call = call;
exports.warningOnce = warningOnce;
exports.noteOnce = noteOnce;
exports.default = void 0;

/* eslint-disable no-console */
var warned = {};

function warning(valid, message) {
  // Support uglify
  if (false) {
    console.error("Warning: ".concat(message));
  }
}

function note(valid, message) {
  // Support uglify
  if (false) {
    console.warn("Note: ".concat(message));
  }
}

function resetWarned() {
  warned = {};
}

function call(method, valid, message) {
  if (!valid && !warned[message]) {
    method(false, message);
    warned[message] = true;
  }
}

function warningOnce(valid, message) {
  call(warning, valid, message);
}

function noteOnce(valid, message) {
  call(note, valid, message);
}

var _default = warningOnce;
/* eslint-enable */

exports.default = _default;

/***/ }),

/***/ "Hjgs":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = toArray;

var _react = _interopRequireDefault(__webpack_require__("GiK3"));

var _reactIs = __webpack_require__("ncfW");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function toArray(children) {
  var ret = [];

  _react.default.Children.forEach(children, function (child) {
    if (child === undefined || child === null) {
      return;
    }

    if (Array.isArray(child)) {
      ret = ret.concat(toArray(child));
    } else if ((0, _reactIs.isFragment)(child) && child.props) {
      ret = ret.concat(toArray(child.props.children));
    } else {
      ret.push(child);
    }
  });

  return ret;
}

/***/ }),

/***/ "IXBG":
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./attendance.png": "1+y7",
	"./attendancePoint.png": "6Mj6",
	"./back.png": "lNEh",
	"./dep.png": "aX42",
	"./errorReport.png": "LK1H",
	"./errorTime.png": "rm0p",
	"./errorTimeReport.png": "1Bek",
	"./event-jd.png": "EYLL",
	"./event-list-click.png": "hwng",
	"./event-list.png": "Wny5",
	"./event-module-click.png": "nxuO",
	"./event-module.png": "kDXx",
	"./event-td.png": "pBGO",
	"./event-yb.png": "Vp7n",
	"./event-zd.png": "MIZS",
	"./float-check.png": "Pe7w",
	"./float.png": "wEcu",
	"./magnify-check.png": "9rO7",
	"./magnify.png": "IqXq",
	"./minimize-check.png": "TGlF",
	"./minimize.png": "qEAy",
	"./nextDep.png": "BUm/",
	"./nowError.png": "BJ3c",
	"./perception.png": "Q+cA",
	"./recording.png": "RMDC",
	"./searchAddress.png": "6upA",
	"./security.png": "dDE8",
	"./securityCompany.png": "0vbU",
	"./securityResource.png": "V8Q4",
	"./securityResourceChecked.png": "vD6o",
	"./setting-click.png": "CF3O",
	"./setting.png": "X/W6",
	"./time.png": "R07g",
	"./todayError.png": "IldK"
};
function webpackContext(req) {
	return __webpack_require__(webpackContextResolve(req));
};
function webpackContextResolve(req) {
	var id = map[req];
	if(!(id + 1)) // check for number or string
		throw new Error("Cannot find module '" + req + "'.");
	return id;
};
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "IXBG";

/***/ }),

/***/ "IldK":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAAEEfUpiAAAAAXNSR0IArs4c6QAAA1ZJREFUWAm1l09IFVEUxtVMsVwEtSitiOjPrihq1aaFGkEJ7apFq6BVkYuKaOUmchNUiwiCIohcJBG0KihpFYabiIIoCcqEpD9qpiH5+n3jnHl3Zu7cNwgdOO+e853vO/e+O//r6mKrVCrfLa4jqSjR2IBPJhULVDFGhJHfxHcrqY+rf4mXCGjQDxYlCgxQLJuPfpHtlDRrVrzuFgS6uVrej5jxD8Ufbl5viVQW21iPWay2Lfh7/HECWgDoswUild9WlYC4x821yBbrFI9dlouY+kvk20xto+2tibLjhDpcMLaqxHNuHikABg10xuxxidTLIMw4JF94OLsOTatN9Nks4FtfAazXltdcQBi1magfLOD0a5feQdxsZHe0Yy2xi7uxNuKzC7gxujt4k4tl4+hsCs2AYBpfnhXGeUeC02REjTK2XYQMFqWJMBtQXYl/9YnATmT53hxiN/4c15n+Gr+IVy8erwoQUh8eso9ZbdIV1RjF1VlCQd7KIdbmLtxnEL8k9omHChr8SnDEbQVr3mCkgvpT1XUmTjG2GtlGOwuVq4Hh7iiOzsScWCQ0h1yyL4bTlb+mq8xTCiFtqkK5qDPUYG9MP5mTVYE1wXuW/iMrmIXfXNWkop5gA6gj+MaUJJ006S9cSWOpzLvBxmCBc1HMMn32REUKrb4i2A5rJNIqD2kmbnDWU7uXiC2ApMu4jF0yjXekw+WCLm/AG72iEIhoPX4Ln8bL2ieIZ/Ciwx+aMtr4tYiHy85WgncNTvKqUjg7pHZ8rETDxVIGECb3wNRCKOi2W9aGIK6zBsQd+GRJ8Ty8XaaNRoAbJcWivUqJ4wQ8925To+c+m3x/DaKv3J5dBKReHzGATVBr0kU8GCAVlXLXIsRvReQAfloLmAoQikrSJLdy4qNFxBr4XTVJ3sKy2xrIdZM97tRDzwyHlgtHtQNXa6yyqDxOQa+WnUWEEninnke6PY7jK3Lr+79AP4+jI9EULEJPE52VZU3X8jGJGbULt8sKY573c2gpxWclGw24m4OmEa/1bWGtz7vaXAxrK/7B2IFREz7CXwQ4bukhSfarLTd/AkDWjpzDf+KLNX0gHUiaegL/g8FDpJGeZnvwbnwL3hb7H0Zdyl/wYfwBJ5e+m0rZP9nCKYUv9en2AAAAAElFTkSuQmCC"

/***/ }),

/***/ "IqXq":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAAXNSR0IArs4c6QAAA/5JREFUaEPdmk9sFHUUx9+bXSgtFIzVGk0P3vRivHnwogeMoVWjiW6EqKQa3D+EHixQs84sw/6GFg1wUOzsVGNjIqgbDhK0xOiBixdvxoucrRKREhBLS5mZr/ltuzO7pC2d2Wlm1rlN8nv7+372vfd77/f7DVObP9zm+qkJQH//kz57wf6AiJ4m4MFEwTFfIqIL6Y3pg/rInum6Ng9Aindu2b+AcG+ihN8hhomvpjrSj9chPABVmKcJ2Jlk8Z425i8NLb9LvjcC/OmFDSsDhpabShJM6Yg14DrOtzVNzJcMLf9QM0B5HHXBRqmQyORWl9Hoe+D/CqAJ8xyIBggI5BUmsonoU1Eq5KMKxVAe0IR5G0A6rIjeex7eNDTUfyusfaNdOICyOQtCV1ABifGAKsavEKinCYD55/S27mf0odf+CQrWyvhQHmgCYEY9F5j4p62dm589cOCN2VZEBbFtGYBJGQbjmJfQzBfSvcqAns3eDCIk7NiWAbrSm++bd+Z2uXA/9Ksi/Zju63xeHxycDytsrXaRABSLu2dUYQ4TcMxvqPh86tGeF/VMZmGtYsKMiwxATq4Z40W4dKQB4mzfA8or2Wz2dhhxa7GJFEBOWBKm7gKHPAjmM4890vNqJpNx1iIo6JjIAWqeKJtjILzbAHE6peZe15ndoALvNn5dABYhxo+D6B0/sflzoeYGWS67ET7rBiA1qqJykuDu9SGib8nXFQAAa0bFImCPhFBSqefK72W/i9ABFBLA9DY63R0dW0dG3rqxkigJcWh0ot91AaFmzycihDSjsh9AiYFTUbbGYTwTygNhJmrVRhXmBAM7wawbWv54/fdiA1jMD2uHojAfLr49tVpoHT1qbft3wblWE838h6Hl+2IHaNyQM9FEWcvnVoIYHf3s/pv2/OVFAPrb0Aq9sQOootJPcL0ViYlPilJ+33KhlkiApSV2koDdfu9EJ0SpMHwnRCIBpEgdUGyj8kXj4ZnCNFbWCsVGiMQCSJHVajX168WZrwC8XBct87qs5fX6e6IBpEjLsjZMX3bPAHihoe0oGlpuTL4nHqAWTtXqRue3mW9A2OHlhKIMCzV3oi0AahCTk5vs6blzBNruQ/C+TqXj68QtoytVZt2yupy/nCkQPbVUuMDAfhAtVt+k1IHVWgv94+oW++qV7wn0ZB3CP/VISCGTwmQtWAnk8Eenuu3rN34g4ImmMUnwgGzMiOhNAlKBmzymWUMrbImtlagl6u9zc4GFLxnI81VRKmyIDUBOrAqzUvMAUbATboCIlbOGlnspVoCw//5ydrHtB6KCWB1A+Hvf9diQtwpx90u+dr9mbfuL7lp/0s6fGrQao3HZB7o6jUvkavP+B52LHV54q7JeAAAAAElFTkSuQmCC"

/***/ }),

/***/ "JjPw":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "K+uK":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "K7vd":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJgAAABoCAYAAAANUDk4AAAAAXNSR0IArs4c6QAAAn5JREFUeF7t1kFO5EAQRUF8WQ7FZZstEhKLqnxSkwr2/hqew0w+r9fr8+Mf/zzP8/Xzn+/3ea+X+Xghb/ZCtn0wgAFWFvAXrKx7sL3uv3x/wQ4UhI8AFsY9mV73QtxgJwy6ZwDr2k4su8EmKg5urPtg3GCDOgamABuIODmx7oW4wSZ53G8Bdt+wXHCDlXUPttd9MG6wAwXhI4CFcU+m170QN9gJg+4ZwLq2E8tusImKgxvrPhg32KCOgSnABiJOTqx7IW6wSR73W4DdNywX3GBl3YPtdR+MG+xAQfgIYGHck+l1L8QNdsKgewawru3EshtsouLgxroPxg02qGNgCrCBiJMT616IG2ySx/0WYPcNywU3WFn3YHvdB+MGO1AQPgJYGPdket0LcYOdMOieAaxrO7HsBpuoOLix7oMZbGNKgV8FHk0UKAsAVta1/QEYBGmBf3/kp3WMXxcA7Dqhgb8KAMZHWgCwNK9xwBhICwCW5jUOGANpAcDSvMYBYyAtAFia1zhgDKQFAEvzGgeMgbQAYGle44AxkBYALM1rHDAG0gKApXmNA8ZAWgCwNK9xwBhICwCW5jUOGANpAcDSvMYBYyAtAFia1zhgDKQFAEvzGgeMgbQAYGle44AxkBYALM1rHDAG0gKApXmNA8ZAWgCwNK9xwBhICwCW5jUOGANpAcDSvMYBYyAtAFia1zhgDKQFAEvzGgeMgbQAYGle44AxkBYALM1rHDAG0gKApXmNA8ZAWgCwNK9xwBhICwCW5jUOGANpAcDSvMYBYyAtAFia1zhgDKQFAEvzGgeMgbQAYGle44AxkBYALM1rHDAG0gKApXmNA8ZAWgCwNK/xb40WUzNbhY4CAAAAAElFTkSuQmCC"

/***/ }),

/***/ "LHBr":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__style_index_less__ = __webpack_require__("vtiu");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__style_index_less___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0__style_index_less__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__index_less__ = __webpack_require__("JjPw");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__index_less___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1__index_less__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__button_style__ = __webpack_require__("crfj");

 // style dependencies



/***/ }),

/***/ "LK1H":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADgklEQVRYR+2XWahXZRTFf6sMJDWElHAiyYewVHy4D4mGI0WRSmhkhQOIegnHpBfBAXxQRJxATA3FKaJCrZeCRhQfjJwH8CGcRRBBBVOz65Yl37mcjudv957r8NJ++nO+8317fWvvtfb5KyKeBZYBowD/fhRxDtgALJEU+QSKiM+BiY8ia8mZ9ZLWFgFcA9o9JgBrJdUXATQATz0mAGskffw/gCID/wBPP8kSlAG4BewH3B9VoiPwcsnG0h4oA9BH0pEqmbM9EWG5TS6c0WQAr0o63kIAK4HpVQFcBX5qQQleAPoDNwoe02QGqlz+CvAl8D2wF7gk6U5EtAFeAt4Crkta/bBV4IZdDCyXZOaaFZ4FLZGhh8woSb/ns0bE80BPwLc/C5yU5HLcF7UAfAKYqjv/cZ2G/HSLiGHA/FR/5fbeBnYAqyTtKZbAi60Kido3h85U56+At3PnuDQXgE5A6/Tco3gpMEeSmccMlAGYBXhM12LgphvMB0RE+9R4rwE+ayNgCZ6Q1BARZqIfMBN4LwHZDow2e7UAPIh517KzJHe9AXwBfAB4rL8jaXd6/gzQS9KBnDmNSxfzmllYVAXAZknjU5LBwC/GAQyStCuXzFTPBsZJ2pJ7biaWAzeBblUATJC0KQHYBnwINILKJbInvJ/dtKCSw0Dve2s1euAEsK+GE86XdDIi3LiXgeeAIZJ+LSQxSFM+W5K/ORsjIqZZEcCuMgCngB5Zk9VqhojoAtgHHK0luevzSdYBk4CpRfeLiNedHDhfBuAvwNPwzwd1YkS8AhwDbknKZJYH4Bv6ppMkWVH5tV6Ap+2NWiUwCE/DMhlOlHQ0IjrY79Op3SWdLiTxJLQcB0v6rbA2HPjOFzCAvwHLoqkxRZLptQRdrhfLaE7rlqvN6F8RESuAGcD2KgC2ShqbEiwBPgWOAnX5PoiIAcAi4CNJZzIEaU4YeFvg3SoArN+uki5HRGfAkvLwWS1pai7RSOAzYGj2cZOU84Of2Sk9sKoAcI55khYmFkYA36bEW1M57hvLSTX+e/ZGMiEb194qRuRcZqGvJN/CvTAXWJD+4FwEdgI/Wmbp4/RN23TyDM8Ll+Vr7zWAzJWa2oTZe38k+72eQAwEbD5uylpxCLCTHsxeMIA6YD3QvbkIgJ+BMdlojQg31hjAMrPV2iUtVQ+kbyy97N1GABWSPtQtdwGDJaoPteV1GAAAAABJRU5ErkJggg=="

/***/ }),

/***/ "LPk8":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _objectSpread2 = _interopRequireDefault(__webpack_require__("+TWC"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__("Q9dM"));
var _createClass2 = _interopRequireDefault(__webpack_require__("wm7F"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("F6AD"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("fghW"));
var _inherits2 = _interopRequireDefault(__webpack_require__("QwVp"));
var _react = _interopRequireWildcard(__webpack_require__("GiK3"));
var _dva = __webpack_require__("S6G3");
__webpack_require__("PK9/");
var _MouseMovement = _interopRequireDefault(__webpack_require__("06MX"));
var _utils = __webpack_require__("oAV5");
var _dec, _class;
/**
 * 录制中倒计时
 */
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
// import { initRecordRTC, stopRecord, startRecord, playRecord, downloadRecord } from '../Video/recordRTC';
var _SIZE = ['minimize', 'float', 'magnify'];
var RecordMini = exports.default = (_dec = (0, _dva.connect)(function (state) {
  return {
    ownCid: state.im.v5Data.ownCid,
    videoMember: state.command.videoMember
  };
}), _dec(_class = /*#__PURE__*/function (_Component) {
  function RecordMini(props) {
    var _this;
    (0, _classCallCheck2.default)(this, RecordMini);
    _this = _callSuper(this, RecordMini, [props]);
    _this.onChange = function (index) {
      var onChange = _this.props.onChange;
      onChange && onChange(index);
    };
    _this.state = {
      videoSize: 2,
      // 0：只显示标题； 1：只显示当前发言人视频；2：最大化
      videoMember: [],
      miniLocal: {
        isDown: false,
        offsetLeft: 0,
        offsetTop: 0
      }
    };
    _this.timeInterval = null;
    return _this;
  }
  (0, _inherits2.default)(RecordMini, _Component);
  return (0, _createClass2.default)(RecordMini, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      if (nextProps.videoSize != this.state.videoSize) {
        this.setState({
          videoSize: nextProps.videoSize
        });
      }
      if (JSON.stringify(nextProps.videoMember) != JSON.stringify(this.state.videoMember)) {
        this.setState({
          videoMember: nextProps.videoMember
        });
      }
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      if (JSON.stringify(nextProps.videoMember) != JSON.stringify(this.state.videoMember) || nextProps.videoSize != this.state.videoSize) {
        return true;
      }
      return false;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {}
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      // const { videoSize, videoMember } = this.props;
      var _this$state = this.state,
        miniLocal = _this$state.miniLocal,
        videoMember = _this$state.videoMember,
        videoSize = _this$state.videoSize;
      var checkedVideos = videoMember.filter(function (item, index) {
        return item.checked;
      });
      var checkedVideo = checkedVideos.length > 0 ? checkedVideos[0] : {};
      var checkedStream = window.recordStream.trtcStream && window.recordStream.trtcStream.filter(function (item, index) {
        return item.getId() == checkedVideo.videoId;
      });
      var statusText = checkedVideo.status == "no" ? "正在调度" : "摄像头未打开";
      var videoID = !(0, _utils.isEmpty)(checkedVideo.id) ? checkedVideo.id : 'main';
      var userName = !(0, _utils.isEmpty)(checkedVideo.id) ? checkedVideo.userName : '我';
      var Steam = videoID == 'main' ? window.recordStream.localStream : checkedStream[0];
      console.log('Steam', Steam);
      var hasVideo = Steam && Steam.hasVideo();
      var that = this;
      console.log('checkedVideo', checkedVideo.id);
      if (videoSize == 1) {
        setTimeout(function () {
          that.timeInterval = setInterval(function () {
            var frame = Steam && Steam.getVideoFrame();
            if (frame) {
              document.querySelector('img#mini-img').src = frame;
            }
            console.log('getVideoFrame');
          }, 2000);
        }, 700);
      } else {
        if (this.timeInterval) clearInterval(this.timeInterval);
      }
      return /*#__PURE__*/_react.default.createElement(_MouseMovement.default, {
        isDown: miniLocal.isDown,
        offsetLeft: miniLocal.offsetLeft,
        offsetTop: miniLocal.offsetTop
      }, function (_ref) {
        var x = _ref.x,
          y = _ref.y,
          _ref$cursor = _ref.cursor,
          cursor = _ref$cursor === void 0 ? 'move' : _ref$cursor;
        return /*#__PURE__*/_react.default.createElement("div", {
          id: "record-mini-content",
          className: "record-mini-content",
          style: {
            top: y == 0 ? '40%' : y,
            left: x == 0 ? 'auto' : x,
            right: x == 0 ? 0 : 'auto'
          },
          onMouseDown: function onMouseDown(e) {
            _this2.setState({
              miniLocal: {
                isDown: true,
                offsetLeft: document.getElementsByClassName('record-mini-content')[0].offsetLeft,
                offsetTop: document.getElementsByClassName('record-mini-content')[0].offsetTop
              }
            });
          },
          onMouseUp: function onMouseUp(e) {
            _this2.setState({
              miniLocal: (0, _objectSpread2.default)({}, miniLocal, {
                isDown: false
              })
            });
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "mini-icon"
        }, _SIZE.map(function (e, i) {
          if (i == videoSize) {
            return /*#__PURE__*/_react.default.createElement("img", {
              src: __webpack_require__("tiui")("./".concat(e, "-check.png"))
            });
          }
          return /*#__PURE__*/_react.default.createElement("img", {
            src: __webpack_require__("IXBG")("./".concat(e, ".png")),
            onClick: _this2.onChange.bind(_this2, i)
          });
        })), /*#__PURE__*/_react.default.createElement("div", {
          className: "mini-title",
          style: {
            display: videoSize != 2 ? 'flex' : 'none'
          }
        }, "\u89C6\u9891\u8C03\u5EA6"), /*#__PURE__*/_react.default.createElement("div", {
          className: "mini-video",
          id: "mini_" + videoID,
          style: {
            display: videoSize == 1 ? 'block' : 'none'
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          id: "mini_mask_" + videoID,
          className: "mask col-div",
          style: {
            display: !hasVideo ? 'flex' : 'none'
          }
        }, /*#__PURE__*/_react.default.createElement("img", {
          style: {
            width: "63px",
            height: "69px",
            zIndex: 10
          },
          src: __webpack_require__("K+uK"),
          alt: ""
        }), /*#__PURE__*/_react.default.createElement("div", {
          style: {
            height: "10px"
          }
        }), /*#__PURE__*/_react.default.createElement("div", {
          style: {
            zIndex: 10
          }
        }, statusText)), /*#__PURE__*/_react.default.createElement("img", {
          id: "mini-img",
          style: {
            display: hasVideo ? 'block' : 'none',
            width: '100%',
            height: '100px'
          }
        }), /*#__PURE__*/_react.default.createElement("div", {
          className: "video-name"
        }, hasVideo ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("img", {
          src: __webpack_require__("8ZKn")
        })) : /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("img", {
          src: __webpack_require__("acLb")
        })), userName)));
      });
    }
  }]);
}(_react.Component)) || _class);

/***/ }),

/***/ "LpuX":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/** @license React v16.13.1
 * react-is.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

var b="function"===typeof Symbol&&Symbol.for,c=b?Symbol.for("react.element"):60103,d=b?Symbol.for("react.portal"):60106,e=b?Symbol.for("react.fragment"):60107,f=b?Symbol.for("react.strict_mode"):60108,g=b?Symbol.for("react.profiler"):60114,h=b?Symbol.for("react.provider"):60109,k=b?Symbol.for("react.context"):60110,l=b?Symbol.for("react.async_mode"):60111,m=b?Symbol.for("react.concurrent_mode"):60111,n=b?Symbol.for("react.forward_ref"):60112,p=b?Symbol.for("react.suspense"):60113,q=b?
Symbol.for("react.suspense_list"):60120,r=b?Symbol.for("react.memo"):60115,t=b?Symbol.for("react.lazy"):60116,v=b?Symbol.for("react.block"):60121,w=b?Symbol.for("react.fundamental"):60117,x=b?Symbol.for("react.responder"):60118,y=b?Symbol.for("react.scope"):60119;
function z(a){if("object"===typeof a&&null!==a){var u=a.$$typeof;switch(u){case c:switch(a=a.type,a){case l:case m:case e:case g:case f:case p:return a;default:switch(a=a&&a.$$typeof,a){case k:case n:case t:case r:case h:return a;default:return u}}case d:return u}}}function A(a){return z(a)===m}exports.AsyncMode=l;exports.ConcurrentMode=m;exports.ContextConsumer=k;exports.ContextProvider=h;exports.Element=c;exports.ForwardRef=n;exports.Fragment=e;exports.Lazy=t;exports.Memo=r;exports.Portal=d;
exports.Profiler=g;exports.StrictMode=f;exports.Suspense=p;exports.isAsyncMode=function(a){return A(a)||z(a)===l};exports.isConcurrentMode=A;exports.isContextConsumer=function(a){return z(a)===k};exports.isContextProvider=function(a){return z(a)===h};exports.isElement=function(a){return"object"===typeof a&&null!==a&&a.$$typeof===c};exports.isForwardRef=function(a){return z(a)===n};exports.isFragment=function(a){return z(a)===e};exports.isLazy=function(a){return z(a)===t};
exports.isMemo=function(a){return z(a)===r};exports.isPortal=function(a){return z(a)===d};exports.isProfiler=function(a){return z(a)===g};exports.isStrictMode=function(a){return z(a)===f};exports.isSuspense=function(a){return z(a)===p};
exports.isValidElementType=function(a){return"string"===typeof a||"function"===typeof a||a===e||a===m||a===g||a===f||a===p||a===q||"object"===typeof a&&null!==a&&(a.$$typeof===t||a.$$typeof===r||a.$$typeof===h||a.$$typeof===k||a.$$typeof===n||a.$$typeof===w||a.$$typeof===x||a.$$typeof===y||a.$$typeof===v)};exports.typeOf=z;


/***/ }),

/***/ "MIZS":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAhCAYAAADdy1suAAAAAXNSR0IArs4c6QAABOZJREFUSEuNlmtsFFUUx3/nznZ3dttuKY9KSOgLiDEgsaAf1OgXBRQBARM+CB+MltDEV6I8hFjctCiCNkqIggESH/GDihJC5FErNCRAqgSJUROhIGAQw6Olhe12d2fmmpl92O12S8+nmf+593//c86554xQwPRGyvssnkUzC6jTUAEkgX+ADi3sK6lgr6zwsDyTwYiOEOpTrAVe0xAqdHAav2wo1gbf5IvB63KI+zcy2UqwB2HaHQhz3AK7Q0Gek1VEM44s8c1mJvk0R4EJWWfFvRTdV49R+zhSVglao3suYp07hPXLDvSNPwce0N7dzdyJHxBzQY9YRzCjipPAVG+lEcA/Zwu+GcsRUUOK146F9dNWEj+uBsdKrRF2lTRSnyWONvG2hnUpUhNzWStG5SMjiobVeZD4V/Oz5D5hltlIm/S+wxjD4oKGEpfJP28nRXUvjIg0syh5ooVE28q0aE4Ur+chiTbRoGGbi6rxMzDrf875fKfnErGPJoOdrioxCL16CSnNpgJtJ4ltn4ruOuuROw73yO0m9gHzPLVzt1M0c0WOWuuPb4h/uySL+WY2EJjr6cixxLFNJA+/4WEKXpdoMxe0psoFgi+dQ5XX5m44vJbksXdTnxmeSLDhNyQQziO2r5yif+fMFK75zFXc53K6KQ2t60cMf86m/i9nY5//IYUFypDQGAILPs1LrtN3nVjLuEyc97vEbt2ZhYj73h+Ljt3IHibltQQbfkd8Zo4Ap+8asRb31nt2QG410SkwyQvFi52o0d5j1pInP8a53IH16+ceZi75DuPuRcOGQmCnS7xb4Bl3pf/JbRTd35C3KXnqExLfN2DUPIa5rC3P7wIDk6fhZbfcntewy3Wq8XWY9SfzblviyDqSxzcTXH4aVZHfRlLlNg3ddcZLnU+YInolxdEwfwPlnuqndlA0w7uVWYvvWYoER+N/YuvQak+0kExfEKC1ZD1zvF5xu5lVaDZ7u4wA5tJWjKpHsyRuVagJDyDmqDxi6+wB4l8v8K60CLZoHg6tpyPThHx9iqMaHsyQ+2d/mGpCyhhSpdeEOraQcC9Fugkp4b1QI6vdDdm2eStChVIc1+kK8ZzjplFUl26bYbdtOjg9F7Hdtnl6V07b1LC3xGGxRHByiN2X2FtU2gbtQM2QMguD+69cY/GUrcQzS/JGU/cGqvwOR/QIyQUOhEaxSF75nzRPcea02AaqHId2DdXDKRfhYKiMhYNJCxJ7YYlQbSsvLF6DGmwCh0IOCyVCfwF/YU2xZmpsh3aEyoGrRGgN2TxdiHRYxRmi/gi1tvJiniFv6+5mQWZoFpKVl7yhFqYn+BHgTHE38yU9iYeN/0jLKraRajPOVYl4/fuONqRiHUERZlR/lDJLE1Lgx8FAobWDrQ3iPouoGaJb1nBrRMnTmyiNxqgRm4BWlCtFqdubxBtl3j+LraFfCT2O0Gs7REvhvERI5CR44IurNArTRWE4DlU+cUeWR3aXKEyl0Rb0Krjp4jZcF+G6IfSajaRGdNpyQqE17nCdLuDDYaISitOlM1aEoK3RCno19Kbxq7bQZTn0lEXoLEjsOv5dSXFxmGrlEFRCmaMpFfA77mHiEVtuKByDHuUQtYTesM1fEiH9n5WiL1huXWsoM0sJK03IsgmkfhegyCU2iNs20RDcLFQl/wFQIs6zlVW3RQAAAABJRU5ErkJggg=="

/***/ }),

/***/ "MRHW":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAA+NJREFUWEe9mF3o3mMYxz9fCYmEnQzLpNWUiAMzK4bChj/LATZvzWyJdjKx4pBCnMiSecnrZgfyEoYyJjZzQKSsJJPMiZdEYsmlL9f9dO+35/k/v2fP//+76jl47vt339fnd73d1/0TY0pE3AOsBh6SdOeY26FxN4iIv4CDgD2SDh53v1ZAETEf+EPSZ02FERFlTFLf/SLiVOBQSduHAU8KFBFHA+uAK4G/gUskvVVvOgwoIi4AXgcOBDYBt0j6aRDYQKCIOC03mlktvkHS0yMCXQ88Va3ZnS/2aT+oQSY+H3gZOKxa9CSwQlLPRZ5rYSHreBxYXu31O3C5pHeaUPsApWXer2ActKslre/3RsOAypqIWOlMBErgG+psSXtZai+giJgBfA4UN32Xb/LJIJ+3BUprnp6Wn5X7/QCcIunHXmI04uGFDGAP/wkskDQQpo3L+mSloT4EDsm5TZKu2gcos6HOoJWSHhuWpqNYqHLfTUAdAhdKetvzPZdFxDbA9cbynKRrh8Hsj4UqqGeBa/L/dkln9YAiYgHwQU46i+ZI+nqagU4EvqqM4vDY9p+FIuJhF6wE2CxpcRuYXLvfR0dEvAEsSl3rJN1agL4HjskJV2NX1lYyzuEaERcDr6Wi3ZKOVUQcBzi9Lb8CR0n6pxXNmA9FxAHAz8ARudUsA10KvJoDWyS5SncmEbEFODcVThjIFfTRHFgvaVVnNP/Hr3WbwbLKQHcA9+bAfZLWdgxk3WawrDXQGuCBHHhQ0m0dA1m3GSxrDHQ1sCEHNkpa2jGQdZvBstRA5wDv5cBWSQs7BrJuM1gWGuh4YFcO/AbMkLSnC6iIcC/uk/7w1De7FMYvgbk5uEjSmx0BXQRsTl07JZ1UgOpIf0LSio6A3EneWGd4AZoHfJQTdtdcSd9MJ1REnADszCuUVZ0paUfdftTBtUHSsmkGet5Z1UymGugMYEc+4BbETXg5UqaULSImspUt+udJ+thKmj113cK6CZ8v6YuppImIkwFfGMuNpn8La6URcWRaaU5CuAtYPFVQCeMeqDT5btBsnV/KS/e7Bjn9HeClJbCllo3rvnST46ZYxq2OA9mB3ZNBF0W3Ay9VUI6pjcBdo2ZfZtPdeTwUfYZZIundZjhMdpW2pRzUxX1e65LwDPAi4N6pb0XPCnwecAVwXZXa3sNummhaZqDLauKMqUequ1o97WPGdzbf1f2zuA32z3evchzUa/yx4eY6ZlpbqAHmknB/dQiOmnhbgdtLak+2uNX3obJBRLiiLwEuq86+Qfs7WF9xLLoCt32DkYAaVnOXMLtyk6eL+3ZJ+rYtRP3cv6M1mouz2UyAAAAAAElFTkSuQmCC"

/***/ }),

/***/ "MtKN":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fillRef = fillRef;
exports.composeRef = composeRef;
exports.supportRef = supportRef;

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function fillRef(ref, node) {
  if (typeof ref === 'function') {
    ref(node);
  } else if (_typeof(ref) === 'object' && ref && 'current' in ref) {
    ref.current = node;
  }
}
/**
 * Merge refs into one ref function to support ref passing.
 */


function composeRef() {
  for (var _len = arguments.length, refs = new Array(_len), _key = 0; _key < _len; _key++) {
    refs[_key] = arguments[_key];
  }

  return function (node) {
    refs.forEach(function (ref) {
      fillRef(ref, node);
    });
  };
}

function supportRef(nodeOrComponent) {
  // Function component node
  if (nodeOrComponent.type && nodeOrComponent.type.prototype && !nodeOrComponent.type.prototype.render) {
    return false;
  } // Class component


  if (typeof nodeOrComponent === 'function' && nodeOrComponent.prototype && !nodeOrComponent.prototype.render) {
    return false;
  }

  return true;
}
/* eslint-enable */

/***/ }),

/***/ "NCSo":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAA9pJREFUWEfFmFvIpWMUx39/FEqOk3JhkpQQhWYStxiaHHLhlMa5ycVkSiiNC6cLmnJIGuMU04iEEpkUF0LRUCSUC6OUlBFyPv31/6z36/2+2Xu/z/6+b7Ju9t7vu571/N71rvWstbb4n8W2gLML49X8WJTY3gM4AzgF+B14Q9J7LUYL5hHg6tJfvSgg2ycDDwP57MsTwDWS/hkHNgImqgsHsn0FsAnYe8ymGyXdOOreGJjHgGun9pDtPYGNwPreZj8CDwHHAufW9T+AIyR93YeaCCPNBFSz2D4IeLZiplv3EXCepB212TsVT7m/TtKDneIQTPSagWwfA7wEHNV7gueByyX93Nv0euC++r1Z0tp8b4FpBrK9Gnga2L82MnAbcLukfJ+V0n25LrwmaVUrzC5Ati8F1gAnAPv19sn3zpvxxhpJL4wJ2Kz9sO59ChwH9FM7t/4L4HkPMwfIdjxwyUBA7ah4SdyMFNvx4g9189fybHfOTISZBbK9DnhgAkzOk1eAqyR9O5QFtn8B9h2hN9Yzne7Ma7D9RVK0LuagS3z81DP4l6Q8bZPY3gkcPE95EGbGQ5U9n9TinCeHS8rngqQCOHHW91ATTAeUDOqyYpukrtBNDTQmmx6vMjInG8cZj4dSAlJ7IlskJcumljEwzwEXjcqmSUApAfeWwv2S+iWhCWyac2bIYDx0E3B3Kd4j6eahRf37SwnTxdAG4I7a5E5Jt7YCLTXMooB2B0wHNPUr210wHVC/Og8GdQtMtbXpjT6XlLa2WRLUSfMna8VWSZeNW90Ck7W2Yy92t0ta0UxTJ/UqYFstel3S6aMMtMIU0DfAoWXnEEnftULFQ8uBL2tBFh4mKe3nrEwDU0DfAweUgQMlddV/kKsrrp8BR5f2U9XxzXaBdSxc2LM2sTbZ/q3X/O8zTRx1QFcCqTktMgSzF/BnGfpbUn43y2xPbTsjzUz/O0G2VA89tlDaTuwkhiI7JS1rppnf5NtOpb8YOB44shcHsbkdWDlUKG2fCHxQEB9Liq1m2WXqqAB+NN1hz8qcFsL2WQX74ogEOKemkyyfup2ZA9QIcyrwdsFmBrtAUveKcgbdUINkVDZJuq7ZPf1X1gITw7ZXAu/2NvkKOF/S+zXV5nVl8oislbR5aqBWmM6w7fRMGaczVkdybm0FMkzmX5BIGv3lktJfN0uX9omZ/qgy2HbaPhN4Bsh4PUo2SLqrmaQUc1KfBrw1LoAnGbSdTMyfDCk/neQMyj8ft0wLE/0A5YTOhBlvNU8H/c1snwSkiOaEflNSxqoFSffKArVMUpc9CzK2FIv+BZ3ty76M2IUNAAAAAElFTkSuQmCC"

/***/ }),

/***/ "NH7q":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.downloadRecord = downloadRecord;
exports.hasError = hasError;
exports.initRecordRTC = initRecordRTC;
exports.playRecord = playRecord;
exports.recordAudioInsert = recordAudioInsert;
exports.startRecord = startRecord;
exports.stopRecord = stopRecord;
var _recordrtc = _interopRequireDefault(__webpack_require__("mbvs"));
// getDisplayMedia 提示用户去选择和授权捕获展示的内容或部分内容（如一个窗口）
// getUserMedia 会提示用户给予使用媒体输入的许可，媒体输入会产生一个MediaStream，里面包含了请求的媒体类型的轨道。此流可以包含一个视频轨道（来自硬件或者虚拟视频源，比如相机、视频采集设备和屏幕共享服务等等）、一个音频轨道（同样来自硬件或虚拟音频源，比如麦克风、A/D转换器等等），也可能是其它轨道类型。

var _videoFormat = 'mp4';
var _videoType = "video/".concat(_videoFormat);

// 录制相关 Stream 流
window.recordStream = {
  desktopStream: null,
  // 屏幕画面&系统声音 由 getDisplayMedia 提供
  voiceStream: null,
  // 当前主播麦克风声音 由 getUserMedia 提供
  localStream: null,
  // trtc 初始化本地音视频流对象
  trtcStream: [] // TRTC 音轨道
};

// 录制 RecordRTC 对象
window.recordVideo = null;

// 保存录制时的 blob 对象
var binaryData = [];

// 检查用户浏览器录制情况
var hasGetUserMedia = !!(navigator.getUserMedia || navigator.getDisplayMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia);

// 初始化录制器
function initRecordRTC() {
  if (!hasGetUserMedia) {
    alert("Your browser cannot stream from your webcam. Please switch to Chrome or Firefox.");
    return;
  }
  window.recordVideo = null;
  window.recordStream = {
    desktopStream: null,
    // 屏幕画面&系统声音 由 getDisplayMedia 提供
    voiceStream: null,
    // 当前主播麦克风声音 由 getUserMedia 提供
    localStream: null,
    // trtc 初始化本地音视频流对象
    trtcStream: [] // TRTC 音轨道
  };
  requestUserMedia();
}

// 开始录制
function startRecord() {
  var success = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  var error = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  console.log('window.recordVideo', window.recordVideo);
  captureDisplayMedia(function (stream) {
    console.log('captureDisplayMedia', stream);
    window.recordStream.desktopStream = new MediaStream(stream);
    // 添加主播麦克风音轨道
    var mainTrack = null;
    if (window.recordStream.voiceStream) {
      console.log('window.recordStream.voiceStream.getAudioTracks()', window.recordStream.voiceStream.getAudioTracks());
      mainTrack = window.recordStream.voiceStream.getAudioTracks()[0];
    } else if (window.recordStream.localStream) {
      console.log('window.recordStream.localStream.getAudioTrack()', window.recordStream.localStream.getAudioTrack());
      mainTrack = window.recordStream.localStream.getAudioTrack();
    }
    if (mainTrack) {
      window.recordStream.desktopStream.addTrack(mainTrack);
    }

    // 初始化 RecordRTC
    window.recordVideo = (0, _recordrtc.default)(window.recordStream.desktopStream, {
      type: 'video'
    });
    // 初始化 binaryData
    binaryData.splice(-1, binaryData.length);
    binaryData.push(stream);

    // 开始录制
    window.recordVideo.startRecording();

    // 录制视频渲染
    document.querySelector('video#record_rtc_video').srcObject = stream;
    var url = (URL || webkitURL).createObjectURL(new Blob(binaryData, {
      type: _videoType
    }));
    document.querySelector('video#record_rtc_video').src = url;
    success && success('ok');
  }, function (err) {
    console.error('captureDisplayMedia', err);
    error && error(err);
  });
}

// 停止录制
function stopRecord() {
  console.log('window.recordVideo', window.recordVideo);
  // 停止录制
  window.recordVideo && window.recordVideo.stopRecording(function () {
    // 初始化视频渲染
    document.querySelector('video#record_rtc_video').srcObject = null;
    document.querySelector('video#record_rtc_video').src = null;

    // 初始化 binaryData
    binaryData.splice(-1, binaryData.length);
    binaryData.push(window.recordVideo.blob);
    var url = (URL || webkitURL).createObjectURL(new Blob(binaryData, {
      type: _videoType
    }));
    document.querySelector('video#record_rtc_video').src = url;
  });
}

// 检测是否存在异常
function hasError() {
  return !window.recordVideo ? true : false;
}

// 下载录制视频
function downloadRecord() {
  console.log('window.recordVideo', window.recordVideo);
  // 初始化 binaryData
  binaryData.splice(-1, binaryData.length);
  binaryData.push(window.recordVideo.blob);
  var url = (URL || webkitURL).createObjectURL(new Blob(binaryData, {
    type: _videoType
  }));
  var fileName = new Date().getTime() + "." + _videoFormat;
  var aLink = document.createElement('a');
  document.body.appendChild(aLink);
  aLink.style.display = 'none';
  aLink.href = url;
  aLink.download = fileName;
  aLink.click();
  document.body.removeChild(aLink);
  window.URL.revokeObjectURL(url);
}

// 播放录制视频
function playRecord() {
  console.log('window.recordVideo', window.recordVideo);
  var recVideo = document.querySelector('video#record_rtc_video');
  // 初始化 binaryData
  binaryData.splice(-1, binaryData.length);
  binaryData.push(window.recordVideo.blob);
  var url = (URL || webkitURL).createObjectURL(new Blob(binaryData, {
    type: _videoType
  }));
  recVideo.src = url;
  recVideo.srcObject = null;
  recVideo.controls = true;
  recVideo.volume = 1;
  recVideo.play();
}

// 当录制过程，有音频插入时
function recordAudioInsert(trtcStream) {
  // trtcStream 记录音轨道
  window.recordStream.trtcStream.push(trtcStream);
  // 停止录制
  window.recordVideo && window.recordVideo.stopRecording(function () {
    // binaryData 追加录制视频
    binaryData.push(window.recordVideo.blob);

    // 整合 stream 流
    var stream = mixerTRTC(window.recordStream.desktopStream, trtcStream);

    // 初始化 RecordRTC
    window.recordVideo = null;
    window.recordVideo = (0, _recordrtc.default)(stream, {
      type: 'video'
    });

    // 开始录制
    window.recordVideo.startRecording();
  });
}

// 混音 TRTC
function mixerTRTC(stream1, stream2) {
  var ctx = new AudioContext();
  var dest = ctx.createMediaStreamDestination();
  if (stream1 && stream1.getAudioTracks().length > 0) ctx.createMediaStreamSource(stream1).connect(dest);
  if (stream2 && stream2.getAudioTrack()) ctx.createMediaStreamSource(stream2).connect(dest);
  var tracks = dest.stream && dest.stream.getTracks();
  tracks = tracks.concat(stream1.getVideoTracks()).concat([stream2.getAudioTrack()]);
  return new MediaStream(tracks);
}

// 混音
function mixer(stream1, stream2) {
  var ctx = new AudioContext();
  var dest = ctx.createMediaStreamDestination();
  if (stream1.getAudioTracks().length > 0) ctx.createMediaStreamSource(stream1).connect(dest);
  if (stream2.getAudioTracks().length > 0) ctx.createMediaStreamSource(stream2).connect(dest);
  var tracks = dest.stream.getTracks();
  tracks = tracks.concat(stream1.getVideoTracks()).concat(stream2.getVideoTracks());
  return new MediaStream(tracks);
}

// 捕捉屏幕媒体
function captureDisplayMedia(callback, error) {
  var params = {
    video: true,
    audio: true
  };
  if (navigator.mediaDevices && navigator.mediaDevices.getDisplayMedia) {
    navigator.mediaDevices.getDisplayMedia(params).then(callback).catch(function (err) {
      console.error(err.name + ": " + err.message);
      if (err.name == 'NotFoundError' || err.name == 'NotAllowedError') {
        // alert("用户拒绝了使用权限");
      }
      error && error(err);
    });
  } else {
    navigator.getDisplayMedia(params).then(callback).catch(function (err) {
      console.error(err.name + ": " + err.message);
      error && error(err);
    });
  }
}

// 请求用户媒体
function requestUserMedia() {
  getUserMedia(function (stream) {
    window.recordStream.voiceStream = stream;
    console.log('checkUserMedia', stream);
    // document.getElementById("record_rtc_audio").srcObject = stream;
  }, function (err) {
    console.error("getUserMedia", err.name + ": " + err.message);
  });
}

// 获取用户媒体
function getUserMedia(callback, error) {
  var params = {
    audio: true
  };
  navigator.getUserMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia;
  if (typeof navigator.mediaDevices.getUserMedia === 'undefined') {
    navigator.getUserMedia(params).then(callback).catch(function (err) {
      console.error("getUserMedia", err.name + ": " + err.message);
      error && error(err);
    });
  } else {
    navigator.mediaDevices.getUserMedia(params).then(callback).catch(function (err) {
      console.error("getUserMedia", err.name + ": " + err.message);
      if (err.name == "NotFoundError" || err.name == "DevicesNotFoundError") {
        //required track is missing
        alert("没有找到合适的媒体");
        console.error("没有找到合适的媒体");
      } else if (err.name == "NotReadableError" || err.name == "TrackStartError") {
        //webcam or mic are already in use
        alert("网络摄像头或麦克风已经投入使用");
        console.error("网络摄像头或麦克风已经投入使用");
      } else if (err.name == "OverconstrainedError" || err.name == "ConstraintNotSatisfiedError") {
        //constraints can not be satisfied by avb. devices
      } else if (err.name == "NotAllowedError" || err.name == "PermissionDeniedError") {
        //permission denied in browser
        alert("浏览器拒绝权限");
        console.error("浏览器拒绝权限");
      } else if (err.name == "TypeError" || err.name == "TypeError") {
        //empty constraints object
      } else {
        //other errors
      }
      error && error(err);
    });
  }
}

/***/ }),

/***/ "Ngpj":
/***/ (function(module, exports) {

//

module.exports = function shallowEqual(objA, objB, compare, compareContext) {
  var ret = compare ? compare.call(compareContext, objA, objB) : void 0;

  if (ret !== void 0) {
    return !!ret;
  }

  if (objA === objB) {
    return true;
  }

  if (typeof objA !== "object" || !objA || typeof objB !== "object" || !objB) {
    return false;
  }

  var keysA = Object.keys(objA);
  var keysB = Object.keys(objB);

  if (keysA.length !== keysB.length) {
    return false;
  }

  var bHasOwnProperty = Object.prototype.hasOwnProperty.bind(objB);

  // Test for A's keys different from B.
  for (var idx = 0; idx < keysA.length; idx++) {
    var key = keysA[idx];

    if (!bHasOwnProperty(key)) {
      return false;
    }

    var valueA = objA[key];
    var valueB = objB[key];

    ret = compare ? compare.call(compareContext, valueA, valueB, key) : void 0;

    if (ret === false || (ret === void 0 && valueA !== valueB)) {
      return false;
    }
  }

  return true;
};


/***/ }),

/***/ "P4e/":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "PK9/":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "Pe7w":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAAXNSR0IArs4c6QAAA6hJREFUaEPtmk1IFGEYx//PrGZp1CWTiiAiuhV2qkO4I1oQ9HEogw4RBH1QVO5sChmkBhUUO1pEYJc6RER2KAyEStzdoI9DJHVKqlOX8hCVVpY7/5jdmWXcXT92HZ0JnNMw79f/9zzPvu/zvu8K/vNH/nP9yAmw5QoX/DSwHgYqhSjzEpKCISjoK1Xwsvu4fM/UkgWgtnGXQVwDUe6l8KyxBQOK4Eg0JPecZaMAkuINdPpKeIYYRUGdEyINYIbN0AjeOyzfL4IHQvz0EoiCUhI7AKxO6hAMlBVhlR1OaYBgOzcxgUeW2P6F87Gu65B4Kt423LYOln4bxGsbQgLYHKuXxyke6wnqbCBxMflRcCmmSaOXls8cO6jzIokGS19jTJNLowDUCFsMoNn8qACt0bC0FAoQ1HkOwHEAV2KanC60H2e7sfSlPTARQPVl1iQMLKxYhgeduyUxnqiqCIcBzAHwJx6WEs8B1Ag3GMBzy2Wdi5djz3gQVRHSFh0PiyuL5ZQ8UN3O9YkEXtiiRHC7OoS9LSJGLuv6DsAUGdSpkwilIYCbUQ37RSRtbbvMlwCmuKoIrwI46vDE9WgIhzMhfAtAUtQ2dJA4kA4dwdW4JsecoeRbAFOkCRFsww0Q+xzhpMfCEvZ9CNkCW0ilV8ctAnvSEAouxELSZIWav2ahXDON2ssi4zXugNhpl9sLoK9DyAlzsIPF7wZxj8B2Rzg1ETjvq3VgvJW07i7nfPmE+yS25Krni4VsolRAvcG5/IouErWZdT0HMBMzEiet3GYilqxyPwD8IDE/b+WpxIlxTZSC2mY0KjgXKtgDAnMqfRbXZKOnAG4M7kYfBXvAjcHd6GMWwA0rTqWPoM4zJFqTc4OgOabJ2dQ8YT0TbSmnMrgbbdU2qiSeWAC10ZBEPQeo0zlvQEENE1gjwJh7ZwLDEsDbIuKD+d4Tko+O1CX1OtMeqGnn2r+J5Clg6sBqck9/cQB1PfXyxlMA0/Kfib48xdua+ysElZ2a/PIshNR2bjUS6Jqc0bNrKQFsi9bLQ88AghGecqbc+YII0BQLywXPAJy/t3zFm/WdJ4eeTKOzAI6z21kPFBLDsyGUK4Rm8oJjWjwwk1dM07IOJO+G/yaTpUVWXLt/yScYkQC6SSxxfSVOJnQzcM0qwFCJgZW/FTx1NRdK7wum+aLbBCgtxtI/Bla4mo06p8Np+6uBFUK9J+SVOV6++4FyAz12FpqVThcyn/uhjSsXcF6C/APUfdNPMejk3AAAAABJRU5ErkJggg=="

/***/ }),

/***/ "Q+cA":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAAEEfUpiAAAAAXNSR0IArs4c6QAAAyBJREFUWAntV71rFEEU/727MwENhx+9gn+BRdRCUliolURICjEGJIhGEESJbFBLhVsDNnZq4Uc6IxaChUGwsRIEEcRCjGCnIBg8kCS3429md3Z39nbv9gIXEB2Ym3kfv/fevDcfe0CmiaEbSll+xU4wK0YYavjqeST4FSu4E20jsiPw1TAU3rga2kZkJzSqxb5acbVIeTJgvYZmBEs0t4uiOLzEQir42FIUe0yva2Jj0CsecCxUMIbL8iwMRmELg9vk9ABHNaBiM2LQdWx3rPjqc7wcI1jGD47LaaWKLUOKWY/nnuyuRcQIBFdigZ54csah+0YkpdAu8sqR51pw14YYrkEDBXuZR7cJ7pF32mVGVIhZctOoZYIF9lPYbwozRY5nMlnDsOFHeDskpa5hBKt4awUdR70E4AT7l3AJngwZQCO7hgIzCh8ZlcG4S9BrLtNm5VYZtb9EJ9lIDXWWZbpdIu4mN9E2q2cPg67/mDmQVlI8bk2L3CqkJSXnFV5oQYcz8CnXjq/GLSZZQlZTUEcVg1jD96woTbcvQZ8DwWHm4yW7lt+noaHoHLxKg/W8PQJFgG0t3CHwPFooegjoQaFJpabFZMZRyr9meJpcs5hkH/jqBZUP5Si3s1J3fpIDfcLW0ZIINNhXT/k72NFOFTOYkQ9Wx02iwjErKBxbeE1ZbKBQ779gwzLg7gLrtpc9aTHdxtRjmFZN9nGau4HzcBv7ap6nMMxGFdcQ9CkCX+2jnwvGuuAbb/aLNgP6kQ17gB0l3D80r72++XprO6lufY1qqA2gnBnhvQgcIOo6L/RFruAB86YPtn6STpJ/nLPfhi75494keSDBIxp+EosCTLNEk4a+qaYom+B9/5OfNePkTzOQSfJWjTzAOab8SIzNmXQPQNFgK3KYNRDwFReMYoVfpwoHjVjhsclTVreADgPwxC2FX/IbC9hMZ4sFttvZniyQ6Rx913E7pO8cJ5rYm1IVzGEP0+r+O4kVepzoV3tW3ueh8veASMC38RIDmMgD9cwT3CCmhwC0hyqusr7vWLHOD3S3aBQ/aKqY76b278r/AAajzJ99YhOYAAAAAElFTkSuQmCC"

/***/ }),

/***/ "R07g":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAACDklEQVRIS72Wv4sTQRTHv+8GSQi3/0CwEA7utJ4hKbZJ6w/UE7RQG0ErRbA4sRM70UIQOwUbtfBAPSFnmyZFwrxa70CwEP8Ac4QNMj55YVc3XBI2kPXBNLs77/P2+37MEOZYs9k8GkI4B+A0gDURqevnRPQDwFcAbWPMTq/X+z7LDU17EcdxPUmSB0R0TUTMvCCIKIjIy2q1er/b7Sp4wg4BnHNnAbwSkQjALwAfdBljfK1WGzsYDof1EIIDcD5dR4hoAOCq9/5jnjABsNbeBvAEwAqA9wC2mFmlmGnW2jUAjwFsAvgN4A4zP802/AVo5CKiTlXje9573VTYnHNbIvIw3b+Z/ckYoJqPRqMvKgsR3V3UeRZFCnmkclUqleOakzHAWvscwHWVhZkvTAvbOdfW5957rah5kr1L5XrBzDcoLcVvIqL6nZilubVW1CszT628jJjm5DMRrRhjjpFz7qaIPAOwzcyXZoVWFJAq8hbARSK6pYBdETkJ4Aozv1kS4DKA10T0SQF7IrJujNno9/v7ywA0Go31EMIeEe2TtVYbZDWKoqjT6RwsA9BqtVYHg4H6PSgFEMdxlCTJzzGgdIkWTfI0CYloN98f1tqJJBcqU200ETk1I0dtZj6T64V/ZVq00YoOpUONVnRULACYHBX/ZdgppNRxnUtOeQdObqaXd2RmkFIP/Xy1LOPa8gf5E3leGBJWtQAAAABJRU5ErkJggg=="

/***/ }),

/***/ "RMDC":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAA3pJREFUWEfNmE1rJEUYx/9P9WS7RzKLXhYMrKCHiOfp5JBkISvkIE7nRY2ikP0GvpFlBfWogqtBVz+BERSNa7LJiIeACWwyh92Zs2wOCi5E2IuSCU51Mt1/qZp0djImcbIOsfvUVFc9z6+fet6qBCd8+MrQIzvb4bNxzBEBHgPQA2GPFUPZBLBJ4DelZPlMt/uDfLX2x0lUSLuTw7H+CcbRq6BcIJhpZ51A6hDeFOV87t64Nd/emn+ZtTvqD9ZjXAU40I7Ao+dIKaNwpWuxvH6cnCMtxMlJJ6z9MkPg9WYBIogJlESwQCUVEbXpZh4yW4Ww/lcPGfdIzDyJcQEGSKgD64FrbvaJaZmbiw4DOxSI48MPh9H2tyRHkkUC0QA+c7vOzMh86V471uLEwLlwd2cawGsEvX1ZIsuu0/2iLKz+2SrnH0AWpl4tEXiqScB1V8mbcuP23XZAWudwrO98GPMTks/f/0H87GZyA61QB4DsNulff0wsIyZuRN51l8ofPAhI65ow8N8m+R4Bq1eMpbzHn2nevgNAupD/NPEZCwP1slu8/U0nYBIZYaHvJSL+eh8KuOYVK280Wa7x2ogmriUflMg7nbLMYZaKyfeT8YySoST69i1UK/jrSWiLyHVvqfxCJy3TKksH/nf3fUpK2WJ50G6jDdex/ok4ir5vDIh2Hel9UAdu9yeso0fcSKJPOc5zJnlaIB3kfyJxcQ/oqlcsv9Wu4P8yTxf8DwleaTg4VrylytNialO4pe+ZcmCSnptxHz0uz9QKeZ4EIlusHJ18TZ6qh7+b5GnKjHvWOyc7gT8VkbNWiWAtu1S5cJzCTgIZPbUgfxPEkHl3RC5JLfBnQU5ZHoXL3mJl5jSB9Gh+mjE+bhhEvhRd8FcIDtuBjFzMLpRXTxOoNu4Po86VPf9dNUB3CPbagS7nSW/+1sZpAumJ/l7uRnf2gDZEB/kqiW4z4GVzOZlb3T5NIE4Od+tatboXaduiA3+LZM4CKe+sLK7bj0c9nXZqjg7mdKy3GkBSTeGWpc2pawX/C4CX/rewD/ouk/FHDReR2VQlRqXUVPpKhzFUqoqrAUpd+2GLXJoaNAOUuhbW+lKamnwDlLpjkIVK00ExKaipOkrvQ6XpsqG59UjNdUxrP5SaC6tWMHNs2q3qQgSMCHH+0Cs9wV0HWO7KecWTXun9DQiwh1e+zbTOAAAAAElFTkSuQmCC"

/***/ }),

/***/ "RkMR":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = showInsuranceModal;
__webpack_require__("sRCI");
var _modal = _interopRequireDefault(__webpack_require__("vnWH"));
var _extends2 = _interopRequireDefault(__webpack_require__("uMMT"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__("Q9dM"));
var _createClass2 = _interopRequireDefault(__webpack_require__("wm7F"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("F6AD"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("fghW"));
var _inherits2 = _interopRequireDefault(__webpack_require__("QwVp"));
var _react = _interopRequireWildcard(__webpack_require__("GiK3"));
var _reactDom = _interopRequireDefault(__webpack_require__("O27J"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
// import PropTypes from 'prop-types';
// 弹窗组件
var NormalModal = /*#__PURE__*/function (_Component) {
  function NormalModal(props, context) {
    var _this;
    (0, _classCallCheck2.default)(this, NormalModal);
    _this = _callSuper(this, NormalModal, [props, context]);
    _this._toggle = function (type) {
      var close = function close() {
        _this.setState({
          visible: false
        }, function () {
          // 删除组件
          setTimeout(function () {
            var divs = document.getElementsByClassName('n_modal');
            Reflect.apply(Array.prototype.forEach, divs, [function (item) {
              _reactDom.default.unmountComponentAtNode(item);
              document.body.removeChild(item);
            }]);
          }, 300);
        });
      };
      // 点击确定以后
      if (type == 'confirm') {
        if (_this.props.onOk) {
          _this.props.onOk(close);
          _this.props.update && _this.props.update();
        } else {
          close();
        }
      } else {
        _this.props.onCancel && _this.props.onCancel();
        close();
      }
    };
    _this.state = {
      visible: true
    };
    return _this;
  }
  (0, _inherits2.default)(NormalModal, _Component);
  return (0, _createClass2.default)(NormalModal, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      return /*#__PURE__*/_react.default.createElement(_modal.default, (0, _extends2.default)({}, this.props, {
        visible: this.state.visible,
        onOk: function onOk() {
          _this2._toggle('confirm');
        },
        onCancel: function onCancel() {
          _this2._toggle();
        },
        okText: this.props.okText || '确定',
        cancelText: this.props.cancelText || '取消'
      }), this.props.content);
    }
  }]);
}(_react.Component); // NormalModal.propTypes = {
// };
// 插入弹窗
function showInsuranceModal(props) {
  var div = document.createElement('div');
  div.setAttribute('class', 'n_modal');
  document.body.appendChild(div);
  props.okText = props.okText || '确定';
  props.cancelText = props.cancelText || '取消';
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(NormalModal, props), div);
}

/***/ }),

/***/ "SECW":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAABQhJREFUWEe1mFtsFGUYht93tiAa3NkCNxaIGEOC0WjkQkASAUlUEBHihQKeoggxGLLTVqjRi15oRG13NkRiQDSeALkwoBFQExGNcvACo9HYhBgxlXrDYWdpFEp3XjN/Z9ahdOksg3vV3fm/93vmO/z/95dI+bEdvQRhNYj1nsvnU8qBaQWyjs5CGAmir+zyirR6iYDGtGqG7+PvUoE/DnaYzUvRb+Uih9TLNesWy8JVJzt4YDjgiwKNf05je//BBgEPguiHhQXlTn4eFx0OyHZ0l4BdEBoIbB99JVYde5knaoHVBMo161ZfRuiayNgiHi+5fLceoJyjx3zhnZhNj2VhQanAH4aCGhLIbtZc+NgpYHRkRODtkovlJKspCp4NFyFJzDnYLOCJmFYvLCzyCvxyMNQFQEFk5OObGMxZEqs9l5uGeqPhgCIb29EKCesBmMIn0EsLdwyO1HlATS0a1+vjpyhNJLohLPKKPFwr50mBAns7r6kgdkqYaPSIv0ZbuLmnk8dj0fvPlZ3Xh6aABxafoTDzYjBJUjb4RQIoEd9BGBVGartX5EMXAJluEKodRAsrvALfHK5N64lQNX3Neko+qiVA4m7P5Rch4MCybF77AcwIo/NB2eUjw8FcSoQizayj9yE8HH4/UC7y9ipQY14zK8C34UNxBCZ7r/G3/xPIflbX6xyODNQ30GBh5skC95svuWa97vtYFQLsKRc5PwmMiVCKoyOb124A8wIdy8KGUoHPGKBsXscANAV/Z4AFp4rclRQozeHamNe9FeDT0FdPucjxHLNGE/r70G3yR3iOjTHt7fSTAqVZ194uy/VwUoJt0jYSE9no6L6K8EkItNdzOTeNk3ptbUd7Jcwx2SEWMtxBN4ZAmzyXK+sVTbPedrRRworQ/0razVorH+vCH17xXLalcVCvre1onYS1xr+FNuYctfhCRwjU6blsrVc0zXrbUYeElrDTWpht0RJUsNUAAdu8IpemcVCvrZ3XVgFLjF0GS4MIzfKFfWGEvvZczq5XNM1629E+CbNMhIjZzLXoWr+CoyHQ6Qk2xv3Szr40TpLa3tiukX96OC7hagOUwaSBjdHRrxCmGCFiXtnlZ0lF06zLOroHwp7Qb1fZ5Q0G6LxKJ97yXC5P4yipre1os4Qn4x1ugMa2atq5fhwMSfuYwRSvg78nFb6UdXarrlMFXeYKBWBEA6af6OCh6sQYLy4SWz2Xyy7FUVIb29EWCaajSVSbqQqUdXQbhEOhoCwLi0oFmiPlcn9yzVro+9gZjR4gppVdfj9QwrFPfIQNhnCrATNOdfDnywnU2Kqb/H4ciC4RwV1tyBHWFHebGnXGRGlyGMpuK4P5lwvKwFSwuzrkA0c4CtO8dTwVvfQF16CxLZrS7+NgNBKE15VladMXpEk+tlQjQ3gNFqaf6GRXPAO17uJzJOyIoACIxDZk8EK93Rd0Eyp4UTLHg/EXzF0kFpcK/GpwOdS8SgeROlcxc5JJX3VLIN6T8NFEG3tr7ejBDtzt4U4SD0h4NGrtUOXIiAwWDo5MzZSdV+RtasQZvFG9q8UekjgN4DCEHhA95pHQBJpReGp0HAxKx3aMwtPxmkkcofjCYEsg8Gp0CNbbdcE+I2BN1NoXs0/0/6FIINjR+ytYLOD+6tlXS53oIvBxQwY7gh046UvUBRQXDaYE+JjkW2iy/IEbi2+hx/LRAwtHS538IylEfN2/pxokvL7XsMgAAAAASUVORK5CYII="

/***/ }),

/***/ "TGlF":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAAXNSR0IArs4c6QAAAW1JREFUaEPtWTtOw1AQnAmfioouiDtwgyTU4QJwiEhgxA1oEAkSh4ALAC3BN8gdItLRQMUni2LhYEUiej9jv2hd7+zb2Z21366JyB9GHj8yAp1r2ZUPXAjRgaBpRYqYUDDkBs6GPY6tsAGMOQt++okRBNte/oiXxjr2/psE2325EeDQK/gfMIHbp4RHRV/tgZyL4BTAZogzCj7eSVyyNZDngmy6acIHm4P2r6T7NcVdhiEm6Ql3Fgi8imDLxqepLYk3tvoiOSBN6NTUy3yUX4GSCZhm09Wu9Aq4BmaKUwKzTIXoI9OML9ppBbQCrtrJP54h9BvChysP7YGV74HyrxKFy9xaAwePx7y30WPll7nor9PRDzTRj5Q2eq+jrdMAUyciSqDqauheaF4B3QtZi1H3QvOU6V7IWj2/AB1oVn6g8VCHEVQlpBIyEsrfRiohlVDdJaR7oSUVyn7y6V4oz1BVA43uhTzfIr7w6Ncq39QKqcSwtbgkAAAAAElFTkSuQmCC"

/***/ }),

/***/ "TLe5":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _events = __webpack_require__("vzCy");
/**
 * @see https://zhuanlan.zhihu.com/p/133303180
 * @see https://www.jianshu.com/p/e95d9ffd32e4
 * Events事件做跨级通信
 **/

var eventCenter = new _events.EventEmitter();
var _default = exports.default = eventCenter;

/***/ }),

/***/ "TnzN":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__("Q9dM"));
var _createClass2 = _interopRequireDefault(__webpack_require__("wm7F"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("F6AD"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("fghW"));
var _inherits2 = _interopRequireDefault(__webpack_require__("QwVp"));
var _react = _interopRequireWildcard(__webpack_require__("GiK3"));
var _dva = __webpack_require__("S6G3");
__webpack_require__("PK9/");
var _reactDom = _interopRequireDefault(__webpack_require__("O27J"));
var _recording = _interopRequireDefault(__webpack_require__("RMDC"));
var _moment = _interopRequireDefault(__webpack_require__("PJh5"));
__webpack_require__("Vz2w");
var _dec, _class;
/**
 * 录制中倒计时
 */
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
_moment.default.locale('zh-cn');
// import { initRecordRTC, stopRecord, startRecord, playRecord, downloadRecord } from '../Video/recordRTC';
var RecordTimer = exports.default = (_dec = (0, _dva.connect)(function (state) {
  return {
    ownCid: state.im.v5Data.ownCid,
    recordStatus: state.command.recordStatus // 0：未录制 1：录制中
  };
}), _dec(_class = /*#__PURE__*/function (_Component) {
  function RecordTimer(props) {
    var _this;
    (0, _classCallCheck2.default)(this, RecordTimer);
    _this = _callSuper(this, RecordTimer, [props]);
    _this.state = {
      isShowChange: false,
      // 切换布局弹框是否显示
      recordStatus: 0,
      // 0：未录制 1：录制中
      recordTime: 0 // 单位: 秒
    };
    _this.recordTimer = null;
    return _this;
  }
  (0, _inherits2.default)(RecordTimer, _Component);
  return (0, _createClass2.default)(RecordTimer, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      if (JSON.stringify(nextProps.recordStatus) !== JSON.stringify(this.state.recordStatus)) {
        if (nextProps.recordStatus == 1) {
          this.setState({
            recordStatus: nextProps.recordStatus
          });
          var that = this;
          this.recordTimer = setInterval(function () {
            that.setState({
              recordTime: that.state.recordTime + 1
            });
          }, 1000);
        } else {
          this.setState({
            recordStatus: nextProps.recordStatus,
            recordTime: 0
          });
          clearInterval(this.recordTimer);
          this.recordTimer = null;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {}
  }, {
    key: "render",
    value: function render() {
      var _this$state = this.state,
        recordStatus = _this$state.recordStatus,
        recordTime = _this$state.recordTime;
      if (recordStatus == 0) {
        return null;
      }
      var today = (0, _moment.default)().format("YYYY年MM月DD日");
      var duration = _moment.default.duration(recordTime * 1000);
      var hours = duration.hours() < 10 ? "0" + duration.hours() : duration.hours();
      var minutes = duration.minutes() < 10 ? "0" + duration.minutes() : duration.minutes();
      var seconds = duration.seconds() < 10 ? "0" + duration.seconds() : duration.seconds();
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "record-timer-content"
      }, /*#__PURE__*/_react.default.createElement("img", {
        src: _recording.default
      }), /*#__PURE__*/_react.default.createElement("div", null, "\u5F55\u5236\u4E2D"), /*#__PURE__*/_react.default.createElement("div", null, hours + ":" + minutes + ":" + seconds), /*#__PURE__*/_react.default.createElement("div", null, today));
    }
  }]);
}(_react.Component)) || _class);

/***/ }),

/***/ "UQ5M":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__style_index_less__ = __webpack_require__("vtiu");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__style_index_less___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0__style_index_less__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__index_less__ = __webpack_require__("P4e/");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__index_less___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1__index_less__);



/***/ }),

/***/ "V8Q4":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACwAAABCCAYAAAAsejQrAAAAAXNSR0IArs4c6QAADnZJREFUaEOtWgt0VNW5/v69z8zkBXmQEOCKorwWL6FGpFYeUXtRoCLF0t56W4uAiz6oF2+XtdfHLba1VS/WWttrfUtberH4WKJSERUUVCxPETQiGAjyCCEkhEkyM+ec/d+1z8zJnHNmkkmAvUjmMGc/vv3t73/svUM4gzJnHRcl4vgysZqowBMA6k9ABRjlDLQCOE7EDURUw+CNhpAbn59Kn53BkKCeNmZmmrUGV7KtbgJ4FgNhgJ1umAGi5Kcu7rP+dN8LgT2KxRP5JJ5ZOZ0aejp+jwBfs9qaxYrvZ2CoA0iDTH1mHThYwa3sTIxMAE/lkbyrJ8C7Bfja1TzStu2HGXyFH5gHQTbE2SgOLgFwUpC4u2q6eGgJkcrFeE7A01+1vi0UnmBwATNrZqA/k2vup5hAYDD0pyOB1LP+TH2RbpPRnl4vDBnfXnk1negKdKeAtVa/9rL1W8W82NVgsKMgv25nJWGg3QZiln+C7mT1Z3JCfvxg3h8Kh69dNY12dga6U8DTV1l/UmwvdFnLrlnCwCLGhH4Sl1QS+hcSSiKATAFqMxmNMeCTJsamowrbGhQSdnIVkv35VyRpqHQ8ZBhTXppOH2dVWbYvp72UWMrMP8nGoPudBvi9EQYuKM6pqo4h4jZj9X6FFXtstCQ6cSNJjR+hcHjSP6bTviC+jNGuXpWYC8VPZ18yYFBvwqKxEqP7iFz20en7VpPx7B4bK/eqpD1k0RwRPu7XO1z1zOUU83bkAzzjFb7AshI7mLlXNpFdNkDg1ioD+Ub3We1qVlom92020Wa7/fnXVAAPv/b1vJuzAtZGdtWL8Q0ALkvZtM8JfGOoxIJR0vESZ7McaFG47V0TJ3w8ppyQICaIqWtmhd5wx+wYfeqL8VnM/KLruhxJpNzY5AGEOyeEzyZOX1+fNinc8nYClso0QoC2r70ucpEPsGZ36vPxbQweF0Q1pITwu+owIjI3s/uagfe+AA5HgXwDGFkOTBwI5Mncc32rzsZvtljp+O5pIolmrZkdecn1VJj6XOwaG7wqm0U+/q9hDOrdtYHFbWDN58D2+kzf2jsCzBwCDCnNDfruTQlsOOQJdimDJPCWN75RML4D8Fefa1/BjG8FI9PU8yRuG9+1FI61AX/bDTS2u8r3A3Mj8eRzCV8dlAwUnZWDpxTmvR6H4kwjJCmGvzk7bw/NXcd5BxpiDQAXeSOtVsBfpkdQWdA5u9vqgZc/A0zFHRlaJpi05Q8pJcweTiiOdA566ZYEVtfaGRUE0R1vzsn/NV3xXOwaVsqRgzdXqKoUWDolL2vPh04Br+5j1DZnslrVjzC2ktASB9bWMk7Gk5NxnUtYClwxCPjyACCSRds7G2z8x7q4M64vlBO2rJtTMJ4u/3vr3Urhv5MV0pq/+UshfH1oqANw1AR21ANbjigciSYnl3I+HVnB6ArCDWPSi94cB+57X0Gxp35qkLAhcGFfoKqScEFpWiq2YsxeFUtGQl+2QeawwfmFNGVF2/MAzw5S+X8z8tC/KCmHt/YDa2oZurNg8ep+7oUSYyr8NR7bwfi0UXVkcJlmSagsBBaMEyhNLeg9m+JYeyCLLAxjtAZcw8zDvQyHJbB2TkHHyMt2Kuyoz25UXng3j5c4v8QP+IkdCruP65QzWYK7Ev1CgPDTS4UDXJc/707gyY90fh8oQnyLJq2IHoOCj5fKAsLKa9OA9fI8sEmhOabFGNhmeKLpd8YIjNe7Ok+5820bp+LJ3NghJZihETBzqMCVg9LtXt1n4f7NCZ9N6bZC0A9p0t+izQCKvbMfUSbw6FX5voG1od33vg2lZeGCDhAwpq/AwovSXuXj44xHtip/Uh/YBHypv8D8sX5P9P4hCz99W8dqPztCisU0cXlrK8BpOgEMLRV4apofsMb2P5ts1DZ1DljX+d5YiQkDCG0msHSTjaPRgJQCK7ToYomR5f5VeeeghTs2aE8RSIYE3Upf+Wu0nsB9vWSV5RFWXZcSlOfFh8cYG+sYnzUpxFISC26bSAgMLgF0QGmJ6wEz933aXfUvAkZVCEwbLFCYdkbOaC/sMfHbzUnX5i/iBxrwBwBf4n0hCFj/b4WQ+iFL0RDqW/UP43grO+C0vqMJoM1iJCxACiDPIBSGgd5hoLyAUOH8AAN6kZNrdFYe+zCOZbvMjLkKSdPo0r+cehbgbzqNPWQ8Pb0Aw/v4PbvOGXY3MEaUdz1g51DSb1pN4Fgr4/ySTFJufasN7x7KdGsRIzKCvvLnU3cy+JcBvJh/YRgLxmbG0NvXmTgaJZxXDIysIIwsFw57elk1m9nWJGHrXEPLhFHbpLC3iVFznPH9KgMXB7yK3rhe9WwUCRU0OWo7J6+olC5d3naJsswPHJeT2sLrz+FlAs/MyNRxTSPj3nct2G6k8zhW3a4wTCg0GEwEDTRuMWJO1uiPjBf1l7hlQqYu1teZ+K/1bjbvO3lZvemG3jNoCbN4bVlLAwNlwaV8fFoBxvTN7PSdOoXHtlpQjovKmsJ6ugo6bmBYH4GfXWZkzSVuXtuKfx5x5eBpK8TiD75b9JCzghOWtTzJzPOCgMdVSjx6dSbLut62owr/u8VCayIZEjpLG4ORbfJ5EjddZCCUJQncfMTCotfb0jA68mHYMhQe/N6/5x9IAY5eyMr+MOOkBsADVxZg0sCA30l1qTOy5R9Z2FBnOylmtuJGtnOLJa4fLVHVP3u6qldr7iutqGnU7Gbkwy9svrHkOke27iDjn25+E4wrvGzp59IIYdnMoo5EKBuoE+3AxoM2dhxVOHxKQWdpeltUlk8YUSFwyQCBsZVd71oe2tyOv+5KZA2igsTkf97YW2+Q04AnLGuZaNnqHQLINRCXnaGlEk99rQj5odz7uu64tGCdV/cmsGRDe0bu4JzREdZumVcy1W3jQ1D1VPPjrHhBeiefFv3F/STuu7IAxZHTP0DJNpnVexP45cY2mM5Wzm+gRIixwOitc0s6ToB8gCcuby5tb8cnDK7M1vm/FBEenFqEwaXd2AbnoFpr9o9bYnhmZ7YQnGpMdMe2+SW/9naVscZVT7ZMVKzeADiSJQ1wQuq8cXm4fnTktE+Adh6z8OAHbfiwXtMatJoky0T08sz5JbOCZ8ZZRTnuiRPXQ2F5V+fRffIJ88fl4arBYZTl55aJ3q1sr7ewYlccb+7Pkpx7ApcQYnt5uHjS6zeQvifxlU6taOxjJ24j4F7vSVCwsX4niDC6QmLiuSFo11WeTygvENAHfg2tygnHu46ZeKfOxEmdyKfyYScVCNyJOMxC7CMjPHn7/MLD2d1kF1ob9/iJ21nhno4T9IzZBo+Wujqg9e/Kg6lAsmv6PByKVG+eV3CwM1g5/dTYPzXdqaCc5CgzyJ6OE8vehohqwyGesnlen07B+vxwV0OPfbTpLsXqF1nO+AOH/oEpZez/ghpwDUzUhgjVWxeW1eWiICfDbgejH2n8OQFLcmm6q0ubjAk7cYH2GyFRvX1B6YFcYLvNsAf0EjD/vLMNfxcb6qRCM5wYHQiRqN7xg9L93QHbY8C6wag/NvwCoLscKw9ea2VxQf5MzgOZqC5EYkpPwJ4WYAf0Iyd+xUrd0a27Ws9FYho81RkRo3rnTSW13WXWrddtDQc7HvmH4/coVre7nCVnn8PNkZPOHJQiVP3RD0s+7ynY02bYHWjkw8d+o0A/cy/Hczs++sIIG9W7FqaTmZ6CPm2G3YFG/P7YvQq4LefARIcMEa7e/aPivTnrdlHhjAHrvkf8oeF+pfjWbG7L+U6cHbBnLAkvEcN+X7+UFX7i/S6ZV9NhGUH1J9/ve0Z/2HHGRpdt1YY9VP8AM/4z3TkdEQZV1yyq2HMmMvCRcLY6cvsZ+rtjDzKrxQQ6Ikhc/uniik/P5hhnRcNBQMMerF8CQ67Y8+PymrMJ9qxq2AWmLym/uRJi1Bxwd/7CpKcTOi2GNaiZryDfkijkeKwQJkVMYUWYyGAbZHo2FEYoZNsJTtgWx5lULJEfi/b6uLR1/RKyegq2xwzrO72WdpS3mYkypSh5umI6/1LFhAZswZK2CrHU/9NVnArJWu5jyKAWYaPxvfm9m4go9wVKaoRuMVy9jo2SWOwc05Z9vOwJprBtoxdLyrdVIkI2pMUkbM9Jqc1ssQXLghkLKxGNJexWkskLDw2eSMVDNg5uXVh2sjuM5wQ8bTVHhMRQmGbEZZMV5Ump+iqSBS4423lQUDZgKWjOHHpt0/kNZw42wMpWQolGFmj0EI+wNA9vXVhxJBfonIBnvMIjALPjDoRtKmShBgIStgIcoBqIVGFWXIJEKM8UllAKsBJsMttRm9TJJGI4E9LPtlCtEHTQ1YgGXyjl3lxMdwlYa7ah1RzVoVATkAafD8gIFJzzXz26sknKEA+0LMCyFDRYB7CVfLBZtRBwQgN1ALuMM30BUFSLQwMOh0IncqWcXQKes5vDbbXmGK9xEXiQMGRekt3k4BYrISDOsU0IpWWRAqss0wGolGoWhmx22dVt9M2stOkghD57SAJG3GqsuaV/l7uPnJKY+RoPsS2z2KffiBqobCm1HJKgHe1KVlysgDylpEzYJsMyTRbyFBQ7h77KuT9OTjIuZLNhJ46m/QsQLrJrdt7QL+PwxKvrnICXrGNjWwsGx5RZ1NGQYKiEKmfiEhtCw03qMqVTn7G5HiMlByKOm8zHiemU6+osCWYzfqBm0TmNZ2x0ugMdKK5+oa2fFKFKfaOV9K2mXnoRkqIwoVQB2whDKUNJKROWMshMKBZsg4WWsiUVtVssWgWpeNo7OBo6ZYTML7YuHOA5eu8cdk6GvU3nMMvoP1AWi+r7kDaHca9r8hpn8jmlzY6KyfqGzZYgbjLzE425JBCE3iPAPvB/ZxktQmG0sa1QGiJCFkUgTSOmwkKyKUwd6SihbCuhLCHjQtkJlRdq7xXvFV1/o/+P53LJwPv+/wGFOfVZv9+8kgAAAABJRU5ErkJggg=="

/***/ }),

/***/ "Vp7n":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAhCAYAAADdy1suAAAAAXNSR0IArs4c6QAABQxJREFUSEuNlmtsVFUQgL+5u2y33d2W0gqCsi0Uf9iWEkBAeQioSKQtBUxqoomgLbF/jIkiAYyiP0wE5W0EAxjERBMlEOiLPmIrEkxDgwQ1tNBiKahJaYG2u33u3mPubm/b7W6h8+uemXO+mTNnztwjjCZFcfGI/1VgBUrNBiaC9CP8C6oGXQqZ7DnNU/RHQkiYspAYNOdWlHoXJGZUx0HDP4jaSqb3u5HzQsFnY2fg008B6Q8BjjSfYJxnAyvxmoYhcElUCvq4c8AU0zjTlUb+1PW8kLgcd/TjKBQ3u29RdqeSw83HqPdeH+6gmi7PKnLpNpRBcBV2vM5aIM0YRmlR7EvdyUb3BjTRIgbv030caDrE5roP8SnfwBx1lCxv/hC4yPkpsM1Q2LUoyhecYcmEhWPKxtmWCrJrc4fDV5DlrRQqXQl0qyYEp0E6MvNL8tzrxwQ1J+26sZ9NVz8wh7+R5VkoFDsLUBw0tHNiZ3Fx8bmQ7Td332ZGVQb9KlhVFrHQ/NxVptgnDzrv1/tJ+2Ue17sagzolTwqFjkJEsozxofS9vJWUFxLtT/+dIvfS64O6gqQ8DqbvDdvRjoY9bKn/KKgX9Z5Q7GpCqSRj3LjsCtMd00IWba3bzmeNuwO6qfbH+HPpRWKtrjDwpfbLzD2/ZEAv3wpFzi4g2iiPnpfasGm2kEUv1uRQ0fpzQBdnjSXBlsCxWYfCDre1r41HKpLN6igRihzdIPbRwIkVSbT13R10Nj0mmb+W1gaqZ7jc6W1lYuXAbkWVGhE3ACnGpIZlV0gZkYqvbh6h5v5Fjt/+PsA5OfcH1j4aOJIQCUmFcEQodJ5AeNmYdTB9DwVJgfoOka+bv6Hgj3d4PnEZlQsKw+yGYkfDbrbUbw/aFG8LJa430dVRYzw7NoPaxb+G3bZt9Z+ws3EPl5dcIN2VGgY2yi393HyueY3No9AsTwhlOOh33gLiDe3hmQfId28IWfza73lMsMVzIO2LiNHuatzPprqBCyKUk+lZGewVxY73UbLT+DT6RPn80zybsGgQUtFaxby4OYwfFxcGLm0pZ3XtK+aV9iP+RWR215hNyIrXaXS2Z4JwG3tTd7DR/UbgpkUSownta/qKLXXbh/qEyOdkdm425g+1zZPOiURxARWsEEPSnanku4fapq70wbZ59NbxkW3zNJmedQh6KNgYnbG7EUs1IqHXL2LMw5VSgta5jlX0mtrwX1OxPQllqYIxwkVKkc61w6HhEZvuDDiWapSYdzRyzCJnkc41I6Gjgw1LqT0Zv6UaJNCgIkgZDs8altMTyRieiuGzztinoQXg7pDFRq3GeHJGgz44YpNUZJ8OgZyb8Eq6PKvNn+Zo5/rgiM1Vp6JSsFmrUHKNLk/2w6Bji9iEl45Pxne/hWyM/v1QiRzxx2g8HTuevr44sMZg1W30Y8GCQsSPkl50nxfVc48cOsd2eOcTXbR1T0NUFOKPRykXFosNXQUfGAGwvwfR2kHrQPm8dPfdIJe+kCsT4s2IdJ4jA6Us4EtCadFBu5qEiB1BoasOkPtBJ6oVLK0ofwfZvSHPotBUKIxfVQairCjfVNAcA+BENIlGiQK9AyUdAb2mWlCWu/j97eT0BpqxKeE5LpvkoPdeMsoajabHge5CWWwI1sDjTcOH0nvQpB2leQPROnv/ZjnmOyu4mVGP90fiiIuORddj6LNGYSWYYyU+VH8vusWL1nV/tCr5H1G1zQWjI7W0AAAAAElFTkSuQmCC"

/***/ }),

/***/ "WO9G":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAABBhJREFUWEfNmE1MHGUYx3/PLAImZWdLKiqxnhrU9GBMT9KilASNsYnfNR7o1ZPtzkLQWIxr/Igi7NJ68igejNX6kdQYJYFqW3pqjIfGlvRkDSo2dHZpIuDuPOYdZzfLdKFDaeq8p8nM+/zn//6fj/d5X2Gdw35FN1vLPF726BW4W4V2UdoNjAqzoswq/JqwmPAa+abwrlxezy8k6uSUo08pvKTQhdIQyU4oCZwQ+MDNy5dRbK5JaHNad5aFYZTOKICrzhGmE8rg5TE5tRbOqoSeO6KJ704zinJgBYDgoUxbwlckONPgMStJZn2XFWkvWbRTZoenPInQiWKF7A89+iD9n+2Vcj1idQmlsppSlyMKvVUjYVGEw80Wo3+OyFwUtW4f0LZFj35V9qM0V2wEJiTFXjcrbhjnKkKGjOcyDdxXBRCOJgRnPicXoxAJz2nN6NayklflmZpvv1gpOsOkVhAybvp+mm9rlFERhgp5eed6iIRtbEdfVeUtwP+vUeqRTh6rdd8KQklHx2piRsXihUJOPr0RZCoYdkafV49PKqQQDhXzkq5x53+PfjbByRo3HbxRyqyi1NuV9wnYVcm+qkJJR09VUluEo4W8PBtVmW2HtcnMvbBflqLa2I5+Xo0pYbqYl52BG8EUPU/5wgcTFhuEjqgBnMro/ar84JsKD7s5+TkKKRPoJWWmkn2W8LQpnr5CtqOTquz2QS2GCzl5OQqomZN0dAjlzWAxrxXzYoI20rAz+p56DAaLmSrkpUfM3qRLzPnbgeDdmuDOqHXGAKUymvU8XjfPlsUbbk6ykdgApk79XeZ3v3iabaaJNkmltc+D8QDkZHFMuqICbpSQr3BaTwC7/AXBPkk6Oo7S578QBty8jN5MQilH+z1lJHD5x2KndUqh2yfUwG53RI7fVEID2u2VmAoy7LhR6DxKh3nRaHHPpZzM1COUyugDwBPqXdV6dCk8FAD+CBgXVIdYlICv3Zz8VA93S0Y7lj3OBwrNGIUWFDaZF00pWv7KypWw4fasNv5WYE4Vez3qVeaKULjLpu1sVpbD9rdlddOSy0KwoCtiO1pUpcVXqJHkpWHxP9aOHR/qLRfO8YcqrddJaH7bvdxx5kX5J2y/ZVBblpcp+oSEhcgua3V0e1nYAyGXKT2q9ASAkwiToZ+WEsqx+bycjeqymAV1Wj8C9vlZ9j+kvZ3WAYX3A/XGY1UYExZ98ds6jFQb2VztjB5Uz+8CzcY8VMhJtc+5VkbW3VyN0UbaD5N9JfCrewN0r5ZNYXJrth9m8kYaNNOLG4zVjjb1lFqzQTMGsWthA5Xi0+QbQrE7BvkBHqeDYiX4YnWUrpCK1WVDbZrG5jomXDtic2EVJmaOTbLIHk/oFWVr3Ss94aKlTGgzx9Z7pfcvw56HcwBK5ogAAAAASUVORK5CYII="

/***/ }),

/***/ "Wny5":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAEBJREFUOE9jZKAQMML0x8XF3WdgYFAg0rwHixYtUgSppZ4BRNqMoQzugmFgwGgskBuJSCmRXCOol5QpjkZyvQAAczweEdHiqQUAAAAASUVORK5CYII="

/***/ }),

/***/ "X/W6":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABMAAAAUCAYAAAEYUjbiAAAAAXNSR0IArs4c6QAAAZ9JREFUOBGdUz1LA0EQvQvWKQQhNkLw68BCrSL4B6ys/AcGEUVttBV/gpZKGq1tLBLzBxT9DSnFjyQYLERt5Hxvb+cybjZHuIF3M/vmzcze7l0QwOI47tAzmLA+DiWAP2NsLIQkRvRTwGMF+GRRiaw2knVLbEnCNOADRDIPsTRMkwhKbE77DmFJGPyyTKxqgwbJU6BriYpV9x0SezZJt9vPJMO5E/PSOuHEXbNWXeoiAHcrvIguhcjwV9JAipaVePFfUi8gOrTCI83LIUk3XpExdYBBAZUdGSMCeuGY992H1pqY9/Oo2MiOiRT3wLZlaa0SelxZL6h9ASrAMxdiI+1pDCMWgHWgBVwDYhsIZoGbkc5JqgY89hPJnhw/PyC2hPxGHF8F+Ck1gSmgBkwCrr2C2ASegDWAn2cNR9ziaV04k/Muz3mJ08AwayOxA6wC28AbMMxmTAJbmfNsp+Grgq7p0aaNikjeewRf4HiWqXENkHftDkSRH8871ONpRf6gxzNbAnr5e5hKbijzLz9w38Wu93MNRvEJ8GGb0B9nNfoDDmdI2fruJ4gAAAAASUVORK5CYII="

/***/ }),

/***/ "Xusr":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__("jlIA"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__("Q9dM"));
var _createClass2 = _interopRequireDefault(__webpack_require__("wm7F"));
function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i.return) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
var ShareClient = exports.default = /*#__PURE__*/function () {
  function ShareClient(options) {
    (0, _classCallCheck2.default)(this, ShareClient);
    this.sdkAppId_ = options.sdkAppId;
    this.userId_ = options.userId;
    this.userSig_ = options.userSig;
    this.roomId_ = options.roomId;
    this.isJoined_ = false;
    this.isPublished_ = false;
    this.localStream_ = null;
    this.client_ = TRTC.createClient({
      mode: 'rtc',
      sdkAppId: this.sdkAppId_,
      userId: this.userId_,
      userSig: this.userSig_
    });
    this.client_.setDefaultMuteRemoteStreams(true);
    this.handleEvents();
  }
  return (0, _createClass2.default)(ShareClient, [{
    key: "join",
    value: function () {
      var _join = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator().m(function _callee() {
        var _this = this;
        var _t, _t2;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.p = _context.n) {
            case 0:
              if (!this.isJoined_) {
                _context.n = 1;
                break;
              }
              console.warn('duplicate RtcClient.join() observed');
              return _context.a(2);
            case 1:
              _context.p = 1;
              _context.n = 2;
              return this.client_.join({
                roomId: this.roomId_
              });
            case 2:
              console.log('ShareClient join room success');
              this.isJoined_ = true;

              // create a local stream for screen share
              this.localStream_ = TRTC.createStream({
                // disable audio as RtcClient already enable audio
                audio: false,
                // enable screen share
                screen: true,
                userId: this.userId_
              });
              _context.p = 3;
              _context.n = 4;
              return this.localStream_.initialize();
            case 4:
              console.log('ShareClient initialize local stream for screen share success');
              this.localStream_.on('player-state-changed', function (event) {
                console.log("local stream ".concat(event.type, " player is ").concat(event.state));
              });
              this.localStream_.on('screen-sharing-stopped', function (event) {
                console.log('share stream video track enned');
                _this.leave();
                // document.getElementById('screen-btn').setAttribute("src",require('../../../assets/images/prevention/screen-off.png'))
                // $('#screen-btn').attr('src', './img/screen-off.png');
              });

              // publish the screen share stream
              _context.n = 5;
              return this.client_.publish(this.localStream_);
            case 5:
              _context.n = 8;
              break;
            case 6:
              _context.p = 6;
              _t = _context.v;
              console.error('ShareClient failed to initialize local stream - ' + _t);
              //用户取消分享屏幕导致推流失败
              _context.n = 7;
              return this.client_.leave();
            case 7:
              this.isJoined_ = false;
              // document.getElementById('screen-btn').setAttribute("src",require('../../../assets/images/prevention/screen-off.png'))
              // $('#screen-btn').attr('src', 'img/screen-off.png');
            case 8:
              _context.n = 10;
              break;
            case 9:
              _context.p = 9;
              _t2 = _context.v;
              console.error('ShareClient join room failed! ' + _t2);
            case 10:
              return _context.a(2);
          }
        }, _callee, this, [[3, 6], [1, 9]]);
      }));
      function join() {
        return _join.apply(this, arguments);
      }
      return join;
    }()
  }, {
    key: "leave",
    value: function () {
      var _leave = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator().m(function _callee2() {
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              if (this.isJoined_) {
                _context2.n = 1;
                break;
              }
              console.warn('leave() - please join() firstly');
              return _context2.a(2);
            case 1:
              if (!this.isPublished_) {
                _context2.n = 3;
                break;
              }
              _context2.n = 2;
              return this.client_.unpublish(this.localStream_);
            case 2:
              this.isPublished_ = false;
            case 3:
              _context2.n = 4;
              return this.client_.leave();
            case 4:
              if (this.localStream_) {
                this.localStream_.close();
                this.localStream_ = null;
              }
              this.isJoined_ = false;
            case 5:
              return _context2.a(2);
          }
        }, _callee2, this);
      }));
      function leave() {
        return _leave.apply(this, arguments);
      }
      return leave;
    }()
  }, {
    key: "handleEvents",
    value: function handleEvents() {
      this.client_.on('error', function (err) {
        console.error(err);
        alert(err);
      });
      this.client_.on('client-banned', function (err) {
        console.error('client has been banned for ' + err);
      });
      // fired when a remote peer is joining the room
      this.client_.on('peer-join', function (evt) {
        var userId = evt.userId;
        console.log('peer-join ' + userId);
      });
      // fired when a remote peer is leaving the room
      this.client_.on('peer-leave', function (evt) {
        var userId = evt.userId;
        console.log('peer-leave ' + userId);
      });
      // fired when a remote stream is added
      this.client_.on('stream-added', function (evt) {
        var remoteStream = evt.stream;
        var id = remoteStream.getId();
        var userId = remoteStream.getUserId();
        console.log("remote stream added: [".concat(userId, "] ID: ").concat(id, " type: ").concat(remoteStream.getType()));
        console.log('subscribe to this remote stream');
      });
      // fired when a remote stream has been subscribed
      this.client_.on('stream-subscribed', function (evt) {
        var uid = evt.userId;
        var remoteStream = evt.stream;
        var id = remoteStream.getId();
        remoteStream.on('player-state-changed', function (event) {
          console.log("".concat(event.type, " player is ").concat(event.state));
        });
        console.log('stream-subscribed ID: ', id);
      });
      // fired when the remote stream is removed, e.g. the remote user called Client.unpublish()
      this.client_.on('stream-removed', function (evt) {
        var remoteStream = evt.stream;
        var id = remoteStream.getId();
        console.log("stream-removed ID: ".concat(id, "  type: ").concat(remoteStream.getType()));
      });
      this.client_.on('stream-updated', function (evt) {
        var remoteStream = evt.stream;
        console.log('type: ' + remoteStream.getType() + ' stream-updated hasAudio: ' + remoteStream.hasAudio() + ' hasVideo: ' + remoteStream.hasVideo() + ' uid: ' + uid);
      });
      this.client_.on('mute-audio', function (evt) {
        console.log(evt.userId + ' mute audio');
      });
      this.client_.on('unmute-audio', function (evt) {
        console.log(evt.userId + ' unmute audio');
      });
      this.client_.on('mute-video', function (evt) {
        console.log(evt.userId + ' mute video');
      });
      this.client_.on('unmute-video', function (evt) {
        console.log(evt.userId + ' unmute video');
      });
    }
  }]);
}();

/***/ }),

/***/ "YeOf":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAbCAYAAAB4Kn/lAAAAAXNSR0IArs4c6QAAAtpJREFUSA29VU1rU0EUzXtpviBSTMnCukiC5gPBXaGrVFFXCom77gV/gKCIBVdCRRT8AYJ7dybgrha1q0J2YmkTIX0LKySkUhLIF0k85zFTbvLei9JFBx535t5zz5y5M2/G8M1pzWbzwvHx8WNACpPJ5CqhhmH8hCnHYrE38Xi8TZ9bM9yc9O3v79+CeY8vwbFLs+B7kMvltl1iPtPNSVIo20IsAbvj9/sL4XB4mR/79KnYlhLgoHEo5vJbrdZ3lbiZyWSeg2gsM1EWs1qtvoDdgN9aWlq6PlsWh2JVU1upGykn4EQqZitXOXJu11IUiTBN8/WsUpnJGDHKV5Ax9h2KsbwrDAQCgQrtvKYx+sRIrIMYwSgByWTytwS69QXGzpGYBTmQfez2RI9xpKY2WcY0Zta6KZ7FnGnsqXhWpWSXMS/1569YKpEKqVzG5Epk//wVz6qUamTMS/3CwcHBJyZls9l7Mvmsfc1n4q9Zw3e30WjoQ94h6eHh4aV/kQuMncMLjFzkZI2PSNDpdC7T4g7gRe4bDocrtPOaxuicdru9rPBHJpx7HAC0ppxl2vF4/AQze24uY8TIHM0Bzh8kLqngOi2fHBgLiXl15zrISapieWJVDtNtDnCWDcuyLvZ6vTrAi3gdbqbT6a/YafsFgQ8YY4fXo77JuHy1mjxigEzu4JRs12q1G6PR6At8J3hpUvblgp18BsAmZqxFIpHVRCLxh+QY/9ebR3HdbncX+DSIN3DCXtrE9Xo93O/3+RqsUCFmLJJcvNJFTGzf04hPvdJqxSXEWZZKKBTKp1Kp3ul1CNU8FbsA0NZQlocsC/qeTS3/HQBU+gt2FWppfafEHJAcxB/RtY8awJ/R/4D6fotGo3YCj6Xa/XVgbzMPrQLsfU1KxxQxHSzLYDB4hO5TJC7S59VAdoLYq2Aw+JbLlzgHsQ6ydqg7a8vvGvynhx+Ee/hKqGeJe6FzpP0LVPttoJtaloYAAAAASUVORK5CYII="

/***/ }),

/***/ "Z1a+":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAAtBJREFUWEftl9uLzVEUxz9flOQyLn+CRvKGmQe3RsnLPCCUB+TejDDjhb9BiRCjxkzNUJQHD1JSHqQMMUjeyIMHeRCD3CaXpTXt39jnOGfm95s5N2XX72Wfvb/rc9Zae++1RI0N1RgP/w6QmU2A1MAm6VcpvJ3jITPbAOwFFgGzMhoYAB4BHZKuZNw7vHwIyMymAaeBbWMVytvXAxyQ9CmrXgLUDezM2+whsJSCruMhjke3pN0p9//xkJktBu4HQQc4BZwBXqTNi5Bvc90r4XMD/ocaJXkYUw+ZWeydHkk7Uu8usNDMPFxJ6Ef0kplNcglJPxIpB+oDloSJBkkPxwnUADwIGnclLc3XM7OZwAlgEzARuAS0SvrqQO+iE1Un6eM4gWYAH4LGgKTZsZ6ZzQeuAvV5dm5KWu1Aw4krqSQXZTFNM2sGLgJ1EYzbT+zOqxiQmR0CjkSn8XPItXZgRQBcWXYgYApwDtgSeeUlsFbSEzO7BTRVEsgTvDGCuQ1slPTG56oBFOduJ7Bf0vdkslpAfs+0S+oocAVUPGRPgTZJbvivUQ0PPQtAN2oFyDl+AoclHa+FkMUMvUCLpMFqJvUdYFlEdQ9YL+l1tY79ZK8igV0R1CtgnaT+iid18j6aWRtwDBgqOYBvgBdwrcDyMNdU9qcjfrDNbBVwGcipACLP1Zej/PCX/P0I5YdXll5+LMg7cdclNTuQJ11SRHnJ2V/ovkg7Z2b+bnlJ7KNPUpzQQ5NmNh04CmwOIbwQmoJBB+qKEq5X0va0xotcdOeBreG3Lkl7iumZeTunnEbCgbwH8xc56Rr8RPj3PFxoafg8Ub0C3BeS1Pd4ke8l8eM0AsmapA3yeiVzyzKKoU5JLVlgfG0CNBU4mXdXZNWK1/sfPCjpS1aR/FZ6TXD5QmBOgeavmL6H521opc9KupYVJCdkY91cjn0l6TJKCfYfaDRv/gYuAGZGEX2aQgAAAABJRU5ErkJggg=="

/***/ }),

/***/ "aX42":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAAAWCAYAAADTlvzyAAAAAXNSR0IArs4c6QAABD5JREFUSEutlm9sU1UYxp/39HZAtlVBt2XGDxqiKDimEYJoYlzwD2CignA70bCtHZABW/cFYggfNMaYENS2Tghb70rEQFv+LKgQp4YlS0SRmWzIFBJhUcN/omYszG7teUwHG213S8B4vt17nvf9nfc9zzn3CrJGsDVWpKk3AZgHigFhuxK1vsFjXsrWpj9v/WRf8dDQ8CYCzwuQBNiZ51Tr66rMM+k6SX8Ihzsm9usLx0g8kJW8t3xqyaMVFRUJO+i2ri7nYPevPQAezpgXOaMmFE5veGNh/+j7DGDQijRq4kObpJcn5OXNqFu++GLw04Muxq88Dsidyonu+uVmn3/n/hIZ/KeX5F3ZsaLURp/HfNcWGLCiu0kuyQrScKj5jTXm18HW6GtaownglJRGRAhB2CXFa/px6Rkm9QEAKit+X2Nt5au5gIdIVmS1ZVej170saEXKSRwl4BxfhWz2edzr/KFIBIA7Y89EvvF53c/ZA0PRFoK16QFKybIGj3tXwIpsI7HSbg8FEp85tbigp+9iJTR3ZALR7PNWrspRYWwRqfdlBCjHUz7P0sMBK/ItiSdzOVWAMnE4JutksjNd4xD1cr3X/MwWSFIFW2M/kZw+KnAoNa/eYx7yW9HDIOfmAhqG8UiC+h4k9VdjyUWON3jMchHRtsDUy4/CsTKt2UNyxMGi1Cqfx2wOWJEQCW+Oll4tdcnd5wdQrbXecl2jDcOYubZ6SW9Gx7ITdHR0GD2nLl4GeMcIEPK5r9b9UiAcXcgkUy4cNwTY6autfD1gRb8g+eK1OPxV6lJFpmkmbYGWtb9wAPEVBFeCnJbWgmGncj5UV7O4L9gaO0JydmYCicPhKDMMzeE4fwFojM2LnFQQq1A5W2pqFv19fSFAIBxbhqT+gECJbQUie31e95Lg9rapTAx1EywY1SmRlQ1ed4vfiraBfMV+j+VPJXgzpRN/KLIawMe5zDCyKpGfaciCxirzd78VOQpi1qh+Ukl+vr6cKI4n4wfHXW1ZSUXJBvGHomcBlubYm1MQtc7nNdtS89cOvxwhOOGGi2V+vcfdPjIf3r2YSb2Z4P05zDUgfivSB+K+bIGIHDAKpXKNaQ4Ew5EnqGUjyQU2V1eqBd8BeL/R696b8sIVDEZBpLSZQ3BamkLRpxOC5kyjyI+lLplzvqDA4LkrWwFUjx6Tm7UeIp2T8ozKB++dcunY6Qs/kHhszHyCE4RaMfa12GLFpg0JZytKqSh8ubZ6aW+wNdZO8tmbQrKLEPw2Mc85d1CzSCX0C4A+a0B1rfaaJ8dcapewqXXPnIROfH87sBvVyNs+r/utHL6wT9m0fc+MRCJx/D8BlWzwedzv3RYwJQ5Y0TUg3yEw+VbAqe8jyTanS1WlzHbbwFRALBbLOzcgs4DkdECmgXQBkk/SgGBQIFcJ+cNBnjCccjT7H2a8UW9l6f+j5l+D7McFm7jQPQAAAABJRU5ErkJggg=="

/***/ }),

/***/ "acLb":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAbCAYAAABm409WAAAAAXNSR0IArs4c6QAAAtRJREFUSA21ljtvE1EQhb1rUrhwQxcLLKTIDyqa/IC0YIngggIpDQ0lUopEdIguSopIlEnhBokuGIShzQ+gocIPRUIGOR2Ft3CBbPOd5c6yzq4TYcVXur7jmTNn5s59rZe5pPV6vVuTyWQTSG06na4xFhx84HneGXLL9/33pVLpp9MnBi+hQdHv9wuj0egV4lOIs2kY0xFojNzI5XIvi8XiwPQ2JgKQ9cPxePwGQJ7+m94ky2Y2m/2Sz+dDgiAICmDWmd0j7Oor9ADMFrP5gBy1mQDdbvc5GR/SfTJ7B/EODirF3EZCawQ6wKeOz4S+XS6XX5tDFECZA2ximAJ6AejAQDZ2Op2W5EqlUjOdjSS3Q5A9/Sexus3El0I1V1kAwJ1OLpxrUxPioxKSr2YvLnFGdjI7brfbU8aTSLmgIA7HdSwKz23F70SesEh3r6r5VXG1JszgG7OhUv6dG9rnkGsrnswjd0nsg9tQAJxPcd4Fn9j/4mAGTbCPxa01CBcMBy1woomcjL7i8ATjqrpk6WRLOKCIcdV8wDqhGe3zNDBZ7KO/SdafwdxWlyydsyXcjEvcmkG42naILqIBbUhHVs9UEnXJ0plNcrzFuArhNo0br0NmhtH5UoDo+KeRgz2VnnIcqeZuwY+kM5vkeBsOh1ortYGuhPAqYNHW/+pmfynHLppflOM+mB/qkqVztlkH/hmXuDWD8PiToS6tRFPNWbR7gN9iPFeXLJ1sCQcUMa7W0g+a77JoEHiFyIkLLi3Dy3SOQ9d3I9xxAuuxYAiobV23onSLNHej1vENHGcm3KZ6iajpFrWdEGRvkSB2XYtDXPa6RftVGQNa3oNjJWGfL+/JtCBLffQtiEZ3ajep6za7I7wUzc4hO2O9Dhn//7PFSGzkftd1skqgGt0j2Ef+n1er1X/PooEvjDOLHLfpgSfDB3HdPJmYn9I+BIS/rts09UNAAf4ACRDJcqyZvx0AAAAASUVORK5CYII="

/***/ }),

/***/ "adV+":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__("cLrx"));
__webpack_require__("UQ5M");
var _message2 = _interopRequireDefault(__webpack_require__("/qCn"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__("jlIA"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__("Q9dM"));
var _createClass2 = _interopRequireDefault(__webpack_require__("wm7F"));
var _common = _interopRequireDefault(__webpack_require__("pdZy"));
var _api_command = __webpack_require__("3fYq");
var _recordRTC = __webpack_require__("NH7q");
function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i.return) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
var RtcClient = exports.default = /*#__PURE__*/function () {
  function RtcClient(options, _this) {
    (0, _classCallCheck2.default)(this, RtcClient);
    this.common = _common.default.call(this);
    this.sdkAppId_ = options.sdkAppId;
    this.userId_ = options.userId;
    this.userSig_ = options.userSig;
    this.roomId_ = options.roomId;
    this.shareUserId = 'share_' + this.userId_;
    this.isJoined_ = false;
    this.isPublished_ = false;
    this.isAudioMuted = false;
    this.isVideoMuted = false;
    this.localStream_ = null;
    this.remoteStreams_ = [];
    this._this = _this; // 这里的 this 指向调用者类，可使用 props, state 等属性
    this.members_ = new Map();

    // create a client for RtcClient
    this.client_ = TRTC.createClient({
      mode: "rtc",
      sdkAppId: this.sdkAppId_,
      userId: this.userId_,
      userSig: this.userSig_,
      userDefineRecordId: this.userId_
    });
    this.handleEvents(_this);
  }
  return (0, _createClass2.default)(RtcClient, [{
    key: "join",
    value: function () {
      var _join = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator().m(function _callee() {
        var createJSON, states, _iterator, _step, state, _t, _t2;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.p = _context.n) {
            case 0:
              if (!this.isJoined_) {
                _context.n = 1;
                break;
              }
              console.warn("duplicate RtcClient.join() observed");
              return _context.a(2);
            case 1:
              _context.p = 1;
              _context.n = 2;
              return this.client_.join({
                roomId: this.roomId_
              });
            case 2:
              console.log("join room success");
              this.isJoined_ = true;

              // create a local stream with audio/video from microphone/camera
              // 当模式为视频上拉时，不需调用摄像头
              createJSON = {
                audio: true,
                userId: this.userId_
              }; // // 功能类型 0: 视频调度(一对多) 1: 视频上拉(一对一)
              if (this._this.props.videoGenre == 0) {
                createJSON.video = true;
                createJSON.mirror = true; // 是否开启本地视频镜像预览。
              } else {
                createJSON.video = false;
                createJSON.mirror = false;
              }
              if (this.common.getCameraId() && this.common.getMicrophoneId()) {
                // this.localStream_ = TRTC.createStream({
                //   audio: true,
                //   video: true,
                //   userId: this.userId_,
                //   cameraId: this.common.getCameraId(),
                //   // cameraId:getCameraId(),
                //   microphoneId: this.common.getMicrophoneId(),
                //   // microphoneId: getMicrophoneId(),
                //   mirror: true
                // });
                createJSON.microphoneId = this.common.getMicrophoneId();
                createJSON.cameraId = this.common.getCameraId();
              } else {
                // not to specify cameraId/microphoneId to avoid OverConstrainedError
                // this.localStream_ = TRTC.createStream({
                //   audio: true,
                //   video: true,
                //   userId: this.userId_,
                //   mirror: true
                // });
              }
              console.log('createJSON', createJSON);
              this.localStream_ = TRTC.createStream(createJSON);
              _context.p = 3;
              _context.n = 4;
              return this.localStream_.initialize();
            case 4:
              console.log("initialize local stream success");
              this.localStream_.on("player-state-changed", function (event) {
                console.log("local stream ".concat(event.type, " player is ").concat(event.state));
              });
              window.recordStream.localStream = this.localStream_;

              // publish the local stream
              _context.n = 5;
              return this.publish();
            case 5:
              this.localStream_.play("main-video");
              if (this._this.props.videoGenre == 1) {
                this.common.isMicOn = false;
                this.muteLocalAudio();
              }
              document.getElementById("main-video-btns").style.display = "flex";
              document.getElementById("player_" + this.localStream_.getId()).appendChild(document.getElementById("mask_main"));
              // $('#main-video-btns').show();
              // $('#mask_main').appendTo($('#player_' + this.localStream_.getId()));

              // var videoDiv = document.createElement("div");
              // videoDiv.id = "player_" + this.localStream_.getId();
              // document.getElementById("mask_main").appendChild(videoDiv)
              // $('#main-video-btns').show();
              // $('#mask_main').appendTo($('#player_' + this.localStream_.getId()));
              _context.n = 7;
              break;
            case 6:
              _context.p = 6;
              _t = _context.v;
              document.getElementById("main-video-btns").style.display = "none";
              document.getElementById("mask_main").style.display = "flex";
              console.error("failed to initialize local stream - " + _t);
            case 7:
              _context.n = 9;
              break;
            case 8:
              _context.p = 8;
              _t2 = _context.v;
              console.error("join room failed! " + _t2);
            case 9:
              //更新成员状态
              states = this.client_.getRemoteMutedState();
              _iterator = _createForOfIteratorHelper(states);
              try {
                for (_iterator.s(); !(_step = _iterator.n()).done;) {
                  state = _step.value;
                  if (state.audioMuted) {
                    document.getElementById(state.userId).getElementsByClassName("member-audio-btn").forEach(function (element, index) {
                      element.setAttribute("src", __webpack_require__("YeOf"));
                    });

                    // $("#" + state.userId)
                    //   .find(".member-audio-btn")
                    //   .attr("src", "./img/mic-off.png");
                  }
                  if (state.videoMuted) {
                    document.getElementById(state.userId).getElementsByClassName("member-video-btn").forEach(function (element, index) {
                      element.setAttribute("src", __webpack_require__("acLb"));
                    });
                    document.getElementById("mask_" + this.members_.get(state.userId).getId()).style.display = "flex";
                    // $("#" + state.userId)
                    //   .find(".member-video-btn")
                    //   .attr("src", "./img/camera-off.png");
                    // $("#mask_" + this.members_.get(state.userId).getId()).show();
                  }
                }
              } catch (err) {
                _iterator.e(err);
              } finally {
                _iterator.f();
              }
            case 10:
              return _context.a(2);
          }
        }, _callee, this, [[3, 6], [1, 8]]);
      }));
      function join() {
        return _join.apply(this, arguments);
      }
      return join;
    }()
  }, {
    key: "leave",
    value: function () {
      var _leave = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator().m(function _callee2() {
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              if (this.isJoined_) {
                _context2.n = 1;
                break;
              }
              console.warn("leave() - please join() firstly");
              return _context2.a(2);
            case 1:
              _context2.n = 2;
              return this.unpublish();
            case 2:
              _context2.n = 3;
              return this.client_.leave();
            case 3:
              this.localStream_.stop();
              this.localStream_.close();
              this.localStream_ = null;
              this.isJoined_ = false;
              // resetView();
              // this.common.resetView()
            case 4:
              return _context2.a(2);
          }
        }, _callee2, this);
      }));
      function leave() {
        return _leave.apply(this, arguments);
      }
      return leave;
    }()
  }, {
    key: "publish",
    value: function () {
      var _publish = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator().m(function _callee3() {
        var _t3;
        return _regenerator().w(function (_context3) {
          while (1) switch (_context3.p = _context3.n) {
            case 0:
              if (this.isJoined_) {
                _context3.n = 1;
                break;
              }
              console.warn("publish() - please join() firstly");
              return _context3.a(2);
            case 1:
              if (!this.isPublished_) {
                _context3.n = 2;
                break;
              }
              console.warn("duplicate RtcClient.publish() observed");
              return _context3.a(2);
            case 2:
              _context3.p = 2;
              _context3.n = 3;
              return this.client_.publish(this.localStream_);
            case 3:
              _context3.n = 5;
              break;
            case 4:
              _context3.p = 4;
              _t3 = _context3.v;
              console.error("failed to publish local stream " + _t3);
              this.isPublished_ = false;
            case 5:
              this.isPublished_ = true;
            case 6:
              return _context3.a(2);
          }
        }, _callee3, this, [[2, 4]]);
      }));
      function publish() {
        return _publish.apply(this, arguments);
      }
      return publish;
    }()
  }, {
    key: "unpublish",
    value: function () {
      var _unpublish = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator().m(function _callee4() {
        return _regenerator().w(function (_context4) {
          while (1) switch (_context4.n) {
            case 0:
              if (this.isJoined_) {
                _context4.n = 1;
                break;
              }
              console.warn("unpublish() - please join() firstly");
              return _context4.a(2);
            case 1:
              if (this.isPublished_) {
                _context4.n = 2;
                break;
              }
              console.warn("RtcClient.unpublish() called but not published yet");
              return _context4.a(2);
            case 2:
              _context4.n = 3;
              return this.client_.unpublish(this.localStream_);
            case 3:
              this.isPublished_ = false;
            case 4:
              return _context4.a(2);
          }
        }, _callee4, this);
      }));
      function unpublish() {
        return _unpublish.apply(this, arguments);
      }
      return unpublish;
    }()
  }, {
    key: "muteLocalAudio",
    value: function muteLocalAudio() {
      this.localStream_ && this.localStream_.muteAudio();
    }
  }, {
    key: "unmuteLocalAudio",
    value: function unmuteLocalAudio() {
      this.localStream_ && this.localStream_.unmuteAudio();
    }
  }, {
    key: "muteLocalVideo",
    value: function muteLocalVideo() {
      this.localStream_ && this.localStream_.muteVideo();
    }
  }, {
    key: "unmuteLocalVideo",
    value: function unmuteLocalVideo() {
      this.localStream_ && this.localStream_.unmuteVideo();
    }
  }, {
    key: "resumeStreams",
    value: function resumeStreams() {
      this.localStream_ && this.localStream_.resume();
      var _iterator2 = _createForOfIteratorHelper(this.remoteStreams_),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var stream = _step2.value;
          stream.resume();
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }, {
    key: "handleEvents",
    value: function handleEvents(_this) {
      var _this2 = this;
      this.client_.on("error", function (err) {
        console.error('client_handleEvents', err);
        alert(err);
        // location.reload();
      });
      // 用户被踢出房间通知
      this.client_.on("client-banned", function (err) {
        console.error("client has been banned for " + err);
        if (!_this2.common.isHidden()) {
          _message2.default.warning('您已被踢出房间');
          // alert("您已被踢出房间");
          // location.reload();
        } else {
          document.addEventListener("visibilitychange", function () {
            if (!_this2.common.isHidden()) {
              _message2.default.warning('您已被踢出房间');
              // alert("您已被踢出房间");
              // location.reload();
            }
          }, false);
        }
      });
      // 远端用户进房通知
      //有好友进来
      this.client_.on("peer-join", function (evt) {
        var userId = evt.userId;
        // console.log("peer-join " + userId);
        // console.log(this.common)
        // console.log(this.common.shareUserId)
        // console.log(_this.props.dispatch)
        // if (userId !== this.common.shareUserId) {
        if (userId !== _this2.shareUserId) {
          _this2.common.addMemberView(userId);
          console.log('client_join', 'fetchVideoMemberList');
          // _this.props.dispatch({
          //   type:'command/fetchVideoMemberList',
          //   payload:{
          //     type:'peerJoin',
          //     memberList:{
          //       mobilePhone:userId,
          //       status:'yes',
          //       id:userId+'yes'
          //     }
          //   }
          // })
        }
      });
      // 远端用户退房通知
      this.client_.on("peer-leave", function (evt) {
        var userId = evt.userId;
        _this2.common.removeView(userId);
        console.log("peer-leave " + userId);
        console.log('client_leave', 'fetchVideoMemberList');
        _this.props.dispatch({
          type: 'command/fetchVideoMemberList',
          payload: {
            type: 'leave',
            memberList: {
              mobilePhone: userId,
              status: 'leave',
              id: userId + 'leave'
            }
          }
        });
      });
      // 远端流添加事件，当远端用户发布流后会收到该通知。
      this.client_.on("stream-added", function (evt) {
        console.log('client_added', evt);
        var remoteStream = evt.stream;
        var id = remoteStream.getId();
        var userId = remoteStream.getUserId();
        _this2.members_.set(userId, remoteStream);
        console.log("remote stream added: [".concat(userId, "] ID: ").concat(id, " type: ").concat(remoteStream.getType()));
        if (remoteStream.getUserId() === _this2.shareUserId) {
          // don't need screen shared by us
          _this2.client_.unsubscribe(remoteStream);
        } else {
          console.log("subscribe to this remote stream");
          _this2.client_.subscribe(remoteStream);
        }
      });
      // SDK和腾讯云的连接状态变化事件，您可以利用该事件从全景上监听SDK与腾讯云的连接状态。
      // 'DISCONNECTED'：连接断开
      // 'CONNECTING'：正在连接中
      // 'RECONNECTING'：自动重连中
      // 'CONNECTED'：已连接
      this.client_.on('connection-state-changed', function (event) {
        console.log(' TRTC 连接状态', event);
        return;
        if (event.prevState == "CONNECTING") {
          // 模拟用户进入，进行测试开发
          var videoMember = []; //用于记录是否已经进入房间使用
          setTimeout(function () {
            for (var index = 1; index < 52; index++) {
              console.log('client_-changed', 'fetchVideoMemberList', event);
              var userId = 179901648 + index;
              var id = new Date().getTime() + "_000000000";
              var userName = '测试' + index;
              _this2.common.addMemberView(userId);
              console.log('client_join', 'fetchVideoMemberList');
              videoMember.push({
                videoId: id,
                hasVideo: false,
                userName: userName,
                mobilePhone: userId,
                status: 'yes',
                id: userId + 'yes'
              });
            }
            _this.props.dispatch({
              type: 'command/fetchVideoMemberList',
              payload: {
                type: 'add',
                memberList: videoMember
              }
            });
          }, 5000);
        }
      });
      // 最后流订阅成功事件，调用订阅()成功后会触发该事件。
      this.client_.on("stream-subscribed", /*#__PURE__*/function () {
        var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator().m(function _callee5(evt) {
          var track, remoteStream, id, uid, data, userName;
          return _regenerator().w(function (_context5) {
            while (1) switch (_context5.n) {
              case 0:
                console.log(evt);
                console.log('client_subscribed', 'fetchVideoMemberList');
                console.log('evt.stream', evt.stream);
                if (evt.stream.hasAudio) {
                  track = evt.stream.getAudioTrack();
                  console.log('evt.track', track);
                  setTimeout(function () {
                    (0, _recordRTC.recordAudioInsert)(evt.stream);
                  }, 700);
                }
                remoteStream = evt.stream;
                id = remoteStream.getId();
                uid = remoteStream.userId_;
                _context5.n = 1;
                return (0, _api_command.searchDeptUser)({
                  keyWord: remoteStream.userId_
                });
              case 1:
                data = _context5.v;
                // console.log('searchDeptUser', data)
                userName = "";
                if (data && data.data && data.data) {
                  userName = data.data[0].item_securityname;
                }
                _this.props.dispatch({
                  type: 'command/fetchVideoMemberList',
                  payload: {
                    type: 'peerJoin',
                    memberList: {
                      videoId: id,
                      hasVideo: remoteStream.hasVideo(),
                      userName: userName,
                      mobilePhone: uid,
                      status: 'yes',
                      id: uid + 'yes'
                    }
                  }
                });
                _this2.remoteStreams_.push(remoteStream);
                remoteStream.play(id, {
                  objectFit: "contain"
                });
                remoteStream.on("player-state-changed", function (event) {
                  console.log("player-state-changed", "".concat(event.type, " player is ").concat(event.state));
                  if (event.type == "video" && event.state == "PLAYING") {
                    _this.props.dispatch({
                      type: 'command/fetchVideoMemberList',
                      payload: {
                        type: 'peerJoin',
                        memberList: {
                          videoId: id,
                          hasVideo: true,
                          userName: userName,
                          mobilePhone: uid,
                          status: 'yes',
                          id: uid + 'yes'
                        }
                      }
                    });
                  }
                });
              case 2:
                return _context5.a(2);
            }
          }, _callee5);
        }));
        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
      // 远端流移除事件，当远端用户取消发布流后会收到通知。
      this.client_.on("stream-removed", function (evt) {
        console.log('client_removed', 'fetchVideoMemberList');
        var remoteStream = evt.stream;
        var id = remoteStream.getId();
        remoteStream.stop();
        _this2.remoteStreams_ = _this2.remoteStreams_.filter(function (stream) {
          return stream.getId() !== id;
        });
        _this2.common.removeView(id);
        console.log("stream-removed ID: ".concat(id, "  type: ").concat(remoteStream.getType()));
      });
      // 远端流更新事件，当远端用户添加、移除或缺失音视频轨道后会收到该通知。
      this.client_.on("stream-updated", function (evt) {
        console.log('client_updated', 'fetchVideoMemberList');
        var remoteStream = evt.stream;
        var uid = _this2.getUidByStreamId(remoteStream.getId());
        if (!remoteStream.hasVideo()) {
          document.getElementById(uid).getElementsByClassName("member-video-btn").forEach(function (element, index) {
            element.setAttribute("src", __webpack_require__("acLb"));
          });

          // $("#" + uid)
          //   .find(".member-video-btn")
          //   .attr("src", "img/camera-off.png");
        }
        // console.log(
        //   "type: " +
        //   remoteStream.getType() +
        //   " stream-updated hasAudio: " +
        //   remoteStream.hasAudio() +
        //   " hasVideo: " +
        //   remoteStream.hasVideo() +
        //   " uid: " +
        //   uid
        // );
      });
      // 远端用户禁用音频通知。
      this.client_.on("mute-audio", function (evt) {
        console.log('client_audio', 'fetchVideoMemberList');
        console.log(evt.userId + " mute audio");
        document.getElementById(evt.userId) && document.getElementById(evt.userId).getElementsByClassName("member-audio-btn").forEach(function (element, index) {
          element.setAttribute("src", __webpack_require__("YeOf"));
        });

        // $("#" + evt.userId)
        //   .find(".member-audio-btn")
        //   .attr("src", "img/mic-off.png");
      });
      // 远端用户启用音频通知。
      this.client_.on("unmute-audio", function (evt) {
        console.log('client_unmute', 'fetchVideoMemberList');
        console.log(evt.userId + " unmute audio");
        document.getElementById(evt.userId).getElementsByClassName("member-audio-btn").forEach(function (element, index) {
          element.setAttribute("src", __webpack_require__("gOsS"));
        });

        // $("#" + evt.userId)
        //   .find(".member-audio-btn")
        //   .attr("src", "img/mic-on.png");
      });
      // 远端用户禁用视频通知。
      this.client_.on("mute-video", function (evt) {
        console.log(evt.userId + " mute video");
        console.log('client-video', 'fetchVideoMemberList');
        document.getElementById(evt.userId).getElementsByClassName("member-video-btn").forEach(function (element, index) {
          element.setAttribute("src", __webpack_require__("acLb"));
        });

        // $("#" + evt.userId)
        //   .find(".member-video-btn")
        //   .attr("src", "img/camera-off.png");
        console.log(_this2.members_.get(evt.userId));
        var streamId = _this2.members_.get(evt.userId).getId();
        if (streamId) {
          document.getElementById("mask_" + streamId).style.display = "flex";
          // $("#mask_" + streamId).show();
        }
      });
      // 远端用户启用视频通知。
      this.client_.on("unmute-video", function (evt) {
        console.log(evt.userId + " unmute video");
        console.log('client-unmute-v', 'fetchVideoMemberList');
        document.getElementById(evt.userId) && document.getElementById(evt.userId).getElementsByClassName("member-video-btn").forEach(function (element, index) {
          element.setAttribute("src", __webpack_require__("8ZKn"));
        });

        // $("#" + evt.userId)
        //   .find(".member-video-btn")
        //   .attr("src", "img/camera-on.png");
        var stream = _this2.members_.get(evt.userId);
        if (stream) {
          var streamId = stream.getId();
          if (streamId) {
            //这里不行
            console.log("mask_" + streamId);
            console.log(document.getElementById("mask_" + streamId));
            document.getElementById("mask_" + streamId) ? document.getElementById("mask_" + streamId).style.display = "none" : '';
            // $("#mask_" + streamId).hide();
          }
        }
      });
    }
  }, {
    key: "showStreamState",
    value: function showStreamState(stream) {
      console.log("has audio: " + stream.hasAudio() + " has video: " + stream.hasVideo());
    }
  }, {
    key: "getUidByStreamId",
    value: function getUidByStreamId(streamId) {
      var _iterator3 = _createForOfIteratorHelper(this.members_),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var _ref2 = _step3.value;
          var _ref3 = (0, _slicedToArray2.default)(_ref2, 2);
          var uid = _ref3[0];
          var stream = _ref3[1];
          if (stream.getId() == streamId) {
            return uid;
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
    }
  }]);
}();

/***/ }),

/***/ "bPsJ":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "d60R":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
__webpack_require__("baa2");
var _icon = _interopRequireDefault(__webpack_require__("FC3+"));
var _objectSpread2 = _interopRequireDefault(__webpack_require__("+TWC"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__("Q9dM"));
var _createClass2 = _interopRequireDefault(__webpack_require__("wm7F"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("F6AD"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("fghW"));
var _inherits2 = _interopRequireDefault(__webpack_require__("QwVp"));
var _react = _interopRequireWildcard(__webpack_require__("GiK3"));
var _dva = __webpack_require__("S6G3");
__webpack_require__("bPsJ");
var _reactDom = _interopRequireDefault(__webpack_require__("O27J"));
var _moment = _interopRequireDefault(__webpack_require__("PJh5"));
var _BoxTool = _interopRequireDefault(__webpack_require__("2pqD"));
var _MouseMovement = _interopRequireDefault(__webpack_require__("06MX"));
var _recordRTC = __webpack_require__("NH7q");
var _classnames = _interopRequireDefault(__webpack_require__("HW6M"));
var _dec, _class;
/**
 * 视频通话页面
 */
// import RecordVideo from './recordVideo';
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var VideoBox = exports.default = (_dec = (0, _dva.connect)(function (state) {
  return {
    ownCid: state.im.v5Data.ownCid,
    videoMember: state.command.videoMember,
    videoType: state.command.videoType,
    // 布局类型 0: 九宫格 1: 右侧列表   2: 顶部列表   3: 十六宫格  4: 二十五宫格
    videoGenre: state.command.videoGenre // 功能类型 0: 视频调度(一对多) 1: 视频上拉(一对一)
  };
}), _dec(_class = /*#__PURE__*/function (_Component) {
  function VideoBox(props) {
    var _this;
    (0, _classCallCheck2.default)(this, VideoBox);
    _this = _callSuper(this, VideoBox, [props]);
    _this.switchVideoTool = function (name) {
      var toolStatus = _this.state.toolStatus;
      toolStatus[name] = !toolStatus[name];
      _this.setState({
        toolStatus: toolStatus,
        toolTime: (0, _moment.default)().format('x')
      });
    };
    _this.setScreen = function () {
      var isFullScreen = _this.state.isFullScreen;
      var boxs = document.getElementById("video-boxs");
      boxs.style.left = "50vw";
      boxs.style.top = "50vh";
      _this.setState({
        isFullScreen: !isFullScreen
      });
    };
    _this.onScrollVideo = function (type) {
      var videoType = _this.props.videoType;
      var _this$state = _this.state,
        videoMember = _this$state.videoMember,
        currentVideoNo = _this$state.currentVideoNo,
        isMainChecked = _this$state.isMainChecked;
      var videoLen = videoMember.length;
      if (videoType == 0 && videoMember.length > 9 || videoType == 3 && videoMember.length > 16 || videoType == 4 && videoMember.length > 25) {
        videoLen = videoType == 0 ? 8 : videoType == 3 ? 15 : 24;
        if (type == 'before' && currentVideoNo != 0) {
          currentVideoNo = currentVideoNo - videoLen < 0 ? 0 : currentVideoNo - videoLen;
        } else if (type == 'after') {
          currentVideoNo = videoLen + currentVideoNo >= videoMember.length ? currentVideoNo : videoLen + currentVideoNo;
        }
      }
      console.log('currentVideoNo', currentVideoNo);
      _this.setState({
        currentVideoNo: currentVideoNo
      });
    };
    _this.onChangeVideo = function (video) {
      console.log('onChangeVideo', video);
      var beforeCheckVideo = _this.state.beforeCheckVideo;
      if (beforeCheckVideo.id) {
        _this.props.dispatch({
          type: 'command/fetchVideoMemberList',
          payload: {
            type: 'peerJoin',
            memberList: {
              videoId: beforeCheckVideo.videoId,
              hasVideo: beforeCheckVideo.hasVideo,
              userName: beforeCheckVideo.userName,
              mobilePhone: beforeCheckVideo.mobilePhone,
              checked: false,
              status: beforeCheckVideo.status,
              id: beforeCheckVideo.id
            }
          }
        });
      }
      if (video == 'main') {
        _this.setState({
          isMainChecked: true
        });
      } else {
        _this.setState({
          beforeCheckVideo: video,
          isMainChecked: false
        });
        _this.props.dispatch({
          type: 'command/fetchVideoMemberList',
          payload: {
            type: 'peerJoin',
            memberList: {
              videoId: video.videoId,
              hasVideo: video.hasVideo,
              userName: video.userName,
              mobilePhone: video.mobilePhone,
              checked: true,
              status: video.status,
              id: video.id
            }
          }
        });
      }
    };
    _this.renderVideoList = function () {
      var _this$state2 = _this.state,
        videoList = _this$state2.videoList,
        currentVideoNo = _this$state2.currentVideoNo,
        videoMember = _this$state2.videoMember,
        isMainChecked = _this$state2.isMainChecked;
      var _this$props = _this.props,
        _videoThis = _this$props._videoThis,
        videoType = _this$props.videoType,
        videoGenre = _this$props.videoGenre;
      var hasShowOption = false;
      var videoingList = videoMember.filter(function (video, index) {
        return video.status != "fail";
      });
      videoingList = videoingList.filter(function (video, index) {
        return video.status != "no";
      });
      console.log('videoingList', videoingList);
      var videoLen = videoingList.length;
      var currentVideoList = [];
      if (videoType == 0 && videoingList.length > 9 || videoType == 3 && videoingList.length > 16 || videoType == 4 && videoingList.length > 25) {
        hasShowOption = true;
        videoLen = videoType == 0 ? 8 : videoType == 3 ? 15 : 24;
        if (currentVideoNo > 0) {
          currentVideoList = videoingList.filter(function (item, index) {
            return index >= currentVideoNo && index < currentVideoNo + videoLen;
          });
        } else {
          currentVideoList = videoingList.filter(function (item, index) {
            return index < videoLen;
          });
        }
      } else {
        currentVideoList = videoingList;
      }
      var hasVideoScheduling = videoGenre == 0 ? true : false;
      if (!hasVideoScheduling) {
        videoLen = 0;
      }
      var clsString = (0, _classnames.default)("col-div", "video-main", "video-container", isMainChecked ? "video-box-checked" : "", hasVideoScheduling ? "" : 'video-main-hidden');
      return /*#__PURE__*/_react.default.createElement("div", {
        id: "div-video-child",
        className: "video-layout".concat(videoType, " video-layout").concat(videoType, "-").concat(videoLen)
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: "div-video-local",
        className: clsString,
        onClick: _this.onChangeVideo.bind(_this, 'main')
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: "main-video",
        style: {
          width: '100%',
          height: '100%'
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: "main-video-btns",
        className: "row-div",
        style: {
          width: "156px",
          position: "absolute",
          zIndex: 10,
          justifyContent: "center",
          alignSelf: "flex-end",
          right: "0",
          bottom: "0"
        }
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "video-name"
      }, "\u6211"), /*#__PURE__*/_react.default.createElement("div", {
        id: "mask_main",
        className: "mask col-div",
        style: {
          display: "none"
        }
      }, /*#__PURE__*/_react.default.createElement("img", {
        style: {
          width: "63px",
          height: "69px",
          zIndex: 10
        },
        src: __webpack_require__("K+uK"),
        alt: ""
      }), /*#__PURE__*/_react.default.createElement("div", {
        style: {
          height: "10px"
        }
      }), /*#__PURE__*/_react.default.createElement("div", {
        style: {
          zIndex: 10
        }
      }, "\u6444\u50CF\u5934\u672A\u6253\u5F00")))), hasShowOption ? /*#__PURE__*/_react.default.createElement("div", {
        className: "video-option-left",
        onClick: _this.onScrollVideo.bind(_this, 'before')
      }, "<") : null, hasShowOption ? /*#__PURE__*/_react.default.createElement("div", {
        className: "video-option-right",
        onClick: _this.onScrollVideo.bind(_this, 'after')
      }, ">") : null, currentVideoList.map(function (video, i) {
        console.log('currentVideoList', video);
        var statusText = video.status == "no" ? "正在调度" : "摄像头未打开";
        var clsStr = (0, _classnames.default)("video-box", "video-container", video.checked ? "video-box-checked" : "");
        return /*#__PURE__*/_react.default.createElement("div", {
          className: clsStr,
          id: video.videoId,
          onClick: _this.onChangeVideo.bind(_this, video)
        }, !video.hasVideo ? /*#__PURE__*/_react.default.createElement("div", {
          id: "mask_" + video.videoId,
          className: "mask col-div"
        }, /*#__PURE__*/_react.default.createElement("img", {
          style: {
            width: "63px",
            height: "69px",
            zIndex: 10
          },
          src: __webpack_require__("K+uK"),
          alt: ""
        }), /*#__PURE__*/_react.default.createElement("div", {
          style: {
            height: "10px"
          }
        }), /*#__PURE__*/_react.default.createElement("div", {
          style: {
            zIndex: 10
          }
        }, statusText)) : null, /*#__PURE__*/_react.default.createElement("div", {
          className: "video-name"
        }, video.hasVideo ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("img", {
          src: __webpack_require__("8ZKn")
        })) : /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("img", {
          src: __webpack_require__("acLb")
        })), video.userName));
      }));
    };
    _this.onMouseDown = function () {
      var isFullScreen = _this.state.isFullScreen;
      if (isFullScreen) {
        return;
      }
      _this.setState({
        videoLocal: {
          isDown: true,
          offsetLeft: document.getElementsByClassName('video-boxs')[0].offsetLeft,
          offsetTop: document.getElementsByClassName('video-boxs')[0].offsetTop
        }
      });
    };
    _this.onMouseUp = function () {
      var isFullScreen = _this.state.isFullScreen;
      if (isFullScreen) {
        return;
      }
      _this.setState({
        videoLocal: (0, _objectSpread2.default)({}, _this.state.videoLocal, {
          isDown: false
        })
      });
    };
    _this.state = {
      videoLocal: {
        isDown: false,
        offsetLeft: 0,
        offsetTop: 0
      },
      isFullScreen: false,
      currentTime: "",
      toolTime: "",
      //处理刷新问题
      toolStatus: {
        mute: false,
        video: false,
        record: false,
        add: false,
        close: false,
        share: false
      },
      canCamera: false,
      canMic: false,
      videoList: [1, 2, 3, 4, 5, 6, 7, 8, 9],
      mainVideo: "",
      videoMember: [],
      currentVideoNo: 0,
      isMainChecked: true,
      beforeCheckVideo: {},
      boxToolStyle: (0, _classnames.default)("box-tool", "box-tool-default")
    };
    return _this;
  }
  (0, _inherits2.default)(VideoBox, _Component);
  return (0, _createClass2.default)(VideoBox, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      if (JSON.stringify(nextProps.videoMember) !== JSON.stringify(this.state.videoMember)) {
        console.log("VideoBox");
        this.setState({
          videoMember: nextProps.videoMember
        });
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;
      var that = this;
      // 判断麦克风和摄像头是否可用
      TRTC.getCameras().then(function (res) {
        console.log('getCameras', res);
        if (res.length > 0) {
          _this2.setState({
            canCamera: true,
            toolStatus: (0, _objectSpread2.default)({}, _this2.state.toolStatus, {
              video: false
            })
          });
        }
      });
      TRTC.getMicrophones().then(function (res) {
        console.log('getMicrophones', res);
        if (res.length > 0) {
          if (_this2.state.videoGenre != 0) {
            _this2.setState({
              canMic: true,
              toolStatus: (0, _objectSpread2.default)({}, _this2.state.toolStatus, {
                mute: true
              })
            });
          } else {
            _this2.setState({
              canMic: true,
              toolStatus: (0, _objectSpread2.default)({}, _this2.state.toolStatus, {
                mute: false
              })
            });
          }
        }
      });
      if (this.state.videoGenre != 0) {
        this.setState({
          toolStatus: (0, _objectSpread2.default)({}, this.state.toolStatus, {
            mute: true
          })
        });
      }
      setInterval(function () {
        _this2.getCurrentTime();
      }, 1000);
      // initRecordRTC();
      setTimeout(function () {
        that.setState({
          boxToolStyle: "box-tool"
        });
      }, 3700);
    }
  }, {
    key: "getCurrentTime",
    value: function getCurrentTime() {
      var date = (0, _moment.default)().format("YYYY-MM-DD");
      var time = (0, _moment.default)().format("HH:mm:ss");
      var week = (0, _moment.default)().day();
      switch (week) {
        case 1:
          week = '星期一';
          break;
        case 2:
          week = '星期二';
          break;
        case 3:
          week = '星期三';
          break;
        case 4:
          week = '星期四';
          break;
        case 5:
          week = '星期五';
          break;
        case 6:
          week = '星期六';
          break;
        case 0:
          week = '星期日';
          break;
      }
      this.setState({
        currentTime: "".concat(date, " ").concat(week, " ").concat(time)
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;
      var _this$state3 = this.state,
        toolStatus = _this$state3.toolStatus,
        currentTime = _this$state3.currentTime,
        isFullScreen = _this$state3.isFullScreen,
        canCamera = _this$state3.canCamera,
        canMic = _this$state3.canMic,
        boxToolStyle = _this$state3.boxToolStyle,
        recordStatus = _this$state3.recordStatus; // console.log('canCamera', canCamera)
      // console.log('canMic', canMic)
      // console.log('videoMember', this.props);
      var _this$props2 = this.props,
        common = _this$props2.common,
        videoType = _this$props2.videoType,
        addMember = _this$props2.addMember,
        dissolutionRoomModal = _this$props2.dissolutionRoomModal,
        videoSize = _this$props2.videoSize,
        videoGenre = _this$props2.videoGenre;
      var displayNode = videoSize != 2 ? 'none' : 'block';
      var videoWidth = isFullScreen ? "100%" : "70%";
      var videoHeight = isFullScreen ? "100%" : "85%";
      var hasVideoScheduling = videoGenre == 0 ? true : false;
      if (!hasVideoScheduling) {
        videoWidth = '375px';
        videoHeight = '667px';
      }
      return /*#__PURE__*/_react.default.createElement(_MouseMovement.default, {
        isDown: this.state.videoLocal.isDown,
        offsetLeft: this.state.videoLocal.offsetLeft,
        offsetTop: this.state.videoLocal.offsetTop
      }, function (_ref) {
        var x = _ref.x,
          y = _ref.y,
          _ref$cursor = _ref.cursor,
          cursor = _ref$cursor === void 0 ? 'move' : _ref$cursor;
        return /*#__PURE__*/_react.default.createElement("div", {
          id: "video-boxs",
          className: "video-boxs",
          ref: "video-boxs",
          style: {
            // width: "70%",
            // position: 'absolute',
            top: y == 0 ? '50%' : y,
            left: x == 0 ? '47%' : x,
            width: videoWidth,
            height: videoHeight,
            display: displayNode
            // top: '50%',
            // left: '50%'
          },
          onMouseDown: _this3.onMouseDown.bind(_this3),
          onMouseUp: _this3.onMouseUp.bind(_this3)
        }, hasVideoScheduling ? /*#__PURE__*/_react.default.createElement("div", {
          className: "box-header",
          style: {
            cursor: isFullScreen ? '' : 'move'
          }
        }, /*#__PURE__*/_react.default.createElement("div", null, currentTime), /*#__PURE__*/_react.default.createElement(_icon.default, {
          className: "icon",
          style: {
            margin: "0 16px"
          },
          onClick: _this3.setScreen,
          type: isFullScreen ? "fullscreen-exit" : "fullscreen"
        }), /*#__PURE__*/_react.default.createElement(_icon.default, {
          className: "icon",
          type: "close",
          onClick: _this3.props.dissolutionRoomModal
        })) : null, /*#__PURE__*/_react.default.createElement("div", {
          id: "video-content",
          className: "video-content"
        }, /*#__PURE__*/_react.default.createElement("div", {
          id: "room-root",
          className: "col-div"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "row-div",
          style: {
            height: "100%",
            width: "100%",
            display: " flex",
            alignItems: "center"
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "col-div",
          style: {
            width: "340px",
            height: "100%",
            padding: "10px",
            display: "none"
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "col-div card",
          style: {
            width: "100%",
            height: "100%"
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          id: "member-list",
          className: "col-div",
          style: {
            width: "100%",
            justifyContent: "flex-start",
            flex: 1
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          id: "member-me",
          style: {
            width: "100%",
            paddingLeft: "20px"
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "row-div member",
          style: {
            width: "100%",
            height: "50px",
            justifyContent: "space-between"
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "member-id"
        }, "(\u6211)"), /*#__PURE__*/_react.default.createElement("div", {
          className: "row-div",
          style: {
            width: "100%",
            height: "27px",
            justifyContent: "center",
            display: "flex",
            alignItems: "center"
          }
        }, /*#__PURE__*/_react.default.createElement("img", {
          className: "member-video-btn",
          style: {
            height: "100%"
          },
          src: __webpack_require__("8ZKn"),
          alt: ""
        }), /*#__PURE__*/_react.default.createElement("div", {
          style: {
            width: 18
          }
        }), /*#__PURE__*/_react.default.createElement("img", {
          className: "member-audio-btn",
          style: {
            height: "100%"
          },
          src: __webpack_require__("gOsS"),
          alt: ""
        }))))))), /*#__PURE__*/_react.default.createElement("div", {
          id: "remote-video-wrap",
          style: {
            height: "100%",
            flex: 1
          }
        }, _this3.renderVideoList())))), /*#__PURE__*/_react.default.createElement(_BoxTool.default, {
          boxToolStyle: boxToolStyle,
          switchVideoTool: _this3.switchVideoTool.bind(_this3),
          canMic: canMic,
          canCamera: canCamera,
          addMember: addMember,
          common: common,
          dissolutionRoomModal: dissolutionRoomModal,
          toolStatus: toolStatus
        }));
      });
    }
  }]);
}(_react.Component)) || _class);

/***/ }),

/***/ "dDE8":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABIAAAATCAYAAACdkl3yAAAAAXNSR0IArs4c6QAAActJREFUOE+tk01IFGEYx3//zWALIi9REBqmpxAjiOrSMb10kA5GJkK3riLsjC2BHmxnF5SOHToIQtpNvRXevPRxqbyqURLlnvoAEbadJ2YcdHc+zINzed+Z53l/7/M8//+II3p0RBzSQVPWRo2HQD+iAwvzNoAFjvOMUW3GC0iCynYNYxk4FSW/idYb0foHn1s80ttGWBJUsXv4vIiS/gJetHeBlnCfY5CC5g4GBVHPJhFngXgLbRhbuCr+v7Ugo2K9+LxKFSJHHwW9PhyoZBcR66mgGl08ViKWIb+JEp8RF5pg4gsOHSA7XEW77d3FmIukB2EYg7iaT6v0YEN6NoB4Eh70KTKml1kGToI8O02dk+RpCY03bnkuUWNAdTxrp06NY2zj6le6/J5dBlb2jCg+4OgKnj1HbOJogpJ9RPREgN/UuUlRn4L3/YoqNoLPdMMt33E4Tzl0eZUd7pPnG3BuL0eM4OhpM8izWWAoNoPbwB0gUGkRWGqKG7OMaTgOeg9cjYHWEDuhXnAC6IrF3+HqehxUBc5kqZLxvYqr4FdqmFHZHmB0A51AezgL0QrkI0hQ2U/gB/AVWCfHKgXNNIOySjHT7nVJNzce+QcPtoIU8lV8jwAAAABJRU5ErkJggg=="

/***/ }),

/***/ "dToI":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAAYdJREFUWEftmL9KA0EQxn8f9v4BC3vzBkYLSxvfILEUwTyAIIgPIELAB4gglvoIFqa0UPMGprcQjPYyMsdG45nLJYEcJ+40x+3Mzn773Xc7cyeCmdkO0ADWgPn+eOr6AjwCTUntjJhk2My2gEOgCixnxL4DHaAl6cpjFCa3gP1RC6R8BhxLOh02x8yOgJN+/jHznktqyMxqwPWYkwbDPoBNSfeDg2a2AdwBc1PkrDugW8DpdbsADiS9Zex8BbgEtoM/2VUK0CDbN8CupOeMfAvAGbAX/G0H9AoshoElSb0cbbgmHkJMR5Lff5mZucZch25VSa6RTDMzX9sxuPUckOshMUmJpnISrAJPIaYrqZIC5D6PcatI6o6R8xtDBDSErh+kRIb+IkOzfO3XJfkxMNFrX7qDsUylo1a+4tp/uKVqP/KO9iL9ubWrSDBJPS16wbz1yguoVKI2s9hTZ2jp//XUUxXX2FOn9RNb2LzTOTI0KUOz7Kmn+pSOPfWIR1iPPXWKnV+/9D4BHRcL9lF0IfsAAAAASUVORK5CYII="

/***/ }),

/***/ "gOsS":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAbCAYAAAB4Kn/lAAAAAXNSR0IArs4c6QAAArNJREFUSA3FVTtoVEEUPbMJGEGJKXULEbUR7IRURlErBbVLL9jqBvwGhEUhfiIksRXs7dwFuyjqVsIWipgmgqRILFcx6KZwx3PuvLc7b/c9g2kyMG/mzT33zJk7w70O/2o3/G5s4Boh5+FxyKAOXzjWsQOP8cj9LHJ3RQZU/Cl08Iz2/QWYFZRwCfPudZ69lLeYkC4mpA0MUXEJ+6xrDjTM1sGiYXNIBhXr+G18MkeHGYzhDqquk/Gt+hJauMfwTHN9BSM42h+WQcUhpjp+I5dUO2gjbZgqDz6ydNsgsccFsw5hdkBp140TkQsTmsKTaYPEwEFDeDQzyLyfFJO+mAiTR7zL7PPuW4TLn/YwwSdCDUfz7PSK992FJy57ybGtC8pO8hRnEVv8K1bcrzLeILYVqN8GxbGSWKGUx7b4JNF8GxT3q4zUILYVqB/GVf/SfBbcudh3y/OEr8REMsF+FlWfPvJ1I634vZuS9zDBRwlMXORUjNeMoIWyjSGRAw7HNiVOManPBlNraGslEiwlPxPJWLfxD67zFMWXK5swoQUf8PRqDp9FXAs2TNqokqMcCxy3nJtHnuZjYYQNPnIPHA51h1t+DL/xlXEZZRo8iTn3NqogyhGqILO0N+VpIQpKRepZVc5YeZryJ3iCN7T/wE4cCMml4m+zvs1wcZmL43jgWv9V84K499zmMDea5kb3Qwz3YI6kTTP8YmgEVJFUyXG4S2Uf2XXz6/z/YGuyCSOsfEQqDnGx9dLhlC9TtXYtc3WZO1+2sAhV1HT8Dp4mpKv0GafPquA9Yv0F8hcEhqfm8Iqrz9nfscaZAy9Uz1K3P0ncaY5iaZL0YkoalswSfap+BN8xRaeb7KORZXCqi3J4aMevunYMyCqOLYpdm4VVxdXjCE3dx0+yJfYa76BmFx37JfO/cKPiq6m4OtcAAAAASUVORK5CYII="

/***/ }),

/***/ "gpon":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__("jlIA"));
__webpack_require__("UQ5M");
var _message2 = _interopRequireDefault(__webpack_require__("/qCn"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__("Q9dM"));
var _createClass2 = _interopRequireDefault(__webpack_require__("wm7F"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__("F6AD"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__("fghW"));
var _inherits2 = _interopRequireDefault(__webpack_require__("QwVp"));
__webpack_require__("sRCI");
var _modal = _interopRequireDefault(__webpack_require__("vnWH"));
__webpack_require__("LHBr");
var _input = _interopRequireDefault(__webpack_require__("A+AJ"));
var _react = _interopRequireWildcard(__webpack_require__("GiK3"));
var _dva = __webpack_require__("S6G3");
__webpack_require__("PK9/");
var _checkRTC = _interopRequireDefault(__webpack_require__("8VXG"));
__webpack_require__("0wj8");
var _utils = __webpack_require__("oAV5");
var _common = _interopRequireDefault(__webpack_require__("pdZy"));
var _api = __webpack_require__("H/Zg");
var _nModal = _interopRequireDefault(__webpack_require__("RkMR"));
var _reactDom = _interopRequireDefault(__webpack_require__("O27J"));
var _VideoBox = _interopRequireDefault(__webpack_require__("d60R"));
var _RecordTimer = _interopRequireDefault(__webpack_require__("TnzN"));
var _RecordMini = _interopRequireDefault(__webpack_require__("LPk8"));
var _events = _interopRequireDefault(__webpack_require__("TLe5"));
var _dec, _class;
/**
 * 视频通话页面
 */
// import Presetting from './presetting';
// import { imKey } from "../../../utils/config";
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t3 in e) "default" !== _t3 && {}.hasOwnProperty.call(e, _t3) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t3)) && (i.get || i.set) ? o(f, _t3, i) : f[_t3] = e[_t3]); return f; })(e, t); }
function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i.return) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var Search = _input.default.Search;
var confirm = _modal.default.confirm,
  warning = _modal.default.warning,
  success = _modal.default.success,
  error = _modal.default.error;
var Video = exports.default = (_dec = (0, _dva.connect)(function (state) {
  return {
    ownCid: state.im.v5Data.ownCid,
    ownName: state.im.v5Data.ownName,
    videoMember: state.command.videoMember,
    recordStatus: state.command.recordStatus,
    // 0：未录制 1：录制中
    videoGenre: state.command.videoGenre // 功能类型 0: 视频调度(一对多) 1: 视频上拉(一对一)
  };
}), _dec(_class = /*#__PURE__*/function (_Component) {
  function Video(props) {
    var _this2;
    (0, _classCallCheck2.default)(this, Video);
    _this2 = _callSuper(this, Video, [props]);
    _this2.onChangeVideoSize = function (value) {
      _this2.setState({
        videoSize: value
      });
    };
    // 解散房间弹窗
    _this2.dissolutionRoomModal = function () {
      var _this = _this2;
      var recordStatus = _this.props.recordStatus;
      if (recordStatus == 1) {
        return _modal.default.warning({
          title: '目前还在录制视频中，请先结束视频录制！',
          okText: '我知道了'
        });
      }
      _modal.default.confirm({
        title: "您将解散房间?",
        content: "注：其他人员也将退出房间",
        okText: "确定",
        cancelText: "取消",
        onOk: function onOk() {
          _modal.default.destroyAll();
          // this.quitRTC();
          _this.common.leave(_this.state.Room_No);
          _this.dissolutionRoom();
          setTimeout(function () {
            _this.props.closeVideoState();
            _this.props.dispatch({
              type: 'command/fetchVideoGenre',
              payload: 0
            });
            _this.props.dispatch({
              type: 'command/fetchVideoType',
              payload: 0
            });
          }, 200);
          _this.hasStop = true;
        },
        onCancel: function onCancel() {
          console.log("Cancel");
        }
      });
    };
    // 添加调度人员
    _this2.onAddMember = function () {
      (0, _nModal.default)({
        title: '添加视频调度人员',
        footer: null,
        width: 500,
        content: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(Search, {
          placeholder: "\u8BF7\u8F93\u5165\u8C03\u5EA6\u8005\u5B8C\u6574\u624B\u673A\u53F7\uFF0C\u5982\u8C03\u5EA6\u591A\u4EBA\u8BF7\u4F7F\u7528\u201C/\u201D\u9694\u5F00",
          enterButton: "\u8C03\u5EA6",
          size: "default",
          onSearch: function onSearch(value) {
            console.log(value);
            if (value) {
              _this2.joinMemberVideo(value);
            } else {
              _message2.default.warning('请输入完整手机号');
            }
          }
        }))
      });
    };
    _this2.common = _common.default.call(_this2);
    _this2.state = {
      RTC: null,
      Room_No: props.Room_No,
      //房间号
      // MemberList: props.MemberList,
      mobilePhone: props.mobilePhone,
      imSig: props.imSig,
      height: null,
      rtc: null,
      isCamOn: true,
      isMicOn: true,
      //拖动
      text: {
        isDown: false,
        offsetLeft: 0,
        offsetTop: 0
      },
      videoLocal: {
        isDown: false,
        offsetLeft: 0,
        offsetTop: 0
      },
      videoSize: 2 // 0：只显示标题； 1：只显示当前发言人视频；2：最大化
    };
    _this2.videoTimer = null;
    _this2.videoMaxTimeCount = 60;
    _this2.hasStop = false;
    return _this2;
  }
  (0, _inherits2.default)(Video, _Component);
  return (0, _createClass2.default)(Video, [{
    key: "forceConnect",
    value: function forceConnect() {
      console.log('强制连接', this.props.videoMember);
      var that = this;
      var mobilePhone = this.props.videoMember.length > 0 && this.props.videoMember[0]['mobilePhone'];
      var status = this.props.videoMember.length > 0 && this.props.videoMember[0]['status'];
      if (status == 'yes') {
        that.hasStop = true;
        return;
      }
      confirm({
        title: '视频上拉失败',
        okText: '再次上拉',
        cancelText: '取消',
        onOk: function onOk() {
          // 强制关闭房间
          that.common.leave(that.state.Room_No);
          that.dissolutionRoom();
          setTimeout(function () {
            that.props.closeVideoState();
          }, 200);
          // 强制重新开启房间
          var data = {
            mobilePhone: mobilePhone
          };
          setTimeout(function () {
            _events.default.emit('clickTextScheduling', {
              item: [data],
              type: "video",
              isNeedRecord: [mobilePhone]
            });
          }, 700);
          that._videoInterval();
        },
        onCancel: function onCancel() {
          console.log('Cancel');
        }
      });
    }
  }, {
    key: "_videoInterval",
    value: function _videoInterval() {
      var that = this;
      this.videoTimer = null;
      this.hasStop = false;
      var number = 0;
      this.videoTimer = setInterval(function () {
        number++;
        console.log('videoTimer-number', number);
        if (number > that.videoMaxTimeCount) {
          that.forceConnect();
          clearInterval(that.videoTimer);
        }
        if (that.hasStop) {
          clearInterval(that.videoTimer);
        }
      }, 1000);
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var that = this;
      (0, _checkRTC.default)();
      var height = document.documentElement.clientHeight - 5;
      this.setState({
        height: height
      });
      this.common.login(this.state.Room_No, this.state.mobilePhone, this.props.ownCid, this.props.ownName, this);
      if (this.props.videoGenre == 1) {
        this._videoInterval();
      }
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      console.log(nextProps);
    }
    //解散房间
  }, {
    key: "dissolutionRoom",
    value: function dissolutionRoom() {
      // window.close();
      (0, _api.trtcVideoRoom)({
        roomNo: this.state.Room_No
      }).then(function (res) {
        console.log(res);
      });
    }
  }, {
    key: "joinMemberVideo",
    value: //加入视频成员
    function () {
      var _joinMemberVideo = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator().m(function _callee(value) {
        var memberList, _this$props, isNeedRecord, schedulingName, memberCidList, uidList, needRecordCidList, videoMember, _iterator, _step, item, data, persons, _iterator2, _step2, recordPhone, _t, _t2;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.p = _context.n) {
            case 0:
              console.log('joinMemberVideo', value);
              memberList = value.split('/');
              _this$props = this.props, isNeedRecord = _this$props.isNeedRecord, schedulingName = _this$props.schedulingName;
              memberCidList = []; //视频人员cid
              uidList = []; //视频人员uid
              needRecordCidList = []; //需要录屏的人员cid
              videoMember = []; //用于记录是否已经进入房间使用
              _iterator = _createForOfIteratorHelper(memberList);
              _context.p = 1;
              _iterator.s();
            case 2:
              if ((_step = _iterator.n()).done) {
                _context.n = 13;
                break;
              }
              item = _step.value;
              if (!item) {
                _context.n = 12;
                break;
              }
              videoMember.push({
                mobilePhone: item,
                status: 'no',
                id: item + 'no'
              });
              _context.n = 3;
              return (0, _api.searchDeptUser)({
                keyWord: item
              });
            case 3:
              data = _context.v;
              if (!(data && data.data)) {
                _context.n = 11;
                break;
              }
              persons = data.data[0]; // uidList.push(item)
              uidList.push("".concat(persons.mobile, ";").concat(persons.id, ";").concat(persons.domainId));
              memberCidList.push(data.data[0].item_cid);
              if (!(isNeedRecord.length > 0)) {
                _context.n = 10;
                break;
              }
              _iterator2 = _createForOfIteratorHelper(isNeedRecord);
              _context.p = 4;
              _iterator2.s();
            case 5:
              if ((_step2 = _iterator2.n()).done) {
                _context.n = 7;
                break;
              }
              recordPhone = _step2.value;
              if (!(recordPhone == item)) {
                _context.n = 6;
                break;
              }
              needRecordCidList.push(data.data[0].item_cid);
              return _context.a(3, 7);
            case 6:
              _context.n = 5;
              break;
            case 7:
              _context.n = 9;
              break;
            case 8:
              _context.p = 8;
              _t = _context.v;
              _iterator2.e(_t);
            case 9:
              _context.p = 9;
              _iterator2.f();
              return _context.f(9);
            case 10:
              _context.n = 12;
              break;
            case 11:
              return _context.a(2, _message2.default.info('手机号:' + item + '的用户不属于平台用户，无法调度，请核对后重新调度'));
            case 12:
              _context.n = 2;
              break;
            case 13:
              _context.n = 15;
              break;
            case 14:
              _context.p = 14;
              _t2 = _context.v;
              _iterator.e(_t2);
            case 15:
              _context.p = 15;
              _iterator.f();
              return _context.f(15);
            case 16:
              this.props.dispatch({
                type: 'command/fetchVideoMemberList',
                payload: {
                  type: 'add',
                  memberList: videoMember
                }
              });
              (0, _api.continueSendVideoRoomMsg)({
                RoomNo: this.state.Room_No,
                //房间号
                MemberList: memberCidList.join(","),
                //视频人员,cid，多个逗号隔开
                Yardman_Task_Name: schedulingName,
                //调度任务名称
                Transcriber: isNeedRecord ? needRecordCidList : '',
                //需要录制的人员的cid，多个逗号隔开
                UseList: uidList.join(","),
                //视频人员uid（手机号），跟MemberList一一对应
                ComId: (0, _utils.gup)('v5_comId', window.location.href) //v5的企业ID
              }).then(function (res) {
                if (res.retType === "0") {
                  setTimeout(function () {
                    var divs = document.getElementsByClassName('n_modal');
                    Reflect.apply(Array.prototype.forEach, divs, [function (item) {
                      _reactDom.default.unmountComponentAtNode(item);
                      document.body.removeChild(item);
                    }]);
                  }, 300);
                }
              });
            case 17:
              return _context.a(2);
          }
        }, _callee, this, [[4, 8, 9, 10], [1, 14, 15, 16]]);
      }));
      function joinMemberVideo(_x) {
        return _joinMemberVideo.apply(this, arguments);
      }
      return joinMemberVideo;
    }()
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;
      var _this$props2 = this.props,
        videoMember = _this$props2.videoMember,
        videoGenre = _this$props2.videoGenre;
      var _this$state = this.state,
        videoSize = _this$state.videoSize,
        videoVisible = _this$state.videoVisible;
      var hasVideoScheduling = videoGenre == 0 ? true : false;
      return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
        id: "video-section"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "calling"
      }, videoMember.map(function (item) {
        return /*#__PURE__*/_react.default.createElement("div", null, item.status == 'delete' ? '' : /*#__PURE__*/_react.default.createElement("div", {
          className: "item",
          id: item.id
        }, item.status == 'no' ? '等待' + item.mobilePhone + '接入' : item.status == 'yes' ? item.mobilePhone + '接入成功' : item.status == 'leave' ? item.mobilePhone + '已离开' : item.status == 'fail' ? /*#__PURE__*/_react.default.createElement("span", null, item.mobilePhone + '调度失败', /*#__PURE__*/_react.default.createElement("span", {
          className: "again",
          onClick: function onClick() {
            _this3.joinMemberVideo(item.mobilePhone);
          }
        }, "\u91CD\u65B0\u8C03\u5EA6")) : ''));
      })), /*#__PURE__*/_react.default.createElement(_VideoBox.default, {
        _videoThis: this,
        dissolutionRoomModal: this.dissolutionRoomModal,
        common: this.common,
        videoSize: videoSize,
        addMember: this.onAddMember
      })), /*#__PURE__*/_react.default.createElement(_RecordTimer.default, null), hasVideoScheduling ? /*#__PURE__*/_react.default.createElement(_RecordMini.default, {
        videoSize: videoSize,
        onChange: this.onChangeVideoSize.bind(this)
      }) : null);
    }
  }]);
}(_react.Component)) || _class);

/***/ }),

/***/ "hK1P":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });

// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__("GiK3");
var react_default = /*#__PURE__*/__webpack_require__.n(react);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__("KSGD");
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);

// EXTERNAL MODULE: ./node_modules/react-lifecycles-compat/react-lifecycles-compat.es.js
var react_lifecycles_compat_es = __webpack_require__("R8mX");

// EXTERNAL MODULE: ./node_modules/antd/node_modules/classnames/index.js
var classnames = __webpack_require__("kTQ8");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: ./node_modules/rc-checkbox/es/index.js + 1 modules
var es = __webpack_require__("jF3+");

// EXTERNAL MODULE: ./node_modules/shallowequal/index.js
var shallowequal = __webpack_require__("Ngpj");
var shallowequal_default = /*#__PURE__*/__webpack_require__.n(shallowequal);

// EXTERNAL MODULE: ./node_modules/antd/es/config-provider/index.js + 1 modules
var config_provider = __webpack_require__("PmSq");

// EXTERNAL MODULE: ./node_modules/antd/es/_util/warning.js
var warning = __webpack_require__("qGip");

// CONCATENATED MODULE: ./node_modules/antd/es/checkbox/Checkbox.js
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};










var Checkbox_Checkbox = /*#__PURE__*/function (_React$Component) {
  _inherits(Checkbox, _React$Component);

  var _super = _createSuper(Checkbox);

  function Checkbox() {
    var _this;

    _classCallCheck(this, Checkbox);

    _this = _super.apply(this, arguments);

    _this.saveCheckbox = function (node) {
      _this.rcCheckbox = node;
    };

    _this.renderCheckbox = function (_ref) {
      var _classNames;

      var getPrefixCls = _ref.getPrefixCls;

      var _assertThisInitialize = _assertThisInitialized(_this),
          props = _assertThisInitialize.props,
          context = _assertThisInitialize.context;

      var customizePrefixCls = props.prefixCls,
          className = props.className,
          children = props.children,
          indeterminate = props.indeterminate,
          style = props.style,
          onMouseEnter = props.onMouseEnter,
          onMouseLeave = props.onMouseLeave,
          restProps = __rest(props, ["prefixCls", "className", "children", "indeterminate", "style", "onMouseEnter", "onMouseLeave"]);

      var checkboxGroup = context.checkboxGroup;
      var prefixCls = getPrefixCls('checkbox', customizePrefixCls);

      var checkboxProps = _extends({}, restProps);

      if (checkboxGroup) {
        checkboxProps.onChange = function () {
          if (restProps.onChange) {
            restProps.onChange.apply(restProps, arguments);
          }

          checkboxGroup.toggleOption({
            label: children,
            value: props.value
          });
        };

        checkboxProps.name = checkboxGroup.name;
        checkboxProps.checked = checkboxGroup.value.indexOf(props.value) !== -1;
        checkboxProps.disabled = props.disabled || checkboxGroup.disabled;
      }

      var classString = classnames_default()(className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-wrapper"), true), _defineProperty(_classNames, "".concat(prefixCls, "-wrapper-checked"), checkboxProps.checked), _defineProperty(_classNames, "".concat(prefixCls, "-wrapper-disabled"), checkboxProps.disabled), _classNames));
      var checkboxClass = classnames_default()(_defineProperty({}, "".concat(prefixCls, "-indeterminate"), indeterminate));
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/label-has-associated-control
        react["createElement"]("label", {
          className: classString,
          style: style,
          onMouseEnter: onMouseEnter,
          onMouseLeave: onMouseLeave
        }, /*#__PURE__*/react["createElement"](es["a" /* default */], _extends({}, checkboxProps, {
          prefixCls: prefixCls,
          className: checkboxClass,
          ref: _this.saveCheckbox
        })), children !== undefined && /*#__PURE__*/react["createElement"]("span", null, children))
      );
    };

    return _this;
  }

  _createClass(Checkbox, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var value = this.props.value;

      var _ref2 = this.context || {},
          _ref2$checkboxGroup = _ref2.checkboxGroup,
          checkboxGroup = _ref2$checkboxGroup === void 0 ? {} : _ref2$checkboxGroup;

      if (checkboxGroup.registerValue) {
        checkboxGroup.registerValue(value);
      }

      Object(warning["a" /* default */])('checked' in this.props || (this.context || {}).checkboxGroup || !('value' in this.props), 'Checkbox', '`value` is not validate prop, do you mean `checked`?');
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      return !shallowequal_default()(this.props, nextProps) || !shallowequal_default()(this.state, nextState) || !shallowequal_default()(this.context.checkboxGroup, nextContext.checkboxGroup);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref3) {
      var prevValue = _ref3.value;
      var value = this.props.value;

      var _ref4 = this.context || {},
          _ref4$checkboxGroup = _ref4.checkboxGroup,
          checkboxGroup = _ref4$checkboxGroup === void 0 ? {} : _ref4$checkboxGroup;

      if (value !== prevValue && checkboxGroup.registerValue && checkboxGroup.cancelValue) {
        checkboxGroup.cancelValue(prevValue);
        checkboxGroup.registerValue(value);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var value = this.props.value;

      var _ref5 = this.context || {},
          _ref5$checkboxGroup = _ref5.checkboxGroup,
          checkboxGroup = _ref5$checkboxGroup === void 0 ? {} : _ref5$checkboxGroup;

      if (checkboxGroup.cancelValue) {
        checkboxGroup.cancelValue(value);
      }
    }
  }, {
    key: "focus",
    value: function focus() {
      this.rcCheckbox.focus();
    }
  }, {
    key: "blur",
    value: function blur() {
      this.rcCheckbox.blur();
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/react["createElement"](config_provider["ConfigConsumer"], null, this.renderCheckbox);
    }
  }]);

  return Checkbox;
}(react["Component"]);

Checkbox_Checkbox.__ANT_CHECKBOX = true;
Checkbox_Checkbox.defaultProps = {
  indeterminate: false
};
Checkbox_Checkbox.contextTypes = {
  checkboxGroup: prop_types["any"]
};
Object(react_lifecycles_compat_es["polyfill"])(Checkbox_Checkbox);
/* harmony default export */ var checkbox_Checkbox = (Checkbox_Checkbox);
// EXTERNAL MODULE: ./node_modules/omit.js/es/index.js
var omit_js_es = __webpack_require__("JkBm");

// CONCATENATED MODULE: ./node_modules/antd/es/checkbox/Group.js
function Group__typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { Group__typeof = function _typeof(obj) { return typeof obj; }; } else { Group__typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return Group__typeof(obj); }

function Group__extends() { Group__extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return Group__extends.apply(this, arguments); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function Group__classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function Group__defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function Group__createClass(Constructor, protoProps, staticProps) { if (protoProps) Group__defineProperties(Constructor.prototype, protoProps); if (staticProps) Group__defineProperties(Constructor, staticProps); return Constructor; }

function Group__inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) Group__setPrototypeOf(subClass, superClass); }

function Group__setPrototypeOf(o, p) { Group__setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return Group__setPrototypeOf(o, p); }

function Group__createSuper(Derived) { var hasNativeReflectConstruct = Group__isNativeReflectConstruct(); return function _createSuperInternal() { var Super = Group__getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = Group__getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return Group__possibleConstructorReturn(this, result); }; }

function Group__possibleConstructorReturn(self, call) { if (call && (Group__typeof(call) === "object" || typeof call === "function")) { return call; } return Group__assertThisInitialized(self); }

function Group__assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function Group__isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function Group__getPrototypeOf(o) { Group__getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return Group__getPrototypeOf(o); }

var Group___rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};










var Group_CheckboxGroup = /*#__PURE__*/function (_React$Component) {
  Group__inherits(CheckboxGroup, _React$Component);

  var _super = Group__createSuper(CheckboxGroup);

  function CheckboxGroup(props) {
    var _this;

    Group__classCallCheck(this, CheckboxGroup);

    _this = _super.call(this, props);

    _this.cancelValue = function (value) {
      _this.setState(function (_ref) {
        var registeredValues = _ref.registeredValues;
        return {
          registeredValues: registeredValues.filter(function (val) {
            return val !== value;
          })
        };
      });
    };

    _this.registerValue = function (value) {
      _this.setState(function (_ref2) {
        var registeredValues = _ref2.registeredValues;
        return {
          registeredValues: [].concat(_toConsumableArray(registeredValues), [value])
        };
      });
    };

    _this.toggleOption = function (option) {
      var registeredValues = _this.state.registeredValues;

      var optionIndex = _this.state.value.indexOf(option.value);

      var value = _toConsumableArray(_this.state.value);

      if (optionIndex === -1) {
        value.push(option.value);
      } else {
        value.splice(optionIndex, 1);
      }

      if (!('value' in _this.props)) {
        _this.setState({
          value: value
        });
      }

      var onChange = _this.props.onChange;

      if (onChange) {
        var options = _this.getOptions();

        onChange(value.filter(function (val) {
          return registeredValues.indexOf(val) !== -1;
        }).sort(function (a, b) {
          var indexA = options.findIndex(function (opt) {
            return opt.value === a;
          });
          var indexB = options.findIndex(function (opt) {
            return opt.value === b;
          });
          return indexA - indexB;
        }));
      }
    };

    _this.renderGroup = function (_ref3) {
      var getPrefixCls = _ref3.getPrefixCls;

      var _assertThisInitialize = Group__assertThisInitialized(_this),
          props = _assertThisInitialize.props,
          state = _assertThisInitialize.state;

      var customizePrefixCls = props.prefixCls,
          className = props.className,
          style = props.style,
          options = props.options,
          restProps = Group___rest(props, ["prefixCls", "className", "style", "options"]);

      var prefixCls = getPrefixCls('checkbox', customizePrefixCls);
      var groupPrefixCls = "".concat(prefixCls, "-group");
      var domProps = Object(omit_js_es["a" /* default */])(restProps, ['children', 'defaultValue', 'value', 'onChange', 'disabled']);
      var children = props.children;

      if (options && options.length > 0) {
        children = _this.getOptions().map(function (option) {
          return /*#__PURE__*/react["createElement"](checkbox_Checkbox, {
            prefixCls: prefixCls,
            key: option.value.toString(),
            disabled: 'disabled' in option ? option.disabled : props.disabled,
            value: option.value,
            checked: state.value.indexOf(option.value) !== -1,
            onChange: option.onChange,
            className: "".concat(groupPrefixCls, "-item")
          }, option.label);
        });
      }

      var classString = classnames_default()(groupPrefixCls, className);
      return /*#__PURE__*/react["createElement"]("div", Group__extends({
        className: classString,
        style: style
      }, domProps), children);
    };

    _this.state = {
      value: props.value || props.defaultValue || [],
      registeredValues: []
    };
    return _this;
  }

  Group__createClass(CheckboxGroup, [{
    key: "getChildContext",
    value: function getChildContext() {
      return {
        checkboxGroup: {
          toggleOption: this.toggleOption,
          value: this.state.value,
          disabled: this.props.disabled,
          name: this.props.name,
          // https://github.com/ant-design/ant-design/issues/16376
          registerValue: this.registerValue,
          cancelValue: this.cancelValue
        }
      };
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      return !shallowequal_default()(this.props, nextProps) || !shallowequal_default()(this.state, nextState);
    }
  }, {
    key: "getOptions",
    value: function getOptions() {
      var options = this.props.options; // https://github.com/Microsoft/TypeScript/issues/7960

      return options.map(function (option) {
        if (typeof option === 'string') {
          return {
            label: option,
            value: option
          };
        }

        return option;
      });
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/react["createElement"](config_provider["ConfigConsumer"], null, this.renderGroup);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps) {
      if ('value' in nextProps) {
        return {
          value: nextProps.value || []
        };
      }

      return null;
    }
  }]);

  return CheckboxGroup;
}(react["Component"]);

Group_CheckboxGroup.defaultProps = {
  options: []
};
Group_CheckboxGroup.propTypes = {
  defaultValue: prop_types["array"],
  value: prop_types["array"],
  options: prop_types["array"].isRequired,
  onChange: prop_types["func"]
};
Group_CheckboxGroup.childContextTypes = {
  checkboxGroup: prop_types["any"]
};
Object(react_lifecycles_compat_es["polyfill"])(Group_CheckboxGroup);
/* harmony default export */ var Group = (Group_CheckboxGroup);
// CONCATENATED MODULE: ./node_modules/antd/es/checkbox/index.js


checkbox_Checkbox.Group = Group;
/* harmony default export */ var es_checkbox = __webpack_exports__["default"] = (checkbox_Checkbox);

/***/ }),

/***/ "hwng":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAEBJREFUOE9jZKAQMML08xX8v8/AwKBApHkPPk1gVASppZ4BRNqMoQzugmFgwGgskBuJSCmRXCOol5QpjkZyvQAA4pweERMlTbUAAAAASUVORK5CYII="

/***/ }),

/***/ "jF3+":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXTERNAL MODULE: ./node_modules/babel-runtime/helpers/objectWithoutProperties.js
var objectWithoutProperties = __webpack_require__("+6Bu");
var objectWithoutProperties_default = /*#__PURE__*/__webpack_require__.n(objectWithoutProperties);

// EXTERNAL MODULE: ./node_modules/babel-runtime/helpers/extends.js
var helpers_extends = __webpack_require__("Dd8w");
var extends_default = /*#__PURE__*/__webpack_require__.n(helpers_extends);

// EXTERNAL MODULE: ./node_modules/babel-runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__("Zrlr");
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/babel-runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__("zwoO");
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/babel-runtime/helpers/inherits.js
var inherits = __webpack_require__("Pf15");
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/react/index.js
var react = __webpack_require__("GiK3");
var react_default = /*#__PURE__*/__webpack_require__.n(react);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__("KSGD");
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__("HW6M");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: ./node_modules/react-lifecycles-compat/react-lifecycles-compat.es.js
var react_lifecycles_compat_es = __webpack_require__("R8mX");

// CONCATENATED MODULE: ./node_modules/rc-checkbox/es/Checkbox.js










var Checkbox_Checkbox = function (_Component) {
  inherits_default()(Checkbox, _Component);

  function Checkbox(props) {
    classCallCheck_default()(this, Checkbox);

    var _this = possibleConstructorReturn_default()(this, _Component.call(this, props));

    _this.handleChange = function (e) {
      var _this$props = _this.props,
          disabled = _this$props.disabled,
          onChange = _this$props.onChange;

      if (disabled) {
        return;
      }
      if (!('checked' in _this.props)) {
        _this.setState({
          checked: e.target.checked
        });
      }
      if (onChange) {
        onChange({
          target: extends_default()({}, _this.props, {
            checked: e.target.checked
          }),
          stopPropagation: function stopPropagation() {
            e.stopPropagation();
          },
          preventDefault: function preventDefault() {
            e.preventDefault();
          },

          nativeEvent: e.nativeEvent
        });
      }
    };

    _this.saveInput = function (node) {
      _this.input = node;
    };

    var checked = 'checked' in props ? props.checked : props.defaultChecked;

    _this.state = {
      checked: checked
    };
    return _this;
  }

  Checkbox.getDerivedStateFromProps = function getDerivedStateFromProps(props, state) {
    if ('checked' in props) {
      return extends_default()({}, state, {
        checked: props.checked
      });
    }
    return null;
  };

  Checkbox.prototype.focus = function focus() {
    this.input.focus();
  };

  Checkbox.prototype.blur = function blur() {
    this.input.blur();
  };

  Checkbox.prototype.render = function render() {
    var _classNames;

    var _props = this.props,
        prefixCls = _props.prefixCls,
        className = _props.className,
        style = _props.style,
        name = _props.name,
        id = _props.id,
        type = _props.type,
        disabled = _props.disabled,
        readOnly = _props.readOnly,
        tabIndex = _props.tabIndex,
        onClick = _props.onClick,
        onFocus = _props.onFocus,
        onBlur = _props.onBlur,
        autoFocus = _props.autoFocus,
        value = _props.value,
        others = objectWithoutProperties_default()(_props, ['prefixCls', 'className', 'style', 'name', 'id', 'type', 'disabled', 'readOnly', 'tabIndex', 'onClick', 'onFocus', 'onBlur', 'autoFocus', 'value']);

    var globalProps = Object.keys(others).reduce(function (prev, key) {
      if (key.substr(0, 5) === 'aria-' || key.substr(0, 5) === 'data-' || key === 'role') {
        prev[key] = others[key];
      }
      return prev;
    }, {});

    var checked = this.state.checked;

    var classString = classnames_default()(prefixCls, className, (_classNames = {}, _classNames[prefixCls + '-checked'] = checked, _classNames[prefixCls + '-disabled'] = disabled, _classNames));

    return react_default.a.createElement(
      'span',
      { className: classString, style: style },
      react_default.a.createElement('input', extends_default()({
        name: name,
        id: id,
        type: type,
        readOnly: readOnly,
        disabled: disabled,
        tabIndex: tabIndex,
        className: prefixCls + '-input',
        checked: !!checked,
        onClick: onClick,
        onFocus: onFocus,
        onBlur: onBlur,
        onChange: this.handleChange,
        autoFocus: autoFocus,
        ref: this.saveInput,
        value: value
      }, globalProps)),
      react_default.a.createElement('span', { className: prefixCls + '-inner' })
    );
  };

  return Checkbox;
}(react["Component"]);

Checkbox_Checkbox.propTypes = {
  prefixCls: prop_types_default.a.string,
  className: prop_types_default.a.string,
  style: prop_types_default.a.object,
  name: prop_types_default.a.string,
  id: prop_types_default.a.string,
  type: prop_types_default.a.string,
  defaultChecked: prop_types_default.a.oneOfType([prop_types_default.a.number, prop_types_default.a.bool]),
  checked: prop_types_default.a.oneOfType([prop_types_default.a.number, prop_types_default.a.bool]),
  disabled: prop_types_default.a.bool,
  onFocus: prop_types_default.a.func,
  onBlur: prop_types_default.a.func,
  onChange: prop_types_default.a.func,
  onClick: prop_types_default.a.func,
  tabIndex: prop_types_default.a.oneOfType([prop_types_default.a.string, prop_types_default.a.number]),
  readOnly: prop_types_default.a.bool,
  autoFocus: prop_types_default.a.bool,
  value: prop_types_default.a.any
};
Checkbox_Checkbox.defaultProps = {
  prefixCls: 'rc-checkbox',
  className: '',
  style: {},
  type: 'checkbox',
  defaultChecked: false,
  onFocus: function onFocus() {},
  onBlur: function onBlur() {},
  onChange: function onChange() {}
};


Object(react_lifecycles_compat_es["polyfill"])(Checkbox_Checkbox);

/* harmony default export */ var es_Checkbox = (Checkbox_Checkbox);
// CONCATENATED MODULE: ./node_modules/rc-checkbox/es/index.js


/* harmony default export */ var es = __webpack_exports__["a"] = (es_Checkbox);

/***/ }),

/***/ "kDXx":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAALtJREFUOE/dkjEKwkAQRf+AlYI3SBU9gGKhXQ4hapNJl3PkKjM5hSRiq0fQU9goqRzZYLEEYYsUQqbct/tY/nxCzyH3Pk3TMxEtfRcRHUVk586Y+QRg5XMzq8qy3FKe5+OmaZ4/PvJS1UmID0EAgJj5DmDWCfEiIhvHsyy7mdm8k9NVVdftFpIkGcVxPPUvRFH0KIriHeKtoM+0AmauASw8kQGoVfXw5RWAbk9qEdkPYY2hqoa4C/G/PfgA5/zGESit+pQAAAAASUVORK5CYII="

/***/ }),

/***/ "kXYA":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

function supportRef(node) {
  // Function component
  if (node.type && node.type.prototype && !node.type.prototype.render) {
    return false;
  }

  return true;
}

exports.supportRef = supportRef;

/***/ }),

/***/ "lNEh":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAK9JREFUOE+l000OwiAQBeAhaUzkBlxPF4RbzAlwC+eobnTBPVj6s+ACLpmmRk2rpXaQJeF9yUweAv48Yi4fQmhijCut9b30rgh472XOuQWAvTFmxwIG4XNKaYuIeTHACffoaARueATUhN8AEQnn3AkALr9m/tzFY4QncASAW0ppM7e0SaC/tNaupZQtEV05yGiJNchXkbjIZBM5SLHKA+TArvJr04jYKKXqPtPSX94BFiCTEcW54swAAAAASUVORK5CYII="

/***/ }),

/***/ "mbvs":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global, process) {var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

// Last time updated: 2021-03-09 3:20:22 AM UTC

// ________________
// RecordRTC v5.6.2

// Open-Sourced: https://github.com/muaz-khan/RecordRTC

// --------------------------------------------------
// Muaz Khan     - www.MuazKhan.com
// MIT License   - www.WebRTC-Experiment.com/licence
// --------------------------------------------------

// ____________
// RecordRTC.js

/**
 * {@link https://github.com/muaz-khan/RecordRTC|RecordRTC} is a WebRTC JavaScript library for audio/video as well as screen activity recording. It supports Chrome, Firefox, Opera, Android, and Microsoft Edge. Platforms: Linux, Mac and Windows. 
 * @summary Record audio, video or screen inside the browser.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef RecordRTC
 * @class
 * @example
 * var recorder = RecordRTC(mediaStream or [arrayOfMediaStream], {
 *     type: 'video', // audio or video or gif or canvas
 *     recorderType: MediaStreamRecorder || CanvasRecorder || StereoAudioRecorder || Etc
 * });
 * recorder.startRecording();
 * @see For further information:
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - Single media-stream object, array of media-streams, html-canvas-element, etc.
 * @param {object} config - {type:"video", recorderType: MediaStreamRecorder, disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, desiredSampRate: 16000, video: HTMLVideoElement, etc.}
 */

function RecordRTC(mediaStream, config) {
    if (!mediaStream) {
        throw 'First parameter is required.';
    }

    config = config || {
        type: 'video'
    };

    config = new RecordRTCConfiguration(mediaStream, config);

    // a reference to user's recordRTC object
    var self = this;

    function startRecording(config2) {
        if (!config.disableLogs) {
            console.log('RecordRTC version: ', self.version);
        }

        if (!!config2) {
            // allow users to set options using startRecording method
            // config2 is similar to main "config" object (second parameter over RecordRTC constructor)
            config = new RecordRTCConfiguration(mediaStream, config2);
        }

        if (!config.disableLogs) {
            console.log('started recording ' + config.type + ' stream.');
        }

        if (mediaRecorder) {
            mediaRecorder.clearRecordedData();
            mediaRecorder.record();

            setState('recording');

            if (self.recordingDuration) {
                handleRecordingDuration();
            }
            return self;
        }

        initRecorder(function() {
            if (self.recordingDuration) {
                handleRecordingDuration();
            }
        });

        return self;
    }

    function initRecorder(initCallback) {
        if (initCallback) {
            config.initCallback = function() {
                initCallback();
                initCallback = config.initCallback = null; // recorder.initRecorder should be call-backed once.
            };
        }

        var Recorder = new GetRecorderType(mediaStream, config);

        mediaRecorder = new Recorder(mediaStream, config);
        mediaRecorder.record();

        setState('recording');

        if (!config.disableLogs) {
            console.log('Initialized recorderType:', mediaRecorder.constructor.name, 'for output-type:', config.type);
        }
    }

    function stopRecording(callback) {
        callback = callback || function() {};

        if (!mediaRecorder) {
            warningLog();
            return;
        }

        if (self.state === 'paused') {
            self.resumeRecording();

            setTimeout(function() {
                stopRecording(callback);
            }, 1);
            return;
        }

        if (self.state !== 'recording' && !config.disableLogs) {
            console.warn('Recording state should be: "recording", however current state is: ', self.state);
        }

        if (!config.disableLogs) {
            console.log('Stopped recording ' + config.type + ' stream.');
        }

        if (config.type !== 'gif') {
            mediaRecorder.stop(_callback);
        } else {
            mediaRecorder.stop();
            _callback();
        }

        setState('stopped');

        function _callback(__blob) {
            if (!mediaRecorder) {
                if (typeof callback.call === 'function') {
                    callback.call(self, '');
                } else {
                    callback('');
                }
                return;
            }

            Object.keys(mediaRecorder).forEach(function(key) {
                if (typeof mediaRecorder[key] === 'function') {
                    return;
                }

                self[key] = mediaRecorder[key];
            });

            var blob = mediaRecorder.blob;

            if (!blob) {
                if (__blob) {
                    mediaRecorder.blob = blob = __blob;
                } else {
                    throw 'Recording failed.';
                }
            }

            if (blob && !config.disableLogs) {
                console.log(blob.type, '->', bytesToSize(blob.size));
            }

            if (callback) {
                var url;

                try {
                    url = URL.createObjectURL(blob);
                } catch (e) {}

                if (typeof callback.call === 'function') {
                    callback.call(self, url);
                } else {
                    callback(url);
                }
            }

            if (!config.autoWriteToDisk) {
                return;
            }

            getDataURL(function(dataURL) {
                var parameter = {};
                parameter[config.type + 'Blob'] = dataURL;
                DiskStorage.Store(parameter);
            });
        }
    }

    function pauseRecording() {
        if (!mediaRecorder) {
            warningLog();
            return;
        }

        if (self.state !== 'recording') {
            if (!config.disableLogs) {
                console.warn('Unable to pause the recording. Recording state: ', self.state);
            }
            return;
        }

        setState('paused');

        mediaRecorder.pause();

        if (!config.disableLogs) {
            console.log('Paused recording.');
        }
    }

    function resumeRecording() {
        if (!mediaRecorder) {
            warningLog();
            return;
        }

        if (self.state !== 'paused') {
            if (!config.disableLogs) {
                console.warn('Unable to resume the recording. Recording state: ', self.state);
            }
            return;
        }

        setState('recording');

        // not all libs have this method yet
        mediaRecorder.resume();

        if (!config.disableLogs) {
            console.log('Resumed recording.');
        }
    }

    function readFile(_blob) {
        postMessage(new FileReaderSync().readAsDataURL(_blob));
    }

    function getDataURL(callback, _mediaRecorder) {
        if (!callback) {
            throw 'Pass a callback function over getDataURL.';
        }

        var blob = _mediaRecorder ? _mediaRecorder.blob : (mediaRecorder || {}).blob;

        if (!blob) {
            if (!config.disableLogs) {
                console.warn('Blob encoder did not finish its job yet.');
            }

            setTimeout(function() {
                getDataURL(callback, _mediaRecorder);
            }, 1000);
            return;
        }

        if (typeof Worker !== 'undefined' && !navigator.mozGetUserMedia) {
            var webWorker = processInWebWorker(readFile);

            webWorker.onmessage = function(event) {
                callback(event.data);
            };

            webWorker.postMessage(blob);
        } else {
            var reader = new FileReader();
            reader.readAsDataURL(blob);
            reader.onload = function(event) {
                callback(event.target.result);
            };
        }

        function processInWebWorker(_function) {
            try {
                var blob = URL.createObjectURL(new Blob([_function.toString(),
                    'this.onmessage =  function (eee) {' + _function.name + '(eee.data);}'
                ], {
                    type: 'application/javascript'
                }));

                var worker = new Worker(blob);
                URL.revokeObjectURL(blob);
                return worker;
            } catch (e) {}
        }
    }

    function handleRecordingDuration(counter) {
        counter = counter || 0;

        if (self.state === 'paused') {
            setTimeout(function() {
                handleRecordingDuration(counter);
            }, 1000);
            return;
        }

        if (self.state === 'stopped') {
            return;
        }

        if (counter >= self.recordingDuration) {
            stopRecording(self.onRecordingStopped);
            return;
        }

        counter += 1000; // 1-second

        setTimeout(function() {
            handleRecordingDuration(counter);
        }, 1000);
    }

    function setState(state) {
        if (!self) {
            return;
        }

        self.state = state;

        if (typeof self.onStateChanged.call === 'function') {
            self.onStateChanged.call(self, state);
        } else {
            self.onStateChanged(state);
        }
    }

    var WARNING = 'It seems that recorder is destroyed or "startRecording" is not invoked for ' + config.type + ' recorder.';

    function warningLog() {
        if (config.disableLogs === true) {
            return;
        }

        console.warn(WARNING);
    }

    var mediaRecorder;

    var returnObject = {
        /**
         * This method starts the recording.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * var recorder = RecordRTC(mediaStream, {
         *     type: 'video'
         * });
         * recorder.startRecording();
         */
        startRecording: startRecording,

        /**
         * This method stops the recording. It is strongly recommended to get "blob" or "URI" inside the callback to make sure all recorders finished their job.
         * @param {function} callback - Callback to get the recorded blob.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * recorder.stopRecording(function() {
         *     // use either "this" or "recorder" object; both are identical
         *     video.src = this.toURL();
         *     var blob = this.getBlob();
         * });
         */
        stopRecording: stopRecording,

        /**
         * This method pauses the recording. You can resume recording using "resumeRecording" method.
         * @method
         * @memberof RecordRTC
         * @instance
         * @todo Firefox is unable to pause the recording. Fix it.
         * @example
         * recorder.pauseRecording();  // pause the recording
         * recorder.resumeRecording(); // resume again
         */
        pauseRecording: pauseRecording,

        /**
         * This method resumes the recording.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * recorder.pauseRecording();  // first of all, pause the recording
         * recorder.resumeRecording(); // now resume it
         */
        resumeRecording: resumeRecording,

        /**
         * This method initializes the recording.
         * @method
         * @memberof RecordRTC
         * @instance
         * @todo This method should be deprecated.
         * @example
         * recorder.initRecorder();
         */
        initRecorder: initRecorder,

        /**
         * Ask RecordRTC to auto-stop the recording after 5 minutes.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * var fiveMinutes = 5 * 1000 * 60;
         * recorder.setRecordingDuration(fiveMinutes, function() {
         *    var blob = this.getBlob();
         *    video.src = this.toURL();
         * });
         * 
         * // or otherwise
         * recorder.setRecordingDuration(fiveMinutes).onRecordingStopped(function() {
         *    var blob = this.getBlob();
         *    video.src = this.toURL();
         * });
         */
        setRecordingDuration: function(recordingDuration, callback) {
            if (typeof recordingDuration === 'undefined') {
                throw 'recordingDuration is required.';
            }

            if (typeof recordingDuration !== 'number') {
                throw 'recordingDuration must be a number.';
            }

            self.recordingDuration = recordingDuration;
            self.onRecordingStopped = callback || function() {};

            return {
                onRecordingStopped: function(callback) {
                    self.onRecordingStopped = callback;
                }
            };
        },

        /**
         * This method can be used to clear/reset all the recorded data.
         * @method
         * @memberof RecordRTC
         * @instance
         * @todo Figure out the difference between "reset" and "clearRecordedData" methods.
         * @example
         * recorder.clearRecordedData();
         */
        clearRecordedData: function() {
            if (!mediaRecorder) {
                warningLog();
                return;
            }

            mediaRecorder.clearRecordedData();

            if (!config.disableLogs) {
                console.log('Cleared old recorded data.');
            }
        },

        /**
         * Get the recorded blob. Use this method inside the "stopRecording" callback.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * recorder.stopRecording(function() {
         *     var blob = this.getBlob();
         *
         *     var file = new File([blob], 'filename.webm', {
         *         type: 'video/webm'
         *     });
         *
         *     var formData = new FormData();
         *     formData.append('file', file); // upload "File" object rather than a "Blob"
         *     uploadToServer(formData);
         * });
         * @returns {Blob} Returns recorded data as "Blob" object.
         */
        getBlob: function() {
            if (!mediaRecorder) {
                warningLog();
                return;
            }

            return mediaRecorder.blob;
        },

        /**
         * Get data-URI instead of Blob.
         * @param {function} callback - Callback to get the Data-URI.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * recorder.stopRecording(function() {
         *     recorder.getDataURL(function(dataURI) {
         *         video.src = dataURI;
         *     });
         * });
         */
        getDataURL: getDataURL,

        /**
         * Get virtual/temporary URL. Usage of this URL is limited to current tab.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * recorder.stopRecording(function() {
         *     video.src = this.toURL();
         * });
         * @returns {String} Returns a virtual/temporary URL for the recorded "Blob".
         */
        toURL: function() {
            if (!mediaRecorder) {
                warningLog();
                return;
            }

            return URL.createObjectURL(mediaRecorder.blob);
        },

        /**
         * Get internal recording object (i.e. internal module) e.g. MutliStreamRecorder, MediaStreamRecorder, StereoAudioRecorder or WhammyRecorder etc.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * var internalRecorder = recorder.getInternalRecorder();
         * if(internalRecorder instanceof MultiStreamRecorder) {
         *     internalRecorder.addStreams([newAudioStream]);
         *     internalRecorder.resetVideoStreams([screenStream]);
         * }
         * @returns {Object} Returns internal recording object.
         */
        getInternalRecorder: function() {
            return mediaRecorder;
        },

        /**
         * Invoke save-as dialog to save the recorded blob into your disk.
         * @param {string} fileName - Set your own file name.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * recorder.stopRecording(function() {
         *     this.save('file-name');
         *
         *     // or manually:
         *     invokeSaveAsDialog(this.getBlob(), 'filename.webm');
         * });
         */
        save: function(fileName) {
            if (!mediaRecorder) {
                warningLog();
                return;
            }

            invokeSaveAsDialog(mediaRecorder.blob, fileName);
        },

        /**
         * This method gets a blob from indexed-DB storage.
         * @param {function} callback - Callback to get the recorded blob.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * recorder.getFromDisk(function(dataURL) {
         *     video.src = dataURL;
         * });
         */
        getFromDisk: function(callback) {
            if (!mediaRecorder) {
                warningLog();
                return;
            }

            RecordRTC.getFromDisk(config.type, callback);
        },

        /**
         * This method appends an array of webp images to the recorded video-blob. It takes an "array" object.
         * @type {Array.<Array>}
         * @param {Array} arrayOfWebPImages - Array of webp images.
         * @method
         * @memberof RecordRTC
         * @instance
         * @todo This method should be deprecated.
         * @example
         * var arrayOfWebPImages = [];
         * arrayOfWebPImages.push({
         *     duration: index,
         *     image: 'data:image/webp;base64,...'
         * });
         * recorder.setAdvertisementArray(arrayOfWebPImages);
         */
        setAdvertisementArray: function(arrayOfWebPImages) {
            config.advertisement = [];

            var length = arrayOfWebPImages.length;
            for (var i = 0; i < length; i++) {
                config.advertisement.push({
                    duration: i,
                    image: arrayOfWebPImages[i]
                });
            }
        },

        /**
         * It is equivalent to <code class="str">"recorder.getBlob()"</code> method. Usage of "getBlob" is recommended, though.
         * @property {Blob} blob - Recorded Blob can be accessed using this property.
         * @memberof RecordRTC
         * @instance
         * @readonly
         * @example
         * recorder.stopRecording(function() {
         *     var blob = this.blob;
         *
         *     // below one is recommended
         *     var blob = this.getBlob();
         * });
         */
        blob: null,

        /**
         * This works only with {recorderType:StereoAudioRecorder}. Use this property on "stopRecording" to verify the encoder's sample-rates.
         * @property {number} bufferSize - Buffer-size used to encode the WAV container
         * @memberof RecordRTC
         * @instance
         * @readonly
         * @example
         * recorder.stopRecording(function() {
         *     alert('Recorder used this buffer-size: ' + this.bufferSize);
         * });
         */
        bufferSize: 0,

        /**
         * This works only with {recorderType:StereoAudioRecorder}. Use this property on "stopRecording" to verify the encoder's sample-rates.
         * @property {number} sampleRate - Sample-rates used to encode the WAV container
         * @memberof RecordRTC
         * @instance
         * @readonly
         * @example
         * recorder.stopRecording(function() {
         *     alert('Recorder used these sample-rates: ' + this.sampleRate);
         * });
         */
        sampleRate: 0,

        /**
         * {recorderType:StereoAudioRecorder} returns ArrayBuffer object.
         * @property {ArrayBuffer} buffer - Audio ArrayBuffer, supported only in Chrome.
         * @memberof RecordRTC
         * @instance
         * @readonly
         * @example
         * recorder.stopRecording(function() {
         *     var arrayBuffer = this.buffer;
         *     alert(arrayBuffer.byteLength);
         * });
         */
        buffer: null,

        /**
         * This method resets the recorder. So that you can reuse single recorder instance many times.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * recorder.reset();
         * recorder.startRecording();
         */
        reset: function() {
            if (self.state === 'recording' && !config.disableLogs) {
                console.warn('Stop an active recorder.');
            }

            if (mediaRecorder && typeof mediaRecorder.clearRecordedData === 'function') {
                mediaRecorder.clearRecordedData();
            }
            mediaRecorder = null;
            setState('inactive');
            self.blob = null;
        },

        /**
         * This method is called whenever recorder's state changes. Use this as an "event".
         * @property {String} state - A recorder's state can be: recording, paused, stopped or inactive.
         * @method
         * @memberof RecordRTC
         * @instance
         * @example
         * recorder.onStateChanged = function(state) {
         *     console.log('Recorder state: ', state);
         * };
         */
        onStateChanged: function(state) {
            if (!config.disableLogs) {
                console.log('Recorder state changed:', state);
            }
        },

        /**
         * A recorder can have inactive, recording, paused or stopped states.
         * @property {String} state - A recorder's state can be: recording, paused, stopped or inactive.
         * @memberof RecordRTC
         * @static
         * @readonly
         * @example
         * // this looper function will keep you updated about the recorder's states.
         * (function looper() {
         *     document.querySelector('h1').innerHTML = 'Recorder\'s state is: ' + recorder.state;
         *     if(recorder.state === 'stopped') return; // ignore+stop
         *     setTimeout(looper, 1000); // update after every 3-seconds
         * })();
         * recorder.startRecording();
         */
        state: 'inactive',

        /**
         * Get recorder's readonly state.
         * @method
         * @memberof RecordRTC
         * @example
         * var state = recorder.getState();
         * @returns {String} Returns recording state.
         */
        getState: function() {
            return self.state;
        },

        /**
         * Destroy RecordRTC instance. Clear all recorders and objects.
         * @method
         * @memberof RecordRTC
         * @example
         * recorder.destroy();
         */
        destroy: function() {
            var disableLogsCache = config.disableLogs;

            config = {
                disableLogs: true
            };
            self.reset();
            setState('destroyed');
            returnObject = self = null;

            if (Storage.AudioContextConstructor) {
                Storage.AudioContextConstructor.close();
                Storage.AudioContextConstructor = null;
            }

            config.disableLogs = disableLogsCache;

            if (!config.disableLogs) {
                console.log('RecordRTC is destroyed.');
            }
        },

        /**
         * RecordRTC version number
         * @property {String} version - Release version number.
         * @memberof RecordRTC
         * @static
         * @readonly
         * @example
         * alert(recorder.version);
         */
        version: '5.6.2'
    };

    if (!this) {
        self = returnObject;
        return returnObject;
    }

    // if someone wants to use RecordRTC with the "new" keyword.
    for (var prop in returnObject) {
        this[prop] = returnObject[prop];
    }

    self = this;

    return returnObject;
}

RecordRTC.version = '5.6.2';

if (true /* && !!module.exports*/ ) {
    module.exports = RecordRTC;
}

if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
        return RecordRTC;
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
}

RecordRTC.getFromDisk = function(type, callback) {
    if (!callback) {
        throw 'callback is mandatory.';
    }

    console.log('Getting recorded ' + (type === 'all' ? 'blobs' : type + ' blob ') + ' from disk!');
    DiskStorage.Fetch(function(dataURL, _type) {
        if (type !== 'all' && _type === type + 'Blob' && callback) {
            callback(dataURL);
        }

        if (type === 'all' && callback) {
            callback(dataURL, _type.replace('Blob', ''));
        }
    });
};

/**
 * This method can be used to store recorded blobs into IndexedDB storage.
 * @param {object} options - {audio: Blob, video: Blob, gif: Blob}
 * @method
 * @memberof RecordRTC
 * @example
 * RecordRTC.writeToDisk({
 *     audio: audioBlob,
 *     video: videoBlob,
 *     gif  : gifBlob
 * });
 */
RecordRTC.writeToDisk = function(options) {
    console.log('Writing recorded blob(s) to disk!');
    options = options || {};
    if (options.audio && options.video && options.gif) {
        options.audio.getDataURL(function(audioDataURL) {
            options.video.getDataURL(function(videoDataURL) {
                options.gif.getDataURL(function(gifDataURL) {
                    DiskStorage.Store({
                        audioBlob: audioDataURL,
                        videoBlob: videoDataURL,
                        gifBlob: gifDataURL
                    });
                });
            });
        });
    } else if (options.audio && options.video) {
        options.audio.getDataURL(function(audioDataURL) {
            options.video.getDataURL(function(videoDataURL) {
                DiskStorage.Store({
                    audioBlob: audioDataURL,
                    videoBlob: videoDataURL
                });
            });
        });
    } else if (options.audio && options.gif) {
        options.audio.getDataURL(function(audioDataURL) {
            options.gif.getDataURL(function(gifDataURL) {
                DiskStorage.Store({
                    audioBlob: audioDataURL,
                    gifBlob: gifDataURL
                });
            });
        });
    } else if (options.video && options.gif) {
        options.video.getDataURL(function(videoDataURL) {
            options.gif.getDataURL(function(gifDataURL) {
                DiskStorage.Store({
                    videoBlob: videoDataURL,
                    gifBlob: gifDataURL
                });
            });
        });
    } else if (options.audio) {
        options.audio.getDataURL(function(audioDataURL) {
            DiskStorage.Store({
                audioBlob: audioDataURL
            });
        });
    } else if (options.video) {
        options.video.getDataURL(function(videoDataURL) {
            DiskStorage.Store({
                videoBlob: videoDataURL
            });
        });
    } else if (options.gif) {
        options.gif.getDataURL(function(gifDataURL) {
            DiskStorage.Store({
                gifBlob: gifDataURL
            });
        });
    }
};

// __________________________
// RecordRTC-Configuration.js

/**
 * {@link RecordRTCConfiguration} is an inner/private helper for {@link RecordRTC}.
 * @summary It configures the 2nd parameter passed over {@link RecordRTC} and returns a valid "config" object.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef RecordRTCConfiguration
 * @class
 * @example
 * var options = RecordRTCConfiguration(mediaStream, options);
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {type:"video", disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, video: HTMLVideoElement, getNativeBlob:true, etc.}
 */

function RecordRTCConfiguration(mediaStream, config) {
    if (!config.recorderType && !config.type) {
        if (!!config.audio && !!config.video) {
            config.type = 'video';
        } else if (!!config.audio && !config.video) {
            config.type = 'audio';
        }
    }

    if (config.recorderType && !config.type) {
        if (config.recorderType === WhammyRecorder || config.recorderType === CanvasRecorder || (typeof WebAssemblyRecorder !== 'undefined' && config.recorderType === WebAssemblyRecorder)) {
            config.type = 'video';
        } else if (config.recorderType === GifRecorder) {
            config.type = 'gif';
        } else if (config.recorderType === StereoAudioRecorder) {
            config.type = 'audio';
        } else if (config.recorderType === MediaStreamRecorder) {
            if (getTracks(mediaStream, 'audio').length && getTracks(mediaStream, 'video').length) {
                config.type = 'video';
            } else if (!getTracks(mediaStream, 'audio').length && getTracks(mediaStream, 'video').length) {
                config.type = 'video';
            } else if (getTracks(mediaStream, 'audio').length && !getTracks(mediaStream, 'video').length) {
                config.type = 'audio';
            } else {
                // config.type = 'UnKnown';
            }
        }
    }

    if (typeof MediaStreamRecorder !== 'undefined' && typeof MediaRecorder !== 'undefined' && 'requestData' in MediaRecorder.prototype) {
        if (!config.mimeType) {
            config.mimeType = 'video/webm';
        }

        if (!config.type) {
            config.type = config.mimeType.split('/')[0];
        }

        if (!config.bitsPerSecond) {
            // config.bitsPerSecond = 128000;
        }
    }

    // consider default type=audio
    if (!config.type) {
        if (config.mimeType) {
            config.type = config.mimeType.split('/')[0];
        }
        if (!config.type) {
            config.type = 'audio';
        }
    }

    return config;
}

// __________________
// GetRecorderType.js

/**
 * {@link GetRecorderType} is an inner/private helper for {@link RecordRTC}.
 * @summary It returns best recorder-type available for your browser.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef GetRecorderType
 * @class
 * @example
 * var RecorderType = GetRecorderType(options);
 * var recorder = new RecorderType(options);
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {type:"video", disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, video: HTMLVideoElement, etc.}
 */

function GetRecorderType(mediaStream, config) {
    var recorder;

    // StereoAudioRecorder can work with all three: Edge, Firefox and Chrome
    // todo: detect if it is Edge, then auto use: StereoAudioRecorder
    if (isChrome || isEdge || isOpera) {
        // Media Stream Recording API has not been implemented in chrome yet;
        // That's why using WebAudio API to record stereo audio in WAV format
        recorder = StereoAudioRecorder;
    }

    if (typeof MediaRecorder !== 'undefined' && 'requestData' in MediaRecorder.prototype && !isChrome) {
        recorder = MediaStreamRecorder;
    }

    // video recorder (in WebM format)
    if (config.type === 'video' && (isChrome || isOpera)) {
        recorder = WhammyRecorder;

        if (typeof WebAssemblyRecorder !== 'undefined' && typeof ReadableStream !== 'undefined') {
            recorder = WebAssemblyRecorder;
        }
    }

    // video recorder (in Gif format)
    if (config.type === 'gif') {
        recorder = GifRecorder;
    }

    // html2canvas recording!
    if (config.type === 'canvas') {
        recorder = CanvasRecorder;
    }

    if (isMediaRecorderCompatible() && recorder !== CanvasRecorder && recorder !== GifRecorder && typeof MediaRecorder !== 'undefined' && 'requestData' in MediaRecorder.prototype) {
        if (getTracks(mediaStream, 'video').length || getTracks(mediaStream, 'audio').length) {
            // audio-only recording
            if (config.type === 'audio') {
                if (typeof MediaRecorder.isTypeSupported === 'function' && MediaRecorder.isTypeSupported('audio/webm')) {
                    recorder = MediaStreamRecorder;
                }
                // else recorder = StereoAudioRecorder;
            } else {
                // video or screen tracks
                if (typeof MediaRecorder.isTypeSupported === 'function' && MediaRecorder.isTypeSupported('video/webm')) {
                    recorder = MediaStreamRecorder;
                }
            }
        }
    }

    if (mediaStream instanceof Array && mediaStream.length) {
        recorder = MultiStreamRecorder;
    }

    if (config.recorderType) {
        recorder = config.recorderType;
    }

    if (!config.disableLogs && !!recorder && !!recorder.name) {
        console.log('Using recorderType:', recorder.name || recorder.constructor.name);
    }

    if (!recorder && isSafari) {
        recorder = MediaStreamRecorder;
    }

    return recorder;
}

// _____________
// MRecordRTC.js

/**
 * MRecordRTC runs on top of {@link RecordRTC} to bring multiple recordings in a single place, by providing simple API.
 * @summary MRecordRTC stands for "Multiple-RecordRTC".
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef MRecordRTC
 * @class
 * @example
 * var recorder = new MRecordRTC();
 * recorder.addStream(MediaStream);
 * recorder.mediaType = {
 *     audio: true, // or StereoAudioRecorder or MediaStreamRecorder
 *     video: true, // or WhammyRecorder or MediaStreamRecorder or WebAssemblyRecorder or CanvasRecorder
 *     gif: true    // or GifRecorder
 * };
 * // mimeType is optional and should be set only in advance cases.
 * recorder.mimeType = {
 *     audio: 'audio/wav',
 *     video: 'video/webm',
 *     gif:   'image/gif'
 * };
 * recorder.startRecording();
 * @see For further information:
 * @see {@link https://github.com/muaz-khan/RecordRTC/tree/master/MRecordRTC|MRecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @requires {@link RecordRTC}
 */

function MRecordRTC(mediaStream) {

    /**
     * This method attaches MediaStream object to {@link MRecordRTC}.
     * @param {MediaStream} mediaStream - A MediaStream object, either fetched using getUserMedia API, or generated using captureStreamUntilEnded or WebAudio API.
     * @method
     * @memberof MRecordRTC
     * @example
     * recorder.addStream(MediaStream);
     */
    this.addStream = function(_mediaStream) {
        if (_mediaStream) {
            mediaStream = _mediaStream;
        }
    };

    /**
     * This property can be used to set the recording type e.g. audio, or video, or gif, or canvas.
     * @property {object} mediaType - {audio: true, video: true, gif: true}
     * @memberof MRecordRTC
     * @example
     * var recorder = new MRecordRTC();
     * recorder.mediaType = {
     *     audio: true, // TRUE or StereoAudioRecorder or MediaStreamRecorder
     *     video: true, // TRUE or WhammyRecorder or MediaStreamRecorder or WebAssemblyRecorder or CanvasRecorder
     *     gif  : true  // TRUE or GifRecorder
     * };
     */
    this.mediaType = {
        audio: true,
        video: true
    };

    /**
     * This method starts recording.
     * @method
     * @memberof MRecordRTC
     * @example
     * recorder.startRecording();
     */
    this.startRecording = function() {
        var mediaType = this.mediaType;
        var recorderType;
        var mimeType = this.mimeType || {
            audio: null,
            video: null,
            gif: null
        };

        if (typeof mediaType.audio !== 'function' && isMediaRecorderCompatible() && !getTracks(mediaStream, 'audio').length) {
            mediaType.audio = false;
        }

        if (typeof mediaType.video !== 'function' && isMediaRecorderCompatible() && !getTracks(mediaStream, 'video').length) {
            mediaType.video = false;
        }

        if (typeof mediaType.gif !== 'function' && isMediaRecorderCompatible() && !getTracks(mediaStream, 'video').length) {
            mediaType.gif = false;
        }

        if (!mediaType.audio && !mediaType.video && !mediaType.gif) {
            throw 'MediaStream must have either audio or video tracks.';
        }

        if (!!mediaType.audio) {
            recorderType = null;
            if (typeof mediaType.audio === 'function') {
                recorderType = mediaType.audio;
            }

            this.audioRecorder = new RecordRTC(mediaStream, {
                type: 'audio',
                bufferSize: this.bufferSize,
                sampleRate: this.sampleRate,
                numberOfAudioChannels: this.numberOfAudioChannels || 2,
                disableLogs: this.disableLogs,
                recorderType: recorderType,
                mimeType: mimeType.audio,
                timeSlice: this.timeSlice,
                onTimeStamp: this.onTimeStamp
            });

            if (!mediaType.video) {
                this.audioRecorder.startRecording();
            }
        }

        if (!!mediaType.video) {
            recorderType = null;
            if (typeof mediaType.video === 'function') {
                recorderType = mediaType.video;
            }

            var newStream = mediaStream;

            if (isMediaRecorderCompatible() && !!mediaType.audio && typeof mediaType.audio === 'function') {
                var videoTrack = getTracks(mediaStream, 'video')[0];

                if (isFirefox) {
                    newStream = new MediaStream();
                    newStream.addTrack(videoTrack);

                    if (recorderType && recorderType === WhammyRecorder) {
                        // Firefox does NOT supports webp-encoding yet
                        // But Firefox do supports WebAssemblyRecorder
                        recorderType = MediaStreamRecorder;
                    }
                } else {
                    newStream = new MediaStream();
                    newStream.addTrack(videoTrack);
                }
            }

            this.videoRecorder = new RecordRTC(newStream, {
                type: 'video',
                video: this.video,
                canvas: this.canvas,
                frameInterval: this.frameInterval || 10,
                disableLogs: this.disableLogs,
                recorderType: recorderType,
                mimeType: mimeType.video,
                timeSlice: this.timeSlice,
                onTimeStamp: this.onTimeStamp,
                workerPath: this.workerPath,
                webAssemblyPath: this.webAssemblyPath,
                frameRate: this.frameRate, // used by WebAssemblyRecorder; values: usually 30; accepts any.
                bitrate: this.bitrate // used by WebAssemblyRecorder; values: 0 to 1000+
            });

            if (!mediaType.audio) {
                this.videoRecorder.startRecording();
            }
        }

        if (!!mediaType.audio && !!mediaType.video) {
            var self = this;

            var isSingleRecorder = isMediaRecorderCompatible() === true;

            if (mediaType.audio instanceof StereoAudioRecorder && !!mediaType.video) {
                isSingleRecorder = false;
            } else if (mediaType.audio !== true && mediaType.video !== true && mediaType.audio !== mediaType.video) {
                isSingleRecorder = false;
            }

            if (isSingleRecorder === true) {
                self.audioRecorder = null;
                self.videoRecorder.startRecording();
            } else {
                self.videoRecorder.initRecorder(function() {
                    self.audioRecorder.initRecorder(function() {
                        // Both recorders are ready to record things accurately
                        self.videoRecorder.startRecording();
                        self.audioRecorder.startRecording();
                    });
                });
            }
        }

        if (!!mediaType.gif) {
            recorderType = null;
            if (typeof mediaType.gif === 'function') {
                recorderType = mediaType.gif;
            }
            this.gifRecorder = new RecordRTC(mediaStream, {
                type: 'gif',
                frameRate: this.frameRate || 200,
                quality: this.quality || 10,
                disableLogs: this.disableLogs,
                recorderType: recorderType,
                mimeType: mimeType.gif
            });
            this.gifRecorder.startRecording();
        }
    };

    /**
     * This method stops recording.
     * @param {function} callback - Callback function is invoked when all encoders finished their jobs.
     * @method
     * @memberof MRecordRTC
     * @example
     * recorder.stopRecording(function(recording){
     *     var audioBlob = recording.audio;
     *     var videoBlob = recording.video;
     *     var gifBlob   = recording.gif;
     * });
     */
    this.stopRecording = function(callback) {
        callback = callback || function() {};

        if (this.audioRecorder) {
            this.audioRecorder.stopRecording(function(blobURL) {
                callback(blobURL, 'audio');
            });
        }

        if (this.videoRecorder) {
            this.videoRecorder.stopRecording(function(blobURL) {
                callback(blobURL, 'video');
            });
        }

        if (this.gifRecorder) {
            this.gifRecorder.stopRecording(function(blobURL) {
                callback(blobURL, 'gif');
            });
        }
    };

    /**
     * This method pauses recording.
     * @method
     * @memberof MRecordRTC
     * @example
     * recorder.pauseRecording();
     */
    this.pauseRecording = function() {
        if (this.audioRecorder) {
            this.audioRecorder.pauseRecording();
        }

        if (this.videoRecorder) {
            this.videoRecorder.pauseRecording();
        }

        if (this.gifRecorder) {
            this.gifRecorder.pauseRecording();
        }
    };

    /**
     * This method resumes recording.
     * @method
     * @memberof MRecordRTC
     * @example
     * recorder.resumeRecording();
     */
    this.resumeRecording = function() {
        if (this.audioRecorder) {
            this.audioRecorder.resumeRecording();
        }

        if (this.videoRecorder) {
            this.videoRecorder.resumeRecording();
        }

        if (this.gifRecorder) {
            this.gifRecorder.resumeRecording();
        }
    };

    /**
     * This method can be used to manually get all recorded blobs.
     * @param {function} callback - All recorded blobs are passed back to the "callback" function.
     * @method
     * @memberof MRecordRTC
     * @example
     * recorder.getBlob(function(recording){
     *     var audioBlob = recording.audio;
     *     var videoBlob = recording.video;
     *     var gifBlob   = recording.gif;
     * });
     * // or
     * var audioBlob = recorder.getBlob().audio;
     * var videoBlob = recorder.getBlob().video;
     */
    this.getBlob = function(callback) {
        var output = {};

        if (this.audioRecorder) {
            output.audio = this.audioRecorder.getBlob();
        }

        if (this.videoRecorder) {
            output.video = this.videoRecorder.getBlob();
        }

        if (this.gifRecorder) {
            output.gif = this.gifRecorder.getBlob();
        }

        if (callback) {
            callback(output);
        }

        return output;
    };

    /**
     * Destroy all recorder instances.
     * @method
     * @memberof MRecordRTC
     * @example
     * recorder.destroy();
     */
    this.destroy = function() {
        if (this.audioRecorder) {
            this.audioRecorder.destroy();
            this.audioRecorder = null;
        }

        if (this.videoRecorder) {
            this.videoRecorder.destroy();
            this.videoRecorder = null;
        }

        if (this.gifRecorder) {
            this.gifRecorder.destroy();
            this.gifRecorder = null;
        }
    };

    /**
     * This method can be used to manually get all recorded blobs' DataURLs.
     * @param {function} callback - All recorded blobs' DataURLs are passed back to the "callback" function.
     * @method
     * @memberof MRecordRTC
     * @example
     * recorder.getDataURL(function(recording){
     *     var audioDataURL = recording.audio;
     *     var videoDataURL = recording.video;
     *     var gifDataURL   = recording.gif;
     * });
     */
    this.getDataURL = function(callback) {
        this.getBlob(function(blob) {
            if (blob.audio && blob.video) {
                getDataURL(blob.audio, function(_audioDataURL) {
                    getDataURL(blob.video, function(_videoDataURL) {
                        callback({
                            audio: _audioDataURL,
                            video: _videoDataURL
                        });
                    });
                });
            } else if (blob.audio) {
                getDataURL(blob.audio, function(_audioDataURL) {
                    callback({
                        audio: _audioDataURL
                    });
                });
            } else if (blob.video) {
                getDataURL(blob.video, function(_videoDataURL) {
                    callback({
                        video: _videoDataURL
                    });
                });
            }
        });

        function getDataURL(blob, callback00) {
            if (typeof Worker !== 'undefined') {
                var webWorker = processInWebWorker(function readFile(_blob) {
                    postMessage(new FileReaderSync().readAsDataURL(_blob));
                });

                webWorker.onmessage = function(event) {
                    callback00(event.data);
                };

                webWorker.postMessage(blob);
            } else {
                var reader = new FileReader();
                reader.readAsDataURL(blob);
                reader.onload = function(event) {
                    callback00(event.target.result);
                };
            }
        }

        function processInWebWorker(_function) {
            var blob = URL.createObjectURL(new Blob([_function.toString(),
                'this.onmessage =  function (eee) {' + _function.name + '(eee.data);}'
            ], {
                type: 'application/javascript'
            }));

            var worker = new Worker(blob);
            var url;
            if (typeof URL !== 'undefined') {
                url = URL;
            } else if (typeof webkitURL !== 'undefined') {
                url = webkitURL;
            } else {
                throw 'Neither URL nor webkitURL detected.';
            }
            url.revokeObjectURL(blob);
            return worker;
        }
    };

    /**
     * This method can be used to ask {@link MRecordRTC} to write all recorded blobs into IndexedDB storage.
     * @method
     * @memberof MRecordRTC
     * @example
     * recorder.writeToDisk();
     */
    this.writeToDisk = function() {
        RecordRTC.writeToDisk({
            audio: this.audioRecorder,
            video: this.videoRecorder,
            gif: this.gifRecorder
        });
    };

    /**
     * This method can be used to invoke a save-as dialog for all recorded blobs.
     * @param {object} args - {audio: 'audio-name', video: 'video-name', gif: 'gif-name'}
     * @method
     * @memberof MRecordRTC
     * @example
     * recorder.save({
     *     audio: 'audio-file-name',
     *     video: 'video-file-name',
     *     gif  : 'gif-file-name'
     * });
     */
    this.save = function(args) {
        args = args || {
            audio: true,
            video: true,
            gif: true
        };

        if (!!args.audio && this.audioRecorder) {
            this.audioRecorder.save(typeof args.audio === 'string' ? args.audio : '');
        }

        if (!!args.video && this.videoRecorder) {
            this.videoRecorder.save(typeof args.video === 'string' ? args.video : '');
        }
        if (!!args.gif && this.gifRecorder) {
            this.gifRecorder.save(typeof args.gif === 'string' ? args.gif : '');
        }
    };
}

/**
 * This method can be used to get all recorded blobs from IndexedDB storage.
 * @param {string} type - 'all' or 'audio' or 'video' or 'gif'
 * @param {function} callback - Callback function to get all stored blobs.
 * @method
 * @memberof MRecordRTC
 * @example
 * MRecordRTC.getFromDisk('all', function(dataURL, type){
 *     if(type === 'audio') { }
 *     if(type === 'video') { }
 *     if(type === 'gif')   { }
 * });
 */
MRecordRTC.getFromDisk = RecordRTC.getFromDisk;

/**
 * This method can be used to store recorded blobs into IndexedDB storage.
 * @param {object} options - {audio: Blob, video: Blob, gif: Blob}
 * @method
 * @memberof MRecordRTC
 * @example
 * MRecordRTC.writeToDisk({
 *     audio: audioBlob,
 *     video: videoBlob,
 *     gif  : gifBlob
 * });
 */
MRecordRTC.writeToDisk = RecordRTC.writeToDisk;

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.MRecordRTC = MRecordRTC;
}

var browserFakeUserAgent = 'Fake/5.0 (FakeOS) AppleWebKit/123 (KHTML, like Gecko) Fake/12.3.4567.89 Fake/123.45';

(function(that) {
    if (!that) {
        return;
    }

    if (typeof window !== 'undefined') {
        return;
    }

    if (typeof global === 'undefined') {
        return;
    }

    global.navigator = {
        userAgent: browserFakeUserAgent,
        getUserMedia: function() {}
    };

    if (!global.console) {
        global.console = {};
    }

    if (typeof global.console.log === 'undefined' || typeof global.console.error === 'undefined') {
        global.console.error = global.console.log = global.console.log || function() {
            console.log(arguments);
        };
    }

    if (typeof document === 'undefined') {
        /*global document:true */
        that.document = {
            documentElement: {
                appendChild: function() {
                    return '';
                }
            }
        };

        document.createElement = document.captureStream = document.mozCaptureStream = function() {
            var obj = {
                getContext: function() {
                    return obj;
                },
                play: function() {},
                pause: function() {},
                drawImage: function() {},
                toDataURL: function() {
                    return '';
                },
                style: {}
            };
            return obj;
        };

        that.HTMLVideoElement = function() {};
    }

    if (typeof location === 'undefined') {
        /*global location:true */
        that.location = {
            protocol: 'file:',
            href: '',
            hash: ''
        };
    }

    if (typeof screen === 'undefined') {
        /*global screen:true */
        that.screen = {
            width: 0,
            height: 0
        };
    }

    if (typeof URL === 'undefined') {
        /*global screen:true */
        that.URL = {
            createObjectURL: function() {
                return '';
            },
            revokeObjectURL: function() {
                return '';
            }
        };
    }

    /*global window:true */
    that.window = global;
})(typeof global !== 'undefined' ? global : null);

// _____________________________
// Cross-Browser-Declarations.js

// animation-frame used in WebM recording

/*jshint -W079 */
var requestAnimationFrame = window.requestAnimationFrame;
if (typeof requestAnimationFrame === 'undefined') {
    if (typeof webkitRequestAnimationFrame !== 'undefined') {
        /*global requestAnimationFrame:true */
        requestAnimationFrame = webkitRequestAnimationFrame;
    } else if (typeof mozRequestAnimationFrame !== 'undefined') {
        /*global requestAnimationFrame:true */
        requestAnimationFrame = mozRequestAnimationFrame;
    } else if (typeof msRequestAnimationFrame !== 'undefined') {
        /*global requestAnimationFrame:true */
        requestAnimationFrame = msRequestAnimationFrame;
    } else if (typeof requestAnimationFrame === 'undefined') {
        // via: https://gist.github.com/paulirish/1579671
        var lastTime = 0;

        /*global requestAnimationFrame:true */
        requestAnimationFrame = function(callback, element) {
            var currTime = new Date().getTime();
            var timeToCall = Math.max(0, 16 - (currTime - lastTime));
            var id = setTimeout(function() {
                callback(currTime + timeToCall);
            }, timeToCall);
            lastTime = currTime + timeToCall;
            return id;
        };
    }
}

/*jshint -W079 */
var cancelAnimationFrame = window.cancelAnimationFrame;
if (typeof cancelAnimationFrame === 'undefined') {
    if (typeof webkitCancelAnimationFrame !== 'undefined') {
        /*global cancelAnimationFrame:true */
        cancelAnimationFrame = webkitCancelAnimationFrame;
    } else if (typeof mozCancelAnimationFrame !== 'undefined') {
        /*global cancelAnimationFrame:true */
        cancelAnimationFrame = mozCancelAnimationFrame;
    } else if (typeof msCancelAnimationFrame !== 'undefined') {
        /*global cancelAnimationFrame:true */
        cancelAnimationFrame = msCancelAnimationFrame;
    } else if (typeof cancelAnimationFrame === 'undefined') {
        /*global cancelAnimationFrame:true */
        cancelAnimationFrame = function(id) {
            clearTimeout(id);
        };
    }
}

// WebAudio API representer
var AudioContext = window.AudioContext;

if (typeof AudioContext === 'undefined') {
    if (typeof webkitAudioContext !== 'undefined') {
        /*global AudioContext:true */
        AudioContext = webkitAudioContext;
    }

    if (typeof mozAudioContext !== 'undefined') {
        /*global AudioContext:true */
        AudioContext = mozAudioContext;
    }
}

/*jshint -W079 */
var URL = window.URL;

if (typeof URL === 'undefined' && typeof webkitURL !== 'undefined') {
    /*global URL:true */
    URL = webkitURL;
}

if (typeof navigator !== 'undefined' && typeof navigator.getUserMedia === 'undefined') { // maybe window.navigator?
    if (typeof navigator.webkitGetUserMedia !== 'undefined') {
        navigator.getUserMedia = navigator.webkitGetUserMedia;
    }

    if (typeof navigator.mozGetUserMedia !== 'undefined') {
        navigator.getUserMedia = navigator.mozGetUserMedia;
    }
}

var isEdge = navigator.userAgent.indexOf('Edge') !== -1 && (!!navigator.msSaveBlob || !!navigator.msSaveOrOpenBlob);
var isOpera = !!window.opera || navigator.userAgent.indexOf('OPR/') !== -1;
var isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1 && ('netscape' in window) && / rv:/.test(navigator.userAgent);
var isChrome = (!isOpera && !isEdge && !!navigator.webkitGetUserMedia) || isElectron() || navigator.userAgent.toLowerCase().indexOf('chrome/') !== -1;

var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);

if (isSafari && !isChrome && navigator.userAgent.indexOf('CriOS') !== -1) {
    isSafari = false;
    isChrome = true;
}

var MediaStream = window.MediaStream;

if (typeof MediaStream === 'undefined' && typeof webkitMediaStream !== 'undefined') {
    MediaStream = webkitMediaStream;
}

/*global MediaStream:true */
if (typeof MediaStream !== 'undefined') {
    // override "stop" method for all browsers
    if (typeof MediaStream.prototype.stop === 'undefined') {
        MediaStream.prototype.stop = function() {
            this.getTracks().forEach(function(track) {
                track.stop();
            });
        };
    }
}

// below function via: http://goo.gl/B3ae8c
/**
 * Return human-readable file size.
 * @param {number} bytes - Pass bytes and get formatted string.
 * @returns {string} - formatted string
 * @example
 * bytesToSize(1024*1024*5) === '5 GB'
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */
function bytesToSize(bytes) {
    var k = 1000;
    var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
    if (bytes === 0) {
        return '0 Bytes';
    }
    var i = parseInt(Math.floor(Math.log(bytes) / Math.log(k)), 10);
    return (bytes / Math.pow(k, i)).toPrecision(3) + ' ' + sizes[i];
}

/**
 * @param {Blob} file - File or Blob object. This parameter is required.
 * @param {string} fileName - Optional file name e.g. "Recorded-Video.webm"
 * @example
 * invokeSaveAsDialog(blob or file, [optional] fileName);
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */
function invokeSaveAsDialog(file, fileName) {
    if (!file) {
        throw 'Blob object is required.';
    }

    if (!file.type) {
        try {
            file.type = 'video/webm';
        } catch (e) {}
    }

    var fileExtension = (file.type || 'video/webm').split('/')[1];
    if (fileExtension.indexOf(';') !== -1) {
        // extended mimetype, e.g. 'video/webm;codecs=vp8,opus'
        fileExtension = fileExtension.split(';')[0];
    }
    if (fileName && fileName.indexOf('.') !== -1) {
        var splitted = fileName.split('.');
        fileName = splitted[0];
        fileExtension = splitted[1];
    }

    var fileFullName = (fileName || (Math.round(Math.random() * 9999999999) + 888888888)) + '.' + fileExtension;

    if (typeof navigator.msSaveOrOpenBlob !== 'undefined') {
        return navigator.msSaveOrOpenBlob(file, fileFullName);
    } else if (typeof navigator.msSaveBlob !== 'undefined') {
        return navigator.msSaveBlob(file, fileFullName);
    }

    var hyperlink = document.createElement('a');
    hyperlink.href = URL.createObjectURL(file);
    hyperlink.download = fileFullName;

    hyperlink.style = 'display:none;opacity:0;color:transparent;';
    (document.body || document.documentElement).appendChild(hyperlink);

    if (typeof hyperlink.click === 'function') {
        hyperlink.click();
    } else {
        hyperlink.target = '_blank';
        hyperlink.dispatchEvent(new MouseEvent('click', {
            view: window,
            bubbles: true,
            cancelable: true
        }));
    }

    URL.revokeObjectURL(hyperlink.href);
}

/**
 * from: https://github.com/cheton/is-electron/blob/master/index.js
 **/
function isElectron() {
    // Renderer process
    if (typeof window !== 'undefined' && typeof window.process === 'object' && window.process.type === 'renderer') {
        return true;
    }

    // Main process
    if (typeof process !== 'undefined' && typeof process.versions === 'object' && !!process.versions.electron) {
        return true;
    }

    // Detect the user agent when the `nodeIntegration` option is set to true
    if (typeof navigator === 'object' && typeof navigator.userAgent === 'string' && navigator.userAgent.indexOf('Electron') >= 0) {
        return true;
    }

    return false;
}

function getTracks(stream, kind) {
    if (!stream || !stream.getTracks) {
        return [];
    }

    return stream.getTracks().filter(function(t) {
        return t.kind === (kind || 'audio');
    });
}

function setSrcObject(stream, element) {
    if ('srcObject' in element) {
        element.srcObject = stream;
    } else if ('mozSrcObject' in element) {
        element.mozSrcObject = stream;
    } else {
        element.srcObject = stream;
    }
}

/**
 * @param {Blob} file - File or Blob object.
 * @param {function} callback - Callback function.
 * @example
 * getSeekableBlob(blob or file, callback);
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */
function getSeekableBlob(inputBlob, callback) {
    // EBML.js copyrights goes to: https://github.com/legokichi/ts-ebml
    if (typeof EBML === 'undefined') {
        throw new Error('Please link: https://www.webrtc-experiment.com/EBML.js');
    }

    var reader = new EBML.Reader();
    var decoder = new EBML.Decoder();
    var tools = EBML.tools;

    var fileReader = new FileReader();
    fileReader.onload = function(e) {
        var ebmlElms = decoder.decode(this.result);
        ebmlElms.forEach(function(element) {
            reader.read(element);
        });
        reader.stop();
        var refinedMetadataBuf = tools.makeMetadataSeekable(reader.metadatas, reader.duration, reader.cues);
        var body = this.result.slice(reader.metadataSize);
        var newBlob = new Blob([refinedMetadataBuf, body], {
            type: 'video/webm'
        });

        callback(newBlob);
    };
    fileReader.readAsArrayBuffer(inputBlob);
}

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.invokeSaveAsDialog = invokeSaveAsDialog;
    RecordRTC.getTracks = getTracks;
    RecordRTC.getSeekableBlob = getSeekableBlob;
    RecordRTC.bytesToSize = bytesToSize;
    RecordRTC.isElectron = isElectron;
}

// __________ (used to handle stuff like http://goo.gl/xmE5eg) issue #129
// Storage.js

/**
 * Storage is a standalone object used by {@link RecordRTC} to store reusable objects e.g. "new AudioContext".
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @example
 * Storage.AudioContext === webkitAudioContext
 * @property {webkitAudioContext} AudioContext - Keeps a reference to AudioContext object.
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */

var Storage = {};

if (typeof AudioContext !== 'undefined') {
    Storage.AudioContext = AudioContext;
} else if (typeof webkitAudioContext !== 'undefined') {
    Storage.AudioContext = webkitAudioContext;
}

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.Storage = Storage;
}

function isMediaRecorderCompatible() {
    if (isFirefox || isSafari || isEdge) {
        return true;
    }

    var nVer = navigator.appVersion;
    var nAgt = navigator.userAgent;
    var fullVersion = '' + parseFloat(navigator.appVersion);
    var majorVersion = parseInt(navigator.appVersion, 10);
    var nameOffset, verOffset, ix;

    if (isChrome || isOpera) {
        verOffset = nAgt.indexOf('Chrome');
        fullVersion = nAgt.substring(verOffset + 7);
    }

    // trim the fullVersion string at semicolon/space if present
    if ((ix = fullVersion.indexOf(';')) !== -1) {
        fullVersion = fullVersion.substring(0, ix);
    }

    if ((ix = fullVersion.indexOf(' ')) !== -1) {
        fullVersion = fullVersion.substring(0, ix);
    }

    majorVersion = parseInt('' + fullVersion, 10);

    if (isNaN(majorVersion)) {
        fullVersion = '' + parseFloat(navigator.appVersion);
        majorVersion = parseInt(navigator.appVersion, 10);
    }

    return majorVersion >= 49;
}

// ______________________
// MediaStreamRecorder.js

/**
 * MediaStreamRecorder is an abstraction layer for {@link https://w3c.github.io/mediacapture-record/MediaRecorder.html|MediaRecorder API}. It is used by {@link RecordRTC} to record MediaStream(s) in both Chrome and Firefox.
 * @summary Runs top over {@link https://w3c.github.io/mediacapture-record/MediaRecorder.html|MediaRecorder API}.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://github.com/muaz-khan|Muaz Khan}
 * @typedef MediaStreamRecorder
 * @class
 * @example
 * var config = {
 *     mimeType: 'video/webm', // vp8, vp9, h264, mkv, opus/vorbis
 *     audioBitsPerSecond : 256 * 8 * 1024,
 *     videoBitsPerSecond : 256 * 8 * 1024,
 *     bitsPerSecond: 256 * 8 * 1024,  // if this is provided, skip above two
 *     checkForInactiveTracks: true,
 *     timeSlice: 1000, // concatenate intervals based blobs
 *     ondataavailable: function() {} // get intervals based blobs
 * }
 * var recorder = new MediaStreamRecorder(mediaStream, config);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 *
 *     // or
 *     var blob = recorder.blob;
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {disableLogs:true, initCallback: function, mimeType: "video/webm", timeSlice: 1000}
 * @throws Will throw an error if first argument "MediaStream" is missing. Also throws error if "MediaRecorder API" are not supported by the browser.
 */

function MediaStreamRecorder(mediaStream, config) {
    var self = this;

    if (typeof mediaStream === 'undefined') {
        throw 'First argument "MediaStream" is required.';
    }

    if (typeof MediaRecorder === 'undefined') {
        throw 'Your browser does not support the Media Recorder API. Please try other modules e.g. WhammyRecorder or StereoAudioRecorder.';
    }

    config = config || {
        // bitsPerSecond: 256 * 8 * 1024,
        mimeType: 'video/webm'
    };

    if (config.type === 'audio') {
        if (getTracks(mediaStream, 'video').length && getTracks(mediaStream, 'audio').length) {
            var stream;
            if (!!navigator.mozGetUserMedia) {
                stream = new MediaStream();
                stream.addTrack(getTracks(mediaStream, 'audio')[0]);
            } else {
                // webkitMediaStream
                stream = new MediaStream(getTracks(mediaStream, 'audio'));
            }
            mediaStream = stream;
        }

        if (!config.mimeType || config.mimeType.toString().toLowerCase().indexOf('audio') === -1) {
            config.mimeType = isChrome ? 'audio/webm' : 'audio/ogg';
        }

        if (config.mimeType && config.mimeType.toString().toLowerCase() !== 'audio/ogg' && !!navigator.mozGetUserMedia) {
            // forcing better codecs on Firefox (via #166)
            config.mimeType = 'audio/ogg';
        }
    }

    var arrayOfBlobs = [];

    /**
     * This method returns array of blobs. Use only with "timeSlice". Its useful to preview recording anytime, without using the "stop" method.
     * @method
     * @memberof MediaStreamRecorder
     * @example
     * var arrayOfBlobs = recorder.getArrayOfBlobs();
     * @returns {Array} Returns array of recorded blobs.
     */
    this.getArrayOfBlobs = function() {
        return arrayOfBlobs;
    };

    /**
     * This method records MediaStream.
     * @method
     * @memberof MediaStreamRecorder
     * @example
     * recorder.record();
     */
    this.record = function() {
        // set defaults
        self.blob = null;
        self.clearRecordedData();
        self.timestamps = [];
        allStates = [];
        arrayOfBlobs = [];

        var recorderHints = config;

        if (!config.disableLogs) {
            console.log('Passing following config over MediaRecorder API.', recorderHints);
        }

        if (mediaRecorder) {
            // mandatory to make sure Firefox doesn't fails to record streams 3-4 times without reloading the page.
            mediaRecorder = null;
        }

        if (isChrome && !isMediaRecorderCompatible()) {
            // to support video-only recording on stable
            recorderHints = 'video/vp8';
        }

        if (typeof MediaRecorder.isTypeSupported === 'function' && recorderHints.mimeType) {
            if (!MediaRecorder.isTypeSupported(recorderHints.mimeType)) {
                if (!config.disableLogs) {
                    console.warn('MediaRecorder API seems unable to record mimeType:', recorderHints.mimeType);
                }

                recorderHints.mimeType = config.type === 'audio' ? 'audio/webm' : 'video/webm';
            }
        }

        // using MediaRecorder API here
        try {
            mediaRecorder = new MediaRecorder(mediaStream, recorderHints);

            // reset
            config.mimeType = recorderHints.mimeType;
        } catch (e) {
            // chrome-based fallback
            mediaRecorder = new MediaRecorder(mediaStream);
        }

        // old hack?
        if (recorderHints.mimeType && !MediaRecorder.isTypeSupported && 'canRecordMimeType' in mediaRecorder && mediaRecorder.canRecordMimeType(recorderHints.mimeType) === false) {
            if (!config.disableLogs) {
                console.warn('MediaRecorder API seems unable to record mimeType:', recorderHints.mimeType);
            }
        }

        // Dispatching OnDataAvailable Handler
        mediaRecorder.ondataavailable = function(e) {
            if (e.data) {
                allStates.push('ondataavailable: ' + bytesToSize(e.data.size));
            }

            if (typeof config.timeSlice === 'number') {
                if (e.data && e.data.size) {
                    arrayOfBlobs.push(e.data);
                    updateTimeStamp();

                    if (typeof config.ondataavailable === 'function') {
                        // intervals based blobs
                        var blob = config.getNativeBlob ? e.data : new Blob([e.data], {
                            type: getMimeType(recorderHints)
                        });
                        config.ondataavailable(blob);
                    }
                }
                return;
            }

            if (!e.data || !e.data.size || e.data.size < 100 || self.blob) {
                // make sure that stopRecording always getting fired
                // even if there is invalid data
                if (self.recordingCallback) {
                    self.recordingCallback(new Blob([], {
                        type: getMimeType(recorderHints)
                    }));
                    self.recordingCallback = null;
                }
                return;
            }

            self.blob = config.getNativeBlob ? e.data : new Blob([e.data], {
                type: getMimeType(recorderHints)
            });

            if (self.recordingCallback) {
                self.recordingCallback(self.blob);
                self.recordingCallback = null;
            }
        };

        mediaRecorder.onstart = function() {
            allStates.push('started');
        };

        mediaRecorder.onpause = function() {
            allStates.push('paused');
        };

        mediaRecorder.onresume = function() {
            allStates.push('resumed');
        };

        mediaRecorder.onstop = function() {
            allStates.push('stopped');
        };

        mediaRecorder.onerror = function(error) {
            if (!error) {
                return;
            }

            if (!error.name) {
                error.name = 'UnknownError';
            }

            allStates.push('error: ' + error);

            if (!config.disableLogs) {
                // via: https://w3c.github.io/mediacapture-record/MediaRecorder.html#exception-summary
                if (error.name.toString().toLowerCase().indexOf('invalidstate') !== -1) {
                    console.error('The MediaRecorder is not in a state in which the proposed operation is allowed to be executed.', error);
                } else if (error.name.toString().toLowerCase().indexOf('notsupported') !== -1) {
                    console.error('MIME type (', recorderHints.mimeType, ') is not supported.', error);
                } else if (error.name.toString().toLowerCase().indexOf('security') !== -1) {
                    console.error('MediaRecorder security error', error);
                }

                // older code below
                else if (error.name === 'OutOfMemory') {
                    console.error('The UA has exhaused the available memory. User agents SHOULD provide as much additional information as possible in the message attribute.', error);
                } else if (error.name === 'IllegalStreamModification') {
                    console.error('A modification to the stream has occurred that makes it impossible to continue recording. An example would be the addition of a Track while recording is occurring. User agents SHOULD provide as much additional information as possible in the message attribute.', error);
                } else if (error.name === 'OtherRecordingError') {
                    console.error('Used for an fatal error other than those listed above. User agents SHOULD provide as much additional information as possible in the message attribute.', error);
                } else if (error.name === 'GenericError') {
                    console.error('The UA cannot provide the codec or recording option that has been requested.', error);
                } else {
                    console.error('MediaRecorder Error', error);
                }
            }

            (function(looper) {
                if (!self.manuallyStopped && mediaRecorder && mediaRecorder.state === 'inactive') {
                    delete config.timeslice;

                    // 10 minutes, enough?
                    mediaRecorder.start(10 * 60 * 1000);
                    return;
                }

                setTimeout(looper, 1000);
            })();

            if (mediaRecorder.state !== 'inactive' && mediaRecorder.state !== 'stopped') {
                mediaRecorder.stop();
            }
        };

        if (typeof config.timeSlice === 'number') {
            updateTimeStamp();
            mediaRecorder.start(config.timeSlice);
        } else {
            // default is 60 minutes; enough?
            // use config => {timeSlice: 1000} otherwise

            mediaRecorder.start(3.6e+6);
        }

        if (config.initCallback) {
            config.initCallback(); // old code
        }
    };

    /**
     * @property {Array} timestamps - Array of time stamps
     * @memberof MediaStreamRecorder
     * @example
     * console.log(recorder.timestamps);
     */
    this.timestamps = [];

    function updateTimeStamp() {
        self.timestamps.push(new Date().getTime());

        if (typeof config.onTimeStamp === 'function') {
            config.onTimeStamp(self.timestamps[self.timestamps.length - 1], self.timestamps);
        }
    }

    function getMimeType(secondObject) {
        if (mediaRecorder && mediaRecorder.mimeType) {
            return mediaRecorder.mimeType;
        }

        return secondObject.mimeType || 'video/webm';
    }

    /**
     * This method stops recording MediaStream.
     * @param {function} callback - Callback function, that is used to pass recorded blob back to the callee.
     * @method
     * @memberof MediaStreamRecorder
     * @example
     * recorder.stop(function(blob) {
     *     video.src = URL.createObjectURL(blob);
     * });
     */
    this.stop = function(callback) {
        callback = callback || function() {};

        self.manuallyStopped = true; // used inside the mediaRecorder.onerror

        if (!mediaRecorder) {
            return;
        }

        this.recordingCallback = callback;

        if (mediaRecorder.state === 'recording') {
            mediaRecorder.stop();
        }

        if (typeof config.timeSlice === 'number') {
            setTimeout(function() {
                self.blob = new Blob(arrayOfBlobs, {
                    type: getMimeType(config)
                });

                self.recordingCallback(self.blob);
            }, 100);
        }
    };

    /**
     * This method pauses the recording process.
     * @method
     * @memberof MediaStreamRecorder
     * @example
     * recorder.pause();
     */
    this.pause = function() {
        if (!mediaRecorder) {
            return;
        }

        if (mediaRecorder.state === 'recording') {
            mediaRecorder.pause();
        }
    };

    /**
     * This method resumes the recording process.
     * @method
     * @memberof MediaStreamRecorder
     * @example
     * recorder.resume();
     */
    this.resume = function() {
        if (!mediaRecorder) {
            return;
        }

        if (mediaRecorder.state === 'paused') {
            mediaRecorder.resume();
        }
    };

    /**
     * This method resets currently recorded data.
     * @method
     * @memberof MediaStreamRecorder
     * @example
     * recorder.clearRecordedData();
     */
    this.clearRecordedData = function() {
        if (mediaRecorder && mediaRecorder.state === 'recording') {
            self.stop(clearRecordedDataCB);
        }

        clearRecordedDataCB();
    };

    function clearRecordedDataCB() {
        arrayOfBlobs = [];
        mediaRecorder = null;
        self.timestamps = [];
    }

    // Reference to "MediaRecorder" object
    var mediaRecorder;

    /**
     * Access to native MediaRecorder API
     * @method
     * @memberof MediaStreamRecorder
     * @instance
     * @example
     * var internal = recorder.getInternalRecorder();
     * internal.ondataavailable = function() {}; // override
     * internal.stream, internal.onpause, internal.onstop, etc.
     * @returns {Object} Returns internal recording object.
     */
    this.getInternalRecorder = function() {
        return mediaRecorder;
    };

    function isMediaStreamActive() {
        if ('active' in mediaStream) {
            if (!mediaStream.active) {
                return false;
            }
        } else if ('ended' in mediaStream) { // old hack
            if (mediaStream.ended) {
                return false;
            }
        }
        return true;
    }

    /**
     * @property {Blob} blob - Recorded data as "Blob" object.
     * @memberof MediaStreamRecorder
     * @example
     * recorder.stop(function() {
     *     var blob = recorder.blob;
     * });
     */
    this.blob = null;


    /**
     * Get MediaRecorder readonly state.
     * @method
     * @memberof MediaStreamRecorder
     * @example
     * var state = recorder.getState();
     * @returns {String} Returns recording state.
     */
    this.getState = function() {
        if (!mediaRecorder) {
            return 'inactive';
        }

        return mediaRecorder.state || 'inactive';
    };

    // list of all recording states
    var allStates = [];

    /**
     * Get MediaRecorder all recording states.
     * @method
     * @memberof MediaStreamRecorder
     * @example
     * var state = recorder.getAllStates();
     * @returns {Array} Returns all recording states
     */
    this.getAllStates = function() {
        return allStates;
    };

    // if any Track within the MediaStream is muted or not enabled at any time, 
    // the browser will only record black frames 
    // or silence since that is the content produced by the Track
    // so we need to stopRecording as soon as any single track ends.
    if (typeof config.checkForInactiveTracks === 'undefined') {
        config.checkForInactiveTracks = false; // disable to minimize CPU usage
    }

    var self = this;

    // this method checks if media stream is stopped
    // or if any track is ended.
    (function looper() {
        if (!mediaRecorder || config.checkForInactiveTracks === false) {
            return;
        }

        if (isMediaStreamActive() === false) {
            if (!config.disableLogs) {
                console.log('MediaStream seems stopped.');
            }
            self.stop();
            return;
        }

        setTimeout(looper, 1000); // check every second
    })();

    // for debugging
    this.name = 'MediaStreamRecorder';
    this.toString = function() {
        return this.name;
    };
}

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.MediaStreamRecorder = MediaStreamRecorder;
}

// source code from: http://typedarray.org/wp-content/projects/WebAudioRecorder/script.js
// https://github.com/mattdiamond/Recorderjs#license-mit
// ______________________
// StereoAudioRecorder.js

/**
 * StereoAudioRecorder is a standalone class used by {@link RecordRTC} to bring "stereo" audio-recording in chrome.
 * @summary JavaScript standalone object for stereo audio recording.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef StereoAudioRecorder
 * @class
 * @example
 * var recorder = new StereoAudioRecorder(MediaStream, {
 *     sampleRate: 44100,
 *     bufferSize: 4096
 * });
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {sampleRate: 44100, bufferSize: 4096, numberOfAudioChannels: 1, etc.}
 */

function StereoAudioRecorder(mediaStream, config) {
    if (!getTracks(mediaStream, 'audio').length) {
        throw 'Your stream has no audio tracks.';
    }

    config = config || {};

    var self = this;

    // variables
    var leftchannel = [];
    var rightchannel = [];
    var recording = false;
    var recordingLength = 0;
    var jsAudioNode;

    var numberOfAudioChannels = 2;

    /**
     * Set sample rates such as 8K or 16K. Reference: http://stackoverflow.com/a/28977136/552182
     * @property {number} desiredSampRate - Desired Bits per sample * 1000
     * @memberof StereoAudioRecorder
     * @instance
     * @example
     * var recorder = StereoAudioRecorder(mediaStream, {
     *   desiredSampRate: 16 * 1000 // bits-per-sample * 1000
     * });
     */
    var desiredSampRate = config.desiredSampRate;

    // backward compatibility
    if (config.leftChannel === true) {
        numberOfAudioChannels = 1;
    }

    if (config.numberOfAudioChannels === 1) {
        numberOfAudioChannels = 1;
    }

    if (!numberOfAudioChannels || numberOfAudioChannels < 1) {
        numberOfAudioChannels = 2;
    }

    if (!config.disableLogs) {
        console.log('StereoAudioRecorder is set to record number of channels: ' + numberOfAudioChannels);
    }

    // if any Track within the MediaStream is muted or not enabled at any time, 
    // the browser will only record black frames 
    // or silence since that is the content produced by the Track
    // so we need to stopRecording as soon as any single track ends.
    if (typeof config.checkForInactiveTracks === 'undefined') {
        config.checkForInactiveTracks = true;
    }

    function isMediaStreamActive() {
        if (config.checkForInactiveTracks === false) {
            // always return "true"
            return true;
        }

        if ('active' in mediaStream) {
            if (!mediaStream.active) {
                return false;
            }
        } else if ('ended' in mediaStream) { // old hack
            if (mediaStream.ended) {
                return false;
            }
        }
        return true;
    }

    /**
     * This method records MediaStream.
     * @method
     * @memberof StereoAudioRecorder
     * @example
     * recorder.record();
     */
    this.record = function() {
        if (isMediaStreamActive() === false) {
            throw 'Please make sure MediaStream is active.';
        }

        resetVariables();

        isAudioProcessStarted = isPaused = false;
        recording = true;

        if (typeof config.timeSlice !== 'undefined') {
            looper();
        }
    };

    function mergeLeftRightBuffers(config, callback) {
        function mergeAudioBuffers(config, cb) {
            var numberOfAudioChannels = config.numberOfAudioChannels;

            // todo: "slice(0)" --- is it causes loop? Should be removed?
            var leftBuffers = config.leftBuffers.slice(0);
            var rightBuffers = config.rightBuffers.slice(0);
            var sampleRate = config.sampleRate;
            var internalInterleavedLength = config.internalInterleavedLength;
            var desiredSampRate = config.desiredSampRate;

            if (numberOfAudioChannels === 2) {
                leftBuffers = mergeBuffers(leftBuffers, internalInterleavedLength);
                rightBuffers = mergeBuffers(rightBuffers, internalInterleavedLength);

                if (desiredSampRate) {
                    leftBuffers = interpolateArray(leftBuffers, desiredSampRate, sampleRate);
                    rightBuffers = interpolateArray(rightBuffers, desiredSampRate, sampleRate);
                }
            }

            if (numberOfAudioChannels === 1) {
                leftBuffers = mergeBuffers(leftBuffers, internalInterleavedLength);

                if (desiredSampRate) {
                    leftBuffers = interpolateArray(leftBuffers, desiredSampRate, sampleRate);
                }
            }

            // set sample rate as desired sample rate
            if (desiredSampRate) {
                sampleRate = desiredSampRate;
            }

            // for changing the sampling rate, reference:
            // http://stackoverflow.com/a/28977136/552182
            function interpolateArray(data, newSampleRate, oldSampleRate) {
                var fitCount = Math.round(data.length * (newSampleRate / oldSampleRate));
                var newData = [];
                var springFactor = Number((data.length - 1) / (fitCount - 1));
                newData[0] = data[0];
                for (var i = 1; i < fitCount - 1; i++) {
                    var tmp = i * springFactor;
                    var before = Number(Math.floor(tmp)).toFixed();
                    var after = Number(Math.ceil(tmp)).toFixed();
                    var atPoint = tmp - before;
                    newData[i] = linearInterpolate(data[before], data[after], atPoint);
                }
                newData[fitCount - 1] = data[data.length - 1];
                return newData;
            }

            function linearInterpolate(before, after, atPoint) {
                return before + (after - before) * atPoint;
            }

            function mergeBuffers(channelBuffer, rLength) {
                var result = new Float64Array(rLength);
                var offset = 0;
                var lng = channelBuffer.length;

                for (var i = 0; i < lng; i++) {
                    var buffer = channelBuffer[i];
                    result.set(buffer, offset);
                    offset += buffer.length;
                }

                return result;
            }

            function interleave(leftChannel, rightChannel) {
                var length = leftChannel.length + rightChannel.length;

                var result = new Float64Array(length);

                var inputIndex = 0;

                for (var index = 0; index < length;) {
                    result[index++] = leftChannel[inputIndex];
                    result[index++] = rightChannel[inputIndex];
                    inputIndex++;
                }
                return result;
            }

            function writeUTFBytes(view, offset, string) {
                var lng = string.length;
                for (var i = 0; i < lng; i++) {
                    view.setUint8(offset + i, string.charCodeAt(i));
                }
            }

            // interleave both channels together
            var interleaved;

            if (numberOfAudioChannels === 2) {
                interleaved = interleave(leftBuffers, rightBuffers);
            }

            if (numberOfAudioChannels === 1) {
                interleaved = leftBuffers;
            }

            var interleavedLength = interleaved.length;

            // create wav file
            var resultingBufferLength = 44 + interleavedLength * 2;

            var buffer = new ArrayBuffer(resultingBufferLength);

            var view = new DataView(buffer);

            // RIFF chunk descriptor/identifier 
            writeUTFBytes(view, 0, 'RIFF');

            // RIFF chunk length
            // changed "44" to "36" via #401
            view.setUint32(4, 36 + interleavedLength * 2, true);

            // RIFF type 
            writeUTFBytes(view, 8, 'WAVE');

            // format chunk identifier 
            // FMT sub-chunk
            writeUTFBytes(view, 12, 'fmt ');

            // format chunk length 
            view.setUint32(16, 16, true);

            // sample format (raw)
            view.setUint16(20, 1, true);

            // stereo (2 channels)
            view.setUint16(22, numberOfAudioChannels, true);

            // sample rate 
            view.setUint32(24, sampleRate, true);

            // byte rate (sample rate * block align)
            view.setUint32(28, sampleRate * numberOfAudioChannels * 2, true);

            // block align (channel count * bytes per sample) 
            view.setUint16(32, numberOfAudioChannels * 2, true);

            // bits per sample 
            view.setUint16(34, 16, true);

            // data sub-chunk
            // data chunk identifier 
            writeUTFBytes(view, 36, 'data');

            // data chunk length 
            view.setUint32(40, interleavedLength * 2, true);

            // write the PCM samples
            var lng = interleavedLength;
            var index = 44;
            var volume = 1;
            for (var i = 0; i < lng; i++) {
                view.setInt16(index, interleaved[i] * (0x7FFF * volume), true);
                index += 2;
            }

            if (cb) {
                return cb({
                    buffer: buffer,
                    view: view
                });
            }

            postMessage({
                buffer: buffer,
                view: view
            });
        }

        if (config.noWorker) {
            mergeAudioBuffers(config, function(data) {
                callback(data.buffer, data.view);
            });
            return;
        }


        var webWorker = processInWebWorker(mergeAudioBuffers);

        webWorker.onmessage = function(event) {
            callback(event.data.buffer, event.data.view);

            // release memory
            URL.revokeObjectURL(webWorker.workerURL);

            // kill webworker (or Chrome will kill your page after ~25 calls)
            webWorker.terminate();
        };

        webWorker.postMessage(config);
    }

    function processInWebWorker(_function) {
        var workerURL = URL.createObjectURL(new Blob([_function.toString(),
            ';this.onmessage =  function (eee) {' + _function.name + '(eee.data);}'
        ], {
            type: 'application/javascript'
        }));

        var worker = new Worker(workerURL);
        worker.workerURL = workerURL;
        return worker;
    }

    /**
     * This method stops recording MediaStream.
     * @param {function} callback - Callback function, that is used to pass recorded blob back to the callee.
     * @method
     * @memberof StereoAudioRecorder
     * @example
     * recorder.stop(function(blob) {
     *     video.src = URL.createObjectURL(blob);
     * });
     */
    this.stop = function(callback) {
        callback = callback || function() {};

        // stop recording
        recording = false;

        mergeLeftRightBuffers({
            desiredSampRate: desiredSampRate,
            sampleRate: sampleRate,
            numberOfAudioChannels: numberOfAudioChannels,
            internalInterleavedLength: recordingLength,
            leftBuffers: leftchannel,
            rightBuffers: numberOfAudioChannels === 1 ? [] : rightchannel,
            noWorker: config.noWorker
        }, function(buffer, view) {
            /**
             * @property {Blob} blob - The recorded blob object.
             * @memberof StereoAudioRecorder
             * @example
             * recorder.stop(function(){
             *     var blob = recorder.blob;
             * });
             */
            self.blob = new Blob([view], {
                type: 'audio/wav'
            });

            /**
             * @property {ArrayBuffer} buffer - The recorded buffer object.
             * @memberof StereoAudioRecorder
             * @example
             * recorder.stop(function(){
             *     var buffer = recorder.buffer;
             * });
             */
            self.buffer = new ArrayBuffer(view.buffer.byteLength);

            /**
             * @property {DataView} view - The recorded data-view object.
             * @memberof StereoAudioRecorder
             * @example
             * recorder.stop(function(){
             *     var view = recorder.view;
             * });
             */
            self.view = view;

            self.sampleRate = desiredSampRate || sampleRate;
            self.bufferSize = bufferSize;

            // recorded audio length
            self.length = recordingLength;

            isAudioProcessStarted = false;

            if (callback) {
                callback(self.blob);
            }
        });
    };

    if (typeof RecordRTC.Storage === 'undefined') {
        RecordRTC.Storage = {
            AudioContextConstructor: null,
            AudioContext: window.AudioContext || window.webkitAudioContext
        };
    }

    if (!RecordRTC.Storage.AudioContextConstructor || RecordRTC.Storage.AudioContextConstructor.state === 'closed') {
        RecordRTC.Storage.AudioContextConstructor = new RecordRTC.Storage.AudioContext();
    }

    var context = RecordRTC.Storage.AudioContextConstructor;

    // creates an audio node from the microphone incoming stream
    var audioInput = context.createMediaStreamSource(mediaStream);

    var legalBufferValues = [0, 256, 512, 1024, 2048, 4096, 8192, 16384];

    /**
     * From the spec: This value controls how frequently the audioprocess event is
     * dispatched and how many sample-frames need to be processed each call.
     * Lower values for buffer size will result in a lower (better) latency.
     * Higher values will be necessary to avoid audio breakup and glitches
     * The size of the buffer (in sample-frames) which needs to
     * be processed each time onprocessaudio is called.
     * Legal values are (256, 512, 1024, 2048, 4096, 8192, 16384).
     * @property {number} bufferSize - Buffer-size for how frequently the audioprocess event is dispatched.
     * @memberof StereoAudioRecorder
     * @example
     * recorder = new StereoAudioRecorder(mediaStream, {
     *     bufferSize: 4096
     * });
     */

    // "0" means, let chrome decide the most accurate buffer-size for current platform.
    var bufferSize = typeof config.bufferSize === 'undefined' ? 4096 : config.bufferSize;

    if (legalBufferValues.indexOf(bufferSize) === -1) {
        if (!config.disableLogs) {
            console.log('Legal values for buffer-size are ' + JSON.stringify(legalBufferValues, null, '\t'));
        }
    }

    if (context.createJavaScriptNode) {
        jsAudioNode = context.createJavaScriptNode(bufferSize, numberOfAudioChannels, numberOfAudioChannels);
    } else if (context.createScriptProcessor) {
        jsAudioNode = context.createScriptProcessor(bufferSize, numberOfAudioChannels, numberOfAudioChannels);
    } else {
        throw 'WebAudio API has no support on this browser.';
    }

    // connect the stream to the script processor
    audioInput.connect(jsAudioNode);

    if (!config.bufferSize) {
        bufferSize = jsAudioNode.bufferSize; // device buffer-size
    }

    /**
     * The sample rate (in sample-frames per second) at which the
     * AudioContext handles audio. It is assumed that all AudioNodes
     * in the context run at this rate. In making this assumption,
     * sample-rate converters or "varispeed" processors are not supported
     * in real-time processing.
     * The sampleRate parameter describes the sample-rate of the
     * linear PCM audio data in the buffer in sample-frames per second.
     * An implementation must support sample-rates in at least
     * the range 22050 to 96000.
     * @property {number} sampleRate - Buffer-size for how frequently the audioprocess event is dispatched.
     * @memberof StereoAudioRecorder
     * @example
     * recorder = new StereoAudioRecorder(mediaStream, {
     *     sampleRate: 44100
     * });
     */
    var sampleRate = typeof config.sampleRate !== 'undefined' ? config.sampleRate : context.sampleRate || 44100;

    if (sampleRate < 22050 || sampleRate > 96000) {
        // Ref: http://stackoverflow.com/a/26303918/552182
        if (!config.disableLogs) {
            console.log('sample-rate must be under range 22050 and 96000.');
        }
    }

    if (!config.disableLogs) {
        if (config.desiredSampRate) {
            console.log('Desired sample-rate: ' + config.desiredSampRate);
        }
    }

    var isPaused = false;
    /**
     * This method pauses the recording process.
     * @method
     * @memberof StereoAudioRecorder
     * @example
     * recorder.pause();
     */
    this.pause = function() {
        isPaused = true;
    };

    /**
     * This method resumes the recording process.
     * @method
     * @memberof StereoAudioRecorder
     * @example
     * recorder.resume();
     */
    this.resume = function() {
        if (isMediaStreamActive() === false) {
            throw 'Please make sure MediaStream is active.';
        }

        if (!recording) {
            if (!config.disableLogs) {
                console.log('Seems recording has been restarted.');
            }
            this.record();
            return;
        }

        isPaused = false;
    };

    /**
     * This method resets currently recorded data.
     * @method
     * @memberof StereoAudioRecorder
     * @example
     * recorder.clearRecordedData();
     */
    this.clearRecordedData = function() {
        config.checkForInactiveTracks = false;

        if (recording) {
            this.stop(clearRecordedDataCB);
        }

        clearRecordedDataCB();
    };

    function resetVariables() {
        leftchannel = [];
        rightchannel = [];
        recordingLength = 0;
        isAudioProcessStarted = false;
        recording = false;
        isPaused = false;
        context = null;

        self.leftchannel = leftchannel;
        self.rightchannel = rightchannel;
        self.numberOfAudioChannels = numberOfAudioChannels;
        self.desiredSampRate = desiredSampRate;
        self.sampleRate = sampleRate;
        self.recordingLength = recordingLength;

        intervalsBasedBuffers = {
            left: [],
            right: [],
            recordingLength: 0
        };
    }

    function clearRecordedDataCB() {
        if (jsAudioNode) {
            jsAudioNode.onaudioprocess = null;
            jsAudioNode.disconnect();
            jsAudioNode = null;
        }

        if (audioInput) {
            audioInput.disconnect();
            audioInput = null;
        }

        resetVariables();
    }

    // for debugging
    this.name = 'StereoAudioRecorder';
    this.toString = function() {
        return this.name;
    };

    var isAudioProcessStarted = false;

    function onAudioProcessDataAvailable(e) {
        if (isPaused) {
            return;
        }

        if (isMediaStreamActive() === false) {
            if (!config.disableLogs) {
                console.log('MediaStream seems stopped.');
            }
            jsAudioNode.disconnect();
            recording = false;
        }

        if (!recording) {
            if (audioInput) {
                audioInput.disconnect();
                audioInput = null;
            }
            return;
        }

        /**
         * This method is called on "onaudioprocess" event's first invocation.
         * @method {function} onAudioProcessStarted
         * @memberof StereoAudioRecorder
         * @example
         * recorder.onAudioProcessStarted: function() { };
         */
        if (!isAudioProcessStarted) {
            isAudioProcessStarted = true;
            if (config.onAudioProcessStarted) {
                config.onAudioProcessStarted();
            }

            if (config.initCallback) {
                config.initCallback();
            }
        }

        var left = e.inputBuffer.getChannelData(0);

        // we clone the samples
        var chLeft = new Float32Array(left);
        leftchannel.push(chLeft);

        if (numberOfAudioChannels === 2) {
            var right = e.inputBuffer.getChannelData(1);
            var chRight = new Float32Array(right);
            rightchannel.push(chRight);
        }

        recordingLength += bufferSize;

        // export raw PCM
        self.recordingLength = recordingLength;

        if (typeof config.timeSlice !== 'undefined') {
            intervalsBasedBuffers.recordingLength += bufferSize;
            intervalsBasedBuffers.left.push(chLeft);

            if (numberOfAudioChannels === 2) {
                intervalsBasedBuffers.right.push(chRight);
            }
        }
    }

    jsAudioNode.onaudioprocess = onAudioProcessDataAvailable;

    // to prevent self audio to be connected with speakers
    if (context.createMediaStreamDestination) {
        jsAudioNode.connect(context.createMediaStreamDestination());
    } else {
        jsAudioNode.connect(context.destination);
    }

    // export raw PCM
    this.leftchannel = leftchannel;
    this.rightchannel = rightchannel;
    this.numberOfAudioChannels = numberOfAudioChannels;
    this.desiredSampRate = desiredSampRate;
    this.sampleRate = sampleRate;
    self.recordingLength = recordingLength;

    // helper for intervals based blobs
    var intervalsBasedBuffers = {
        left: [],
        right: [],
        recordingLength: 0
    };

    // this looper is used to support intervals based blobs (via timeSlice+ondataavailable)
    function looper() {
        if (!recording || typeof config.ondataavailable !== 'function' || typeof config.timeSlice === 'undefined') {
            return;
        }

        if (intervalsBasedBuffers.left.length) {
            mergeLeftRightBuffers({
                desiredSampRate: desiredSampRate,
                sampleRate: sampleRate,
                numberOfAudioChannels: numberOfAudioChannels,
                internalInterleavedLength: intervalsBasedBuffers.recordingLength,
                leftBuffers: intervalsBasedBuffers.left,
                rightBuffers: numberOfAudioChannels === 1 ? [] : intervalsBasedBuffers.right
            }, function(buffer, view) {
                var blob = new Blob([view], {
                    type: 'audio/wav'
                });
                config.ondataavailable(blob);

                setTimeout(looper, config.timeSlice);
            });

            intervalsBasedBuffers = {
                left: [],
                right: [],
                recordingLength: 0
            };
        } else {
            setTimeout(looper, config.timeSlice);
        }
    }
}

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.StereoAudioRecorder = StereoAudioRecorder;
}

// _________________
// CanvasRecorder.js

/**
 * CanvasRecorder is a standalone class used by {@link RecordRTC} to bring HTML5-Canvas recording into video WebM. It uses HTML2Canvas library and runs top over {@link Whammy}.
 * @summary HTML2Canvas recording into video WebM.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef CanvasRecorder
 * @class
 * @example
 * var recorder = new CanvasRecorder(htmlElement, { disableLogs: true, useWhammyRecorder: true });
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {HTMLElement} htmlElement - querySelector/getElementById/getElementsByTagName[0]/etc.
 * @param {object} config - {disableLogs:true, initCallback: function}
 */

function CanvasRecorder(htmlElement, config) {
    if (typeof html2canvas === 'undefined') {
        throw 'Please link: https://www.webrtc-experiment.com/screenshot.js';
    }

    config = config || {};
    if (!config.frameInterval) {
        config.frameInterval = 10;
    }

    // via DetectRTC.js
    var isCanvasSupportsStreamCapturing = false;
    ['captureStream', 'mozCaptureStream', 'webkitCaptureStream'].forEach(function(item) {
        if (item in document.createElement('canvas')) {
            isCanvasSupportsStreamCapturing = true;
        }
    });

    var _isChrome = (!!window.webkitRTCPeerConnection || !!window.webkitGetUserMedia) && !!window.chrome;

    var chromeVersion = 50;
    var matchArray = navigator.userAgent.match(/Chrom(e|ium)\/([0-9]+)\./);
    if (_isChrome && matchArray && matchArray[2]) {
        chromeVersion = parseInt(matchArray[2], 10);
    }

    if (_isChrome && chromeVersion < 52) {
        isCanvasSupportsStreamCapturing = false;
    }

    if (config.useWhammyRecorder) {
        isCanvasSupportsStreamCapturing = false;
    }

    var globalCanvas, mediaStreamRecorder;

    if (isCanvasSupportsStreamCapturing) {
        if (!config.disableLogs) {
            console.log('Your browser supports both MediRecorder API and canvas.captureStream!');
        }

        if (htmlElement instanceof HTMLCanvasElement) {
            globalCanvas = htmlElement;
        } else if (htmlElement instanceof CanvasRenderingContext2D) {
            globalCanvas = htmlElement.canvas;
        } else {
            throw 'Please pass either HTMLCanvasElement or CanvasRenderingContext2D.';
        }
    } else if (!!navigator.mozGetUserMedia) {
        if (!config.disableLogs) {
            console.error('Canvas recording is NOT supported in Firefox.');
        }
    }

    var isRecording;

    /**
     * This method records Canvas.
     * @method
     * @memberof CanvasRecorder
     * @example
     * recorder.record();
     */
    this.record = function() {
        isRecording = true;

        if (isCanvasSupportsStreamCapturing && !config.useWhammyRecorder) {
            // CanvasCaptureMediaStream
            var canvasMediaStream;
            if ('captureStream' in globalCanvas) {
                canvasMediaStream = globalCanvas.captureStream(25); // 25 FPS
            } else if ('mozCaptureStream' in globalCanvas) {
                canvasMediaStream = globalCanvas.mozCaptureStream(25);
            } else if ('webkitCaptureStream' in globalCanvas) {
                canvasMediaStream = globalCanvas.webkitCaptureStream(25);
            }

            try {
                var mdStream = new MediaStream();
                mdStream.addTrack(getTracks(canvasMediaStream, 'video')[0]);
                canvasMediaStream = mdStream;
            } catch (e) {}

            if (!canvasMediaStream) {
                throw 'captureStream API are NOT available.';
            }

            // Note: Jan 18, 2016 status is that, 
            // Firefox MediaRecorder API can't record CanvasCaptureMediaStream object.
            mediaStreamRecorder = new MediaStreamRecorder(canvasMediaStream, {
                mimeType: config.mimeType || 'video/webm'
            });
            mediaStreamRecorder.record();
        } else {
            whammy.frames = [];
            lastTime = new Date().getTime();
            drawCanvasFrame();
        }

        if (config.initCallback) {
            config.initCallback();
        }
    };

    this.getWebPImages = function(callback) {
        if (htmlElement.nodeName.toLowerCase() !== 'canvas') {
            callback();
            return;
        }

        var framesLength = whammy.frames.length;
        whammy.frames.forEach(function(frame, idx) {
            var framesRemaining = framesLength - idx;
            if (!config.disableLogs) {
                console.log(framesRemaining + '/' + framesLength + ' frames remaining');
            }

            if (config.onEncodingCallback) {
                config.onEncodingCallback(framesRemaining, framesLength);
            }

            var webp = frame.image.toDataURL('image/webp', 1);
            whammy.frames[idx].image = webp;
        });

        if (!config.disableLogs) {
            console.log('Generating WebM');
        }

        callback();
    };

    /**
     * This method stops recording Canvas.
     * @param {function} callback - Callback function, that is used to pass recorded blob back to the callee.
     * @method
     * @memberof CanvasRecorder
     * @example
     * recorder.stop(function(blob) {
     *     video.src = URL.createObjectURL(blob);
     * });
     */
    this.stop = function(callback) {
        isRecording = false;

        var that = this;

        if (isCanvasSupportsStreamCapturing && mediaStreamRecorder) {
            mediaStreamRecorder.stop(callback);
            return;
        }

        this.getWebPImages(function() {
            /**
             * @property {Blob} blob - Recorded frames in video/webm blob.
             * @memberof CanvasRecorder
             * @example
             * recorder.stop(function() {
             *     var blob = recorder.blob;
             * });
             */
            whammy.compile(function(blob) {
                if (!config.disableLogs) {
                    console.log('Recording finished!');
                }

                that.blob = blob;

                if (that.blob.forEach) {
                    that.blob = new Blob([], {
                        type: 'video/webm'
                    });
                }

                if (callback) {
                    callback(that.blob);
                }

                whammy.frames = [];
            });
        });
    };

    var isPausedRecording = false;

    /**
     * This method pauses the recording process.
     * @method
     * @memberof CanvasRecorder
     * @example
     * recorder.pause();
     */
    this.pause = function() {
        isPausedRecording = true;

        if (mediaStreamRecorder instanceof MediaStreamRecorder) {
            mediaStreamRecorder.pause();
            return;
        }
    };

    /**
     * This method resumes the recording process.
     * @method
     * @memberof CanvasRecorder
     * @example
     * recorder.resume();
     */
    this.resume = function() {
        isPausedRecording = false;

        if (mediaStreamRecorder instanceof MediaStreamRecorder) {
            mediaStreamRecorder.resume();
            return;
        }

        if (!isRecording) {
            this.record();
        }
    };

    /**
     * This method resets currently recorded data.
     * @method
     * @memberof CanvasRecorder
     * @example
     * recorder.clearRecordedData();
     */
    this.clearRecordedData = function() {
        if (isRecording) {
            this.stop(clearRecordedDataCB);
        }
        clearRecordedDataCB();
    };

    function clearRecordedDataCB() {
        whammy.frames = [];
        isRecording = false;
        isPausedRecording = false;
    }

    // for debugging
    this.name = 'CanvasRecorder';
    this.toString = function() {
        return this.name;
    };

    function cloneCanvas() {
        //create a new canvas
        var newCanvas = document.createElement('canvas');
        var context = newCanvas.getContext('2d');

        //set dimensions
        newCanvas.width = htmlElement.width;
        newCanvas.height = htmlElement.height;

        //apply the old canvas to the new one
        context.drawImage(htmlElement, 0, 0);

        //return the new canvas
        return newCanvas;
    }

    function drawCanvasFrame() {
        if (isPausedRecording) {
            lastTime = new Date().getTime();
            return setTimeout(drawCanvasFrame, 500);
        }

        if (htmlElement.nodeName.toLowerCase() === 'canvas') {
            var duration = new Date().getTime() - lastTime;
            // via #206, by Jack i.e. @Seymourr
            lastTime = new Date().getTime();

            whammy.frames.push({
                image: cloneCanvas(),
                duration: duration
            });

            if (isRecording) {
                setTimeout(drawCanvasFrame, config.frameInterval);
            }
            return;
        }

        html2canvas(htmlElement, {
            grabMouse: typeof config.showMousePointer === 'undefined' || config.showMousePointer,
            onrendered: function(canvas) {
                var duration = new Date().getTime() - lastTime;
                if (!duration) {
                    return setTimeout(drawCanvasFrame, config.frameInterval);
                }

                // via #206, by Jack i.e. @Seymourr
                lastTime = new Date().getTime();

                whammy.frames.push({
                    image: canvas.toDataURL('image/webp', 1),
                    duration: duration
                });

                if (isRecording) {
                    setTimeout(drawCanvasFrame, config.frameInterval);
                }
            }
        });
    }

    var lastTime = new Date().getTime();

    var whammy = new Whammy.Video(100);
}

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.CanvasRecorder = CanvasRecorder;
}

// _________________
// WhammyRecorder.js

/**
 * WhammyRecorder is a standalone class used by {@link RecordRTC} to bring video recording in Chrome. It runs top over {@link Whammy}.
 * @summary Video recording feature in Chrome.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef WhammyRecorder
 * @class
 * @example
 * var recorder = new WhammyRecorder(mediaStream);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {disableLogs: true, initCallback: function, video: HTMLVideoElement, etc.}
 */

function WhammyRecorder(mediaStream, config) {

    config = config || {};

    if (!config.frameInterval) {
        config.frameInterval = 10;
    }

    if (!config.disableLogs) {
        console.log('Using frames-interval:', config.frameInterval);
    }

    /**
     * This method records video.
     * @method
     * @memberof WhammyRecorder
     * @example
     * recorder.record();
     */
    this.record = function() {
        if (!config.width) {
            config.width = 320;
        }

        if (!config.height) {
            config.height = 240;
        }

        if (!config.video) {
            config.video = {
                width: config.width,
                height: config.height
            };
        }

        if (!config.canvas) {
            config.canvas = {
                width: config.width,
                height: config.height
            };
        }

        canvas.width = config.canvas.width || 320;
        canvas.height = config.canvas.height || 240;

        context = canvas.getContext('2d');

        // setting defaults
        if (config.video && config.video instanceof HTMLVideoElement) {
            video = config.video.cloneNode();

            if (config.initCallback) {
                config.initCallback();
            }
        } else {
            video = document.createElement('video');

            setSrcObject(mediaStream, video);

            video.onloadedmetadata = function() { // "onloadedmetadata" may NOT work in FF?
                if (config.initCallback) {
                    config.initCallback();
                }
            };

            video.width = config.video.width;
            video.height = config.video.height;
        }

        video.muted = true;
        video.play();

        lastTime = new Date().getTime();
        whammy = new Whammy.Video();

        if (!config.disableLogs) {
            console.log('canvas resolutions', canvas.width, '*', canvas.height);
            console.log('video width/height', video.width || canvas.width, '*', video.height || canvas.height);
        }

        drawFrames(config.frameInterval);
    };

    /**
     * Draw and push frames to Whammy
     * @param {integer} frameInterval - set minimum interval (in milliseconds) between each time we push a frame to Whammy
     */
    function drawFrames(frameInterval) {
        frameInterval = typeof frameInterval !== 'undefined' ? frameInterval : 10;

        var duration = new Date().getTime() - lastTime;
        if (!duration) {
            return setTimeout(drawFrames, frameInterval, frameInterval);
        }

        if (isPausedRecording) {
            lastTime = new Date().getTime();
            return setTimeout(drawFrames, 100);
        }

        // via #206, by Jack i.e. @Seymourr
        lastTime = new Date().getTime();

        if (video.paused) {
            // via: https://github.com/muaz-khan/WebRTC-Experiment/pull/316
            // Tweak for Android Chrome
            video.play();
        }

        context.drawImage(video, 0, 0, canvas.width, canvas.height);
        whammy.frames.push({
            duration: duration,
            image: canvas.toDataURL('image/webp')
        });

        if (!isStopDrawing) {
            setTimeout(drawFrames, frameInterval, frameInterval);
        }
    }

    function asyncLoop(o) {
        var i = -1,
            length = o.length;

        (function loop() {
            i++;
            if (i === length) {
                o.callback();
                return;
            }

            // "setTimeout" added by Jim McLeod
            setTimeout(function() {
                o.functionToLoop(loop, i);
            }, 1);
        })();
    }


    /**
     * remove black frames from the beginning to the specified frame
     * @param {Array} _frames - array of frames to be checked
     * @param {number} _framesToCheck - number of frame until check will be executed (-1 - will drop all frames until frame not matched will be found)
     * @param {number} _pixTolerance - 0 - very strict (only black pixel color) ; 1 - all
     * @param {number} _frameTolerance - 0 - very strict (only black frame color) ; 1 - all
     * @returns {Array} - array of frames
     */
    // pull#293 by @volodalexey
    function dropBlackFrames(_frames, _framesToCheck, _pixTolerance, _frameTolerance, callback) {
        var localCanvas = document.createElement('canvas');
        localCanvas.width = canvas.width;
        localCanvas.height = canvas.height;
        var context2d = localCanvas.getContext('2d');
        var resultFrames = [];

        var checkUntilNotBlack = _framesToCheck === -1;
        var endCheckFrame = (_framesToCheck && _framesToCheck > 0 && _framesToCheck <= _frames.length) ?
            _framesToCheck : _frames.length;
        var sampleColor = {
            r: 0,
            g: 0,
            b: 0
        };
        var maxColorDifference = Math.sqrt(
            Math.pow(255, 2) +
            Math.pow(255, 2) +
            Math.pow(255, 2)
        );
        var pixTolerance = _pixTolerance && _pixTolerance >= 0 && _pixTolerance <= 1 ? _pixTolerance : 0;
        var frameTolerance = _frameTolerance && _frameTolerance >= 0 && _frameTolerance <= 1 ? _frameTolerance : 0;
        var doNotCheckNext = false;

        asyncLoop({
            length: endCheckFrame,
            functionToLoop: function(loop, f) {
                var matchPixCount, endPixCheck, maxPixCount;

                var finishImage = function() {
                    if (!doNotCheckNext && maxPixCount - matchPixCount <= maxPixCount * frameTolerance) {
                        // console.log('removed black frame : ' + f + ' ; frame duration ' + _frames[f].duration);
                    } else {
                        // console.log('frame is passed : ' + f);
                        if (checkUntilNotBlack) {
                            doNotCheckNext = true;
                        }
                        resultFrames.push(_frames[f]);
                    }
                    loop();
                };

                if (!doNotCheckNext) {
                    var image = new Image();
                    image.onload = function() {
                        context2d.drawImage(image, 0, 0, canvas.width, canvas.height);
                        var imageData = context2d.getImageData(0, 0, canvas.width, canvas.height);
                        matchPixCount = 0;
                        endPixCheck = imageData.data.length;
                        maxPixCount = imageData.data.length / 4;

                        for (var pix = 0; pix < endPixCheck; pix += 4) {
                            var currentColor = {
                                r: imageData.data[pix],
                                g: imageData.data[pix + 1],
                                b: imageData.data[pix + 2]
                            };
                            var colorDifference = Math.sqrt(
                                Math.pow(currentColor.r - sampleColor.r, 2) +
                                Math.pow(currentColor.g - sampleColor.g, 2) +
                                Math.pow(currentColor.b - sampleColor.b, 2)
                            );
                            // difference in color it is difference in color vectors (r1,g1,b1) <=> (r2,g2,b2)
                            if (colorDifference <= maxColorDifference * pixTolerance) {
                                matchPixCount++;
                            }
                        }
                        finishImage();
                    };
                    image.src = _frames[f].image;
                } else {
                    finishImage();
                }
            },
            callback: function() {
                resultFrames = resultFrames.concat(_frames.slice(endCheckFrame));

                if (resultFrames.length <= 0) {
                    // at least one last frame should be available for next manipulation
                    // if total duration of all frames will be < 1000 than ffmpeg doesn't work well...
                    resultFrames.push(_frames[_frames.length - 1]);
                }
                callback(resultFrames);
            }
        });
    }

    var isStopDrawing = false;

    /**
     * This method stops recording video.
     * @param {function} callback - Callback function, that is used to pass recorded blob back to the callee.
     * @method
     * @memberof WhammyRecorder
     * @example
     * recorder.stop(function(blob) {
     *     video.src = URL.createObjectURL(blob);
     * });
     */
    this.stop = function(callback) {
        callback = callback || function() {};

        isStopDrawing = true;

        var _this = this;
        // analyse of all frames takes some time!
        setTimeout(function() {
            // e.g. dropBlackFrames(frames, 10, 1, 1) - will cut all 10 frames
            // e.g. dropBlackFrames(frames, 10, 0.5, 0.5) - will analyse 10 frames
            // e.g. dropBlackFrames(frames, 10) === dropBlackFrames(frames, 10, 0, 0) - will analyse 10 frames with strict black color
            dropBlackFrames(whammy.frames, -1, null, null, function(frames) {
                whammy.frames = frames;

                // to display advertisement images!
                if (config.advertisement && config.advertisement.length) {
                    whammy.frames = config.advertisement.concat(whammy.frames);
                }

                /**
                 * @property {Blob} blob - Recorded frames in video/webm blob.
                 * @memberof WhammyRecorder
                 * @example
                 * recorder.stop(function() {
                 *     var blob = recorder.blob;
                 * });
                 */
                whammy.compile(function(blob) {
                    _this.blob = blob;

                    if (_this.blob.forEach) {
                        _this.blob = new Blob([], {
                            type: 'video/webm'
                        });
                    }

                    if (callback) {
                        callback(_this.blob);
                    }
                });
            });
        }, 10);
    };

    var isPausedRecording = false;

    /**
     * This method pauses the recording process.
     * @method
     * @memberof WhammyRecorder
     * @example
     * recorder.pause();
     */
    this.pause = function() {
        isPausedRecording = true;
    };

    /**
     * This method resumes the recording process.
     * @method
     * @memberof WhammyRecorder
     * @example
     * recorder.resume();
     */
    this.resume = function() {
        isPausedRecording = false;

        if (isStopDrawing) {
            this.record();
        }
    };

    /**
     * This method resets currently recorded data.
     * @method
     * @memberof WhammyRecorder
     * @example
     * recorder.clearRecordedData();
     */
    this.clearRecordedData = function() {
        if (!isStopDrawing) {
            this.stop(clearRecordedDataCB);
        }
        clearRecordedDataCB();
    };

    function clearRecordedDataCB() {
        whammy.frames = [];
        isStopDrawing = true;
        isPausedRecording = false;
    }

    // for debugging
    this.name = 'WhammyRecorder';
    this.toString = function() {
        return this.name;
    };

    var canvas = document.createElement('canvas');
    var context = canvas.getContext('2d');

    var video;
    var lastTime;
    var whammy;
}

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.WhammyRecorder = WhammyRecorder;
}

// https://github.com/antimatter15/whammy/blob/master/LICENSE
// _________
// Whammy.js

// todo: Firefox now supports webp for webm containers!
// their MediaRecorder implementation works well!
// should we provide an option to record via Whammy.js or MediaRecorder API is a better solution?

/**
 * Whammy is a standalone class used by {@link RecordRTC} to bring video recording in Chrome. It is written by {@link https://github.com/antimatter15|antimatter15}
 * @summary A real time javascript webm encoder based on a canvas hack.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef Whammy
 * @class
 * @example
 * var recorder = new Whammy().Video(15);
 * recorder.add(context || canvas || dataURL);
 * var output = recorder.compile();
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */

var Whammy = (function() {
    // a more abstract-ish API

    function WhammyVideo(duration) {
        this.frames = [];
        this.duration = duration || 1;
        this.quality = 0.8;
    }

    /**
     * Pass Canvas or Context or image/webp(string) to {@link Whammy} encoder.
     * @method
     * @memberof Whammy
     * @example
     * recorder = new Whammy().Video(0.8, 100);
     * recorder.add(canvas || context || 'image/webp');
     * @param {string} frame - Canvas || Context || image/webp
     * @param {number} duration - Stick a duration (in milliseconds)
     */
    WhammyVideo.prototype.add = function(frame, duration) {
        if ('canvas' in frame) { //CanvasRenderingContext2D
            frame = frame.canvas;
        }

        if ('toDataURL' in frame) {
            frame = frame.toDataURL('image/webp', this.quality);
        }

        if (!(/^data:image\/webp;base64,/ig).test(frame)) {
            throw 'Input must be formatted properly as a base64 encoded DataURI of type image/webp';
        }
        this.frames.push({
            image: frame,
            duration: duration || this.duration
        });
    };

    function processInWebWorker(_function) {
        var blob = URL.createObjectURL(new Blob([_function.toString(),
            'this.onmessage =  function (eee) {' + _function.name + '(eee.data);}'
        ], {
            type: 'application/javascript'
        }));

        var worker = new Worker(blob);
        URL.revokeObjectURL(blob);
        return worker;
    }

    function whammyInWebWorker(frames) {
        function ArrayToWebM(frames) {
            var info = checkFrames(frames);
            if (!info) {
                return [];
            }

            var clusterMaxDuration = 30000;

            var EBML = [{
                'id': 0x1a45dfa3, // EBML
                'data': [{
                    'data': 1,
                    'id': 0x4286 // EBMLVersion
                }, {
                    'data': 1,
                    'id': 0x42f7 // EBMLReadVersion
                }, {
                    'data': 4,
                    'id': 0x42f2 // EBMLMaxIDLength
                }, {
                    'data': 8,
                    'id': 0x42f3 // EBMLMaxSizeLength
                }, {
                    'data': 'webm',
                    'id': 0x4282 // DocType
                }, {
                    'data': 2,
                    'id': 0x4287 // DocTypeVersion
                }, {
                    'data': 2,
                    'id': 0x4285 // DocTypeReadVersion
                }]
            }, {
                'id': 0x18538067, // Segment
                'data': [{
                    'id': 0x1549a966, // Info
                    'data': [{
                        'data': 1e6, //do things in millisecs (num of nanosecs for duration scale)
                        'id': 0x2ad7b1 // TimecodeScale
                    }, {
                        'data': 'whammy',
                        'id': 0x4d80 // MuxingApp
                    }, {
                        'data': 'whammy',
                        'id': 0x5741 // WritingApp
                    }, {
                        'data': doubleToString(info.duration),
                        'id': 0x4489 // Duration
                    }]
                }, {
                    'id': 0x1654ae6b, // Tracks
                    'data': [{
                        'id': 0xae, // TrackEntry
                        'data': [{
                            'data': 1,
                            'id': 0xd7 // TrackNumber
                        }, {
                            'data': 1,
                            'id': 0x73c5 // TrackUID
                        }, {
                            'data': 0,
                            'id': 0x9c // FlagLacing
                        }, {
                            'data': 'und',
                            'id': 0x22b59c // Language
                        }, {
                            'data': 'V_VP8',
                            'id': 0x86 // CodecID
                        }, {
                            'data': 'VP8',
                            'id': 0x258688 // CodecName
                        }, {
                            'data': 1,
                            'id': 0x83 // TrackType
                        }, {
                            'id': 0xe0, // Video
                            'data': [{
                                'data': info.width,
                                'id': 0xb0 // PixelWidth
                            }, {
                                'data': info.height,
                                'id': 0xba // PixelHeight
                            }]
                        }]
                    }]
                }]
            }];

            //Generate clusters (max duration)
            var frameNumber = 0;
            var clusterTimecode = 0;
            while (frameNumber < frames.length) {

                var clusterFrames = [];
                var clusterDuration = 0;
                do {
                    clusterFrames.push(frames[frameNumber]);
                    clusterDuration += frames[frameNumber].duration;
                    frameNumber++;
                } while (frameNumber < frames.length && clusterDuration < clusterMaxDuration);

                var clusterCounter = 0;
                var cluster = {
                    'id': 0x1f43b675, // Cluster
                    'data': getClusterData(clusterTimecode, clusterCounter, clusterFrames)
                }; //Add cluster to segment
                EBML[1].data.push(cluster);
                clusterTimecode += clusterDuration;
            }

            return generateEBML(EBML);
        }

        function getClusterData(clusterTimecode, clusterCounter, clusterFrames) {
            return [{
                'data': clusterTimecode,
                'id': 0xe7 // Timecode
            }].concat(clusterFrames.map(function(webp) {
                var block = makeSimpleBlock({
                    discardable: 0,
                    frame: webp.data.slice(4),
                    invisible: 0,
                    keyframe: 1,
                    lacing: 0,
                    trackNum: 1,
                    timecode: Math.round(clusterCounter)
                });
                clusterCounter += webp.duration;
                return {
                    data: block,
                    id: 0xa3
                };
            }));
        }

        // sums the lengths of all the frames and gets the duration

        function checkFrames(frames) {
            if (!frames[0]) {
                postMessage({
                    error: 'Something went wrong. Maybe WebP format is not supported in the current browser.'
                });
                return;
            }

            var width = frames[0].width,
                height = frames[0].height,
                duration = frames[0].duration;

            for (var i = 1; i < frames.length; i++) {
                duration += frames[i].duration;
            }
            return {
                duration: duration,
                width: width,
                height: height
            };
        }

        function numToBuffer(num) {
            var parts = [];
            while (num > 0) {
                parts.push(num & 0xff);
                num = num >> 8;
            }
            return new Uint8Array(parts.reverse());
        }

        function strToBuffer(str) {
            return new Uint8Array(str.split('').map(function(e) {
                return e.charCodeAt(0);
            }));
        }

        function bitsToBuffer(bits) {
            var data = [];
            var pad = (bits.length % 8) ? (new Array(1 + 8 - (bits.length % 8))).join('0') : '';
            bits = pad + bits;
            for (var i = 0; i < bits.length; i += 8) {
                data.push(parseInt(bits.substr(i, 8), 2));
            }
            return new Uint8Array(data);
        }

        function generateEBML(json) {
            var ebml = [];
            for (var i = 0; i < json.length; i++) {
                var data = json[i].data;

                if (typeof data === 'object') {
                    data = generateEBML(data);
                }

                if (typeof data === 'number') {
                    data = bitsToBuffer(data.toString(2));
                }

                if (typeof data === 'string') {
                    data = strToBuffer(data);
                }

                var len = data.size || data.byteLength || data.length;
                var zeroes = Math.ceil(Math.ceil(Math.log(len) / Math.log(2)) / 8);
                var sizeToString = len.toString(2);
                var padded = (new Array((zeroes * 7 + 7 + 1) - sizeToString.length)).join('0') + sizeToString;
                var size = (new Array(zeroes)).join('0') + '1' + padded;

                ebml.push(numToBuffer(json[i].id));
                ebml.push(bitsToBuffer(size));
                ebml.push(data);
            }

            return new Blob(ebml, {
                type: 'video/webm'
            });
        }

        function toBinStrOld(bits) {
            var data = '';
            var pad = (bits.length % 8) ? (new Array(1 + 8 - (bits.length % 8))).join('0') : '';
            bits = pad + bits;
            for (var i = 0; i < bits.length; i += 8) {
                data += String.fromCharCode(parseInt(bits.substr(i, 8), 2));
            }
            return data;
        }

        function makeSimpleBlock(data) {
            var flags = 0;

            if (data.keyframe) {
                flags |= 128;
            }

            if (data.invisible) {
                flags |= 8;
            }

            if (data.lacing) {
                flags |= (data.lacing << 1);
            }

            if (data.discardable) {
                flags |= 1;
            }

            if (data.trackNum > 127) {
                throw 'TrackNumber > 127 not supported';
            }

            var out = [data.trackNum | 0x80, data.timecode >> 8, data.timecode & 0xff, flags].map(function(e) {
                return String.fromCharCode(e);
            }).join('') + data.frame;

            return out;
        }

        function parseWebP(riff) {
            var VP8 = riff.RIFF[0].WEBP[0];

            var frameStart = VP8.indexOf('\x9d\x01\x2a'); // A VP8 keyframe starts with the 0x9d012a header
            for (var i = 0, c = []; i < 4; i++) {
                c[i] = VP8.charCodeAt(frameStart + 3 + i);
            }

            var width, height, tmp;

            //the code below is literally copied verbatim from the bitstream spec
            tmp = (c[1] << 8) | c[0];
            width = tmp & 0x3FFF;
            tmp = (c[3] << 8) | c[2];
            height = tmp & 0x3FFF;
            return {
                width: width,
                height: height,
                data: VP8,
                riff: riff
            };
        }

        function getStrLength(string, offset) {
            return parseInt(string.substr(offset + 4, 4).split('').map(function(i) {
                var unpadded = i.charCodeAt(0).toString(2);
                return (new Array(8 - unpadded.length + 1)).join('0') + unpadded;
            }).join(''), 2);
        }

        function parseRIFF(string) {
            var offset = 0;
            var chunks = {};

            while (offset < string.length) {
                var id = string.substr(offset, 4);
                var len = getStrLength(string, offset);
                var data = string.substr(offset + 4 + 4, len);
                offset += 4 + 4 + len;
                chunks[id] = chunks[id] || [];

                if (id === 'RIFF' || id === 'LIST') {
                    chunks[id].push(parseRIFF(data));
                } else {
                    chunks[id].push(data);
                }
            }
            return chunks;
        }

        function doubleToString(num) {
            return [].slice.call(
                new Uint8Array((new Float64Array([num])).buffer), 0).map(function(e) {
                return String.fromCharCode(e);
            }).reverse().join('');
        }

        var webm = new ArrayToWebM(frames.map(function(frame) {
            var webp = parseWebP(parseRIFF(atob(frame.image.slice(23))));
            webp.duration = frame.duration;
            return webp;
        }));

        postMessage(webm);
    }

    /**
     * Encodes frames in WebM container. It uses WebWorkinvoke to invoke 'ArrayToWebM' method.
     * @param {function} callback - Callback function, that is used to pass recorded blob back to the callee.
     * @method
     * @memberof Whammy
     * @example
     * recorder = new Whammy().Video(0.8, 100);
     * recorder.compile(function(blob) {
     *    // blob.size - blob.type
     * });
     */
    WhammyVideo.prototype.compile = function(callback) {
        var webWorker = processInWebWorker(whammyInWebWorker);

        webWorker.onmessage = function(event) {
            if (event.data.error) {
                console.error(event.data.error);
                return;
            }
            callback(event.data);
        };

        webWorker.postMessage(this.frames);
    };

    return {
        /**
         * A more abstract-ish API.
         * @method
         * @memberof Whammy
         * @example
         * recorder = new Whammy().Video(0.8, 100);
         * @param {?number} speed - 0.8
         * @param {?number} quality - 100
         */
        Video: WhammyVideo
    };
})();

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.Whammy = Whammy;
}

// ______________ (indexed-db)
// DiskStorage.js

/**
 * DiskStorage is a standalone object used by {@link RecordRTC} to store recorded blobs in IndexedDB storage.
 * @summary Writing blobs into IndexedDB.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @example
 * DiskStorage.Store({
 *     audioBlob: yourAudioBlob,
 *     videoBlob: yourVideoBlob,
 *     gifBlob  : yourGifBlob
 * });
 * DiskStorage.Fetch(function(dataURL, type) {
 *     if(type === 'audioBlob') { }
 *     if(type === 'videoBlob') { }
 *     if(type === 'gifBlob')   { }
 * });
 * // DiskStorage.dataStoreName = 'recordRTC';
 * // DiskStorage.onError = function(error) { };
 * @property {function} init - This method must be called once to initialize IndexedDB ObjectStore. Though, it is auto-used internally.
 * @property {function} Fetch - This method fetches stored blobs from IndexedDB.
 * @property {function} Store - This method stores blobs in IndexedDB.
 * @property {function} onError - This function is invoked for any known/unknown error.
 * @property {string} dataStoreName - Name of the ObjectStore created in IndexedDB storage.
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */


var DiskStorage = {
    /**
     * This method must be called once to initialize IndexedDB ObjectStore. Though, it is auto-used internally.
     * @method
     * @memberof DiskStorage
     * @internal
     * @example
     * DiskStorage.init();
     */
    init: function() {
        var self = this;

        if (typeof indexedDB === 'undefined' || typeof indexedDB.open === 'undefined') {
            console.error('IndexedDB API are not available in this browser.');
            return;
        }

        var dbVersion = 1;
        var dbName = this.dbName || location.href.replace(/\/|:|#|%|\.|\[|\]/g, ''),
            db;
        var request = indexedDB.open(dbName, dbVersion);

        function createObjectStore(dataBase) {
            dataBase.createObjectStore(self.dataStoreName);
        }

        function putInDB() {
            var transaction = db.transaction([self.dataStoreName], 'readwrite');

            if (self.videoBlob) {
                transaction.objectStore(self.dataStoreName).put(self.videoBlob, 'videoBlob');
            }

            if (self.gifBlob) {
                transaction.objectStore(self.dataStoreName).put(self.gifBlob, 'gifBlob');
            }

            if (self.audioBlob) {
                transaction.objectStore(self.dataStoreName).put(self.audioBlob, 'audioBlob');
            }

            function getFromStore(portionName) {
                transaction.objectStore(self.dataStoreName).get(portionName).onsuccess = function(event) {
                    if (self.callback) {
                        self.callback(event.target.result, portionName);
                    }
                };
            }

            getFromStore('audioBlob');
            getFromStore('videoBlob');
            getFromStore('gifBlob');
        }

        request.onerror = self.onError;

        request.onsuccess = function() {
            db = request.result;
            db.onerror = self.onError;

            if (db.setVersion) {
                if (db.version !== dbVersion) {
                    var setVersion = db.setVersion(dbVersion);
                    setVersion.onsuccess = function() {
                        createObjectStore(db);
                        putInDB();
                    };
                } else {
                    putInDB();
                }
            } else {
                putInDB();
            }
        };
        request.onupgradeneeded = function(event) {
            createObjectStore(event.target.result);
        };
    },
    /**
     * This method fetches stored blobs from IndexedDB.
     * @method
     * @memberof DiskStorage
     * @internal
     * @example
     * DiskStorage.Fetch(function(dataURL, type) {
     *     if(type === 'audioBlob') { }
     *     if(type === 'videoBlob') { }
     *     if(type === 'gifBlob')   { }
     * });
     */
    Fetch: function(callback) {
        this.callback = callback;
        this.init();

        return this;
    },
    /**
     * This method stores blobs in IndexedDB.
     * @method
     * @memberof DiskStorage
     * @internal
     * @example
     * DiskStorage.Store({
     *     audioBlob: yourAudioBlob,
     *     videoBlob: yourVideoBlob,
     *     gifBlob  : yourGifBlob
     * });
     */
    Store: function(config) {
        this.audioBlob = config.audioBlob;
        this.videoBlob = config.videoBlob;
        this.gifBlob = config.gifBlob;

        this.init();

        return this;
    },
    /**
     * This function is invoked for any known/unknown error.
     * @method
     * @memberof DiskStorage
     * @internal
     * @example
     * DiskStorage.onError = function(error){
     *     alerot( JSON.stringify(error) );
     * };
     */
    onError: function(error) {
        console.error(JSON.stringify(error, null, '\t'));
    },

    /**
     * @property {string} dataStoreName - Name of the ObjectStore created in IndexedDB storage.
     * @memberof DiskStorage
     * @internal
     * @example
     * DiskStorage.dataStoreName = 'recordRTC';
     */
    dataStoreName: 'recordRTC',
    dbName: null
};

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.DiskStorage = DiskStorage;
}

// ______________
// GifRecorder.js

/**
 * GifRecorder is standalone calss used by {@link RecordRTC} to record video or canvas into animated gif.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef GifRecorder
 * @class
 * @example
 * var recorder = new GifRecorder(mediaStream || canvas || context, { onGifPreview: function, onGifRecordingStarted: function, width: 1280, height: 720, frameRate: 200, quality: 10 });
 * recorder.record();
 * recorder.stop(function(blob) {
 *     img.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object or HTMLCanvasElement or CanvasRenderingContext2D.
 * @param {object} config - {disableLogs:true, initCallback: function, width: 320, height: 240, frameRate: 200, quality: 10}
 */

function GifRecorder(mediaStream, config) {
    if (typeof GIFEncoder === 'undefined') {
        var script = document.createElement('script');
        script.src = 'https://www.webrtc-experiment.com/gif-recorder.js';
        (document.body || document.documentElement).appendChild(script);
    }

    config = config || {};

    var isHTMLObject = mediaStream instanceof CanvasRenderingContext2D || mediaStream instanceof HTMLCanvasElement;

    /**
     * This method records MediaStream.
     * @method
     * @memberof GifRecorder
     * @example
     * recorder.record();
     */
    this.record = function() {
        if (typeof GIFEncoder === 'undefined') {
            setTimeout(self.record, 1000);
            return;
        }

        if (!isLoadedMetaData) {
            setTimeout(self.record, 1000);
            return;
        }

        if (!isHTMLObject) {
            if (!config.width) {
                config.width = video.offsetWidth || 320;
            }

            if (!config.height) {
                config.height = video.offsetHeight || 240;
            }

            if (!config.video) {
                config.video = {
                    width: config.width,
                    height: config.height
                };
            }

            if (!config.canvas) {
                config.canvas = {
                    width: config.width,
                    height: config.height
                };
            }

            canvas.width = config.canvas.width || 320;
            canvas.height = config.canvas.height || 240;

            video.width = config.video.width || 320;
            video.height = config.video.height || 240;
        }

        // external library to record as GIF images
        gifEncoder = new GIFEncoder();

        // void setRepeat(int iter) 
        // Sets the number of times the set of GIF frames should be played. 
        // Default is 1; 0 means play indefinitely.
        gifEncoder.setRepeat(0);

        // void setFrameRate(Number fps) 
        // Sets frame rate in frames per second. 
        // Equivalent to setDelay(1000/fps).
        // Using "setDelay" instead of "setFrameRate"
        gifEncoder.setDelay(config.frameRate || 200);

        // void setQuality(int quality) 
        // Sets quality of color quantization (conversion of images to the 
        // maximum 256 colors allowed by the GIF specification). 
        // Lower values (minimum = 1) produce better colors, 
        // but slow processing significantly. 10 is the default, 
        // and produces good color mapping at reasonable speeds. 
        // Values greater than 20 do not yield significant improvements in speed.
        gifEncoder.setQuality(config.quality || 10);

        // Boolean start() 
        // This writes the GIF Header and returns false if it fails.
        gifEncoder.start();

        if (typeof config.onGifRecordingStarted === 'function') {
            config.onGifRecordingStarted();
        }

        startTime = Date.now();

        function drawVideoFrame(time) {
            if (self.clearedRecordedData === true) {
                return;
            }

            if (isPausedRecording) {
                return setTimeout(function() {
                    drawVideoFrame(time);
                }, 100);
            }

            lastAnimationFrame = requestAnimationFrame(drawVideoFrame);

            if (typeof lastFrameTime === undefined) {
                lastFrameTime = time;
            }

            // ~10 fps
            if (time - lastFrameTime < 90) {
                return;
            }

            if (!isHTMLObject && video.paused) {
                // via: https://github.com/muaz-khan/WebRTC-Experiment/pull/316
                // Tweak for Android Chrome
                video.play();
            }

            if (!isHTMLObject) {
                context.drawImage(video, 0, 0, canvas.width, canvas.height);
            }

            if (config.onGifPreview) {
                config.onGifPreview(canvas.toDataURL('image/png'));
            }

            gifEncoder.addFrame(context);
            lastFrameTime = time;
        }

        lastAnimationFrame = requestAnimationFrame(drawVideoFrame);

        if (config.initCallback) {
            config.initCallback();
        }
    };

    /**
     * This method stops recording MediaStream.
     * @param {function} callback - Callback function, that is used to pass recorded blob back to the callee.
     * @method
     * @memberof GifRecorder
     * @example
     * recorder.stop(function(blob) {
     *     img.src = URL.createObjectURL(blob);
     * });
     */
    this.stop = function(callback) {
        callback = callback || function() {};

        if (lastAnimationFrame) {
            cancelAnimationFrame(lastAnimationFrame);
        }

        endTime = Date.now();

        /**
         * @property {Blob} blob - The recorded blob object.
         * @memberof GifRecorder
         * @example
         * recorder.stop(function(){
         *     var blob = recorder.blob;
         * });
         */
        this.blob = new Blob([new Uint8Array(gifEncoder.stream().bin)], {
            type: 'image/gif'
        });

        callback(this.blob);

        // bug: find a way to clear old recorded blobs
        gifEncoder.stream().bin = [];
    };

    var isPausedRecording = false;

    /**
     * This method pauses the recording process.
     * @method
     * @memberof GifRecorder
     * @example
     * recorder.pause();
     */
    this.pause = function() {
        isPausedRecording = true;
    };

    /**
     * This method resumes the recording process.
     * @method
     * @memberof GifRecorder
     * @example
     * recorder.resume();
     */
    this.resume = function() {
        isPausedRecording = false;
    };

    /**
     * This method resets currently recorded data.
     * @method
     * @memberof GifRecorder
     * @example
     * recorder.clearRecordedData();
     */
    this.clearRecordedData = function() {
        self.clearedRecordedData = true;
        clearRecordedDataCB();
    };

    function clearRecordedDataCB() {
        if (gifEncoder) {
            gifEncoder.stream().bin = [];
        }
    }

    // for debugging
    this.name = 'GifRecorder';
    this.toString = function() {
        return this.name;
    };

    var canvas = document.createElement('canvas');
    var context = canvas.getContext('2d');

    if (isHTMLObject) {
        if (mediaStream instanceof CanvasRenderingContext2D) {
            context = mediaStream;
            canvas = context.canvas;
        } else if (mediaStream instanceof HTMLCanvasElement) {
            context = mediaStream.getContext('2d');
            canvas = mediaStream;
        }
    }

    var isLoadedMetaData = true;

    if (!isHTMLObject) {
        var video = document.createElement('video');
        video.muted = true;
        video.autoplay = true;
        video.playsInline = true;

        isLoadedMetaData = false;
        video.onloadedmetadata = function() {
            isLoadedMetaData = true;
        };

        setSrcObject(mediaStream, video);

        video.play();
    }

    var lastAnimationFrame = null;
    var startTime, endTime, lastFrameTime;

    var gifEncoder;

    var self = this;
}

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.GifRecorder = GifRecorder;
}

// Last time updated: 2019-06-21 4:09:42 AM UTC

// ________________________
// MultiStreamsMixer v1.2.2

// Open-Sourced: https://github.com/muaz-khan/MultiStreamsMixer

// --------------------------------------------------
// Muaz Khan     - www.MuazKhan.com
// MIT License   - www.WebRTC-Experiment.com/licence
// --------------------------------------------------

function MultiStreamsMixer(arrayOfMediaStreams, elementClass) {

    var browserFakeUserAgent = 'Fake/5.0 (FakeOS) AppleWebKit/123 (KHTML, like Gecko) Fake/12.3.4567.89 Fake/123.45';

    (function(that) {
        if (typeof RecordRTC !== 'undefined') {
            return;
        }

        if (!that) {
            return;
        }

        if (typeof window !== 'undefined') {
            return;
        }

        if (typeof global === 'undefined') {
            return;
        }

        global.navigator = {
            userAgent: browserFakeUserAgent,
            getUserMedia: function() {}
        };

        if (!global.console) {
            global.console = {};
        }

        if (typeof global.console.log === 'undefined' || typeof global.console.error === 'undefined') {
            global.console.error = global.console.log = global.console.log || function() {
                console.log(arguments);
            };
        }

        if (typeof document === 'undefined') {
            /*global document:true */
            that.document = {
                documentElement: {
                    appendChild: function() {
                        return '';
                    }
                }
            };

            document.createElement = document.captureStream = document.mozCaptureStream = function() {
                var obj = {
                    getContext: function() {
                        return obj;
                    },
                    play: function() {},
                    pause: function() {},
                    drawImage: function() {},
                    toDataURL: function() {
                        return '';
                    },
                    style: {}
                };
                return obj;
            };

            that.HTMLVideoElement = function() {};
        }

        if (typeof location === 'undefined') {
            /*global location:true */
            that.location = {
                protocol: 'file:',
                href: '',
                hash: ''
            };
        }

        if (typeof screen === 'undefined') {
            /*global screen:true */
            that.screen = {
                width: 0,
                height: 0
            };
        }

        if (typeof URL === 'undefined') {
            /*global screen:true */
            that.URL = {
                createObjectURL: function() {
                    return '';
                },
                revokeObjectURL: function() {
                    return '';
                }
            };
        }

        /*global window:true */
        that.window = global;
    })(typeof global !== 'undefined' ? global : null);

    // requires: chrome://flags/#enable-experimental-web-platform-features

    elementClass = elementClass || 'multi-streams-mixer';

    var videos = [];
    var isStopDrawingFrames = false;

    var canvas = document.createElement('canvas');
    var context = canvas.getContext('2d');
    canvas.style.opacity = 0;
    canvas.style.position = 'absolute';
    canvas.style.zIndex = -1;
    canvas.style.top = '-1000em';
    canvas.style.left = '-1000em';
    canvas.className = elementClass;
    (document.body || document.documentElement).appendChild(canvas);

    this.disableLogs = false;
    this.frameInterval = 10;

    this.width = 360;
    this.height = 240;

    // use gain node to prevent echo
    this.useGainNode = true;

    var self = this;

    // _____________________________
    // Cross-Browser-Declarations.js

    // WebAudio API representer
    var AudioContext = window.AudioContext;

    if (typeof AudioContext === 'undefined') {
        if (typeof webkitAudioContext !== 'undefined') {
            /*global AudioContext:true */
            AudioContext = webkitAudioContext;
        }

        if (typeof mozAudioContext !== 'undefined') {
            /*global AudioContext:true */
            AudioContext = mozAudioContext;
        }
    }

    /*jshint -W079 */
    var URL = window.URL;

    if (typeof URL === 'undefined' && typeof webkitURL !== 'undefined') {
        /*global URL:true */
        URL = webkitURL;
    }

    if (typeof navigator !== 'undefined' && typeof navigator.getUserMedia === 'undefined') { // maybe window.navigator?
        if (typeof navigator.webkitGetUserMedia !== 'undefined') {
            navigator.getUserMedia = navigator.webkitGetUserMedia;
        }

        if (typeof navigator.mozGetUserMedia !== 'undefined') {
            navigator.getUserMedia = navigator.mozGetUserMedia;
        }
    }

    var MediaStream = window.MediaStream;

    if (typeof MediaStream === 'undefined' && typeof webkitMediaStream !== 'undefined') {
        MediaStream = webkitMediaStream;
    }

    /*global MediaStream:true */
    if (typeof MediaStream !== 'undefined') {
        // override "stop" method for all browsers
        if (typeof MediaStream.prototype.stop === 'undefined') {
            MediaStream.prototype.stop = function() {
                this.getTracks().forEach(function(track) {
                    track.stop();
                });
            };
        }
    }

    var Storage = {};

    if (typeof AudioContext !== 'undefined') {
        Storage.AudioContext = AudioContext;
    } else if (typeof webkitAudioContext !== 'undefined') {
        Storage.AudioContext = webkitAudioContext;
    }

    function setSrcObject(stream, element) {
        if ('srcObject' in element) {
            element.srcObject = stream;
        } else if ('mozSrcObject' in element) {
            element.mozSrcObject = stream;
        } else {
            element.srcObject = stream;
        }
    }

    this.startDrawingFrames = function() {
        drawVideosToCanvas();
    };

    function drawVideosToCanvas() {
        if (isStopDrawingFrames) {
            return;
        }

        var videosLength = videos.length;

        var fullcanvas = false;
        var remaining = [];
        videos.forEach(function(video) {
            if (!video.stream) {
                video.stream = {};
            }

            if (video.stream.fullcanvas) {
                fullcanvas = video;
            } else {
                // todo: video.stream.active or video.stream.live to fix blank frames issues?
                remaining.push(video);
            }
        });

        if (fullcanvas) {
            canvas.width = fullcanvas.stream.width;
            canvas.height = fullcanvas.stream.height;
        } else if (remaining.length) {
            canvas.width = videosLength > 1 ? remaining[0].width * 2 : remaining[0].width;

            var height = 1;
            if (videosLength === 3 || videosLength === 4) {
                height = 2;
            }
            if (videosLength === 5 || videosLength === 6) {
                height = 3;
            }
            if (videosLength === 7 || videosLength === 8) {
                height = 4;
            }
            if (videosLength === 9 || videosLength === 10) {
                height = 5;
            }
            canvas.height = remaining[0].height * height;
        } else {
            canvas.width = self.width || 360;
            canvas.height = self.height || 240;
        }

        if (fullcanvas && fullcanvas instanceof HTMLVideoElement) {
            drawImage(fullcanvas);
        }

        remaining.forEach(function(video, idx) {
            drawImage(video, idx);
        });

        setTimeout(drawVideosToCanvas, self.frameInterval);
    }

    function drawImage(video, idx) {
        if (isStopDrawingFrames) {
            return;
        }

        var x = 0;
        var y = 0;
        var width = video.width;
        var height = video.height;

        if (idx === 1) {
            x = video.width;
        }

        if (idx === 2) {
            y = video.height;
        }

        if (idx === 3) {
            x = video.width;
            y = video.height;
        }

        if (idx === 4) {
            y = video.height * 2;
        }

        if (idx === 5) {
            x = video.width;
            y = video.height * 2;
        }

        if (idx === 6) {
            y = video.height * 3;
        }

        if (idx === 7) {
            x = video.width;
            y = video.height * 3;
        }

        if (typeof video.stream.left !== 'undefined') {
            x = video.stream.left;
        }

        if (typeof video.stream.top !== 'undefined') {
            y = video.stream.top;
        }

        if (typeof video.stream.width !== 'undefined') {
            width = video.stream.width;
        }

        if (typeof video.stream.height !== 'undefined') {
            height = video.stream.height;
        }

        context.drawImage(video, x, y, width, height);

        if (typeof video.stream.onRender === 'function') {
            video.stream.onRender(context, x, y, width, height, idx);
        }
    }

    function getMixedStream() {
        isStopDrawingFrames = false;
        var mixedVideoStream = getMixedVideoStream();

        var mixedAudioStream = getMixedAudioStream();
        if (mixedAudioStream) {
            mixedAudioStream.getTracks().filter(function(t) {
                return t.kind === 'audio';
            }).forEach(function(track) {
                mixedVideoStream.addTrack(track);
            });
        }

        var fullcanvas;
        arrayOfMediaStreams.forEach(function(stream) {
            if (stream.fullcanvas) {
                fullcanvas = true;
            }
        });

        // mixedVideoStream.prototype.appendStreams = appendStreams;
        // mixedVideoStream.prototype.resetVideoStreams = resetVideoStreams;
        // mixedVideoStream.prototype.clearRecordedData = clearRecordedData;

        return mixedVideoStream;
    }

    function getMixedVideoStream() {
        resetVideoStreams();

        var capturedStream;

        if ('captureStream' in canvas) {
            capturedStream = canvas.captureStream();
        } else if ('mozCaptureStream' in canvas) {
            capturedStream = canvas.mozCaptureStream();
        } else if (!self.disableLogs) {
            console.error('Upgrade to latest Chrome or otherwise enable this flag: chrome://flags/#enable-experimental-web-platform-features');
        }

        var videoStream = new MediaStream();

        capturedStream.getTracks().filter(function(t) {
            return t.kind === 'video';
        }).forEach(function(track) {
            videoStream.addTrack(track);
        });

        canvas.stream = videoStream;

        return videoStream;
    }

    function getMixedAudioStream() {
        // via: @pehrsons
        if (!Storage.AudioContextConstructor) {
            Storage.AudioContextConstructor = new Storage.AudioContext();
        }

        self.audioContext = Storage.AudioContextConstructor;

        self.audioSources = [];

        if (self.useGainNode === true) {
            self.gainNode = self.audioContext.createGain();
            self.gainNode.connect(self.audioContext.destination);
            self.gainNode.gain.value = 0; // don't hear self
        }

        var audioTracksLength = 0;
        arrayOfMediaStreams.forEach(function(stream) {
            if (!stream.getTracks().filter(function(t) {
                    return t.kind === 'audio';
                }).length) {
                return;
            }

            audioTracksLength++;

            var audioSource = self.audioContext.createMediaStreamSource(stream);

            if (self.useGainNode === true) {
                audioSource.connect(self.gainNode);
            }

            self.audioSources.push(audioSource);
        });

        if (!audioTracksLength) {
            // because "self.audioContext" is not initialized
            // that's why we've to ignore rest of the code
            return;
        }

        self.audioDestination = self.audioContext.createMediaStreamDestination();
        self.audioSources.forEach(function(audioSource) {
            audioSource.connect(self.audioDestination);
        });
        return self.audioDestination.stream;
    }

    function getVideo(stream) {
        var video = document.createElement('video');

        setSrcObject(stream, video);

        video.className = elementClass;

        video.muted = true;
        video.volume = 0;

        video.width = stream.width || self.width || 360;
        video.height = stream.height || self.height || 240;

        video.play();

        return video;
    }

    this.appendStreams = function(streams) {
        if (!streams) {
            throw 'First parameter is required.';
        }

        if (!(streams instanceof Array)) {
            streams = [streams];
        }

        streams.forEach(function(stream) {
            var newStream = new MediaStream();

            if (stream.getTracks().filter(function(t) {
                    return t.kind === 'video';
                }).length) {
                var video = getVideo(stream);
                video.stream = stream;
                videos.push(video);

                newStream.addTrack(stream.getTracks().filter(function(t) {
                    return t.kind === 'video';
                })[0]);
            }

            if (stream.getTracks().filter(function(t) {
                    return t.kind === 'audio';
                }).length) {
                var audioSource = self.audioContext.createMediaStreamSource(stream);
                self.audioDestination = self.audioContext.createMediaStreamDestination();
                audioSource.connect(self.audioDestination);

                newStream.addTrack(self.audioDestination.stream.getTracks().filter(function(t) {
                    return t.kind === 'audio';
                })[0]);
            }

            arrayOfMediaStreams.push(newStream);
        });
    };

    this.releaseStreams = function() {
        videos = [];
        isStopDrawingFrames = true;

        if (self.gainNode) {
            self.gainNode.disconnect();
            self.gainNode = null;
        }

        if (self.audioSources.length) {
            self.audioSources.forEach(function(source) {
                source.disconnect();
            });
            self.audioSources = [];
        }

        if (self.audioDestination) {
            self.audioDestination.disconnect();
            self.audioDestination = null;
        }

        if (self.audioContext) {
            self.audioContext.close();
        }

        self.audioContext = null;

        context.clearRect(0, 0, canvas.width, canvas.height);

        if (canvas.stream) {
            canvas.stream.stop();
            canvas.stream = null;
        }
    };

    this.resetVideoStreams = function(streams) {
        if (streams && !(streams instanceof Array)) {
            streams = [streams];
        }

        resetVideoStreams(streams);
    };

    function resetVideoStreams(streams) {
        videos = [];
        streams = streams || arrayOfMediaStreams;

        // via: @adrian-ber
        streams.forEach(function(stream) {
            if (!stream.getTracks().filter(function(t) {
                    return t.kind === 'video';
                }).length) {
                return;
            }

            var video = getVideo(stream);
            video.stream = stream;
            videos.push(video);
        });
    }

    // for debugging
    this.name = 'MultiStreamsMixer';
    this.toString = function() {
        return this.name;
    };

    this.getMixedStream = getMixedStream;

}

if (typeof RecordRTC === 'undefined') {
    if (true /* && !!module.exports*/ ) {
        module.exports = MultiStreamsMixer;
    }

    if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
            return MultiStreamsMixer;
        }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    }
}

// ______________________
// MultiStreamRecorder.js

/*
 * Video conference recording, using captureStream API along with WebAudio and Canvas2D API.
 */

/**
 * MultiStreamRecorder can record multiple videos in single container.
 * @summary Multi-videos recorder.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef MultiStreamRecorder
 * @class
 * @example
 * var options = {
 *     mimeType: 'video/webm'
 * }
 * var recorder = new MultiStreamRecorder(ArrayOfMediaStreams, options);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 *
 *     // or
 *     var blob = recorder.blob;
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStreams} mediaStreams - Array of MediaStreams.
 * @param {object} config - {disableLogs:true, frameInterval: 1, mimeType: "video/webm"}
 */

function MultiStreamRecorder(arrayOfMediaStreams, options) {
    arrayOfMediaStreams = arrayOfMediaStreams || [];
    var self = this;

    var mixer;
    var mediaRecorder;

    options = options || {
        elementClass: 'multi-streams-mixer',
        mimeType: 'video/webm',
        video: {
            width: 360,
            height: 240
        }
    };

    if (!options.frameInterval) {
        options.frameInterval = 10;
    }

    if (!options.video) {
        options.video = {};
    }

    if (!options.video.width) {
        options.video.width = 360;
    }

    if (!options.video.height) {
        options.video.height = 240;
    }

    /**
     * This method records all MediaStreams.
     * @method
     * @memberof MultiStreamRecorder
     * @example
     * recorder.record();
     */
    this.record = function() {
        // github/muaz-khan/MultiStreamsMixer
        mixer = new MultiStreamsMixer(arrayOfMediaStreams, options.elementClass || 'multi-streams-mixer');

        if (getAllVideoTracks().length) {
            mixer.frameInterval = options.frameInterval || 10;
            mixer.width = options.video.width || 360;
            mixer.height = options.video.height || 240;
            mixer.startDrawingFrames();
        }

        if (options.previewStream && typeof options.previewStream === 'function') {
            options.previewStream(mixer.getMixedStream());
        }

        // record using MediaRecorder API
        mediaRecorder = new MediaStreamRecorder(mixer.getMixedStream(), options);
        mediaRecorder.record();
    };

    function getAllVideoTracks() {
        var tracks = [];
        arrayOfMediaStreams.forEach(function(stream) {
            getTracks(stream, 'video').forEach(function(track) {
                tracks.push(track);
            });
        });
        return tracks;
    }

    /**
     * This method stops recording MediaStream.
     * @param {function} callback - Callback function, that is used to pass recorded blob back to the callee.
     * @method
     * @memberof MultiStreamRecorder
     * @example
     * recorder.stop(function(blob) {
     *     video.src = URL.createObjectURL(blob);
     * });
     */
    this.stop = function(callback) {
        if (!mediaRecorder) {
            return;
        }

        mediaRecorder.stop(function(blob) {
            self.blob = blob;

            callback(blob);

            self.clearRecordedData();
        });
    };

    /**
     * This method pauses the recording process.
     * @method
     * @memberof MultiStreamRecorder
     * @example
     * recorder.pause();
     */
    this.pause = function() {
        if (mediaRecorder) {
            mediaRecorder.pause();
        }
    };

    /**
     * This method resumes the recording process.
     * @method
     * @memberof MultiStreamRecorder
     * @example
     * recorder.resume();
     */
    this.resume = function() {
        if (mediaRecorder) {
            mediaRecorder.resume();
        }
    };

    /**
     * This method resets currently recorded data.
     * @method
     * @memberof MultiStreamRecorder
     * @example
     * recorder.clearRecordedData();
     */
    this.clearRecordedData = function() {
        if (mediaRecorder) {
            mediaRecorder.clearRecordedData();
            mediaRecorder = null;
        }

        if (mixer) {
            mixer.releaseStreams();
            mixer = null;
        }
    };

    /**
     * Add extra media-streams to existing recordings.
     * @method
     * @memberof MultiStreamRecorder
     * @param {MediaStreams} mediaStreams - Array of MediaStreams
     * @example
     * recorder.addStreams([newAudioStream, newVideoStream]);
     */
    this.addStreams = function(streams) {
        if (!streams) {
            throw 'First parameter is required.';
        }

        if (!(streams instanceof Array)) {
            streams = [streams];
        }

        arrayOfMediaStreams.concat(streams);

        if (!mediaRecorder || !mixer) {
            return;
        }

        mixer.appendStreams(streams);

        if (options.previewStream && typeof options.previewStream === 'function') {
            options.previewStream(mixer.getMixedStream());
        }
    };

    /**
     * Reset videos during live recording. Replace old videos e.g. replace cameras with full-screen.
     * @method
     * @memberof MultiStreamRecorder
     * @param {MediaStreams} mediaStreams - Array of MediaStreams
     * @example
     * recorder.resetVideoStreams([newVideo1, newVideo2]);
     */
    this.resetVideoStreams = function(streams) {
        if (!mixer) {
            return;
        }

        if (streams && !(streams instanceof Array)) {
            streams = [streams];
        }

        mixer.resetVideoStreams(streams);
    };

    /**
     * Returns MultiStreamsMixer
     * @method
     * @memberof MultiStreamRecorder
     * @example
     * let mixer = recorder.getMixer();
     * mixer.appendStreams([newStream]);
     */
    this.getMixer = function() {
        return mixer;
    };

    // for debugging
    this.name = 'MultiStreamRecorder';
    this.toString = function() {
        return this.name;
    };
}

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.MultiStreamRecorder = MultiStreamRecorder;
}

// _____________________
// RecordRTC.promises.js

/**
 * RecordRTCPromisesHandler adds promises support in {@link RecordRTC}. Try a {@link https://github.com/muaz-khan/RecordRTC/blob/master/simple-demos/RecordRTCPromisesHandler.html|demo here}
 * @summary Promises for {@link RecordRTC}
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef RecordRTCPromisesHandler
 * @class
 * @example
 * var recorder = new RecordRTCPromisesHandler(mediaStream, options);
 * recorder.startRecording()
 *         .then(successCB)
 *         .catch(errorCB);
 * // Note: You can access all RecordRTC API using "recorder.recordRTC" e.g. 
 * recorder.recordRTC.onStateChanged = function(state) {};
 * recorder.recordRTC.setRecordingDuration(5000);
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - Single media-stream object, array of media-streams, html-canvas-element, etc.
 * @param {object} config - {type:"video", recorderType: MediaStreamRecorder, disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, video: HTMLVideoElement, etc.}
 * @throws Will throw an error if "new" keyword is not used to initiate "RecordRTCPromisesHandler". Also throws error if first argument "MediaStream" is missing.
 * @requires {@link RecordRTC}
 */

function RecordRTCPromisesHandler(mediaStream, options) {
    if (!this) {
        throw 'Use "new RecordRTCPromisesHandler()"';
    }

    if (typeof mediaStream === 'undefined') {
        throw 'First argument "MediaStream" is required.';
    }

    var self = this;

    /**
     * @property {Blob} blob - Access/reach the native {@link RecordRTC} object.
     * @memberof RecordRTCPromisesHandler
     * @example
     * let internal = recorder.recordRTC.getInternalRecorder();
     * alert(internal instanceof MediaStreamRecorder);
     * recorder.recordRTC.onStateChanged = function(state) {};
     */
    self.recordRTC = new RecordRTC(mediaStream, options);

    /**
     * This method records MediaStream.
     * @method
     * @memberof RecordRTCPromisesHandler
     * @example
     * recorder.startRecording()
     *         .then(successCB)
     *         .catch(errorCB);
     */
    this.startRecording = function() {
        return new Promise(function(resolve, reject) {
            try {
                self.recordRTC.startRecording();
                resolve();
            } catch (e) {
                reject(e);
            }
        });
    };

    /**
     * This method stops the recording.
     * @method
     * @memberof RecordRTCPromisesHandler
     * @example
     * recorder.stopRecording().then(function() {
     *     var blob = recorder.getBlob();
     * }).catch(errorCB);
     */
    this.stopRecording = function() {
        return new Promise(function(resolve, reject) {
            try {
                self.recordRTC.stopRecording(function(url) {
                    self.blob = self.recordRTC.getBlob();

                    if (!self.blob || !self.blob.size) {
                        reject('Empty blob.', self.blob);
                        return;
                    }

                    resolve(url);
                });
            } catch (e) {
                reject(e);
            }
        });
    };

    /**
     * This method pauses the recording. You can resume recording using "resumeRecording" method.
     * @method
     * @memberof RecordRTCPromisesHandler
     * @example
     * recorder.pauseRecording()
     *         .then(successCB)
     *         .catch(errorCB);
     */
    this.pauseRecording = function() {
        return new Promise(function(resolve, reject) {
            try {
                self.recordRTC.pauseRecording();
                resolve();
            } catch (e) {
                reject(e);
            }
        });
    };

    /**
     * This method resumes the recording.
     * @method
     * @memberof RecordRTCPromisesHandler
     * @example
     * recorder.resumeRecording()
     *         .then(successCB)
     *         .catch(errorCB);
     */
    this.resumeRecording = function() {
        return new Promise(function(resolve, reject) {
            try {
                self.recordRTC.resumeRecording();
                resolve();
            } catch (e) {
                reject(e);
            }
        });
    };

    /**
     * This method returns data-url for the recorded blob.
     * @method
     * @memberof RecordRTCPromisesHandler
     * @example
     * recorder.stopRecording().then(function() {
     *     recorder.getDataURL().then(function(dataURL) {
     *         window.open(dataURL);
     *     }).catch(errorCB);;
     * }).catch(errorCB);
     */
    this.getDataURL = function(callback) {
        return new Promise(function(resolve, reject) {
            try {
                self.recordRTC.getDataURL(function(dataURL) {
                    resolve(dataURL);
                });
            } catch (e) {
                reject(e);
            }
        });
    };

    /**
     * This method returns the recorded blob.
     * @method
     * @memberof RecordRTCPromisesHandler
     * @example
     * recorder.stopRecording().then(function() {
     *     recorder.getBlob().then(function(blob) {})
     * }).catch(errorCB);
     */
    this.getBlob = function() {
        return new Promise(function(resolve, reject) {
            try {
                resolve(self.recordRTC.getBlob());
            } catch (e) {
                reject(e);
            }
        });
    };

    /**
     * This method returns the internal recording object.
     * @method
     * @memberof RecordRTCPromisesHandler
     * @example
     * let internalRecorder = await recorder.getInternalRecorder();
     * if(internalRecorder instanceof MultiStreamRecorder) {
     *     internalRecorder.addStreams([newAudioStream]);
     *     internalRecorder.resetVideoStreams([screenStream]);
     * }
     * @returns {Object} 
     */
    this.getInternalRecorder = function() {
        return new Promise(function(resolve, reject) {
            try {
                resolve(self.recordRTC.getInternalRecorder());
            } catch (e) {
                reject(e);
            }
        });
    };

    /**
     * This method resets the recorder. So that you can reuse single recorder instance many times.
     * @method
     * @memberof RecordRTCPromisesHandler
     * @example
     * await recorder.reset();
     * recorder.startRecording(); // record again
     */
    this.reset = function() {
        return new Promise(function(resolve, reject) {
            try {
                resolve(self.recordRTC.reset());
            } catch (e) {
                reject(e);
            }
        });
    };

    /**
     * Destroy RecordRTC instance. Clear all recorders and objects.
     * @method
     * @memberof RecordRTCPromisesHandler
     * @example
     * recorder.destroy().then(successCB).catch(errorCB);
     */
    this.destroy = function() {
        return new Promise(function(resolve, reject) {
            try {
                resolve(self.recordRTC.destroy());
            } catch (e) {
                reject(e);
            }
        });
    };

    /**
     * Get recorder's readonly state.
     * @method
     * @memberof RecordRTCPromisesHandler
     * @example
     * let state = await recorder.getState();
     * // or
     * recorder.getState().then(state => { console.log(state); })
     * @returns {String} Returns recording state.
     */
    this.getState = function() {
        return new Promise(function(resolve, reject) {
            try {
                resolve(self.recordRTC.getState());
            } catch (e) {
                reject(e);
            }
        });
    };

    /**
     * @property {Blob} blob - Recorded data as "Blob" object.
     * @memberof RecordRTCPromisesHandler
     * @example
     * await recorder.stopRecording();
     * let blob = recorder.getBlob(); // or "recorder.recordRTC.blob"
     * invokeSaveAsDialog(blob);
     */
    this.blob = null;

    /**
     * RecordRTC version number
     * @property {String} version - Release version number.
     * @memberof RecordRTCPromisesHandler
     * @static
     * @readonly
     * @example
     * alert(recorder.version);
     */
    this.version = '5.6.2';
}

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.RecordRTCPromisesHandler = RecordRTCPromisesHandler;
}

// ______________________
// WebAssemblyRecorder.js

/**
 * WebAssemblyRecorder lets you create webm videos in JavaScript via WebAssembly. The library consumes raw RGBA32 buffers (4 bytes per pixel) and turns them into a webm video with the given framerate and quality. This makes it compatible out-of-the-box with ImageData from a CANVAS. With realtime mode you can also use webm-wasm for streaming webm videos.
 * @summary Video recording feature in Chrome, Firefox and maybe Edge.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef WebAssemblyRecorder
 * @class
 * @example
 * var recorder = new WebAssemblyRecorder(mediaStream);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {webAssemblyPath:'webm-wasm.wasm',workerPath: 'webm-worker.js', frameRate: 30, width: 1920, height: 1080, bitrate: 1024, realtime: true}
 */
function WebAssemblyRecorder(stream, config) {
    // based on: github.com/GoogleChromeLabs/webm-wasm

    if (typeof ReadableStream === 'undefined' || typeof WritableStream === 'undefined') {
        // because it fixes readable/writable streams issues
        console.error('Following polyfill is strongly recommended: https://unpkg.com/@mattiasbuelens/web-streams-polyfill/dist/polyfill.min.js');
    }

    config = config || {};

    config.width = config.width || 640;
    config.height = config.height || 480;
    config.frameRate = config.frameRate || 30;
    config.bitrate = config.bitrate || 1200;
    config.realtime = config.realtime || true;

    function createBufferURL(buffer, type) {
        return URL.createObjectURL(new Blob([buffer], {
            type: type || ''
        }));
    }

    var finished;

    function cameraStream() {
        return new ReadableStream({
            start: function(controller) {
                var cvs = document.createElement('canvas');
                var video = document.createElement('video');
                var first = true;
                video.srcObject = stream;
                video.muted = true;
                video.height = config.height;
                video.width = config.width;
                video.volume = 0;
                video.onplaying = function() {
                    cvs.width = config.width;
                    cvs.height = config.height;
                    var ctx = cvs.getContext('2d');
                    var frameTimeout = 1000 / config.frameRate;
                    var cameraTimer = setInterval(function f() {
                        if (finished) {
                            clearInterval(cameraTimer);
                            controller.close();
                        }

                        if (first) {
                            first = false;
                            if (config.onVideoProcessStarted) {
                                config.onVideoProcessStarted();
                            }
                        }

                        ctx.drawImage(video, 0, 0);
                        if (controller._controlledReadableStream.state !== 'closed') {
                            try {
                                controller.enqueue(
                                    ctx.getImageData(0, 0, config.width, config.height)
                                );
                            } catch (e) {}
                        }
                    }, frameTimeout);
                };
                video.play();
            }
        });
    }

    var worker;

    function startRecording(stream, buffer) {
        if (!config.workerPath && !buffer) {
            finished = false;

            // is it safe to use @latest ?

            fetch(
                'https://unpkg.com/webm-wasm@latest/dist/webm-worker.js'
            ).then(function(r) {
                r.arrayBuffer().then(function(buffer) {
                    startRecording(stream, buffer);
                });
            });
            return;
        }

        if (!config.workerPath && buffer instanceof ArrayBuffer) {
            var blob = new Blob([buffer], {
                type: 'text/javascript'
            });
            config.workerPath = URL.createObjectURL(blob);
        }

        if (!config.workerPath) {
            console.error('workerPath parameter is missing.');
        }

        worker = new Worker(config.workerPath);

        worker.postMessage(config.webAssemblyPath || 'https://unpkg.com/webm-wasm@latest/dist/webm-wasm.wasm');
        worker.addEventListener('message', function(event) {
            if (event.data === 'READY') {
                worker.postMessage({
                    width: config.width,
                    height: config.height,
                    bitrate: config.bitrate || 1200,
                    timebaseDen: config.frameRate || 30,
                    realtime: config.realtime
                });

                cameraStream().pipeTo(new WritableStream({
                    write: function(image) {
                        if (finished) {
                            console.error('Got image, but recorder is finished!');
                            return;
                        }

                        worker.postMessage(image.data.buffer, [image.data.buffer]);
                    }
                }));
            } else if (!!event.data) {
                if (!isPaused) {
                    arrayOfBuffers.push(event.data);
                }
            }
        });
    }

    /**
     * This method records video.
     * @method
     * @memberof WebAssemblyRecorder
     * @example
     * recorder.record();
     */
    this.record = function() {
        arrayOfBuffers = [];
        isPaused = false;
        this.blob = null;
        startRecording(stream);

        if (typeof config.initCallback === 'function') {
            config.initCallback();
        }
    };

    var isPaused;

    /**
     * This method pauses the recording process.
     * @method
     * @memberof WebAssemblyRecorder
     * @example
     * recorder.pause();
     */
    this.pause = function() {
        isPaused = true;
    };

    /**
     * This method resumes the recording process.
     * @method
     * @memberof WebAssemblyRecorder
     * @example
     * recorder.resume();
     */
    this.resume = function() {
        isPaused = false;
    };

    function terminate(callback) {
        if (!worker) {
            if (callback) {
                callback();
            }

            return;
        }

        // Wait for null event data to indicate that the encoding is complete
        worker.addEventListener('message', function(event) {
            if (event.data === null) {
                worker.terminate();
                worker = null;

                if (callback) {
                    callback();
                }
            }
        });

        worker.postMessage(null);
    }

    var arrayOfBuffers = [];

    /**
     * This method stops recording video.
     * @param {function} callback - Callback function, that is used to pass recorded blob back to the callee.
     * @method
     * @memberof WebAssemblyRecorder
     * @example
     * recorder.stop(function(blob) {
     *     video.src = URL.createObjectURL(blob);
     * });
     */
    this.stop = function(callback) {
        finished = true;

        var recorder = this;

        terminate(function() {
            recorder.blob = new Blob(arrayOfBuffers, {
                type: 'video/webm'
            });

            callback(recorder.blob);
        });
    };

    // for debugging
    this.name = 'WebAssemblyRecorder';
    this.toString = function() {
        return this.name;
    };

    /**
     * This method resets currently recorded data.
     * @method
     * @memberof WebAssemblyRecorder
     * @example
     * recorder.clearRecordedData();
     */
    this.clearRecordedData = function() {
        arrayOfBuffers = [];
        isPaused = false;
        this.blob = null;

        // todo: if recording-ON then STOP it first
    };

    /**
     * @property {Blob} blob - The recorded blob object.
     * @memberof WebAssemblyRecorder
     * @example
     * recorder.stop(function(){
     *     var blob = recorder.blob;
     * });
     */
    this.blob = null;
}

if (typeof RecordRTC !== 'undefined') {
    RecordRTC.WebAssemblyRecorder = WebAssemblyRecorder;
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__("DuR2"), __webpack_require__("W2nU")))

/***/ }),

/***/ "ncfW":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


if (true) {
  module.exports = __webpack_require__("LpuX");
} else {
  module.exports = require('./cjs/react-is.development.js');
}


/***/ }),

/***/ "nxuO":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAALBJREFUOE/dkj0OAWEQhp83Ua349GoOQBTcQ3AC9e4N9ga7jiNWtByBU/D5KY1YivWTbKGQmPaZeTKZecWXpdt8LbSloPPkEjOfaPjgC0G3yM2YH6YaqDGx4Bhw+rDI2aeqlvF/EGAmF7EFmi9HXPlEfTC5kA3QernT2qfq5V8gtorb44oNvs6OWJcyfhd8UbnARZZhtAseAzKfapzz0Oa85yTziUb/8MayqJZx/TwHV4vrphErqTZQAAAAAElFTkSuQmCC"

/***/ }),

/***/ "pBGO":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAhCAYAAADdy1suAAAAAXNSR0IArs4c6QAABKNJREFUSEuNlltMFFcYx38zuy4LcpVbQwPIpQ8taAJIk160NioaWlCsAVqTpq0Y9qV9aC0RnvrSRGlMJCSiAVJLQ4qoWEIqsJBIbWNLJESthsrFKqbWIqhFQWDXnebMZbPL7gLnaeZ/zvmdb77zXUYiwGiGKDN8oMA2IAuIk8AB3FOgX4GOaWgv1zSfIS1WOiBkFiqBzxUICXSwrv8tQ2UxfL94nRe4FdJdcA7IXAboNS3BmXn46EOYMSbc4BZIAy4CCcZkxLp1pJaVEb91KyFJSaAozNy5w/3ubm7V1/Pk5k3PA/pkyC+GZ0JUwd+CNRgGgAzxLgcFkVVTQ9r+/Uiy7Nd4l9PJSG0tVysqUJxOY01jKZS5wafgawWqVKjVyma7ndiNG1fkjX+6uviloMANl2BbCfRKbRC9ALeBUEHKbWggdd++FUGNRX8eOcLVAwfUVwl+K4HXpVNgU6BOiJHZ2eRdvuz1+bPj4/yUno7LoUWVZDJRMD5OcIL7KtS5zowMno6MqGtc8LLUAh3Au0LIOX6c9PJyL2vvnj7NpeJit5Zms7GhTrXDawwdPsy1gwdVTYYvBFi4IVkI74yNEZqa6rXhWmUlQ4cOqVpIYiI7rl9nVXi4D/jh4CA9OTmqrsB3AjwLBCNJ7Jmbw2SxeG36OS+P+z09qrYqIoKg6GhePXnS53LnJyf5MTbW8PN5ARZxZw0EPhcTw8LUlPsw8UU7btzAZLV6GTD34AHtcXGG1inAo2jJQf7oKGFp6qN7jB47xlR/P7ebmlTtzbY2Xiwq8nHFo8FB7LorgAYBPgO8J1bm1NWRbrP5bBo7cYIBm434LVvY3NvrMy8Ez8sDPhXh9okCjWIyMiuLvIEBn2z7o6qKoepqtl+5QkSmbxlRwy0zk6fDw/rd8ZLUBKstcBeIEuqG+nrSytSsdI/f9+7FsmYN2bW1fq31TBDAXgrb1VrRAl8C1eJZ1Im37HbiNm1yQ/7t6SEqNxdLZKQP+F5nJ78WFhop/VyBN96HfhV8AcwTcFGB1wx41tGjWhEymfxaKYrQcE2NmhQeReibUqgQG9xlswniLHDJiBAxGZ6ZqZbNF/SyqbhczBpls7FxcdlsL4HdkprRHmDx0gpJLugDUvyaGVg8PwG7P4N5Y4lPa2qGZDNcUFYO7wyHonwPqI/FxmlnIdmhWb52Kcsl6AqDXYuhAcFi4gcN2ifpBWrxARJ0z8Kuj2HO3+E+rvBc1Aopus+TFm22P4OdgaBLWmyAmiHVpEYkBrxXhkKjaQZy1ZIWG5v0Di7gwzIULAddkcUGXPg8FCYKtPq97PBr8VcgvwIifyNk7W/I4gCRgwrw3AXzMswEwaOd8GRFl9cOYQ5IcUKQKEwShJnAoqitTB0CLCLhPwmmnTBjhlvFsOB5gJfFuqXrAZMeZsFisQLxkugyoAiYAo+F7oJJCSZlmN4DWovWhxdYAVGf18tgViBRhtU6OEb0RUn9yWJawHV9AngorC/WOpF/sFBFfQ6BtQ7RYDUfq65waYcpMjg9XDHjgOkE+OttcP9nLRkVrRBhgfAFCBH+Nus+NmvgeQfMhMLjQFHyP/MffkAUiD/oAAAAAElFTkSuQmCC"

/***/ }),

/***/ "pdZy":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _interopRequireDefault = __webpack_require__("ouCL");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Common;
__webpack_require__("UQ5M");
var _message2 = _interopRequireDefault(__webpack_require__("/qCn"));
var _rtcClient = _interopRequireDefault(__webpack_require__("adV+"));
var _shareClient = _interopRequireDefault(__webpack_require__("Xusr"));
var _presetting = _interopRequireDefault(__webpack_require__("2mw7"));
var _api = __webpack_require__("H/Zg");
function Common() {
  var isCamOn = true;
  var isMicOn = true;
  var isScreenOn = false;
  var isJoined = true;
  var rtc = null;
  var share = null;
  var shareUserId = "";
  var cameraId = "";
  var micId = "";
  var number = 0;
  var videoThis = null;
  var common = {
    login: function login(roomId, mobilePhone, cid, name, _this) {
      var _this2 = this;
      (0, _presetting.default)(false, roomId, mobilePhone, cid, name, function (options) {
        rtc = new _rtcClient.default(options, _this);
        console.log(_this);
        videoThis = _this;
        _this2.join();
      });
      (0, _presetting.default)(true, roomId, mobilePhone, cid, name, function (options) {
        shareUserId = options.userId;
        share = new _shareClient.default(options);
      });

      // if ($("#userId").val() == "") {
      //   alert("用户名不能为空！");
      //   return;
      // }
      // if ($("#roomId").val() == "") {
      //   alert("房间号不能为空！");
      //   return;
      // }
      // presetting.login(false, (options) => {
      //   const options = {
      //     sdkAppId: 1400246643,
      //     userId: "user_43707228",
      //     userSig:
      //       "eJwtzMEKgzAQBNB-ydUia4y6Cr0Ueih4UqG9lWoSWaJVkrQUSv*9oh7nzTBf1pR1*FaWFYyHwA5rJqmenjSt-HLK3kWcQcY57gMnzWOeSbIiEgBcpKmIt8bTqBZNEFFEOeCm6jOTXTwFgQD7B-XLe95IDzc7TH2gz21QXU5j1155OdLQmUrWueZZMiBOxh3Z7w8UZDLR",
      //     roomId: "83999",
      //   };
      //   rtc = new RtcClient(options);
      //   // join();
      // // });
      // // presetting.login(true, (options) => {
      // //   shareUserId = options.userId;
      //   share = new ShareClient(options);
      // });
    },
    join: function join() {
      rtc.join();
      // $("#login-root").hide();
      // $("#room-root").show();
      // $("#header-roomId").html("房间号: " + $("#roomId").val());
      // $("#member-me")
      //   .find(".member-id")
      //   .html($("#userId").val() + "(我)");
    },
    leave: function leave(roomNo) {
      // document
      //   .getElementById("main-video")
      //   .appendChild(document.getElementById("mask_main"));
      // $("#mask_main").appendTo($("#main-video"));
      /**
       * 调用结束时间的接口
       * 主要作用是服务端记录结束时间
       */
      (0, _api.updateRoomEndTime)({
        roomNo: roomNo
      }).then(function (res) {
        console.log(res);
      });
      rtc.leave();
      share.leave();
      _message2.default.info('您已离开房间');
    },
    publish: function publish() {
      rtc.publish();
    },
    unpublish: function unpublish() {
      rtc.unpublish();
    },
    muteAudio: function muteAudio() {
      rtc.muteLocalAudio();
    },
    unmuteAudio: function unmuteAudio() {
      rtc.unmuteLocalAudio();
    },
    muteVideo: function muteVideo() {
      document.getElementById("mask_main").style.display = "flex";
      // $("#mask_main").show();
      rtc.muteLocalVideo();
    },
    unmuteVideo: function unmuteVideo() {
      rtc.unmuteLocalVideo();
      document.getElementById("mask_main").style.display = "none";
      // $("#mask_main").hide();
    },
    startSharing: function startSharing() {
      share.join();
    },
    stopSharing: function stopSharing() {
      share.leave();
    },
    //主视频点击切换
    mainVideoClick: function mainVideoClick() {
      var mainVideo = document.getElementById("main-video");
      if (document.getElementById("div-video-local").childNodes[0].getAttribute("id") == mainVideo.getAttribute("id")) {
        return;
      }
      //释放main-video grid-area
      // mainVideo.style.gridArea = "auto/auto/auto/auto";
      // exchangeView(document.getElementById("main-video"), mainVideo);
      // //将video-grid中第一个div设为main-video
      // document.getElementsByClassName("video-box")[0].style.gridArea =
      //   "1/1/3/4";
      mainVideo.style.height = '100%';
      // mainVideo.style.paddingBottom='0';
      var right = mainVideo;
      var left = document.querySelector('#div-video-local').childNodes[0];
      document.querySelector('#div-video-local').removeChild(left);
      document.querySelector('#div-video-local').appendChild(right);
      left.style.height = '200px';
      // document
      //   .querySelector('#div-video-child')
      //   .removeChild(
      //     right
      //   );
      document.querySelector('#div-video-child').appendChild(left);

      //chromeM71以下会自动暂停，手动唤醒
      if (getBroswer().broswer == "Chrome" && getBroswer().version < "72") {
        rtc.resumeStreams();
      }
      // $("#main-video").on("click", () => {
      //   let mainVideo = $(".video-box").first();
      //   if ($("#main-video").is(mainVideo)) {
      //     return;
      //   }
      //   //释放main-video grid-area
      //   mainVideo.css("grid-area", "auto/auto/auto/auto");
      //   exchangeView($("#main-video"), mainVideo);
      //   //将video-grid中第一个div设为main-video
      //   $(".video-box").first().css("grid-area", "1/1/3/4");
      //   //chromeM71以下会自动暂停，手动唤醒
      //   if (getBroswer().broswer == "Chrome" && getBroswer().version < "72") {
      //     rtc.resumeStreams();
      //   }
      // });
    },
    //共享屏幕按钮点击
    screenShareClick: function screenShareClick() {
      // throttle(() => {
      if (!TRTC.isScreenShareSupported()) {
        alert("当前浏览器不支持屏幕分享！");
        return;
      }
      if (isScreenOn) {
        // document
        //   .getElementById("screen-btn")
        //   .setAttribute(
        //     "src",
        //     require("../../../assets/images/prevention/screen-off.png")
        //   );
        // $("#screen-btn").attr("src", "./img/screen-off.png");
        this.stopSharing();
        isScreenOn = false;
      } else {
        // document
        //   .getElementById("screen-btn")
        //   .setAttribute(
        //     "src",
        //     require("../../../assets/images/prevention/screen-on.png")
        //   );
        // $("#screen-btn").attr("src", "./img/screen-on.png");
        this.startSharing();
        isScreenOn = true;
      }
      // }, 2000);
    },
    setBtnClickFuc: function setBtnClickFuc() {
      //userid roomid规格
      //$('#userId').on('input', function(e) {
      //    e.preventDefault();
      //    let val = $('#userId').val().slice(5);
      //    $('#userId').val('user_'+val.replace(/[^\d]/g,''));
      //});
      // $("#roomId").on("input", function (e) {
      //   e.preventDefault();
      //   let val = $("#roomId").val();
      //   $("#roomId").val(val.replace(/[^\d]/g, ""));
      // });
      //login
      // $("#login-btn").click(() => {
      //   login();
      // });
      //open or close camera
      // $("#video-btn").on("click", () => {
      //   if (isCamOn) {
      //     $("#video-btn").attr("src", "./img/big-camera-off.png");
      //     $("#video-btn").attr("title", "打开摄像头");
      //     $("#member-me")
      //       .find(".member-video-btn")
      //       .attr("src", "img/camera-off.png");
      //     isCamOn = false;
      //     muteVideo();
      //   } else {
      //     $("#video-btn").attr("src", "./img/big-camera-on.png");
      //     $("#video-btn").attr("title", "关闭摄像头");
      //     $("#member-me")
      //       .find(".member-video-btn")
      //       .attr("src", "img/camera-on.png");
      //     isCamOn = true;
      //     unmuteVideo();
      //   }
      // });
      //open or close microphone
      // $("#mic-btn").on("click", () => {
      //   if (isMicOn) {
      //     $("#mic-btn").attr("src", "./img/big-mic-off.png");
      //     $("#mic-btn").attr("title", "打开麦克风");
      //     $("#member-me")
      //       .find(".member-audio-btn")
      //       .attr("src", "img/mic-off.png");
      //     isMicOn = false;
      //     muteAudio();
      //   } else {
      //     $("#mic-btn").attr("src", "./img/big-mic-on.png");
      //     $("#mic-btn").attr("title", "关闭麦克风");
      //     $("#member-me")
      //       .find(".member-audio-btn")
      //       .attr("src", "img/mic-on.png");
      //     isMicOn = true;
      //     unmuteAudio();
      //   }
      // });
      //share screen or not
      // $("#screen-btn").on(
      //   "click",
      //   throttle(() => {
      //     if (!TRTC.isScreenShareSupported()) {
      //       alert("当前浏览器不支持屏幕分享！");
      //       return;
      //     }
      //     if ($("#screen-btn").attr("src") == "./img/screen-on.png") {
      //       $("#screen-btn").attr("src", "./img/screen-off.png");
      //       stopSharing();
      //       isScreenOn = false;
      //     } else {
      //       $("#screen-btn").attr("src", "./img/screen-on.png");
      //       startSharing();
      //       isScreenOn = true;
      //     }
      //   }, 2000)
      // );
      //logout
      // $("#logout-btn").on("click", () => {
      //   leave();
      //   $("#room-root").hide();
      //   $("#login-root").show();
      // });
      //switch main video
      // $("#main-video").on("click", () => {
      //   let mainVideo = $(".video-box").first();
      //   if ($("#main-video").is(mainVideo)) {
      //     return;
      //   }
      //   //释放main-video grid-area
      //   mainVideo.css("grid-area", "auto/auto/auto/auto");
      //   exchangeView($("#main-video"), mainVideo);
      //   //将video-grid中第一个div设为main-video
      //   $(".video-box").first().css("grid-area", "1/1/3/4");
      //   //chromeM71以下会自动暂停，手动唤醒
      //   if (getBroswer().broswer == "Chrome" && getBroswer().version < "72") {
      //     rtc.resumeStreams();
      //   }
      // });

      //chrome60以下不支持popover，防止error
      if (getBroswer().broswer == "Chrome" && getBroswer().version < "60") return;
      //开启popover
      $(function () {
        $('[data-toggle="popover"]').popover();
      });
      $("#camera").popover({
        html: true,
        content: function content() {
          return $("#camera-option").html();
        }
      });
      $("#microphone").popover({
        html: true,
        content: function content() {
          return $("#mic-option").html();
        }
      });
      $("#camera").on("click", function () {
        $("#microphone").popover("hide");
        $(".popover-body").find("div").attr("onclick", "setCameraId(this)");
      });
      $("#microphone").on("click", function () {
        $("#camera").popover("hide");
        $(".popover-body").find("div").attr("onclick", "setMicId(this)");
      });

      //点击body关闭popover
      $("body").click(function () {
        $("#camera").popover("hide");
        $("#microphone").popover("hide");
      });

      //popover事件
      $("#camera").on("show.bs.popover", function () {
        $("#camera").attr("src", "./img/camera-on.png");
      });
      $("#camera").on("hide.bs.popover", function () {
        $("#camera").attr("src", "./img/camera.png");
      });
      $("#microphone").on("show.bs.popover", function () {
        $("#microphone").attr("src", "./img/mic-on.png");
      });
      $("#microphone").on("hide.bs.popover", function () {
        $("#microphone").attr("src", "./img/mic.png");
      });
    },
    setCameraId: function setCameraId(thisDiv) {
      //   cameraId = $(thisDiv).attr("id");
      cameraId = thisDiv;
    },
    setMicId: function setMicId(thisDiv) {
      micId = $(thisDiv).attr("id");
    },
    addVideoView: function addVideoView(id, videoThis) {
      var isLocal = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var div = document.createElement("div");
      div.setAttribute("id", id);
      div.className = "video-box video-container";
      div.style.justifyContent = "center";
      number = number + 1;
      document.getElementById("div-video-child").appendChild(div);
      // div.onclick = ()=>{
      //   console.log(123);
      //   videoThis.setLayout(id)
      // }
      // document.getElementById("video-content").appendChild(div);
      //设置监听
      //切换排版
      // div.onclick = () => {
      //   let list = document.querySelectorAll('.video-container');
      //   let left = document.getElementById('video-left');
      //   let right = document.getElementById('video-right');
      //   left.style.display = "block";
      //   right.style.display = "block";
      //   for (let i = 0; i < list.length; i++) {
      //     list[i].width = "100%";
      //     list[i].height = "100%";
      //     if (list[i] != div) {
      //       document.querySelector('#video-right').appendChild(list[i]);
      //     }
      //   }
      //   document.querySelector('#video-left').appendChild(div)
      //   //chromeM71以下会自动暂停，手动唤醒
      //   if (getBroswer().broswer == "Chrome" && getBroswer().version < "72") {
      //     rtc.resumeStreams();
      //   }
      // };
      //拖动事件
      // let clientX = 0, clientY = 0, x = 0, y = 0, isDown = false,
      //   offsetLeft = 0, offsetTop = 0

      // div.onmousedown = (e) => {
      //   isDown = true
      //   clientX = e.clientX
      //   clientY = e.clientY
      //   offsetLeft = document.getElementById(id).offsetLeft
      //   offsetTop = document.getElementById(id).offsetTop
      // }
      // div.onmousemove = (e) => {
      //   if (isDown == false) {
      //     return
      //   }
      //   //获取x坐标和y坐标
      //   var nx = e.clientX;
      //   var ny = e.clientY;
      //   // //计算移动后的左偏移量和顶部的偏移量
      //   var nl = nx - (clientX - offsetLeft);
      //   var nt = ny - (clientY - offsetTop);
      //   x = nl;
      //   y = nt;
      //   div.style.top = y + 'px'
      //   div.style.left = x + 'px'
      // }
      // div.onmouseup = (e) => {
      //   isDown = false
      // }
    },
    addMemberView: function addMemberView(id) {
      var memberElm = document.getElementById("member-me").cloneNode(true);
      // let memberElm = $("#member-me").clone();
      memberElm.setAttribute("id", id);
      memberElm.getElementsByClassName("member-id")[0].innerHTML = id;
      // memberElm.find("div.member-id").html(id);
      memberElm.style.display = "flex";
      // memberElm.css("display", "flex");
      document.getElementById("member-list").appendChild(memberElm);
      // memberElm.appendTo($("#member-list"));
    },
    removeView: function removeView(id) {
      if (document.getElementById(id)) {
        // document.getElementsByClassName("video-box")[0].style.gridArea =
        //   "1/1/3/4";
        document.getElementById(id).remove();
        if (document.getElementById('div-video-local').childNodes.length == 0) {
          var mainVideo = document.getElementById("main-video");
          mainVideo.style.height = '25%';
          // mainVideo.style.paddingBottom='0';
          var right = mainVideo;
          document.querySelector('#div-video-local').appendChild(right);
        }
      }
      // if ($("#" + id)[0]) {
      //   $("#" + id).remove();
      //   //将video-grid中第一个div设为main-video
      //   $(".video-box").first().css("grid-area", "1/1/3/4");
      // }
    },
    isPC: function isPC() {
      var userAgentInfo = navigator.userAgent;
      var Agents = new Array("Android", "iPhone", "SymbianOS", "Windows Phone", "iPad", "iPod");
      var flag = true;
      for (var v = 0; v < Agents.length; v++) {
        if (userAgentInfo.indexOf(Agents[v]) > 0) {
          flag = false;
          break;
        }
      }
      return flag;
    },
    getCameraId: function getCameraId() {
      var _this3 = this;
      //   return cameraId;
      TRTC.getCameras().then(function (devices) {
        // devices.forEach(device => {
        //   if (!cameraId) {
        //    return cameraId = device.deviceId;
        //   }
        //   // let div = $('<div></div>');
        //   // div.attr('id', device.deviceId);
        //   // div.html(device.label);
        //   // div.appendTo('#camera-option');
        // });
        if (devices.length > 0) {
          _this3.isCamOn = true;
          cameraId = devices[0].deviceId;
          return cameraId;
        } else {
          _this3.isCamOn = false;
          console.error("您的电脑没有摄像头或不允许该浏览器使用");
          _message2.default.warning("您的电脑没有摄像头或不允许该浏览器使用");
        }
      });
    },
    getMicrophoneId: function getMicrophoneId() {
      var _this4 = this;
      //   return micId;
      TRTC.getMicrophones().then(function (devices) {
        console.log(devices);
        // devices.forEach(device => {
        //   if (!Common.micId) {
        //     Common.micId = device.deviceId;
        //   }
        //   // let div = $('<div></div>');
        //   // div.attr('id', device.deviceId);
        //   // div.html(device.label);
        //   // div.appendTo('#mic-option');
        // });
        if (devices.length > 0) {
          _this4.isMicOn = true;
          micId = devices[0].deviceId;
          return micId;
        } else {
          _this4.isMicOn = false;
          console.error("您的电脑没有麦克风或不允许该浏览器使用");
          _message2.default.error("您的电脑没有麦克风或不允许该浏览器使用");
        }
      });
    },
    throttle: function throttle(func, delay) {
      var timer = null;
      var startTime = Date.now();
      return function () {
        var curTime = Date.now();
        var remaining = delay - (curTime - startTime);
        var context = this;
        var args = arguments;
        clearTimeout(timer);
        if (remaining <= 0) {
          func.apply(context, args);
          startTime = Date.now();
        } else {
          timer = setTimeout(function () {
            console.log("duplicate click");
          }, remaining);
        }
      };
    },
    isHidden: function isHidden() {
      var hidden, visibilityChange;
      if (typeof document.hidden !== "undefined") {
        hidden = "hidden";
        visibilityChange = "visibilitychange";
      } else if (typeof document.msHidden !== "undefined") {
        hidden = "msHidden";
        visibilityChange = "msvisibilitychange";
      } else if (typeof document.webkitHidden !== "undefined") {
        hidden = "webkitHidden";
        visibilityChange = "webkitvisibilitychange";
      }
      return document[hidden];
    },
    isCamOn: isCamOn,
    isMicOn: isMicOn,
    isScreenOn: isScreenOn,
    isJoined: isJoined,
    rtc: rtc,
    share: share,
    shareUserId: shareUserId,
    cameraId: cameraId,
    micId: micId
  };
  function getBroswer() {
    var sys = {};
    var ua = navigator.userAgent.toLowerCase();
    var s;
    (s = ua.match(/edge\/([\d.]+)/)) ? sys.edge = s[1] : (s = ua.match(/rv:([\d.]+)\) like gecko/)) ? sys.ie = s[1] : (s = ua.match(/msie ([\d.]+)/)) ? sys.ie = s[1] : (s = ua.match(/firefox\/([\d.]+)/)) ? sys.firefox = s[1] : (s = ua.match(/chrome\/([\d.]+)/)) ? sys.chrome = s[1] : (s = ua.match(/opera.([\d.]+)/)) ? sys.opera = s[1] : (s = ua.match(/version\/([\d.]+).*safari/)) ? sys.safari = s[1] : 0;
    if (sys.edge) return {
      broswer: "Edge",
      version: sys.edge
    };
    if (sys.ie) return {
      broswer: "IE",
      version: sys.ie
    };
    if (sys.firefox) return {
      broswer: "Firefox",
      version: sys.firefox
    };
    if (sys.chrome) return {
      broswer: "Chrome",
      version: sys.chrome
    };
    if (sys.opera) return {
      broswer: "Opera",
      version: sys.opera
    };
    if (sys.safari) return {
      broswer: "Safari",
      version: sys.safari
    };
    return {
      broswer: "",
      version: "0"
    };
  }
  function throttle(func, delay) {
    var timer = null;
    var startTime = Date.now();
    return function () {
      var curTime = Date.now();
      var remaining = delay - (curTime - startTime);
      var context = this;
      var args = arguments;
      clearTimeout(timer);
      if (remaining <= 0) {
        func.apply(context, args);
        startTime = Date.now();
      } else {
        timer = setTimeout(function () {
          console.log("duplicate click");
        }, remaining);
      }
    };
  }
  //交换位置
  function exchangeView(a, b) {
    var ep1 = a.parentNode,
      ep2 = b.parentNode,
      index1 = Array.prototype.indexOf.call(ep1.children, a),
      index2 = Array.prototype.indexOf.call(ep2.children, b);
    ep2.insertBefore(a, ep2.children[index2]);
    ep1.insertBefore(b, ep1.children[index1]);
  }
  return common;
}

/***/ }),

/***/ "qEAy":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAAXNSR0IArs4c6QAAAXxJREFUaEPtWT1Ow1AM/txEZWFiA3EHrsBeLgA7gjIjGGiqKk0HEHMrxA4XAGauwB0Q3VhgoUowSkuqgET1fhKSVzmz7efP/pw8fyE4/pDj+WMKoHd+vRlP4gsA22Be1wJFNAbw6Df9k97p/rOWbwHGlCaffMRPDF6ziUegV2/F3/pvENTpj27AvGuT/NyX6DYK2nv5WEE4GgA4ZnCzkDO+gxBoAuAyBfAypw01WlFw+KBzUHdw1fpMkrupD9E4CtobPwEM3xhY1YmpakvAO3XCIWcOUffIaKgXxSi/AyUDUK2mqV3pHTBNTNVPAKSVKmKOVCv+2046IB0w5U72QSuCv0XEMMUhM7D0M1D+VSJ3mWt43k54dnCvw8fqL3OuX6edX2icXyl1+F5HW6MFpk5ABEDV3RBdKOuA6EKaXBRdKF8w0YU06ZM3l4Vm6RcaC3YouQqFhEJKRPnbSCgkFKo7hUQXWtCh2U8+0YVmJapsoRFdyPItYuvuvKzyBZX/tzipRvsMAAAAAElFTkSuQmCC"

/***/ }),

/***/ "rm0p":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAAEEfUpiAAAAAXNSR0IArs4c6QAAAttJREFUWAnFl79rFEEUx+8SyaGRNFFMbMTGgKAg9oIgnFVae/8B27Sef4CV8T/Q3jpwZWxiIwixUYgEwer0YmFzfj+zM7tzs/P2bi8ePng77+f3zc7OvtntdDxNJpNfiBe4SJloeOBGPN6AY7UbRSAWJM8rcR+tG8K9r7MShK4oG+EClHaX1JSCkwIx3Y8V5taPDansCgOFw0FGlzAxZ5J/TXwsHkYxhShjjk7wcuNjjetOESaRyJ62pwzUTAKqlQopBEGlnmYERxhZ6xdBSccSSSiHICW0lSawWD3xOAlM1YGVmAaif84Zve3QAUnhCWSJADmmHn4SOGIRPjqkxS4bAJxauap2TSt5xGoGUuyzOD7/lsQRzfLr0q1qJ8n9zVLrjxE0ZW2JR0b2flmxSVAyb9lQTFfgHeG1XGvKcT4FDcRNxCbrZYHkaLMGd6ZAlJzb68zkGxeDipnIyaLl6ApVcg5voxO4ljDSuIGS0Lo2z2+CE3us9tiJueQ4qEl+CcB56NFMgPAOhFHVvkQVt5sA3kaBTtRyXJRwM7If1dpk5JxHfMxj2melF6GywiLJyhnEANZmsrDduVICIChyXpCimU5lR4qArDWhR+SbSJRfE/3MALWajFw1Ipac9gWZAYli6w2XqzWBNXsyBInb9KW2MwE7PxE5ZnXTuNhzv1KrMr6JHXPK1Rb2QNbGsfAukQcpoOnktvKxFweUBA6gtvQvJkDNPs1sz93K/7ns0Qz5VL/csr47bchRPrn3jHy671PxE8M/BoBzvy3dMACzZoF/MAoc849yIL6VzbSNXwVoe+f3HPAI+OL5IT7P2Tx/ySryp8SrKzpq/0jYEZ9VvqVL1NqhNm9BR8J3DZvi9+hLJmps+pr1Unok/Dwuox2DOf1JWS9fWRTcE9OeZ/01KcQkcsEoPkMr+FIqfwlLiyEIhM36ULwrvi2+7lmD+8051fhJ/E489HtLYjP9Bc0SAk/RIOKMAAAAAElFTkSuQmCC"

/***/ }),

/***/ "rpBe":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__style_index_less__ = __webpack_require__("vtiu");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__style_index_less___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0__style_index_less__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__index_less__ = __webpack_require__("uznb");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__index_less___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1__index_less__);



/***/ }),

/***/ "tiui":
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./float-check.png": "Pe7w",
	"./magnify-check.png": "9rO7",
	"./minimize-check.png": "TGlF"
};
function webpackContext(req) {
	return __webpack_require__(webpackContextResolve(req));
};
function webpackContextResolve(req) {
	var id = map[req];
	if(!(id + 1)) // check for number or string
		throw new Error("Cannot find module '" + req + "'.");
	return id;
};
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "tiui";

/***/ }),

/***/ "uznb":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ "vD6o":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "vzCy":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



var R = typeof Reflect === 'object' ? Reflect : null
var ReflectApply = R && typeof R.apply === 'function'
  ? R.apply
  : function ReflectApply(target, receiver, args) {
    return Function.prototype.apply.call(target, receiver, args);
  }

var ReflectOwnKeys
if (R && typeof R.ownKeys === 'function') {
  ReflectOwnKeys = R.ownKeys
} else if (Object.getOwnPropertySymbols) {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target)
      .concat(Object.getOwnPropertySymbols(target));
  };
} else {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target);
  };
}

function ProcessEmitWarning(warning) {
  if (console && console.warn) console.warn(warning);
}

var NumberIsNaN = Number.isNaN || function NumberIsNaN(value) {
  return value !== value;
}

function EventEmitter() {
  EventEmitter.init.call(this);
}
module.exports = EventEmitter;
module.exports.once = once;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;

EventEmitter.prototype._events = undefined;
EventEmitter.prototype._eventsCount = 0;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
var defaultMaxListeners = 10;

function checkListener(listener) {
  if (typeof listener !== 'function') {
    throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
  }
}

Object.defineProperty(EventEmitter, 'defaultMaxListeners', {
  enumerable: true,
  get: function() {
    return defaultMaxListeners;
  },
  set: function(arg) {
    if (typeof arg !== 'number' || arg < 0 || NumberIsNaN(arg)) {
      throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + arg + '.');
    }
    defaultMaxListeners = arg;
  }
});

EventEmitter.init = function() {

  if (this._events === undefined ||
      this._events === Object.getPrototypeOf(this)._events) {
    this._events = Object.create(null);
    this._eventsCount = 0;
  }

  this._maxListeners = this._maxListeners || undefined;
};

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
  if (typeof n !== 'number' || n < 0 || NumberIsNaN(n)) {
    throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n + '.');
  }
  this._maxListeners = n;
  return this;
};

function _getMaxListeners(that) {
  if (that._maxListeners === undefined)
    return EventEmitter.defaultMaxListeners;
  return that._maxListeners;
}

EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
  return _getMaxListeners(this);
};

EventEmitter.prototype.emit = function emit(type) {
  var args = [];
  for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);
  var doError = (type === 'error');

  var events = this._events;
  if (events !== undefined)
    doError = (doError && events.error === undefined);
  else if (!doError)
    return false;

  // If there is no 'error' event listener then throw.
  if (doError) {
    var er;
    if (args.length > 0)
      er = args[0];
    if (er instanceof Error) {
      // Note: The comments on the `throw` lines are intentional, they show
      // up in Node's output if this results in an unhandled exception.
      throw er; // Unhandled 'error' event
    }
    // At least give some kind of context to the user
    var err = new Error('Unhandled error.' + (er ? ' (' + er.message + ')' : ''));
    err.context = er;
    throw err; // Unhandled 'error' event
  }

  var handler = events[type];

  if (handler === undefined)
    return false;

  if (typeof handler === 'function') {
    ReflectApply(handler, this, args);
  } else {
    var len = handler.length;
    var listeners = arrayClone(handler, len);
    for (var i = 0; i < len; ++i)
      ReflectApply(listeners[i], this, args);
  }

  return true;
};

function _addListener(target, type, listener, prepend) {
  var m;
  var events;
  var existing;

  checkListener(listener);

  events = target._events;
  if (events === undefined) {
    events = target._events = Object.create(null);
    target._eventsCount = 0;
  } else {
    // To avoid recursion in the case that type === "newListener"! Before
    // adding it to the listeners, first emit "newListener".
    if (events.newListener !== undefined) {
      target.emit('newListener', type,
                  listener.listener ? listener.listener : listener);

      // Re-assign `events` because a newListener handler could have caused the
      // this._events to be assigned to a new object
      events = target._events;
    }
    existing = events[type];
  }

  if (existing === undefined) {
    // Optimize the case of one listener. Don't need the extra array object.
    existing = events[type] = listener;
    ++target._eventsCount;
  } else {
    if (typeof existing === 'function') {
      // Adding the second element, need to change to array.
      existing = events[type] =
        prepend ? [listener, existing] : [existing, listener];
      // If we've already got an array, just append.
    } else if (prepend) {
      existing.unshift(listener);
    } else {
      existing.push(listener);
    }

    // Check for listener leak
    m = _getMaxListeners(target);
    if (m > 0 && existing.length > m && !existing.warned) {
      existing.warned = true;
      // No error code for this since it is a Warning
      // eslint-disable-next-line no-restricted-syntax
      var w = new Error('Possible EventEmitter memory leak detected. ' +
                          existing.length + ' ' + String(type) + ' listeners ' +
                          'added. Use emitter.setMaxListeners() to ' +
                          'increase limit');
      w.name = 'MaxListenersExceededWarning';
      w.emitter = target;
      w.type = type;
      w.count = existing.length;
      ProcessEmitWarning(w);
    }
  }

  return target;
}

EventEmitter.prototype.addListener = function addListener(type, listener) {
  return _addListener(this, type, listener, false);
};

EventEmitter.prototype.on = EventEmitter.prototype.addListener;

EventEmitter.prototype.prependListener =
    function prependListener(type, listener) {
      return _addListener(this, type, listener, true);
    };

function onceWrapper() {
  if (!this.fired) {
    this.target.removeListener(this.type, this.wrapFn);
    this.fired = true;
    if (arguments.length === 0)
      return this.listener.call(this.target);
    return this.listener.apply(this.target, arguments);
  }
}

function _onceWrap(target, type, listener) {
  var state = { fired: false, wrapFn: undefined, target: target, type: type, listener: listener };
  var wrapped = onceWrapper.bind(state);
  wrapped.listener = listener;
  state.wrapFn = wrapped;
  return wrapped;
}

EventEmitter.prototype.once = function once(type, listener) {
  checkListener(listener);
  this.on(type, _onceWrap(this, type, listener));
  return this;
};

EventEmitter.prototype.prependOnceListener =
    function prependOnceListener(type, listener) {
      checkListener(listener);
      this.prependListener(type, _onceWrap(this, type, listener));
      return this;
    };

// Emits a 'removeListener' event if and only if the listener was removed.
EventEmitter.prototype.removeListener =
    function removeListener(type, listener) {
      var list, events, position, i, originalListener;

      checkListener(listener);

      events = this._events;
      if (events === undefined)
        return this;

      list = events[type];
      if (list === undefined)
        return this;

      if (list === listener || list.listener === listener) {
        if (--this._eventsCount === 0)
          this._events = Object.create(null);
        else {
          delete events[type];
          if (events.removeListener)
            this.emit('removeListener', type, list.listener || listener);
        }
      } else if (typeof list !== 'function') {
        position = -1;

        for (i = list.length - 1; i >= 0; i--) {
          if (list[i] === listener || list[i].listener === listener) {
            originalListener = list[i].listener;
            position = i;
            break;
          }
        }

        if (position < 0)
          return this;

        if (position === 0)
          list.shift();
        else {
          spliceOne(list, position);
        }

        if (list.length === 1)
          events[type] = list[0];

        if (events.removeListener !== undefined)
          this.emit('removeListener', type, originalListener || listener);
      }

      return this;
    };

EventEmitter.prototype.off = EventEmitter.prototype.removeListener;

EventEmitter.prototype.removeAllListeners =
    function removeAllListeners(type) {
      var listeners, events, i;

      events = this._events;
      if (events === undefined)
        return this;

      // not listening for removeListener, no need to emit
      if (events.removeListener === undefined) {
        if (arguments.length === 0) {
          this._events = Object.create(null);
          this._eventsCount = 0;
        } else if (events[type] !== undefined) {
          if (--this._eventsCount === 0)
            this._events = Object.create(null);
          else
            delete events[type];
        }
        return this;
      }

      // emit removeListener for all listeners on all events
      if (arguments.length === 0) {
        var keys = Object.keys(events);
        var key;
        for (i = 0; i < keys.length; ++i) {
          key = keys[i];
          if (key === 'removeListener') continue;
          this.removeAllListeners(key);
        }
        this.removeAllListeners('removeListener');
        this._events = Object.create(null);
        this._eventsCount = 0;
        return this;
      }

      listeners = events[type];

      if (typeof listeners === 'function') {
        this.removeListener(type, listeners);
      } else if (listeners !== undefined) {
        // LIFO order
        for (i = listeners.length - 1; i >= 0; i--) {
          this.removeListener(type, listeners[i]);
        }
      }

      return this;
    };

function _listeners(target, type, unwrap) {
  var events = target._events;

  if (events === undefined)
    return [];

  var evlistener = events[type];
  if (evlistener === undefined)
    return [];

  if (typeof evlistener === 'function')
    return unwrap ? [evlistener.listener || evlistener] : [evlistener];

  return unwrap ?
    unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
}

EventEmitter.prototype.listeners = function listeners(type) {
  return _listeners(this, type, true);
};

EventEmitter.prototype.rawListeners = function rawListeners(type) {
  return _listeners(this, type, false);
};

EventEmitter.listenerCount = function(emitter, type) {
  if (typeof emitter.listenerCount === 'function') {
    return emitter.listenerCount(type);
  } else {
    return listenerCount.call(emitter, type);
  }
};

EventEmitter.prototype.listenerCount = listenerCount;
function listenerCount(type) {
  var events = this._events;

  if (events !== undefined) {
    var evlistener = events[type];

    if (typeof evlistener === 'function') {
      return 1;
    } else if (evlistener !== undefined) {
      return evlistener.length;
    }
  }

  return 0;
}

EventEmitter.prototype.eventNames = function eventNames() {
  return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];
};

function arrayClone(arr, n) {
  var copy = new Array(n);
  for (var i = 0; i < n; ++i)
    copy[i] = arr[i];
  return copy;
}

function spliceOne(list, index) {
  for (; index + 1 < list.length; index++)
    list[index] = list[index + 1];
  list.pop();
}

function unwrapListeners(arr) {
  var ret = new Array(arr.length);
  for (var i = 0; i < ret.length; ++i) {
    ret[i] = arr[i].listener || arr[i];
  }
  return ret;
}

function once(emitter, name) {
  return new Promise(function (resolve, reject) {
    function errorListener(err) {
      emitter.removeListener(name, resolver);
      reject(err);
    }

    function resolver() {
      if (typeof emitter.removeListener === 'function') {
        emitter.removeListener('error', errorListener);
      }
      resolve([].slice.call(arguments));
    };

    eventTargetAgnosticAddListener(emitter, name, resolver, { once: true });
    if (name !== 'error') {
      addErrorHandlerIfEventEmitter(emitter, errorListener, { once: true });
    }
  });
}

function addErrorHandlerIfEventEmitter(emitter, handler, flags) {
  if (typeof emitter.on === 'function') {
    eventTargetAgnosticAddListener(emitter, 'error', handler, flags);
  }
}

function eventTargetAgnosticAddListener(emitter, name, listener, flags) {
  if (typeof emitter.on === 'function') {
    if (flags.once) {
      emitter.once(name, listener);
    } else {
      emitter.on(name, listener);
    }
  } else if (typeof emitter.addEventListener === 'function') {
    // EventTarget does not have `error` event semantics like Node
    // EventEmitters, we do not listen for `error` events here.
    emitter.addEventListener(name, function wrapListener(arg) {
      // IE does not have builtin `{ once: true }` support so we
      // have to do it manually.
      if (flags.once) {
        emitter.removeEventListener(name, wrapListener);
      }
      listener(arg);
    });
  } else {
    throw new TypeError('The "emitter" argument must be of type EventEmitter. Received type ' + typeof emitter);
  }
}


/***/ }),

/***/ "wEcu":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAAXNSR0IArs4c6QAAA89JREFUaEPtmltIFGEUx8/5djVLUzIj6iki8qmop3roIdCCoMtDKQhFEEg7GwVdDNKd6XNmLFDwIWJ3th7sISLUh8Qg6EKB0OUhinoJqZ586X5RE2vnOzG7zjqu620dnRHcp2Hnu/x/55z9zvm+bxEW+AcXuH7ICsCv3CwW/QPbhBBbGGChl5ACaJAx9potL3rBTx3+nallHEBEMw4BiCgQrPJS+Li5Eb4AsLAuhzqd78YAJMWT6PCV8HEmZ1VOiDSAFTaJX7/f25ZHgF5E1gVAf7wFwmVE4gABbEzqQPgSLCneYIdTGkBpMnYJU9xPtYHewOrAVn78uMfiU6bj8fgy85P5yoZgAbZbbQg9GNGaahTRonVA0Gw9M2Qtqhw6763lx86uaEazIFE34oXzuhxuGQOgaDEuiC6mALBRlSWeK4CsxpoA6BQAXtEUqSHXcZz9JtI3GkJTAChNRoUQULK5vLSrurranEyUrMaGCSgfAf9qirTEcwCuR7cnBDxLugyhY1N5Wc1kEBE1SrZoXQm7kixn5QH5UnwbJczntihEvBWIhI5wRJHNur4DsEQqWqxVEJ1OQzC8oTaEjiFi2tr2O18CpFYq4yqQOJGGALimylIoE8K3AESEsm7Egah2FAKvaop00hlKvgWwRI5AtAHRUYcnWjUlfNb3IWQL5EQsoRs3gajG/o4hXFblcH0y1Py2CmVbafjjx0Gz591tAjo4CpFKgAsCwBIdj8fz+j6LTiLan4ZEVg8kLvkqD0yWSXl7e7757tsdAtqTrZ0vEtlUpQBvaytI9A11A0FlZlvPAVKFGZyzapupQHzpAVmN9hNAUS7iAZF0WWI59c3olHMtNAsPEAI+1RRph6cAbkzuxhg5e8CNyd0YYxHADSvOZgxZNxQSotEaAxm7qEVCavLZHtTNPfFshE7Ul2uxnQmAh9b7IEAll6UnngO0trYv/T74rQIANzGgCffOAnAYgN4uyQ9+MMW/YX4h/NEG9cwDvOn6ZtP815E+sJqG25LnVYG8Kt5Q+8ZTAMvyPwa+vp6JeIfg3hVFZVvOnKke8iyEIlpsLxB1T8Po2Zsg7tNl6a6HAMYFZ8k9YxBk9bocuuwZgHPFm7H4jJNDT37EiwCOs9tFD+QSw4shlC2E5vOCY248MI9XTBFtDvKAdcln/uz/QEBlIwnC9Us+QkqAgHuEuMb1TGyJnpdrVoTBYEHRenNooMfVWsheTeb8otsCKCleC/1D61ytRp3L4Vz91cAOIU0Jv7Tmm+l+oLRw5SO7Ch1XTueynvuhjysXcF6C/AdXXnde+gQhVQAAAABJRU5ErkJggg=="

/***/ }),

/***/ "x85o":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = findDOMNode;

var _reactDom = _interopRequireDefault(__webpack_require__("O27J"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Return if a node is a DOM node. Else will return by `findDOMNode`
 */
function findDOMNode(node) {
  if (node instanceof HTMLElement) {
    return node;
  }

  return _reactDom.default.findDOMNode(node);
}

/***/ }),

/***/ "z+gd":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* WEBPACK VAR INJECTION */(function(global) {/**
 * A collection of shims that provide minimal functionality of the ES6 collections.
 *
 * These implementations are not meant to be used outside of the ResizeObserver
 * modules as they cover only a limited range of use cases.
 */
/* eslint-disable require-jsdoc, valid-jsdoc */
var MapShim = (function () {
    if (typeof Map !== 'undefined') {
        return Map;
    }
    /**
     * Returns index in provided array that matches the specified key.
     *
     * @param {Array<Array>} arr
     * @param {*} key
     * @returns {number}
     */
    function getIndex(arr, key) {
        var result = -1;
        arr.some(function (entry, index) {
            if (entry[0] === key) {
                result = index;
                return true;
            }
            return false;
        });
        return result;
    }
    return /** @class */ (function () {
        function class_1() {
            this.__entries__ = [];
        }
        Object.defineProperty(class_1.prototype, "size", {
            /**
             * @returns {boolean}
             */
            get: function () {
                return this.__entries__.length;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {*} key
         * @returns {*}
         */
        class_1.prototype.get = function (key) {
            var index = getIndex(this.__entries__, key);
            var entry = this.__entries__[index];
            return entry && entry[1];
        };
        /**
         * @param {*} key
         * @param {*} value
         * @returns {void}
         */
        class_1.prototype.set = function (key, value) {
            var index = getIndex(this.__entries__, key);
            if (~index) {
                this.__entries__[index][1] = value;
            }
            else {
                this.__entries__.push([key, value]);
            }
        };
        /**
         * @param {*} key
         * @returns {void}
         */
        class_1.prototype.delete = function (key) {
            var entries = this.__entries__;
            var index = getIndex(entries, key);
            if (~index) {
                entries.splice(index, 1);
            }
        };
        /**
         * @param {*} key
         * @returns {void}
         */
        class_1.prototype.has = function (key) {
            return !!~getIndex(this.__entries__, key);
        };
        /**
         * @returns {void}
         */
        class_1.prototype.clear = function () {
            this.__entries__.splice(0);
        };
        /**
         * @param {Function} callback
         * @param {*} [ctx=null]
         * @returns {void}
         */
        class_1.prototype.forEach = function (callback, ctx) {
            if (ctx === void 0) { ctx = null; }
            for (var _i = 0, _a = this.__entries__; _i < _a.length; _i++) {
                var entry = _a[_i];
                callback.call(ctx, entry[1], entry[0]);
            }
        };
        return class_1;
    }());
})();

/**
 * Detects whether window and document objects are available in current environment.
 */
var isBrowser = typeof window !== 'undefined' && typeof document !== 'undefined' && window.document === document;

// Returns global object of a current environment.
var global$1 = (function () {
    if (typeof global !== 'undefined' && global.Math === Math) {
        return global;
    }
    if (typeof self !== 'undefined' && self.Math === Math) {
        return self;
    }
    if (typeof window !== 'undefined' && window.Math === Math) {
        return window;
    }
    // eslint-disable-next-line no-new-func
    return Function('return this')();
})();

/**
 * A shim for the requestAnimationFrame which falls back to the setTimeout if
 * first one is not supported.
 *
 * @returns {number} Requests' identifier.
 */
var requestAnimationFrame$1 = (function () {
    if (typeof requestAnimationFrame === 'function') {
        // It's required to use a bounded function because IE sometimes throws
        // an "Invalid calling object" error if rAF is invoked without the global
        // object on the left hand side.
        return requestAnimationFrame.bind(global$1);
    }
    return function (callback) { return setTimeout(function () { return callback(Date.now()); }, 1000 / 60); };
})();

// Defines minimum timeout before adding a trailing call.
var trailingTimeout = 2;
/**
 * Creates a wrapper function which ensures that provided callback will be
 * invoked only once during the specified delay period.
 *
 * @param {Function} callback - Function to be invoked after the delay period.
 * @param {number} delay - Delay after which to invoke callback.
 * @returns {Function}
 */
function throttle (callback, delay) {
    var leadingCall = false, trailingCall = false, lastCallTime = 0;
    /**
     * Invokes the original callback function and schedules new invocation if
     * the "proxy" was called during current request.
     *
     * @returns {void}
     */
    function resolvePending() {
        if (leadingCall) {
            leadingCall = false;
            callback();
        }
        if (trailingCall) {
            proxy();
        }
    }
    /**
     * Callback invoked after the specified delay. It will further postpone
     * invocation of the original function delegating it to the
     * requestAnimationFrame.
     *
     * @returns {void}
     */
    function timeoutCallback() {
        requestAnimationFrame$1(resolvePending);
    }
    /**
     * Schedules invocation of the original function.
     *
     * @returns {void}
     */
    function proxy() {
        var timeStamp = Date.now();
        if (leadingCall) {
            // Reject immediately following calls.
            if (timeStamp - lastCallTime < trailingTimeout) {
                return;
            }
            // Schedule new call to be in invoked when the pending one is resolved.
            // This is important for "transitions" which never actually start
            // immediately so there is a chance that we might miss one if change
            // happens amids the pending invocation.
            trailingCall = true;
        }
        else {
            leadingCall = true;
            trailingCall = false;
            setTimeout(timeoutCallback, delay);
        }
        lastCallTime = timeStamp;
    }
    return proxy;
}

// Minimum delay before invoking the update of observers.
var REFRESH_DELAY = 20;
// A list of substrings of CSS properties used to find transition events that
// might affect dimensions of observed elements.
var transitionKeys = ['top', 'right', 'bottom', 'left', 'width', 'height', 'size', 'weight'];
// Check if MutationObserver is available.
var mutationObserverSupported = typeof MutationObserver !== 'undefined';
/**
 * Singleton controller class which handles updates of ResizeObserver instances.
 */
var ResizeObserverController = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserverController.
     *
     * @private
     */
    function ResizeObserverController() {
        /**
         * Indicates whether DOM listeners have been added.
         *
         * @private {boolean}
         */
        this.connected_ = false;
        /**
         * Tells that controller has subscribed for Mutation Events.
         *
         * @private {boolean}
         */
        this.mutationEventsAdded_ = false;
        /**
         * Keeps reference to the instance of MutationObserver.
         *
         * @private {MutationObserver}
         */
        this.mutationsObserver_ = null;
        /**
         * A list of connected observers.
         *
         * @private {Array<ResizeObserverSPI>}
         */
        this.observers_ = [];
        this.onTransitionEnd_ = this.onTransitionEnd_.bind(this);
        this.refresh = throttle(this.refresh.bind(this), REFRESH_DELAY);
    }
    /**
     * Adds observer to observers list.
     *
     * @param {ResizeObserverSPI} observer - Observer to be added.
     * @returns {void}
     */
    ResizeObserverController.prototype.addObserver = function (observer) {
        if (!~this.observers_.indexOf(observer)) {
            this.observers_.push(observer);
        }
        // Add listeners if they haven't been added yet.
        if (!this.connected_) {
            this.connect_();
        }
    };
    /**
     * Removes observer from observers list.
     *
     * @param {ResizeObserverSPI} observer - Observer to be removed.
     * @returns {void}
     */
    ResizeObserverController.prototype.removeObserver = function (observer) {
        var observers = this.observers_;
        var index = observers.indexOf(observer);
        // Remove observer if it's present in registry.
        if (~index) {
            observers.splice(index, 1);
        }
        // Remove listeners if controller has no connected observers.
        if (!observers.length && this.connected_) {
            this.disconnect_();
        }
    };
    /**
     * Invokes the update of observers. It will continue running updates insofar
     * it detects changes.
     *
     * @returns {void}
     */
    ResizeObserverController.prototype.refresh = function () {
        var changesDetected = this.updateObservers_();
        // Continue running updates if changes have been detected as there might
        // be future ones caused by CSS transitions.
        if (changesDetected) {
            this.refresh();
        }
    };
    /**
     * Updates every observer from observers list and notifies them of queued
     * entries.
     *
     * @private
     * @returns {boolean} Returns "true" if any observer has detected changes in
     *      dimensions of it's elements.
     */
    ResizeObserverController.prototype.updateObservers_ = function () {
        // Collect observers that have active observations.
        var activeObservers = this.observers_.filter(function (observer) {
            return observer.gatherActive(), observer.hasActive();
        });
        // Deliver notifications in a separate cycle in order to avoid any
        // collisions between observers, e.g. when multiple instances of
        // ResizeObserver are tracking the same element and the callback of one
        // of them changes content dimensions of the observed target. Sometimes
        // this may result in notifications being blocked for the rest of observers.
        activeObservers.forEach(function (observer) { return observer.broadcastActive(); });
        return activeObservers.length > 0;
    };
    /**
     * Initializes DOM listeners.
     *
     * @private
     * @returns {void}
     */
    ResizeObserverController.prototype.connect_ = function () {
        // Do nothing if running in a non-browser environment or if listeners
        // have been already added.
        if (!isBrowser || this.connected_) {
            return;
        }
        // Subscription to the "Transitionend" event is used as a workaround for
        // delayed transitions. This way it's possible to capture at least the
        // final state of an element.
        document.addEventListener('transitionend', this.onTransitionEnd_);
        window.addEventListener('resize', this.refresh);
        if (mutationObserverSupported) {
            this.mutationsObserver_ = new MutationObserver(this.refresh);
            this.mutationsObserver_.observe(document, {
                attributes: true,
                childList: true,
                characterData: true,
                subtree: true
            });
        }
        else {
            document.addEventListener('DOMSubtreeModified', this.refresh);
            this.mutationEventsAdded_ = true;
        }
        this.connected_ = true;
    };
    /**
     * Removes DOM listeners.
     *
     * @private
     * @returns {void}
     */
    ResizeObserverController.prototype.disconnect_ = function () {
        // Do nothing if running in a non-browser environment or if listeners
        // have been already removed.
        if (!isBrowser || !this.connected_) {
            return;
        }
        document.removeEventListener('transitionend', this.onTransitionEnd_);
        window.removeEventListener('resize', this.refresh);
        if (this.mutationsObserver_) {
            this.mutationsObserver_.disconnect();
        }
        if (this.mutationEventsAdded_) {
            document.removeEventListener('DOMSubtreeModified', this.refresh);
        }
        this.mutationsObserver_ = null;
        this.mutationEventsAdded_ = false;
        this.connected_ = false;
    };
    /**
     * "Transitionend" event handler.
     *
     * @private
     * @param {TransitionEvent} event
     * @returns {void}
     */
    ResizeObserverController.prototype.onTransitionEnd_ = function (_a) {
        var _b = _a.propertyName, propertyName = _b === void 0 ? '' : _b;
        // Detect whether transition may affect dimensions of an element.
        var isReflowProperty = transitionKeys.some(function (key) {
            return !!~propertyName.indexOf(key);
        });
        if (isReflowProperty) {
            this.refresh();
        }
    };
    /**
     * Returns instance of the ResizeObserverController.
     *
     * @returns {ResizeObserverController}
     */
    ResizeObserverController.getInstance = function () {
        if (!this.instance_) {
            this.instance_ = new ResizeObserverController();
        }
        return this.instance_;
    };
    /**
     * Holds reference to the controller's instance.
     *
     * @private {ResizeObserverController}
     */
    ResizeObserverController.instance_ = null;
    return ResizeObserverController;
}());

/**
 * Defines non-writable/enumerable properties of the provided target object.
 *
 * @param {Object} target - Object for which to define properties.
 * @param {Object} props - Properties to be defined.
 * @returns {Object} Target object.
 */
var defineConfigurable = (function (target, props) {
    for (var _i = 0, _a = Object.keys(props); _i < _a.length; _i++) {
        var key = _a[_i];
        Object.defineProperty(target, key, {
            value: props[key],
            enumerable: false,
            writable: false,
            configurable: true
        });
    }
    return target;
});

/**
 * Returns the global object associated with provided element.
 *
 * @param {Object} target
 * @returns {Object}
 */
var getWindowOf = (function (target) {
    // Assume that the element is an instance of Node, which means that it
    // has the "ownerDocument" property from which we can retrieve a
    // corresponding global object.
    var ownerGlobal = target && target.ownerDocument && target.ownerDocument.defaultView;
    // Return the local global object if it's not possible extract one from
    // provided element.
    return ownerGlobal || global$1;
});

// Placeholder of an empty content rectangle.
var emptyRect = createRectInit(0, 0, 0, 0);
/**
 * Converts provided string to a number.
 *
 * @param {number|string} value
 * @returns {number}
 */
function toFloat(value) {
    return parseFloat(value) || 0;
}
/**
 * Extracts borders size from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @param {...string} positions - Borders positions (top, right, ...)
 * @returns {number}
 */
function getBordersSize(styles) {
    var positions = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        positions[_i - 1] = arguments[_i];
    }
    return positions.reduce(function (size, position) {
        var value = styles['border-' + position + '-width'];
        return size + toFloat(value);
    }, 0);
}
/**
 * Extracts paddings sizes from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @returns {Object} Paddings box.
 */
function getPaddings(styles) {
    var positions = ['top', 'right', 'bottom', 'left'];
    var paddings = {};
    for (var _i = 0, positions_1 = positions; _i < positions_1.length; _i++) {
        var position = positions_1[_i];
        var value = styles['padding-' + position];
        paddings[position] = toFloat(value);
    }
    return paddings;
}
/**
 * Calculates content rectangle of provided SVG element.
 *
 * @param {SVGGraphicsElement} target - Element content rectangle of which needs
 *      to be calculated.
 * @returns {DOMRectInit}
 */
function getSVGContentRect(target) {
    var bbox = target.getBBox();
    return createRectInit(0, 0, bbox.width, bbox.height);
}
/**
 * Calculates content rectangle of provided HTMLElement.
 *
 * @param {HTMLElement} target - Element for which to calculate the content rectangle.
 * @returns {DOMRectInit}
 */
function getHTMLElementContentRect(target) {
    // Client width & height properties can't be
    // used exclusively as they provide rounded values.
    var clientWidth = target.clientWidth, clientHeight = target.clientHeight;
    // By this condition we can catch all non-replaced inline, hidden and
    // detached elements. Though elements with width & height properties less
    // than 0.5 will be discarded as well.
    //
    // Without it we would need to implement separate methods for each of
    // those cases and it's not possible to perform a precise and performance
    // effective test for hidden elements. E.g. even jQuery's ':visible' filter
    // gives wrong results for elements with width & height less than 0.5.
    if (!clientWidth && !clientHeight) {
        return emptyRect;
    }
    var styles = getWindowOf(target).getComputedStyle(target);
    var paddings = getPaddings(styles);
    var horizPad = paddings.left + paddings.right;
    var vertPad = paddings.top + paddings.bottom;
    // Computed styles of width & height are being used because they are the
    // only dimensions available to JS that contain non-rounded values. It could
    // be possible to utilize the getBoundingClientRect if only it's data wasn't
    // affected by CSS transformations let alone paddings, borders and scroll bars.
    var width = toFloat(styles.width), height = toFloat(styles.height);
    // Width & height include paddings and borders when the 'border-box' box
    // model is applied (except for IE).
    if (styles.boxSizing === 'border-box') {
        // Following conditions are required to handle Internet Explorer which
        // doesn't include paddings and borders to computed CSS dimensions.
        //
        // We can say that if CSS dimensions + paddings are equal to the "client"
        // properties then it's either IE, and thus we don't need to subtract
        // anything, or an element merely doesn't have paddings/borders styles.
        if (Math.round(width + horizPad) !== clientWidth) {
            width -= getBordersSize(styles, 'left', 'right') + horizPad;
        }
        if (Math.round(height + vertPad) !== clientHeight) {
            height -= getBordersSize(styles, 'top', 'bottom') + vertPad;
        }
    }
    // Following steps can't be applied to the document's root element as its
    // client[Width/Height] properties represent viewport area of the window.
    // Besides, it's as well not necessary as the <html> itself neither has
    // rendered scroll bars nor it can be clipped.
    if (!isDocumentElement(target)) {
        // In some browsers (only in Firefox, actually) CSS width & height
        // include scroll bars size which can be removed at this step as scroll
        // bars are the only difference between rounded dimensions + paddings
        // and "client" properties, though that is not always true in Chrome.
        var vertScrollbar = Math.round(width + horizPad) - clientWidth;
        var horizScrollbar = Math.round(height + vertPad) - clientHeight;
        // Chrome has a rather weird rounding of "client" properties.
        // E.g. for an element with content width of 314.2px it sometimes gives
        // the client width of 315px and for the width of 314.7px it may give
        // 314px. And it doesn't happen all the time. So just ignore this delta
        // as a non-relevant.
        if (Math.abs(vertScrollbar) !== 1) {
            width -= vertScrollbar;
        }
        if (Math.abs(horizScrollbar) !== 1) {
            height -= horizScrollbar;
        }
    }
    return createRectInit(paddings.left, paddings.top, width, height);
}
/**
 * Checks whether provided element is an instance of the SVGGraphicsElement.
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
var isSVGGraphicsElement = (function () {
    // Some browsers, namely IE and Edge, don't have the SVGGraphicsElement
    // interface.
    if (typeof SVGGraphicsElement !== 'undefined') {
        return function (target) { return target instanceof getWindowOf(target).SVGGraphicsElement; };
    }
    // If it's so, then check that element is at least an instance of the
    // SVGElement and that it has the "getBBox" method.
    // eslint-disable-next-line no-extra-parens
    return function (target) { return (target instanceof getWindowOf(target).SVGElement &&
        typeof target.getBBox === 'function'); };
})();
/**
 * Checks whether provided element is a document element (<html>).
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
function isDocumentElement(target) {
    return target === getWindowOf(target).document.documentElement;
}
/**
 * Calculates an appropriate content rectangle for provided html or svg element.
 *
 * @param {Element} target - Element content rectangle of which needs to be calculated.
 * @returns {DOMRectInit}
 */
function getContentRect(target) {
    if (!isBrowser) {
        return emptyRect;
    }
    if (isSVGGraphicsElement(target)) {
        return getSVGContentRect(target);
    }
    return getHTMLElementContentRect(target);
}
/**
 * Creates rectangle with an interface of the DOMRectReadOnly.
 * Spec: https://drafts.fxtf.org/geometry/#domrectreadonly
 *
 * @param {DOMRectInit} rectInit - Object with rectangle's x/y coordinates and dimensions.
 * @returns {DOMRectReadOnly}
 */
function createReadOnlyRect(_a) {
    var x = _a.x, y = _a.y, width = _a.width, height = _a.height;
    // If DOMRectReadOnly is available use it as a prototype for the rectangle.
    var Constr = typeof DOMRectReadOnly !== 'undefined' ? DOMRectReadOnly : Object;
    var rect = Object.create(Constr.prototype);
    // Rectangle's properties are not writable and non-enumerable.
    defineConfigurable(rect, {
        x: x, y: y, width: width, height: height,
        top: y,
        right: x + width,
        bottom: height + y,
        left: x
    });
    return rect;
}
/**
 * Creates DOMRectInit object based on the provided dimensions and the x/y coordinates.
 * Spec: https://drafts.fxtf.org/geometry/#dictdef-domrectinit
 *
 * @param {number} x - X coordinate.
 * @param {number} y - Y coordinate.
 * @param {number} width - Rectangle's width.
 * @param {number} height - Rectangle's height.
 * @returns {DOMRectInit}
 */
function createRectInit(x, y, width, height) {
    return { x: x, y: y, width: width, height: height };
}

/**
 * Class that is responsible for computations of the content rectangle of
 * provided DOM element and for keeping track of it's changes.
 */
var ResizeObservation = /** @class */ (function () {
    /**
     * Creates an instance of ResizeObservation.
     *
     * @param {Element} target - Element to be observed.
     */
    function ResizeObservation(target) {
        /**
         * Broadcasted width of content rectangle.
         *
         * @type {number}
         */
        this.broadcastWidth = 0;
        /**
         * Broadcasted height of content rectangle.
         *
         * @type {number}
         */
        this.broadcastHeight = 0;
        /**
         * Reference to the last observed content rectangle.
         *
         * @private {DOMRectInit}
         */
        this.contentRect_ = createRectInit(0, 0, 0, 0);
        this.target = target;
    }
    /**
     * Updates content rectangle and tells whether it's width or height properties
     * have changed since the last broadcast.
     *
     * @returns {boolean}
     */
    ResizeObservation.prototype.isActive = function () {
        var rect = getContentRect(this.target);
        this.contentRect_ = rect;
        return (rect.width !== this.broadcastWidth ||
            rect.height !== this.broadcastHeight);
    };
    /**
     * Updates 'broadcastWidth' and 'broadcastHeight' properties with a data
     * from the corresponding properties of the last observed content rectangle.
     *
     * @returns {DOMRectInit} Last observed content rectangle.
     */
    ResizeObservation.prototype.broadcastRect = function () {
        var rect = this.contentRect_;
        this.broadcastWidth = rect.width;
        this.broadcastHeight = rect.height;
        return rect;
    };
    return ResizeObservation;
}());

var ResizeObserverEntry = /** @class */ (function () {
    /**
     * Creates an instance of ResizeObserverEntry.
     *
     * @param {Element} target - Element that is being observed.
     * @param {DOMRectInit} rectInit - Data of the element's content rectangle.
     */
    function ResizeObserverEntry(target, rectInit) {
        var contentRect = createReadOnlyRect(rectInit);
        // According to the specification following properties are not writable
        // and are also not enumerable in the native implementation.
        //
        // Property accessors are not being used as they'd require to define a
        // private WeakMap storage which may cause memory leaks in browsers that
        // don't support this type of collections.
        defineConfigurable(this, { target: target, contentRect: contentRect });
    }
    return ResizeObserverEntry;
}());

var ResizeObserverSPI = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserver.
     *
     * @param {ResizeObserverCallback} callback - Callback function that is invoked
     *      when one of the observed elements changes it's content dimensions.
     * @param {ResizeObserverController} controller - Controller instance which
     *      is responsible for the updates of observer.
     * @param {ResizeObserver} callbackCtx - Reference to the public
     *      ResizeObserver instance which will be passed to callback function.
     */
    function ResizeObserverSPI(callback, controller, callbackCtx) {
        /**
         * Collection of resize observations that have detected changes in dimensions
         * of elements.
         *
         * @private {Array<ResizeObservation>}
         */
        this.activeObservations_ = [];
        /**
         * Registry of the ResizeObservation instances.
         *
         * @private {Map<Element, ResizeObservation>}
         */
        this.observations_ = new MapShim();
        if (typeof callback !== 'function') {
            throw new TypeError('The callback provided as parameter 1 is not a function.');
        }
        this.callback_ = callback;
        this.controller_ = controller;
        this.callbackCtx_ = callbackCtx;
    }
    /**
     * Starts observing provided element.
     *
     * @param {Element} target - Element to be observed.
     * @returns {void}
     */
    ResizeObserverSPI.prototype.observe = function (target) {
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        // Do nothing if current environment doesn't have the Element interface.
        if (typeof Element === 'undefined' || !(Element instanceof Object)) {
            return;
        }
        if (!(target instanceof getWindowOf(target).Element)) {
            throw new TypeError('parameter 1 is not of type "Element".');
        }
        var observations = this.observations_;
        // Do nothing if element is already being observed.
        if (observations.has(target)) {
            return;
        }
        observations.set(target, new ResizeObservation(target));
        this.controller_.addObserver(this);
        // Force the update of observations.
        this.controller_.refresh();
    };
    /**
     * Stops observing provided element.
     *
     * @param {Element} target - Element to stop observing.
     * @returns {void}
     */
    ResizeObserverSPI.prototype.unobserve = function (target) {
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        // Do nothing if current environment doesn't have the Element interface.
        if (typeof Element === 'undefined' || !(Element instanceof Object)) {
            return;
        }
        if (!(target instanceof getWindowOf(target).Element)) {
            throw new TypeError('parameter 1 is not of type "Element".');
        }
        var observations = this.observations_;
        // Do nothing if element is not being observed.
        if (!observations.has(target)) {
            return;
        }
        observations.delete(target);
        if (!observations.size) {
            this.controller_.removeObserver(this);
        }
    };
    /**
     * Stops observing all elements.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.disconnect = function () {
        this.clearActive();
        this.observations_.clear();
        this.controller_.removeObserver(this);
    };
    /**
     * Collects observation instances the associated element of which has changed
     * it's content rectangle.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.gatherActive = function () {
        var _this = this;
        this.clearActive();
        this.observations_.forEach(function (observation) {
            if (observation.isActive()) {
                _this.activeObservations_.push(observation);
            }
        });
    };
    /**
     * Invokes initial callback function with a list of ResizeObserverEntry
     * instances collected from active resize observations.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.broadcastActive = function () {
        // Do nothing if observer doesn't have active observations.
        if (!this.hasActive()) {
            return;
        }
        var ctx = this.callbackCtx_;
        // Create ResizeObserverEntry instance for every active observation.
        var entries = this.activeObservations_.map(function (observation) {
            return new ResizeObserverEntry(observation.target, observation.broadcastRect());
        });
        this.callback_.call(ctx, entries, ctx);
        this.clearActive();
    };
    /**
     * Clears the collection of active observations.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.clearActive = function () {
        this.activeObservations_.splice(0);
    };
    /**
     * Tells whether observer has active observations.
     *
     * @returns {boolean}
     */
    ResizeObserverSPI.prototype.hasActive = function () {
        return this.activeObservations_.length > 0;
    };
    return ResizeObserverSPI;
}());

// Registry of internal observers. If WeakMap is not available use current shim
// for the Map collection as it has all required methods and because WeakMap
// can't be fully polyfilled anyway.
var observers = typeof WeakMap !== 'undefined' ? new WeakMap() : new MapShim();
/**
 * ResizeObserver API. Encapsulates the ResizeObserver SPI implementation
 * exposing only those methods and properties that are defined in the spec.
 */
var ResizeObserver = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserver.
     *
     * @param {ResizeObserverCallback} callback - Callback that is invoked when
     *      dimensions of the observed elements change.
     */
    function ResizeObserver(callback) {
        if (!(this instanceof ResizeObserver)) {
            throw new TypeError('Cannot call a class as a function.');
        }
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        var controller = ResizeObserverController.getInstance();
        var observer = new ResizeObserverSPI(callback, controller, this);
        observers.set(this, observer);
    }
    return ResizeObserver;
}());
// Expose public methods of ResizeObserver.
[
    'observe',
    'unobserve',
    'disconnect'
].forEach(function (method) {
    ResizeObserver.prototype[method] = function () {
        var _a;
        return (_a = observers.get(this))[method].apply(_a, arguments);
    };
});

var index = (function () {
    // Export existing implementation if available.
    if (typeof global$1.ResizeObserver !== 'undefined') {
        return global$1.ResizeObserver;
    }
    return ResizeObserver;
})();

/* harmony default export */ __webpack_exports__["default"] = (index);

/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__("DuR2")))

/***/ }),

/***/ "zVWh":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAA0pJREFUWEfNmMvLVlUUh59fVjrINAeiQg6LcCDirDQv4EAKvCRGA/0PvERSkIpGKaiFl/4CbSCKt6BwIKTmZSbiICSHCiUOuumgzFry81tHdq/n/dzv933QWXAG73n3Xus5a6+19tpbDCgR8RLwFrAEmAnMyMeafsrnJnAG+FbSr4OYUO3giFgBrAPmA89WznsAXAC+lHSyZs5TgSLiDWA38HqNwmHGXAY+lHRpOD19gSJiHPAFsKFHwb+AlZ8CrhTL5GHN8s0FludHPNMzfz/wgaR/2sBagSJiMnA046SZ9ydwwJCS7tR4KyKm2jiwHphQzHF8rZb0W6+eJ4ASxh54rRh8HHhf0q0akN4xEfEysBd4p/jvuj3YC/UfoFym04VnAtgiaedIQFrAPgY+Axq79tTScvl6gfYVMWOY9yQdGQuYRkdEvAscLqD2S9rY/P8YKLPpYmF881h5po+ndhTv5zXZVwI5HZvUPi5pVa1nImK8x0r6a4A5x4qYuizJ5WVoLbPonUhlzqZXagM4ImYD53PuAknXaqAy0G8U2bfSxbMB+g5YlIp2S/qoRml+zBbg0xy/VZKDtkoiYpeLZQ4+K2mxcm9yXfF24KI3vbbOJNB2YFsq/USSf1dJ1qmfARdPbzNTDbQGOJQaLkryXlUtETFioPwg73Xz0uBaAxnGUJZNkrxdVMsYALmSf54GvzLQWWBhvlgk6Vw1zVBCjNZDtm0GyzkD/eisyhevSnLkPyERMQdY1tJ6eInfzAnfZ7tRzndsfC3pah+9tm0Gyw0D3QVeyBcTJd3rnRgRzwMO/EmDeK8Y+/ujgJXut+i2bTNY7hnoD2BivnhRUvPn47kR8RxwG5gyQqBfgGmS/m4Bsm0zWO4OsmSzgLdblmwx4Mfieuand8m+kfRD7ZJ1LqgPAmuT/v9I+03AnrR/qGuFcU33tg67KiJGs7luzi7Qqtxdln3OsEnZurkmkM9cI20/nH1NdV/YL5ta0t19dnv7kVCjadB8ZHKD1nq06ZPu/Ru0BHLH1p0WNqG60+QnkF3fnWNQQvnU2o2DYhN8nTpKF1DduWwo07Qz1zEthawbF1YtYL7Sc1/kKz1X27YrPd+S+CLBfdBAV3oPAX/xzUOBdT/GAAAAAElFTkSuQmCC"

/***/ })

});