/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.constants.GroupDataConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.system.SystemGroupData;
import com.zbkj.common.request.SystemFormItemCheckRequest;
import com.zbkj.common.response.PageLayoutBottomNavigationResponse;
import com.zbkj.common.response.PageLayoutIndexResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.service.ArticleService;
import com.zbkj.service.service.PageLayoutService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemGroupDataService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PageLayoutServiceImpl
implements PageLayoutService {
    @Autowired
    private SystemGroupDataService systemGroupDataService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private ArticleService articleService;

    @Override
    public PageLayoutIndexResponse index() {
        PageLayoutIndexResponse response = new PageLayoutIndexResponse();
        List<SystemGroupData> bannerList = this.systemGroupDataService.findListByGid(GroupDataConstants.GROUP_DATA_ID_INDEX_BANNER);
        response.setIndexBanner(this.convertData(bannerList));
        List<SystemGroupData> menuList = this.systemGroupDataService.findListByGid(GroupDataConstants.GROUP_DATA_ID_INDEX_MENU);
        response.setIndexMenu(this.convertData(menuList));
        response.setIndexNews(this.articleService.getIndexHeadline());
        List<SystemGroupData> userMenuList = this.systemGroupDataService.findListByGid(GroupDataConstants.GROUP_DATA_ID_USER_CENTER_MENU);
        response.setUserMenu(this.convertData(userMenuList));
        List<SystemGroupData> userBannerList = this.systemGroupDataService.findListByGid(GroupDataConstants.GROUP_DATA_ID_USER_CENTER_BANNER);
        response.setUserBanner(this.convertData(userBannerList));
        response.setUserDefaultAvatar(this.systemConfigService.getValueByKey("h5_avatar"));
        return response;
    }

    @Override
    public Boolean save(JSONObject jsonObject) {
        ArrayList dataList = CollUtil.newArrayList((Object[])new SystemGroupData[0]);
        if (StrUtil.isNotBlank((CharSequence)jsonObject.getString("indexBanner"))) {
            List indexBanner = CrmebUtil.jsonArrayToJsonObjectList((JSONArray)jsonObject.getJSONArray("indexBanner"));
            dataList.addAll(this.convertGroupData(indexBanner, GroupDataConstants.GROUP_DATA_ID_INDEX_BANNER));
        }
        if (StrUtil.isNotBlank((CharSequence)jsonObject.getString("indexMenu"))) {
            List indexMenu = CrmebUtil.jsonArrayToJsonObjectList((JSONArray)jsonObject.getJSONArray("indexMenu"));
            dataList.addAll(this.convertGroupData(indexMenu, GroupDataConstants.GROUP_DATA_ID_INDEX_MENU));
        }
        if (StrUtil.isNotBlank((CharSequence)jsonObject.getString("userMenu"))) {
            List userMenu = CrmebUtil.jsonArrayToJsonObjectList((JSONArray)jsonObject.getJSONArray("userMenu"));
            dataList.addAll(this.convertGroupData(userMenu, GroupDataConstants.GROUP_DATA_ID_USER_CENTER_MENU));
        }
        if (StrUtil.isNotBlank((CharSequence)jsonObject.getString("userBanner"))) {
            List userBanner = CrmebUtil.jsonArrayToJsonObjectList((JSONArray)jsonObject.getJSONArray("userBanner"));
            dataList.addAll(this.convertGroupData(userBanner, GroupDataConstants.GROUP_DATA_ID_USER_CENTER_BANNER));
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.systemGroupDataService.deleteByGid(GroupDataConstants.GROUP_DATA_ID_INDEX_BANNER);
            this.systemGroupDataService.deleteByGid(GroupDataConstants.GROUP_DATA_ID_INDEX_MENU);
            this.systemGroupDataService.deleteByGid(GroupDataConstants.GROUP_DATA_ID_USER_CENTER_MENU);
            this.systemGroupDataService.deleteByGid(GroupDataConstants.GROUP_DATA_ID_USER_CENTER_BANNER);
            this.systemGroupDataService.saveBatch(dataList, 100);
            return Boolean.TRUE;
        });
        return execute;
    }

    @Override
    public Boolean indexBannerSave(JSONObject jsonObject) {
        List indexBanner = CrmebUtil.jsonArrayToJsonObjectList((JSONArray)jsonObject.getJSONArray("indexBanner"));
        List<SystemGroupData> dataList = this.convertGroupData(indexBanner, GroupDataConstants.GROUP_DATA_ID_INDEX_BANNER);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.systemGroupDataService.deleteByGid(GroupDataConstants.GROUP_DATA_ID_INDEX_BANNER);
            this.systemGroupDataService.saveBatch(dataList, 100);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean indexMenuSave(JSONObject jsonObject) {
        List indexMenu = CrmebUtil.jsonArrayToJsonObjectList((JSONArray)jsonObject.getJSONArray("indexMenu"));
        List<SystemGroupData> dataList = this.convertGroupData(indexMenu, GroupDataConstants.GROUP_DATA_ID_INDEX_MENU);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.systemGroupDataService.deleteByGid(GroupDataConstants.GROUP_DATA_ID_INDEX_MENU);
            this.systemGroupDataService.saveBatch(dataList, 100);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean userBannerSave(JSONObject jsonObject) {
        List userBanner = CrmebUtil.jsonArrayToJsonObjectList((JSONArray)jsonObject.getJSONArray("userBanner"));
        List<SystemGroupData> dataList = this.convertGroupData(userBanner, GroupDataConstants.GROUP_DATA_ID_USER_CENTER_BANNER);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.systemGroupDataService.deleteByGid(GroupDataConstants.GROUP_DATA_ID_USER_CENTER_BANNER);
            this.systemGroupDataService.saveBatch(dataList, 100);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean userMenuSave(JSONObject jsonObject) {
        List userMenu = CrmebUtil.jsonArrayToJsonObjectList((JSONArray)jsonObject.getJSONArray("userMenu"));
        List<SystemGroupData> dataList = this.convertGroupData(userMenu, GroupDataConstants.GROUP_DATA_ID_USER_CENTER_MENU);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.systemGroupDataService.deleteByGid(GroupDataConstants.GROUP_DATA_ID_USER_CENTER_MENU);
            this.systemGroupDataService.saveBatch(dataList, 100);
            return Boolean.TRUE;
        });
    }

    @Override
    public PageLayoutBottomNavigationResponse getBottomNavigation() {
        PageLayoutBottomNavigationResponse response = new PageLayoutBottomNavigationResponse();
        List<SystemGroupData> dataList = this.systemGroupDataService.findListByGid(GroupDataConstants.GROUP_DATA_ID_BOTTOM_NAVIGATION);
        response.setBottomNavigationList(this.convertData(dataList));
        String isCustom = this.systemConfigService.getValueByKey("bottom_navigation_is_custom");
        response.setIsCustom(isCustom);
        return response;
    }

    @Override
    public Boolean bottomNavigationSave(JSONObject jsonObject) {
        String isCustom = jsonObject.getString("isCustom");
        if (StrUtil.isBlank((CharSequence)isCustom)) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u662f\u5426\u81ea\u5b9a\u4e49");
        }
        List bottomNavigationList = CrmebUtil.jsonArrayToJsonObjectList((JSONArray)jsonObject.getJSONArray("bottomNavigationList"));
        if (CollUtil.isEmpty((Collection)bottomNavigationList)) {
            throw new CrmebException("\u8bf7\u4f20\u5165\u5e95\u90e8\u5bfc\u822a\u6570\u636e");
        }
        List<SystemGroupData> dataList = this.convertGroupData(bottomNavigationList, GroupDataConstants.GROUP_DATA_ID_BOTTOM_NAVIGATION);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.systemGroupDataService.deleteByGid(GroupDataConstants.GROUP_DATA_ID_BOTTOM_NAVIGATION);
            this.systemGroupDataService.saveBatch(dataList, 100);
            this.systemConfigService.updateOrSaveValueByName("bottom_navigation_is_custom", isCustom);
            return Boolean.TRUE;
        });
    }

    private List<SystemGroupData> convertGroupData(List<JSONObject> jsonObjectList, Integer gid) {
        return jsonObjectList.stream().map(e -> {
            SystemGroupData groupData = new SystemGroupData();
            if (e.containsKey((Object)"id") && ObjectUtil.isNotNull((Object)e.getInteger("id"))) {
                groupData.setId(e.getInteger("id"));
            }
            groupData.setGid(gid);
            groupData.setSort(e.getInteger("sort"));
            groupData.setStatus(e.getBoolean("status"));
            HashMap jsonMap = CollUtil.newHashMap();
            jsonMap.put("id", e.getInteger("tempid"));
            jsonMap.put("sort", groupData.getSort());
            jsonMap.put("status", groupData.getStatus());
            ArrayList mapList = CollUtil.newArrayList((Object[])new Map[0]);
            e.remove((Object)"id");
            e.remove((Object)"gid");
            e.remove((Object)"sort");
            e.remove((Object)"status");
            e.remove((Object)"tempid");
            e.forEach((key, value) -> {
                HashMap map = CollUtil.newHashMap();
                map.put("name", key);
                map.put("title", key);
                map.put("value", value);
                if (String.valueOf(value).contains("crmebimage")) {
                    String values = this.systemAttachmentService.clearPrefix(String.valueOf(value));
                    map.put("value", values);
                }
                mapList.add(map);
            });
            jsonMap.put("fields", mapList);
            groupData.setValue(JSONObject.toJSONString((Object)jsonMap));
            return groupData;
        }).collect(Collectors.toList());
    }

    private List<HashMap<String, Object>> convertData(List<SystemGroupData> dataList) {
        return dataList.stream().map(data -> {
            HashMap map = CollUtil.newHashMap();
            map.put("id", data.getId());
            map.put("gid", data.getGid());
            map.put("sort", data.getSort());
            map.put("status", data.getStatus());
            JSONObject jsonObject = JSONObject.parseObject((String)data.getValue());
            List systemFormItemCheckRequestList = CrmebUtil.jsonToListClass((String)jsonObject.getString("fields"), SystemFormItemCheckRequest.class);
            systemFormItemCheckRequestList.forEach(e -> map.put(e.getName(), e.getValue()));
            map.put("tempid", jsonObject.getInteger("id"));
            return map;
        }).collect(Collectors.toList());
    }
}

