package com.zbkj.front.controller.bcx;

import com.zbkj.common.model.bcx.BcxFapiaoApply;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxFapiaoApplyCreateRequest;
import com.zbkj.common.request.bcx.BcxFapiaoApplyRejectRequest;
import com.zbkj.common.response.bcx.BcxFapiaoApplyDetailResponse;
import com.zbkj.common.response.bcx.BcxFapiaoLastSendToResponse;
import com.zbkj.common.response.bcx.BcxSummaryInfo;
import com.zbkj.common.result.CommonResult;
import com.zbkj.common.request.bcx.BcxFapiaoApplyRequest;
import com.zbkj.common.response.bcx.BcxFapiaoApplyResponse;
import com.zbkj.service.service.bcx.BcxFapiaoApplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 发票申请单 控制层
 */
@Slf4j
@Api(tags = "发票申请单控制器")
@RestController
@RequestMapping("/api/front/fapiao/apply")
public class BcxFapiaoApplyController {

    @Autowired
    private BcxFapiaoApplyService bcxFapiaoApplyService;


    @ApiOperation("查询单条发票申请单")
    @RequestMapping(value = "/info/{applyNo}", method = RequestMethod.GET)
    public CommonResult<BcxFapiaoApplyDetailResponse> queryById(@PathVariable String applyNo){
        return CommonResult.success(bcxFapiaoApplyService.queryByApplyNo(applyNo));
    }

    @ApiOperation("开票方 查询分页发票申请单")
    @RequestMapping(value = "/writer/list", method = RequestMethod.POST)
    public CommonResult<CommonPage<BcxFapiaoApplyResponse>> queryWriterPagedList(@RequestBody @Validated BcxFapiaoApplyRequest request,
                                                                           @Validated PageParamRequest pageParamRequest){
        return CommonResult.success(CommonPage.restPage(bcxFapiaoApplyService.queryWriterPagedList(request, pageParamRequest)));
    }

    @ApiOperation("收票方 查询分页发票申请单")
    @RequestMapping(value = "/receiver/list", method = RequestMethod.POST)
    public CommonResult<CommonPage<BcxFapiaoApplyResponse>> queryReceiverPagedList(@RequestBody @Validated BcxFapiaoApplyRequest request,
                                                                           @Validated PageParamRequest pageParamRequest){
        return CommonResult.success(CommonPage.restPage(bcxFapiaoApplyService.queryReceiverPagedList(request, pageParamRequest)));
    }

    @ApiOperation("新增发票申请单")
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public CommonResult<BcxFapiaoApply> create(@RequestBody @Validated BcxFapiaoApplyCreateRequest request){
            return CommonResult.success(bcxFapiaoApplyService.create(request));
    }

    @ApiOperation("拒绝开票")
    @RequestMapping(value = "/reject", method = RequestMethod.POST)
    public CommonResult<BcxFapiaoApply> reject(@RequestBody @Validated BcxFapiaoApplyRejectRequest request){
        if (bcxFapiaoApplyService.rejectById(request)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

    @ApiOperation(value = "开票方 获取列表统计数据")
    @RequestMapping(value = "/writer/summary", method = RequestMethod.POST)
    public CommonResult<BcxSummaryInfo> getWriterSummaryInfo(@RequestBody @Validated BcxFapiaoApplyRequest request) {
        return CommonResult.success(bcxFapiaoApplyService.getWriterSummaryInfo(request));
    }
    @ApiOperation(value = "收票方 获取列表统计数据")
    @RequestMapping(value = "/receiver/summary", method = RequestMethod.POST)
    public CommonResult<BcxSummaryInfo> getReceiverSummaryInfo(@RequestBody @Validated BcxFapiaoApplyRequest request) {
        return CommonResult.success(bcxFapiaoApplyService.getReceiverSummaryInfo(request));
    }
    @ApiOperation("查询最后一次收票人信息")
    @RequestMapping(value = "/last/send/to", method = RequestMethod.GET)
    public CommonResult<BcxFapiaoLastSendToResponse> lastSendTo(){
        return CommonResult.success(bcxFapiaoApplyService.lastSendTo());
    }
}
