package com.zbkj.front.controller;

import com.zbkj.common.model.bcx.BcxSettleBill;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxPerformanceReportSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxBrokerageStatisticsResponse;
import com.zbkj.common.response.BcxPerformanceReportResponse;
import com.zbkj.common.response.BcxPerformanceReportStatisticsResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.BcxPerformanceReportService;
import com.zbkj.service.service.BcxSettleBillService;
import com.zbkj.service.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * description: 分销系统-用户-业绩报表 控制层
 * author : linchunpeng
 * date : 2023/8/3
 */
@Slf4j
@Api(tags = "分销系统-用户业绩报表控制层")
@RestController
@RequestMapping("/api/front/user/performance/report")
public class UserPerformanceReportController {

    @Autowired
    private BcxPerformanceReportService bcxPerformanceReportService;
    @Autowired
    private BcxSettleBillService bcxSettleBillService;
    @Autowired
    private UserService userService;


    @ApiOperation(value = "业绩报表统计(渠道端、分销商端、分销员端，调用这个接口)")
    @RequestMapping(value = "/statistics", method = RequestMethod.GET)
    public CommonResult<BcxPerformanceReportStatisticsResponse> statistics(@Validated BcxPerformanceReportSearchRequest searchRequest) {
        searchRequest.setUserId(userService.getUserId());
        searchRequest.setSearchType(6);
        return CommonResult.success(bcxPerformanceReportService.statistics(searchRequest));
    }

    @ApiOperation(value = "业绩报表统计(分销商端查看员工的时候，调用这个接口)")
    @RequestMapping(value = "/fxy/statistics", method = RequestMethod.GET)
    public CommonResult<BcxPerformanceReportStatisticsResponse> fxyStatistics(@Validated BcxPerformanceReportSearchRequest searchRequest) {
        searchRequest.setSpreadUid(userService.getUserId());
        searchRequest.setSearchType(5);
        return CommonResult.success(bcxPerformanceReportService.statistics(searchRequest));
    }

    @ApiOperation(value = "佣金列表(渠道端、分销商端、分销员端，调用这个接口)")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxPerformanceReportResponse>> getList(@Validated BcxPerformanceReportSearchRequest searchRequest,
                                                                                 @Validated PageParamRequest pageParamRequest) {
        searchRequest.setUserId(userService.getUserId());
        searchRequest.setSearchType(6);
        return CommonResult.success(CommonPage.restPage(bcxPerformanceReportService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "分销员佣金列表(分销商端查看员工的时候，调用这个接口)")
    @RequestMapping(value = "/fxy/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxPerformanceReportResponse>> getFxyList(@Validated BcxPerformanceReportSearchRequest searchRequest,
                                                                             @Validated PageParamRequest pageParamRequest) {
        searchRequest.setSpreadUid(userService.getUserId());
        searchRequest.setSearchType(5);
        return CommonResult.success(CommonPage.restPage(bcxPerformanceReportService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "账单佣金列表(渠道端、分销商端、分销员端，调用这个接口)")
    @RequestMapping(value = "/settle/bill/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxPerformanceReportResponse>> getSettleBillList(@Validated BcxPerformanceReportSearchRequest searchRequest,
                                                                                    @Validated PageParamRequest pageParamRequest) {
        BcxSettleBill settleBill = bcxSettleBillService.getById(searchRequest.getSettleBillId());
        searchRequest.setSearchType(settleBill.getBelongType());
        return CommonResult.success(CommonPage.restPage(bcxPerformanceReportService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "收益中心统计(渠道端、分销商端、分销员端，调用这个接口)")
    @RequestMapping(value = "/brokerage/statistics", method = RequestMethod.GET)
    public CommonResult<BcxBrokerageStatisticsResponse> brokerageStatistics() {
        return CommonResult.success(bcxPerformanceReportService.brokerageStatistics());
    }

}