package com.zbkj.common.response.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.HorizontalAlignmentEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 发票明细导出对象
 */
@Data
public class BcxFapiaoWriteExcelDto implements Serializable {

    @ExcelProperty(value = "流水号", order = 10)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String applyNo;

    @ExcelProperty(value = "收票方", order = 12)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String receiver;

    @ExcelProperty(value = "费用类型", order = 22)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String sourceTypeName;
    public String getSourceTypeName() {
        if (sourceType == 0) return "商品购买";
        if (sourceType == 1) return "平台服务费";
        if (sourceType == 2) return "渠道服务费";
        if (sourceType == 3) return "分销服务费";
        return "未知";
    }
    @ExcelIgnore
    private Integer sourceType;

    @ExcelProperty(value = "发票金额", order = 18)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private BigDecimal fapiaoAmount;

    @ExcelProperty(value = "发票类型", order = 22)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String fapiaoTypeName;

    public String getFapiaoTypeName() {
        if (fapiaoType == 0) return "增值税普通";
        if (fapiaoType == 1) return "增值税专用";
        return "未知";
    }

    @ExcelIgnore
    private Integer fapiaoType;

    @ExcelProperty(value = "税号", order = 24)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String taxNo;

    @ExcelProperty(value = "开户银行", order = 26)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String bankName;

    @ExcelProperty(value = "银行账号", order = 28)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String bankAccount;

    @ExcelProperty(value = "企业地址", order = 30)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String address;

    @ExcelProperty(value = "企业电话", order = 32)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String phone;

    @ExcelProperty(value = "抬头类型", order = 34)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String titleTypeName;

    public String getTitleTypeName() {
        if (titleType == 0) return "个人";
        if (titleType == 1) return "企业";
        return "未知";
    }

    @ExcelIgnore
    private Integer titleType;

    @ExcelProperty(value = "发票抬头", order = 36)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String title;

    @ExcelProperty(value = "开票状态", order = 40)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String fapiaoStatusName;

    public String getFapiaoStatusName() {
        if (fapiaoStatus == 0) return "未开票";
        if (fapiaoStatus == 1) return "已开发票";
        return "未知";
    }

    @ExcelIgnore
    private Integer fapiaoStatus;

    @ExcelProperty(value = "收票人名称", order = 42)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String sendToName;

    @ExcelProperty(value = "收票人电话", order = 42)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String sendToPhone;

    @ExcelProperty(value = "收票人email", order = 42)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String sendToEmail;

    @ExcelProperty(value = "收票人地址", order = 42)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String sendToAddress;
}
