package com.zbkj.common.request.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "OrderSaveUserRequest对象", description = "保存风评保险订单用户请求对象")
public class OrderSaveUserRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单唯一编号", required = true)
    @NotBlank(message = "订单唯一编号不能为空")
    private String sourceId;

    @ApiModelProperty(value = "校验码(sourceId的jwt)", required = true)
    @NotBlank(message = "校验码不能为空")
    private String verify;

    @ApiModelProperty(value = "订单用户ID", required = true)
    @NotEmpty(message = "订单用户ID不能为空")
    private String userId;

}
