package com.zbkj.common.model.huifu;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <b> 企业钱包账户 </b>
 * @author ZXF
 * @create 2023/07/26 0026 16:48
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_huifu_wallet_account")
@ApiModel(value="HuifuWalletAccount对象", description="企业钱包账户")
public class HuifuWalletAccount implements Serializable {

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty(value = "用户联合ID")
    private String uniId;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "公司名称")
    private String comName;
    @ApiModelProperty(value = "经营简称")
    private String shortName;
    @ApiModelProperty(value = "汇付企业类型")
    private String hfComType;
    @ApiModelProperty(value = "企业证件号码")
    private String comCerNo;
    @ApiModelProperty(value = "证照有效期类型:1:长期有效 0:非长期有效；")
    private String licenseValidityType;
    @ApiModelProperty(value = "证照有效期起始日期yyyyMMdd")
    private String licenseBeginDate;
    @ApiModelProperty(value = "证照有效期结束日期yyyyMMdd")
    private String licenseEndDate;
    @ApiModelProperty(value = "注册地址(省)")
    private String regProvId;
    @ApiModelProperty(value = "注册地址(市)")
    private String regAreaId;
    @ApiModelProperty(value = "注册地址(区)")
    private String regDistrictId;
    @ApiModelProperty(value = "注册地址(详细信息)")
    private String regAddress;
    @ApiModelProperty(value = "法定代表人姓名")
    private String legalRepName;
    @ApiModelProperty(value = "法定代表人证件类型")
    private String idcardType;
    @ApiModelProperty(value = "法定代表人证件号码")
    private String idcardNo;
    @ApiModelProperty(value = "证照有效期类型:1:长期有效 0:非长期有效；")
    private String legalCertValidityType;
    @ApiModelProperty(value = "身份证有效期开始日期")
    private String legalCertBeginDate;
    @ApiModelProperty(value = "身份证有效期截止日期")
    private String legalCertEndDate;
    @ApiModelProperty(value = "联系人姓名")
    private String contactName;
    @ApiModelProperty(value = "联系电话")
    private String contactPhone;
//    @ApiModelProperty(value = "手机号")
//    private String mobilePhone;
    @ApiModelProperty(value = "钱包账户号")
    private String walletAccountNo;
    @ApiModelProperty(value = "冻结金额")
    private String frozenAmount;
    @ApiModelProperty(value = "状态 N：“正常”; C：“关闭”; F：“冻结”; D：“销户”")
    private String acctStat;

}