package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * 商品限购
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_product_quota")
@ApiModel(value = "BcxProductQuota对象", description = "商品限购表")
public class BcxProductQuota implements Serializable {
    private static final long serialVersionUID=123424232523L;

    @ApiModelProperty(value = "限购id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "限购商品id")
    private Integer productId;

    @ApiModelProperty(value = "启用限购 1-启用 0其他-不启用")
    private Boolean enabled;

    @ApiModelProperty(value = "单次限购数量")
    private Integer oneQuota;

    @ApiModelProperty(value = "用户总限购数量")
    private Integer allQuota;

}
