/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.dto.IpLocation;
import com.zbkj.common.vo.MyRecord;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.lionsoul.ip2region.xdb.Searcher;

public class IPUtil {
    private static final String ZERO = "0";
    private static final String LOCALHOST = "127.0.0.1";

    public static MyRecord getAddressByIp(String ip) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ip", ip);
        map.put("accessKey", "alibaba-inc");
        String result = IPUtil.post("http://ip.taobao.com/outGetIpInfo", map);
        Map valueMap = (Map)JSONObject.parseObject((String)result, Map.class);
        MyRecord myRecord = new MyRecord();
        if ("query success".equals(valueMap.get("msg"))) {
            Map dataMap = (Map)valueMap.get("data");
            String country = (String)dataMap.get("country");
            String region = (String)dataMap.get("region");
            String city = (String)dataMap.get("city");
            myRecord.set("country", country);
            myRecord.set("region", region);
            myRecord.set("city", city);
        }
        return myRecord;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String post(String url, Map<String, String> mapParameter) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            Throwable throwable;
            CloseableHttpResponse response;
            block34: {
                HttpPost httpPost = new HttpPost(url);
                ArrayList nameValuePairList = new ArrayList();
                if (mapParameter != null && mapParameter.size() > 0) {
                    mapParameter.forEach((k, v) -> nameValuePairList.add(new BasicNameValuePair(k, v)));
                }
                if (nameValuePairList.size() > 0) {
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePairList);
                    httpPost.setEntity((HttpEntity)entity);
                }
                try {
                    String string;
                    block35: {
                        response = httpClient.execute((HttpUriRequest)httpPost);
                        throwable = null;
                        try {
                            HttpEntity httpEntity;
                            if (response == null || (httpEntity = response.getEntity()) == null) break block34;
                            string = EntityUtils.toString((HttpEntity)httpEntity);
                            if (response == null) return string;
                            if (throwable == null) break block35;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (response == null) throw throwable3;
                                if (throwable == null) {
                                    response.close();
                                    throw throwable3;
                                }
                                try {
                                    response.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            response.close();
                            return string;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            return string;
                        }
                    }
                    response.close();
                    return string;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (response == null) return null;
            if (throwable == null) {
                response.close();
                return null;
            }
            try {
                response.close();
                return null;
            }
            catch (Throwable throwable6) {
                throwable.addSuppressed(throwable6);
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-Forwarded-For");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && LOCALHOST.equals(ipAddress = request.getRemoteAddr())) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
                ipAddress = inet.getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static IpLocation getLocation(String ip) {
        IpLocation location = new IpLocation();
        location.setIp(ip);
        try (InputStream inputStream = IPUtil.class.getResourceAsStream("/ip2region/ip2region.xdb");){
            byte[] bytes = IoUtil.readBytes((InputStream)inputStream);
            Searcher searcher = Searcher.newWithBuffer((byte[])bytes);
            String region = searcher.search(ip);
            if (StrUtil.isNotBlank((CharSequence)region)) {
                String[] result = region.split("\\|");
                location.setCountry(ZERO.equals(result[0]) ? "" : result[0]);
                location.setProvince(ZERO.equals(result[2]) ? "" : result[2]);
                location.setCity(ZERO.equals(result[3]) ? "" : result[3]);
                location.setIsp(ZERO.equals(result[4]) ? "" : result[4]);
            }
            searcher.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return location;
        }
        return location;
    }
}

