package com.zbkj.service.wangshang.handle;

import com.zbkj.service.wangshang.api.MybankApiException;
import com.zbkj.service.wangshang.api.MybankApiExceptionEnum;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 策略模式的工厂类
 */
@Component
public class StrategyFactory {

    /**
     * 此处在spring上下文加载时会把所有的策略注册到map中
     * 存放所有策略类Bean的map, Spring 会自动将实现 MybankStrategy 接口的类注入到这个Map中;
     * 这个Map的key值就是你的bean id, value值则为对应的策略实现类
     **/
    @Autowired
    Map<String, MybankNotifyService> strategyMap = new ConcurrentHashMap();

    /**
     * @param type
     * @return com.zbkj.service.wangshang.api.service.MybankStrategy
     * @Description 根据对应通知的策略bean id获取对应策略实现类对象
     **/
    public MybankNotifyService getStrategy(String type) throws Exception {
        MybankNotifyService strategy = strategyMap.get(type);
        if (strategy == null) {
            throw new MybankApiException(MybankApiExceptionEnum.STRATEGY_NOT_DEFINED);
        }
        return strategy;
    }
}
