package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 商户单笔提现确认接口< ant.mybank.bkcloudfunds.withdraw.applyconfirm>
 * 请求模型
 * <p>
 *  TODO
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsWithdrawApplyConfirmRequestModel extends RequestBody {

    private static final long serialVersionUID = 7419696403025560536L;
    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 提现商户号
     * <p>
     * 网商为商户分配的商户号，通过商户入驻结果查询接口获取。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 外部订单分账请求流水号
     * <P>
     * 由合作方生成，同笔交易，交易状态未明需要重试时，使用同一个交易号。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 网商提现订单号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OrderNo")
    private String orderNo;


    /**
     * 平台设置提现手续费用（银行控制盖帽比率），用户实收资金= TotalAmount - PlatformFee
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PlatformFee")
    private String platformFee;

    /**
     * 币种
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "FeeCurrency")
    private String feeCurrency;

    /**
     * 提现总金额（单位：分）
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "TotalAmount")
    private String totalAmount;

    /**
     * 币种
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 短信动态码
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "SmsCode")
    private String smsCode;

    /**
     * 备注
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Memo")
    private String memo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getPlatformFee() {
        return platformFee;
    }

    public void setPlatformFee(String platformFee) {
        this.platformFee = platformFee;
    }

    public String getFeeCurrency() {
        return feeCurrency;
    }

    public void setFeeCurrency(String feeCurrency) {
        this.feeCurrency = feeCurrency;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getSmsCode() {
        return smsCode;
    }

    public void setSmsCode(String smsCode) {
        this.smsCode = smsCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}