package com.zbkj.service.wangshang.api.domain.model;


import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 充值保证金查询接口<ant.mybank.bkcloudfunds.vostro.charge.batchquery>
 * <p>
 * TODO 充值保证金查询
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsVostroChargeBatchQueryRequestModel extends RequestBody {

    private static final long serialVersionUID = -3282601457138195946L;
    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 查询商户号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 来账单号
     * <p>
     * 如果填写了来账单号，则直接返回该指定单子信息，区间查询失效
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OrderNo")
    private String orderNo;

    /**
     * 来账业务场景
     * <p>
     * 预留字段，暂时不需要填写（默认值PRE_CHARGE）
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "VostroScene")
    private String vostroScene;

    /**
     * 起始时间 YYYYMMDD
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "StartTime")
    private String startTime;

    /**
     * 结束时间 YYYYMMDD
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "EndTime")
    private String endTime;

    /**
     * 查询分页开始索引，默认1
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PageIndex")
    private String pageIndex;

    /**
     * 分页大小，默认20 最大50
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PageSize")
    private String pageSize;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getVostroScene() {
        return vostroScene;
    }

    public void setVostroScene(String vostroScene) {
        this.vostroScene = vostroScene;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(String pageIndex) {
        this.pageIndex = pageIndex;
    }

    public String getPageSize() {
        return pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }
}