package com.zbkj.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.model.huifu.HuifuWalletAccount;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * <b>  </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:08
 * @version
 * @注意事项 </b>
 */
public interface HuifuWalletAccountDao extends BaseMapper<HuifuWalletAccount> {

    /**
     * 插入企业钱包账户
     *
     * @param huifuWalletAccount
     * @return
     * @author llc
     * @date 2019-06-22
     */
    int insertHuifuWalletAccount(HuifuWalletAccount huifuWalletAccount);
    /**
     * <b> 修改企业钱包账户 </b>
     * @author ZXF
     * @create 2023/04/12 0012 11:17
     * @version
     * @注意事项 </b>
     */
    int updateHuifuWalletAccountAll(HuifuWalletAccount huifuWalletAccount);


    /**
     * 更新企业钱包账户
     *
     * @param huifuWalletAccount
     * @return
     * @author llc
     * @date 2019-06-22
     */
    int updateHuifuWalletAccount(HuifuWalletAccount huifuWalletAccount);

    int updateHuifuWalletAccountNo(HuifuWalletAccount huifuWalletAccount);
    int updateHuifuWalletAcctStat(@Param("id") Integer id, @Param("acctStat") String acctStat);


    /**
     * 查询所有企业钱包账户
     *
     * @return
     */
    List<HuifuWalletAccountDto> getAllHuifuWalletAccount();

    List<HuifuWalletAccountDto> getLastDayTradeHuifuWalletAccount(@Param("startDate") String startDate,@Param("endDate") String endDate,@Param("payChannel") String payChannel);

    /**
     * 查询企业钱包账户
     *
     * @param uniId
     * @return
     * @author llc
     * @date 2019-06-24
     */
    HuifuWalletAccountDto getHuifuWalletAccountByUniId(@Param("uniId") String uniId,@Param("payChannel") String payChannel);

    /**
     * <b> 根据订单号查询企业钱包账户 </b>
     * @author ZXF
     * @create 2025/06/14 0014 16:18
     * @version
     * @注意事项 </b>
     */
    HuifuWalletAccountDto getHuifuWalletAccountByOrderNo(@Param("orderNo") String orderNo);
    HuifuWalletAccountDto getHuifuWalletAccountByOutMerchantId(@Param("outMerchantId") String outMerchantId);

    /**
     * <b> 修改冻结金额 </b>
     * @author ZXF
     * @create 2023/03/30 0030 16:36
     * @version
     * @注意事项 </b>
     */
    void updateFrozenAmount(@Param("uniId") String uniId, @Param("frozenAmount") String frozenAmount);
//    void updateSumFrozenAmount(@Param("uniId") String uniId, @Param("amount") BigDecimal amount);
    int updateSumFrozenAmount(@Param("uniId") String uniId, @Param("frozenAmount") String frozenAmount, @Param("amount") BigDecimal amount,@Param("payChannel") String payChannel);
    String getFrozenAmount(@Param("uniId") String uniId,@Param("payChannel") String payChannel);


    /**
     * 根据钱包号查询企业钱包账户
     *
     * @param walletNo
     * @return
     * @author lp
     * @date 2019-09-03
     */
    HuifuWalletAccountDto getHuifuWalletAccountByWalletNo(@Param("walletNo") String walletNo);

    /**
     * 根据银行卡号查询企业钱包账户
     *
     * @param accountNo
     * @return
     * @author lp
     * @date 2019-09-03
     */
    HuifuWalletAccountDto getHuifuWalletAccountByAccountNo(@Param("accountNo") String accountNo,@Param("payChannel") String payChannel);

}
