/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.payment.impls;

import com.zbkj.bcx.cores.components.JsonProvider;
import com.zbkj.common.exception.CrmebWalletException;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.payment.impls.PaymentProviderAbstract;
import com.zbkj.payment.mappers.PaymentTransactionMapper;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.huifu.constants.HFBusiCode;
import com.zbkj.service.huifu.v2.V2ApiRequest;
import com.zbkj.service.service.CommonWalletService;
import com.zbkj.service.service.SystemConfigService;
import java.util.Map;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="HUIFU")
public class PaymentProviderImpl_HF
extends PaymentProviderAbstract {
    private static final Logger logger = LoggerFactory.getLogger(PaymentProviderImpl_HF.class);

    public PaymentProviderImpl_HF(RedisUtil redisUtil, RedissonClient redissonClient, SystemConfigService systemConfigService, HuifuWalletAccountDao huifuWalletAccountDao, HuifuWalletTradeDao huifuWalletTradeDao, TransactionTemplate transactionTemplate, CommonWalletService commonWalletService, JsonProvider jsonProvider, PaymentTransactionMapper transactionMapper) {
        super(redisUtil, redissonClient, systemConfigService, huifuWalletAccountDao, huifuWalletTradeDao, transactionTemplate, commonWalletService, jsonProvider, transactionMapper);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Map<String, Object> doYePayTransfer(Map<String, Object> p) {
        try {
            HFBusiCode hFBusiCode = HFBusiCode.YEPAY;
            Map response = V2ApiRequest.api((HFBusiCode)hFBusiCode, p);
            return response;
        }
        catch (Exception e) {
            throw new CrmebWalletException(e.getMessage());
        }
    }

    public String getChannelName() {
        return PaymentChannel.HUIFU.getName();
    }
}

