package com.zbkj.common.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <b> 虚拟订单响应对象 </b>
 * @author ZXF
 * @create 2025/08/26 0026 10:44
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="RefundVirtualOrderResponse对象", description="虚拟订单响应对象")
public class VirtualOrderResponse implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "虚拟订单id")
    private Integer id;
    @ApiModelProperty(value = "虚拟订单号")
    private String virtualOrderNo;

    @ApiModelProperty(value = "商户ID")
    private Integer merId;
    @ApiModelProperty(value = "商户名称")
    private String merName;

    @ApiModelProperty(value = "用户id")
    private Integer uid;
    @ApiModelProperty(value = "用户名称")
    private String uName;

    @ApiModelProperty(value = "商品ID")
    private Integer productId;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty(value = "商品规格值 ID")
    private Integer attrValueId;

    @ApiModelProperty(value = "商品sku")
    private String sku;

    @ApiModelProperty(value = "商品单价")
    private BigDecimal price;

    @ApiModelProperty(value = "购买数量")
    private Integer payNum;

    @ApiModelProperty(value = "订单总额")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "已使用数量")
    private Integer dealNum;

    @ApiModelProperty(value = "退款数量")
    private Integer refundNum;
    @ApiModelProperty(value = "可用数量=购买数量-已使用数量-退款数量")
    private Integer availableNum;

    @ApiModelProperty(value = "订单创建请求源数据jsonstring")
    private String createOrderRequest;

    @ApiModelProperty(value = "订单预处理源数据jsonstring")
    private String preOrderInfoVo;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "订单状态（0：待支付, 1：已支付, 2：已完成）")
    private Integer status;

    @ApiModelProperty(value = "汇总虚单号及对应的消耗数（virtualOrderNo，num）")
    private String virtualNos;
}
