package com.zbkj.common.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "UserProductBenefitsResponse对象", description = "分销商分销商品响应对象")
public class UserProductBenefitsResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "配置id")
    private String id;

    @ApiModelProperty(value = "商品ID")
    private Integer productId;

    @ApiModelProperty(value = "商品图片")
    private String productImage;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty(value = "类型，B：B端商品，C：C端商品")
    private String productType;

    @ApiModelProperty(value = "是否启用单独配置，0否，1是")
    private Integer isEnableConfig;

    @ApiModelProperty(value = "分销商品总比例（%)")
    private Integer brokerageTotal;

    @ApiModelProperty(value = "分销员比例（%）")
    private Integer brokerage;
}
