package com.zbkj.common.response;

import com.zbkj.common.model.product.ProductAttr;
import com.zbkj.common.model.product.ProductDescription;
import com.zbkj.common.vo.CouponSimpleVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 商品详情响应对象
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="StoreProductInfoResponse对象", description="商品详情响应对象")
public class ProductInfoResponse implements Serializable {

    private static final long serialVersionUID = 9215241889318610262L;

    @ApiModelProperty(value = "商品id")
    private Integer id;

    @ApiModelProperty(value = "商品图片")
    private String image;

    @ApiModelProperty(value = "轮播图")
    private String sliderImage;

    @ApiModelProperty(value = "商品名称")
    private String name;

    @ApiModelProperty(value = "商品简介")
    private String intro;

    @ApiModelProperty(value = "关键字")
    private String keyword;

    @ApiModelProperty(value = "商户分类id(逗号拼接)")
    private String cateId;

    @ApiModelProperty(value = "品牌id")
    private Integer brandId;

    @ApiModelProperty(value = "平台分类id")
    private Integer categoryId;

    @ApiModelProperty(value = "保障服务ids(英文逗号拼接)")
    private String guaranteeIds;

    @ApiModelProperty(value = "单位名")
    private String unitName;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "获得积分")
    private Integer giveIntegral;

    @ApiModelProperty(value = "虚拟销量")
    private Integer ficti;

    @ApiModelProperty(value = "规格 0单 1多")
    private Boolean specType;

    @ApiModelProperty(value = "商品属性")
    private List<ProductAttr> attr;

    @ApiModelProperty(value = "商品属性详情")
    private List<AttrValueResponse> attrValue;

    @ApiModelProperty(value = "商品描述")
    private List<ProductDescription> contents;

    @ApiModelProperty(value = "优惠券Ids（商户端）")
    private List<Integer> couponIds;

    @ApiModelProperty(value = "优惠券列表（平台端）")
    private List<CouponSimpleVo> couponList;

    @ApiModelProperty(value = "展示图")
    private String flatPattern;

    @ApiModelProperty(value = "运费模板ID")
    private Integer tempId;

    @ApiModelProperty(value = "是否单独分佣")
    private Boolean isSub;

    @ApiModelProperty(value = "商品类型：0-实体, 1-虚拟, 2-特殊(考培), 3-保险, 4-风评 等等")
    private Integer bizType;

    @ApiModelProperty(value = "业务类型子分类：1-对讲机、2-执法记录仪、0-其他")
    private Integer bizSubType;

    @ApiModelProperty(value = "设备型号，对讲机和执法记录仪 这个字段必填")
    private String deviceModel;

    @ApiModelProperty(value = "主商品id，该字段有值的商品下单时需要关联主商品订单")
    private Integer masterId;

    @ApiModelProperty(value = "显示立即购买按钮 0-不显示 1-显示")
    private Boolean showBuyBtn;

    @ApiModelProperty(value = "显示申请试用按钮 0-不显示 1-显示")
    private Boolean showTryBtn;

    @ApiModelProperty(value = "是否动态报价 0-否 1-是")
    private Boolean dynamicPrice;
}
