package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * description: 部门成员服务表
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_department_member_serve")
@ApiModel(value = "BcxDepartmentMemberService对象", description = "部门成员服务表")
public class BcxDepartmentMemberServe implements Serializable {
    
    @ApiModelProperty(value = "主键id")
    @TableId(value = "id")
    private Long id;

    @ApiModelProperty(value = "部门成员-平台id")
    private String bcxId;

    @ApiModelProperty(value = "服务公司id")
    private String orgId;

    @ApiModelProperty(value = "状态：0无效，1有效")
    private Integer status;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    

}