package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * description: 部门表
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_department")
@ApiModel(value = "BcxDepartment对象", description = "部门表")
public class BcxDepartment implements Serializable {
    
    @ApiModelProperty(value = "主键id")
    @TableId(value = "id")
    private Long id;
    
    @ApiModelProperty(value = "平台id")
    private String bcxId;
    
    @ApiModelProperty(value = "部门代码")
    private String code;

    @ApiModelProperty(value = "上级部门代码")
    private String parentCode;

    @ApiModelProperty(value = "部门代码树")
    private String treeCode;

    @ApiModelProperty(value = "部门名称")
    private String name;

    @ApiModelProperty(value = "状态：0无效，1有效")
    private Integer status;
    
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    

}