package com.zbkj.common.response.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.HorizontalAlignmentEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import lombok.Data;

/**
 * description: 结算单-分销员导出excel dto对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
public class BcxSettleFxyExcelDto extends BcxSettleBaseExcelDto {


    @ExcelProperty(value = "分销员", order = 1)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String brokerageUserRealName;

    @ExcelProperty(value = "所属企业", order = 2)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String brokerageUserOrg;

}