package com.zbkj.common.response.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.HorizontalAlignmentEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import lombok.Data;

/**
 * description: 业绩账单-部门成员导出excel dto对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
public class BcxSettleBillDepartmentMemberExcelDto extends BcxSettleBillBaseExcelDto {


    @ExcelProperty(value = "部门成员", order = 1)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String departmentMemberName;

    @ExcelProperty(value = "所属部门", order = 2)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String departmentName;

}