package com.zbkj.common.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * description: 结算单统计 response对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxSettleStatisticsResponse对象", description = "结算单统计 response对象")
public class BcxSettleStatisticsResponse implements Serializable {


    @ApiModelProperty(value = "总笔数")
    private Integer totalCount;

    @ApiModelProperty(value = "总实付金额")
    private BigDecimal totalPayPrice;

    @ApiModelProperty(value = "总结算佣金")
    private BigDecimal totalBrokeragePrice;

}