package com.zbkj.common.model.huifu;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <b> 交易业务日志 </b>
 * @author ZXF
 * @create 2023/07/26 0026 16:47
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_transaction_log")
@ApiModel(value="TransactionLog对象", description="交易业务日志")
public class TransactionLog implements Serializable {

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "请求报文")
    private String requestMessage;
    @ApiModelProperty(value = "返回报文")
    private String responseMessage;
    @ApiModelProperty(value = "交易类型")
    private String tradeType;
    @ApiModelProperty(value = "交易状态")
    private String tradeStatus;
    /**
     * 可以是当次请求的流水号或者订单号等
     */
    @ApiModelProperty(value = "关键编码")
    private String keyNo;
    @ApiModelProperty(value = "支付渠道")
    private String payChannel;

}