package com.zbkj.common.model.huifu;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <b> 企业钱包账户提现记录 </b>
 * @author ZXF
 * @create 2023/07/26 0026 16:48
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_huifu_wallet_translog")
@ApiModel(value="HuifuWalletTranslog对象", description="企业钱包账户提现记录")
public class HuifuWalletTranslog implements Serializable {

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty(value = "用户联合ID")
    private String uniId;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "出金交易流水编号")
    private String transId;
    @ApiModelProperty(value = "交易请求日期")
    private String transDate;
//    @ApiModelProperty(value = "结算方式D1，T1")
//    private String settleCycle;
    @ApiModelProperty(value = "银行卡号")
    private String cardNo;
    @ApiModelProperty(value = "银行户名")
    private String cardName;
    @ApiModelProperty(value = "银行编码")
    private String bankCode;
    @ApiModelProperty(value = "银行名称")
    private String bankName;
    @ApiModelProperty(value = "交易金额（元）")
    private String transAmt;
    @ApiModelProperty(value = "手续费（元）")
    private String feeAmt;
//    @ApiModelProperty(value = "手续费用户ID")
//    private String feeCustUid;
    @ApiModelProperty(value = "交易类型:SURROGATE-银行卡代发、ENCHASHMENT-取现")
    private String transType;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "交易状态")
    private String transStat;
    @ApiModelProperty(value = "交易描述")
    private String transDesc;
    @ApiModelProperty(value = "支付通道")
    private String payChannel;

}