package com.zbkj.common.model.huifu;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <b> 企业钱包对账未匹配到数据 </b>
 * @author ZXF
 * @create 2025/09/23 0023 9:52
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_huifu_wallet_trade_recon")
@ApiModel(value="HuifuWalletTradeRecon对象", description="企业钱包对账未匹配到数据")
public class HuifuWalletTradeRecon implements Serializable {

    @ApiModelProperty(value = "平台号")
    private String isvOrgId;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "交易号")
    private String tradeNo;

    @ApiModelProperty(value = "外部交易号")
    private String outTradeNo;

    @ApiModelProperty(value = "交易类型：UNIFIED_WITHHOLD、VOSTRO_SUB_ACCOUNT")
    private String tradeType;

    @ApiModelProperty(value = "订单金额")
    private String orderAmt;

    @ApiModelProperty(value = "交易金额")
    private String tradeAmt;

    @ApiModelProperty(value = "手续费")
    private String bankFee;

    @ApiModelProperty(value = "币种")
    private String ccy;

    @ApiModelProperty(value = "状态：FINISH")
    private String status;

    @ApiModelProperty(value = "创建时间")
    private String createTime;

    @ApiModelProperty(value = "完成时间")
    private String finishTime;

    @ApiModelProperty(value = "关联交易号")
    private String relateTradeNo;

    public HuifuWalletTradeRecon(String isvOrgId, String orderNo, String tradeNo, String outTradeNo,
                                 String tradeType, String orderAmt, String tradeAmt, String bankFee,
                                 String ccy, String status, String createTime, String finishTime, String relateTradeNo) {
        this.isvOrgId = isvOrgId;
        this.orderNo = orderNo;
        this.tradeNo = tradeNo;
        this.outTradeNo = outTradeNo;
        this.tradeType = tradeType;
        this.orderAmt = orderAmt;
        this.tradeAmt = tradeAmt;
        this.bankFee = bankFee;
        this.ccy = ccy;
        this.status = status;
        this.createTime = createTime;
        this.finishTime = finishTime;
        this.relateTradeNo = relateTradeNo;
    }

    public static HuifuWalletTradeRecon create(String[] arr){
        return new HuifuWalletTradeRecon(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7], arr[8], arr[9], arr[10], arr[11], arr[12]);
    }
}