package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 福利配置表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_product_benefits")
@ApiModel(value = "BcxProductBenefits对象", description = "福利配置表")
public class BcxProductBenefits implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "福利配置id")
    @TableId(value = "id", type = IdType.AUTO)
    private String id;

    @ApiModelProperty(value = "商品规格值 ID")
    private Integer skuId;

    @ApiModelProperty(value = "商品ID")
    private Integer productId;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty(value = "类型，B：B端商品，C：C端商品")
    private String productType;

    @ApiModelProperty(value = "企业id")
    private String companyId;

    @ApiModelProperty(value = "企业名称")
    private String companyName;

    @ApiModelProperty(value = "分销商授权开始时间")
    private Date authStartTime;

    @ApiModelProperty(value = "分销商授权结束时间")
    private Date authEndTime;

    @ApiModelProperty(value = "是否启用单独配置，0否，1是")
    private Integer isEnableConfig;

    @ApiModelProperty(value = "分销员比例（一级返佣）")
    private Integer brokerage;

}