package com.zbkj.service.wangshang.notify.service.impl;

import com.zbkj.common.constants.Constants;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.BkcloudfundsUnifiedOrderNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.BkcloudfundsUnifiedOrderNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 行业小程序订单结果通知
 * ant.mybank.bkcloudfunds.unifiedorder.notify
 **/
@Service(value = "bkcloudfundsUnifiedOrderNotifyService")
public class BkcloudfundsUnifiedOrderNotifyServiceImpl implements MybankNotifyService {

    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String xmlContext, String function) throws Exception {
        //通知内容转换
        BkcloudfundsUnifiedOrderNotifyRequest unifiedOrderNotifyRequest =
                XmlConverter.getInstance().toResponse(xmlContext, BkcloudfundsUnifiedOrderNotifyRequest.class);
        RequestHead head = unifiedOrderNotifyRequest.getBkcloudfundsUnifiedOrderNotify().getRequestHead();
        //保存通知内容
        boolean flag = saveNotify(unifiedOrderNotifyRequest.getBkcloudfundsUnifiedOrderNotify().getBkcloudfundsUnifiedOrderNotifyModel());
        //响应结果根据执行结果统一处理
        String response = commomRequstHandle.getSignResult(flag, head);
        transactionLogService.save("行业小程序订单结果通知：ant.mybank.bkcloudfunds.unifiedorder.notify", Constants.Y, xmlContext,response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(BkcloudfundsUnifiedOrderNotifyModel bkcloudfundsUnifiedOrderNotifyModel) {
        //TODO

        return true;
    }

}
