package com.zbkj.service.wangshang.api.domain.model.smscode;

import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 短信验证码发送接口<ant.mybank.merchantprod.sendsmscode>
 * <p>
 * 合作方在商户进驻、商户提现、商户余额支付等流程中，基于风险控制的需要，需要客户触发网商短信验证码校验的机制。
 * 合作方可通过调用本接口触发短信验证码，并在其他交易中上送此验证码。
 * 短信发送有并发数量限制，须大量请求请提前报备。
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class MerchantprodSendsmscodeRequestModel extends RequestBody {
    private static final long serialVersionUID = 7652903401065423052L;

    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 短信业务类型
     * <p>
     * 本短信验证码对应的业务。可选值：
     * <p>
     * 01：开通银行账户
     * <p>
     * 02：换绑银行卡
     * <p>
     * 03：更换银行预留手机号
     * <p>
     * 04：商户入驻申请
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "BizType")
    private String bizType;

    /**
     * 网商商户号
     * <p>
     * 网商为商户分配的商户号，通过商户入驻结果查询接口获取。当BizType为02、03、05时必填，其余情况不可填。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 手机号
     * <p>
     * 短信验证码接受手机号。当BizType为01、03、04时必填，其余情况不可填。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Mobile")
    private String mobile;

    /**
     * 外部交易号
     *
     * <p>
     * 合作方系统生成的外部交易号，同一交易号被视为同一笔交易。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    public String getIsvOrgId() {
        return isvOrgId;
    }
    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getBizType() { return bizType; }
    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getMerchantId() {
        return merchantId;
    }
    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMobile() {
        return mobile;
    }
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }
    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }
}